/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkAccess;
import org.omg.CORBA.TRANSIENT;

public class NSNetworkAccess
extends ProxyNetworkAccess {
    private ProxyNetworkDC netDC;
    private NetworkId id;

    public NSNetworkAccess(NetworkId id, ProxyNetworkDC netDC) throws NetworkNotFound {
        this(NSNetworkAccess.getFromDC(id, netDC), id, netDC);
    }

    public NSNetworkAccess(NetworkAccess na, NetworkId id, ProxyNetworkDC netDC) {
        super(na);
        this.id = id;
        this.netDC = netDC;
    }

    public void reset() {
        try {
            this.net = NSNetworkAccess.getFromDC(this.id, this.netDC);
        }
        catch (NetworkNotFound e) {
            TRANSIENT t = new TRANSIENT("Unable to find the network to reset it");
            t.initCause((Throwable)e);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NetworkAccess getFromDC(NetworkId id, ProxyNetworkDC netDC) throws NetworkNotFound {
        ProxyNetworkDC proxyNetworkDC = netDC;
        synchronized (proxyNetworkDC) {
            netDC.reset();
            return new SynchronizedNetworkAccess(netDC.a_finder().retrieve_by_id(id));
        }
    }
}

