/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.DataCenterRouter;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;

public class HardCodeDataCenterRouter
extends DataCenterRouter
implements DataCenterOperations {
    static final String SCEPP = "SCEPP";
    static final String BUD = "BUD";
    static final String POND = "POND";
    static final int SCEPP_INDEX = 0;
    static final int BUD_INDEX = 1;
    static final int POND_INDEX = 2;
    private static final TimeInterval BUD_OFFSET = new TimeInterval(60.0, UnitImpl.DAY);
    private static final MicroSecondDate SCEPP_TO_POND = new ISOTime("20040629112106.8104GMT").getDate();
    protected ProxySeismogramDC sceppDC = null;
    protected MicroSecondDate sceppDCLoadTime = null;
    protected ProxySeismogramDC budDC = null;
    protected MicroSecondDate budDCLoadTime = null;
    protected ProxySeismogramDC pondDC = null;
    protected MicroSecondDate pondDCLoadTime = null;
    FissuresNamingService fissuresNamingService;
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$cache$HardCodeDataCenterRouter == null ? (class$edu$sc$seis$fissuresUtil$cache$HardCodeDataCenterRouter = HardCodeDataCenterRouter.class$("edu.sc.seis.fissuresUtil.cache.HardCodeDataCenterRouter")) : class$edu$sc$seis$fissuresUtil$cache$HardCodeDataCenterRouter));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$HardCodeDataCenterRouter;

    public HardCodeDataCenterRouter(FissuresNamingService fissuresNamingService) {
        this.fissuresNamingService = fissuresNamingService;
        DCResolver sceppResolve = new DCResolver(SCEPP);
        sceppResolve.start();
        DCResolver budResolve = new DCResolver(BUD);
        budResolve.start();
        DCResolver pondResolve = new DCResolver(POND);
        pondResolve.start();
    }

    public String queue_seismograms(RequestFilter[] p0) {
        throw new NO_IMPLEMENT();
    }

    public LocalSeismogram[] retrieve_queue(String p0) {
        throw new NO_IMPLEMENT();
    }

    public String request_status(String p0) {
        throw new NO_IMPLEMENT();
    }

    public void cancel_request(String p0) {
        throw new NO_IMPLEMENT();
    }

    public String request_seismograms(RequestFilter[] p0, DataCenterCallBack p1, boolean p2, Time p3) {
        throw new NO_IMPLEMENT();
    }

    public RequestFilter[] available_data(RequestFilter[] filters) {
        DataCenterRoute[] route = this.makeRoutes(filters);
        LinkedList<RequestFilter> allSeis = new LinkedList<RequestFilter>();
        for (int i = 0; i < route.length; ++i) {
            RequestFilter[] rf = route[i].getRequestFilters();
            if (rf.length == 0 || route[i].getDataCenter() == null) continue;
            try {
                logger.debug((Object)("Asking from " + i + " for " + ChannelIdUtil.toString((ChannelId)rf[0].channel_id) + " from " + rf[0].start_time.date_time + " to " + rf[0].end_time.date_time));
                RequestFilter[] ls = null;
                ls = route[i].getDataCenter().available_data(rf);
                String mesg = "Got " + ls.length + " req filter from " + i;
                mesg = ls.length != 0 ? mesg + " for " + ChannelIdUtil.toString((ChannelId)ls[0].channel_id) + " from " + ls[0].start_time.date_time + " to " + ls[0].end_time.date_time : mesg + " for " + ChannelIdUtil.toString((ChannelId)rf[0].channel_id);
                logger.debug((Object)mesg);
                for (int j = 0; j < ls.length; ++j) {
                    allSeis.add(ls[j]);
                }
                continue;
            }
            catch (SystemException e) {
                logger.error((Object)("Problem getting available data, first= " + ChannelIdUtil.toString((ChannelId)rf[0].channel_id)), (Throwable)e);
                throw e;
            }
        }
        return allSeis.toArray(new RequestFilter[0]);
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] filters) throws FissuresException {
        DataCenterRoute[] route = this.makeRoutes(filters);
        LinkedList<LocalSeismogram> allSeis = new LinkedList<LocalSeismogram>();
        for (int i = 0; i < route.length; ++i) {
            RequestFilter[] rf = route[i].getRequestFilters();
            if (rf.length != 0 && route[i].getDataCenter() != null) {
                try {
                    LocalSeismogram[] ls = route[i].getDataCenter().retrieve_seismograms(rf);
                    logger.debug((Object)("Got " + ls.length + " lseis from " + i + " for " + ChannelIdUtil.toString((ChannelId)rf[0].channel_id) + " from " + rf[0].start_time.date_time + " to " + rf[0].end_time.date_time));
                    for (int j = 0; j < ls.length; ++j) {
                        allSeis.add(ls[j]);
                    }
                    continue;
                }
                catch (SystemException e) {
                    logger.error((Object)("Problem getting available data, first= " + ChannelIdUtil.toString((ChannelId)rf[0].channel_id)), (Throwable)e);
                    throw e;
                }
            }
            logger.warn((Object)("No filters for route " + i));
        }
        return (LocalSeismogram[])allSeis.toArray(new LocalSeismogramImpl[0]);
    }

    protected DataCenterRoute[] makeRoutes(RequestFilter[] filters) {
        DataCenterRoute[] out = new DataCenterRoute[]{new DataCenterRoute(SCEPP), new DataCenterRoute(BUD), new DataCenterRoute(POND)};
        MicroSecondDate BUD_CUTOFF = ClockUtil.now().subtract(BUD_OFFSET);
        for (int i = 0; i < filters.length; ++i) {
            MicroSecondDate end = new MicroSecondDate(filters[i].end_time);
            if (filters[i].channel_id.network_id.network_code.equals("SP") && end.after((Date)SCEPP_TO_POND)) {
                logger.info((Object)("Request to SCEPP" + ChannelIdUtil.toStringNoDates((ChannelId)filters[i].channel_id)));
                out[0].add(filters[i]);
                continue;
            }
            if (end.after((Date)BUD_CUTOFF)) {
                logger.info((Object)("Request to Bud" + ChannelIdUtil.toStringNoDates((ChannelId)filters[i].channel_id)));
                out[1].add(filters[i]);
                continue;
            }
            logger.info((Object)("Request to Pond" + ChannelIdUtil.toStringNoDates((ChannelId)filters[i].channel_id)));
            out[2].add(filters[i]);
        }
        return out;
    }

    public List getDataCenter(String networkCode) {
        LinkedList<ProxySeismogramDC> out = new LinkedList<ProxySeismogramDC>();
        if (networkCode.equals("SP")) {
            out.add(this.getSceppDC());
        } else {
            out.add(this.getBudDC());
            out.add(this.getPondDC());
        }
        return out;
    }

    public ProxySeismogramDC getDC(String serverName) {
        if (serverName == SCEPP) {
            return this.getSceppDC();
        }
        if (serverName == BUD) {
            return this.getBudDC();
        }
        if (serverName == POND) {
            return this.getPondDC();
        }
        throw new IllegalArgumentException("server " + serverName + " not known.");
    }

    protected ProxySeismogramDC getSceppDC() {
        logger.debug((Object)"Resolving Scepp DataCenter");
        while (this.sceppDC == null) {
            TimeInterval delay = this.sceppDCLoadTime.difference(ClockUtil.now());
            delay.convertTo(UnitImpl.SECOND);
            logger.debug((Object)("Resolving Scepp DataCenter " + delay));
            if (delay.getValue() > 10.0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.sceppDC;
    }

    protected ProxySeismogramDC loadSceppDC() {
        if (this.sceppDC == null) {
            this.sceppDC = BulletproofVestFactory.vestSeismogramDC("edu/sc/seis", "SCEPPSeismogramDC", this.fissuresNamingService, 1);
        }
        return this.sceppDC;
    }

    protected ProxySeismogramDC getBudDC() {
        while (this.budDC == null) {
            logger.debug((Object)"Resolving Bud DataCenter");
            TimeInterval delay = this.budDCLoadTime.difference(ClockUtil.now());
            delay.convertTo(UnitImpl.SECOND);
            logger.debug((Object)("Resolving Bud DataCenter " + delay));
            if (delay.getValue() > 10.0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.budDC;
    }

    protected ProxySeismogramDC loadBudDC() {
        if (this.budDC == null) {
            this.budDC = BulletproofVestFactory.vestSeismogramDC("edu/iris/dmc", "IRIS_BudDataCenter", this.fissuresNamingService, 1);
        }
        return this.budDC;
    }

    protected ProxySeismogramDC getPondDC() {
        while (this.pondDC == null) {
            logger.debug((Object)"Resolving Pond DataCenter");
            TimeInterval delay = this.pondDCLoadTime.difference(ClockUtil.now());
            delay.convertTo(UnitImpl.SECOND);
            logger.debug((Object)("Resolving Pond DataCenter " + delay));
            if (delay.getValue() > 10.0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.pondDC;
    }

    protected ProxySeismogramDC loadPondDC() {
        if (this.pondDC == null) {
            this.pondDC = BulletproofVestFactory.vestSeismogramDC("edu/iris/dmc", "IRIS_PondDataCenter", this.fissuresNamingService, 1);
        }
        return this.pondDC;
    }

    public ProxySeismogramDC getDataCenter(RequestFilter[] infilters) {
        DataCenterRoute[] routes = this.makeRoutes(infilters);
        for (int i = 0; i < routes.length; ++i) {
            if (routes[i].filterList.size() <= 0) continue;
            return routes[i].dc;
        }
        return this.getBudDC();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class DCResolver
    extends Thread {
        String serverName;

        DCResolver(String serverName) {
            super("DCResolver" + serverName);
            this.serverName = serverName;
            if (serverName.equals(HardCodeDataCenterRouter.SCEPP)) {
                HardCodeDataCenterRouter.this.sceppDC = null;
                HardCodeDataCenterRouter.this.sceppDCLoadTime = ClockUtil.now();
            } else if (serverName.equals(HardCodeDataCenterRouter.BUD)) {
                HardCodeDataCenterRouter.this.budDC = null;
                HardCodeDataCenterRouter.this.budDCLoadTime = ClockUtil.now();
            } else if (serverName.equals(HardCodeDataCenterRouter.POND)) {
                HardCodeDataCenterRouter.this.pondDC = null;
                HardCodeDataCenterRouter.this.pondDCLoadTime = ClockUtil.now();
            }
        }

        public void run() {
            if (this.serverName.equals(HardCodeDataCenterRouter.SCEPP)) {
                HardCodeDataCenterRouter.this.loadSceppDC();
            } else if (this.serverName.equals(HardCodeDataCenterRouter.BUD)) {
                HardCodeDataCenterRouter.this.loadBudDC();
            } else if (this.serverName.equals(HardCodeDataCenterRouter.POND)) {
                HardCodeDataCenterRouter.this.loadPondDC();
            }
        }
    }

    protected class DataCenterRoute {
        ProxySeismogramDC dc;
        String dns;
        String serverName;
        LinkedList filterList = new LinkedList();

        DataCenterRoute(String serverName) {
            this.serverName = serverName;
            this.dc = HardCodeDataCenterRouter.this.getDC(serverName);
        }

        String getServerName() {
            return this.serverName;
        }

        void add(RequestFilter filter) {
            this.filterList.add(filter);
        }

        RequestFilter[] getRequestFilters() {
            return this.filterList.toArray(new RequestFilter[0]);
        }

        DataCenterOperations getDataCenter() {
            return this.dc;
        }

        void reloadDataCenter() {
            this.dc = null;
            DCResolver resolve = new DCResolver(this.serverName);
            resolve.start();
            this.dc = HardCodeDataCenterRouter.this.getDC(this.serverName);
        }
    }
}

