/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.SphericalCoords;
import java.util.ArrayList;

public class OrientationUtil {
    private static final double TWO_OVER_PI = 0.6366197723675814;

    public static Channel[] inOrientation(OrientationRange orient, Channel[] chans) {
        double centerAZ = orient.center.azimuth;
        double centerDip = orient.center.dip;
        double degDist = QuantityImpl.createQuantityImpl((Quantity)orient.angular_distance).convertTo((UnitImpl)UnitImpl.DEGREE).value;
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (int i = 0; i < chans.length; ++i) {
            Channel chan = chans[i];
            Orientation chanOrient = chan.an_orientation;
            double dist = SphericalCoords.distance((double)centerDip, (double)centerAZ, (double)chanOrient.dip, (double)chanOrient.azimuth);
            if (!(dist <= degDist)) continue;
            results.add(chan);
        }
        return results.toArray(new Channel[results.size()]);
    }

    public static boolean areOrthogonal(Orientation one, Orientation two) {
        double A1 = Math.toRadians(one.azimuth);
        double A2 = Math.toRadians(two.azimuth);
        double D1 = Math.toRadians(one.dip);
        double D2 = Math.toRadians(two.dip);
        if (one.dip == two.dip) {
            if (Math.abs(one.dip) == 90.0f) {
                return false;
            }
            if (one.dip == 0.0f) {
                return OrientationUtil.isOddInteger(0.6366197723675814 * (A1 - A2));
            }
            return OrientationUtil.isOddInteger(0.6366197723675814 * (D1 - D2));
        }
        return (Math.cos(A1 - A2) * Math.cos(D1) * Math.cos(D2) + Math.sin(D1)) * Math.sin(D2) == 0.0;
    }

    private static boolean isOddInteger(double d) {
        return d == (double)((int)d) && d % 2.0 != 0.0;
    }
}

