/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import edu.sc.seis.fissuresUtil.freq.Cmplx;

public class Hilbert
implements LocalSeismogramFunction {
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        double tmp;
        int i;
        Cmplx[] c = Cmplx.fft(seis.get_as_floats());
        for (i = 0; i < c.length / 2; ++i) {
            tmp = c[i].i;
            c[i].i = c[i].r;
            c[i].r = -tmp;
        }
        for (i = c.length / 2; i < c.length; ++i) {
            tmp = c[i].i;
            c[i].i = -c[i].r;
            c[i].r = tmp;
        }
        return new LocalSeismogramImpl((SeismogramAttr)seis, Cmplx.fftInverse(c, seis.getNumPoints()));
    }

    public Cmplx[] analyticSignal(LocalSeismogramImpl seis) throws FissuresException {
        float[] seisData = seis.get_as_floats();
        LocalSeismogramImpl hilbert = this.apply(seis);
        float[] hilbertData = hilbert.get_as_floats();
        Cmplx[] out = new Cmplx[seis.getNumPoints()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new Cmplx(seisData[i], hilbertData[i]);
        }
        return out;
    }

    public double[] unwrapPhase(Cmplx[] analytic) {
        double b;
        double a;
        double[] out = new double[analytic.length];
        int wraps = 0;
        out[0] = a = analytic[0].phs();
        out[1] = b = analytic[1].phs();
        for (int i = 2; i < out.length; ++i) {
            double c = analytic[i].phs() + (double)(wraps * 2) * Math.PI;
            if (b - c > Math.PI) {
                c = analytic[i].phs() + (double)(++wraps * 2) * Math.PI;
            } else if (b - c < -Math.PI) {
                c = analytic[i].phs() + (double)(--wraps * 2) * Math.PI;
            }
            out[i] = c;
            a = b;
            b = c;
        }
        return out;
    }

    public double[] phase(Cmplx[] analytic) {
        double[] phase = new double[analytic.length];
        for (int i = 0; i < analytic.length; ++i) {
            phase[i] = analytic[i].phs();
        }
        return phase;
    }

    public double[] envelope(Cmplx[] analytic) {
        double[] amp = new double[analytic.length];
        for (int i = 0; i < analytic.length; ++i) {
            amp[i] = analytic[i].mag();
        }
        return amp;
    }

    public double[] instantFreq(Cmplx[] analytic) {
        double[] phase = new double[analytic.length];
        phase = this.unwrapPhase(analytic);
        double[] freq = new double[phase.length];
        freq[0] = phase[0];
        for (int i = 1; i < freq.length; ++i) {
            freq[i] = phase[i] - phase[i - 1];
        }
        return freq;
    }
}

