/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCriterion;

public final class WakeupOnSensorEntry
extends WakeupCriterion {
    Bounds region;
    Bounds transformedRegion;
    Sensor armingSensor;

    public WakeupOnSensorEntry(Bounds bounds) {
        this.region = (Bounds)bounds.clone();
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    void updateTransformRegion() {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(this.behav.getCurrentLocalToVworld(null));
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.addSensorEntryCondition(this);
        if (this.behav != null && this.behav.enable) {
            ++behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.removeSensorEntryCondition(this);
        if (this.behav != null && this.behav.enable) {
            --behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    void setTarget(Sensor sensor) {
        this.armingSensor = sensor;
    }

    public Sensor getTriggeringSensor() {
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (this.behav == null || !this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorEntry0"));
            }
        }
        return this.armingSensor;
    }
}

