/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TransparencyAttributesRetained;

public class TransparencyAttributes
extends NodeComponent {
    public static final int ALLOW_MODE_READ = 0;
    public static final int ALLOW_MODE_WRITE = 1;
    public static final int ALLOW_VALUE_READ = 2;
    public static final int ALLOW_VALUE_WRITE = 3;
    public static final int ALLOW_BLEND_FUNCTION_READ = 4;
    public static final int ALLOW_BLEND_FUNCTION_WRITE = 5;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int BLENDED = 2;
    public static final int SCREEN_DOOR = 3;
    public static final int NONE = 4;
    public static final int BLEND_ZERO = 0;
    public static final int BLEND_ONE = 1;
    public static final int BLEND_SRC_ALPHA = 2;
    public static final int BLEND_ONE_MINUS_SRC_ALPHA = 3;

    public TransparencyAttributes() {
    }

    public TransparencyAttributes(int n, float f) {
        this(n, f, 2, 3);
    }

    public TransparencyAttributes(int n, float f, int n2, int n3) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes6"));
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes7"));
        }
        if (n3 < 0 || n3 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes8"));
        }
        ((TransparencyAttributesRetained)this.retained).initTransparencyMode(n);
        ((TransparencyAttributesRetained)this.retained).initTransparency(f);
        ((TransparencyAttributesRetained)this.retained).initSrcBlendFunction(n2);
        ((TransparencyAttributesRetained)this.retained).initDstBlendFunction(n3);
    }

    public void setTransparencyMode(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes0"));
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes6"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setTransparencyMode(n);
        } else {
            ((TransparencyAttributesRetained)this.retained).initTransparencyMode(n);
        }
    }

    public int getTransparencyMode() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes1"));
        }
        return ((TransparencyAttributesRetained)this.retained).getTransparencyMode();
    }

    public void setTransparency(float f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes2"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setTransparency(f);
        } else {
            ((TransparencyAttributesRetained)this.retained).initTransparency(f);
        }
    }

    public float getTransparency() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes3"));
        }
        return ((TransparencyAttributesRetained)this.retained).getTransparency();
    }

    public void setSrcBlendFunction(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes4"));
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes7"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setSrcBlendFunction(n);
        } else {
            ((TransparencyAttributesRetained)this.retained).initSrcBlendFunction(n);
        }
    }

    public int getSrcBlendFunction() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes5"));
        }
        return ((TransparencyAttributesRetained)this.retained).getSrcBlendFunction();
    }

    public void setDstBlendFunction(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes4"));
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TransparencyAttributes8"));
        }
        if (this.isLive()) {
            ((TransparencyAttributesRetained)this.retained).setDstBlendFunction(n);
        } else {
            ((TransparencyAttributesRetained)this.retained).initDstBlendFunction(n);
        }
    }

    public int getDstBlendFunction() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransparencyAttributes5"));
        }
        return ((TransparencyAttributesRetained)this.retained).getDstBlendFunction();
    }

    void createRetained() {
        this.retained = new TransparencyAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.duplicateNodeComponent(this);
        return transparencyAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        TransparencyAttributesRetained transparencyAttributesRetained = (TransparencyAttributesRetained)nodeComponent.retained;
        TransparencyAttributesRetained transparencyAttributesRetained2 = (TransparencyAttributesRetained)this.retained;
        transparencyAttributesRetained2.initTransparencyMode(transparencyAttributesRetained.getTransparencyMode());
        transparencyAttributesRetained2.initTransparency(transparencyAttributesRetained.getTransparency());
        transparencyAttributesRetained2.initSrcBlendFunction(transparencyAttributesRetained.getSrcBlendFunction());
        transparencyAttributesRetained2.initDstBlendFunction(transparencyAttributesRetained.getDstBlendFunction());
    }
}

