/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.TransformStructure;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    UnorderList traverseList = new UnorderList(class$javax$media$j3d$TransformGroupRetained == null ? (class$javax$media$j3d$TransformGroupRetained = TransformStructure.class$("javax.media.j3d.TransformGroupRetained")) : class$javax$media$j3d$TransformGroupRetained);
    UnorderList transformList = new UnorderList(class$javax$media$j3d$Transform3D == null ? (class$javax$media$j3d$Transform3D = TransformStructure.class$("javax.media.j3d.Transform3D")) : class$javax$media$j3d$Transform3D);
    ArrayList objectList = new ArrayList();
    ArrayList collisionObjectList = new ArrayList();
    HashKey key = new HashKey(250);
    ArrayList dirtyTransformGroups = new ArrayList();
    ArrayList keySet = new ArrayList();
    Locale locale = null;
    Transform3D currentTrans = new Transform3D();
    TransformGroupRetained[] tgs;
    Transform3D[] t3ds;
    static /* synthetic */ Class class$javax$media$j3d$TransformGroupRetained;
    static /* synthetic */ Class class$javax$media$j3d$Transform3D;

    TransformStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 8192);
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (j3dMessageArray != null) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                int n2 = 0;
                while (n2 < n) {
                    J3dMessage j3dMessage = j3dMessageArray[n2];
                    switch (j3dMessage.type) {
                        case 3: {
                            int n3 = this.traverseList.indexOf(j3dMessage.args[1]);
                            if (n3 == -1) {
                                this.objectList.add(j3dMessage.args[0]);
                                this.traverseList.add(j3dMessage.args[1]);
                                this.transformList.add(j3dMessage.args[2]);
                                break;
                            }
                            Transform3D transform3D = (Transform3D)this.transformList.get(n3);
                            VirtualUniverse.mc.addToTransformFreeList(transform3D);
                            this.transformList.set(n3, j3dMessage.args[2]);
                            break;
                        }
                        case 0: {
                            this.objectList.add(j3dMessage.args[0]);
                            break;
                        }
                        case 24: {
                            this.objectList.add(j3dMessage.args[3]);
                            break;
                        }
                        case 17: {
                            this.objectList.add(j3dMessage.args[0]);
                            break;
                        }
                        case 16: {
                            this.objectList.add(j3dMessage.args[3]);
                            break;
                        }
                        case 26: {
                            this.objectList.add(j3dMessage.args[1]);
                            break;
                        }
                        case 25: {
                            this.objectList.add(j3dMessage.args[0]);
                            break;
                        }
                        case 37: {
                            this.processBoundsAutoComputeChanged(j3dMessage);
                            break;
                        }
                        case 35: {
                            this.processRegionBoundChanged(j3dMessage);
                            break;
                        }
                        case 34: {
                            this.processCollisionBoundChanged(j3dMessage);
                        }
                    }
                    j3dMessage.decRefcount();
                    ++n2;
                }
                this.processCurrentLocalToVworld();
                this.processGeometryAtomVwcBounds(l);
            }
        }
    }

    void processCurrentLocalToVworld() {
        if (this.transformList.size() <= 0) {
            return;
        }
        this.tgs = (TransformGroupRetained[])this.traverseList.toArray(false);
        this.t3ds = (Transform3D[])this.transformList.toArray(false);
        this.sortTransformGroups();
        VirtualUniverse.mc.addMirrorObject(this);
        int n = this.transformList.size();
        int n2 = 0;
        while (n2 < n) {
            this.tgs[n2].currentTransform.set(this.t3ds[n2]);
            TransformGroupRetained transformGroupRetained = this.tgs[n2];
            synchronized (transformGroupRetained) {
                if (this.tgs[n2].isDirty != null) {
                    int n3 = 0;
                    while (n3 < this.tgs[n2].isDirty.length) {
                        this.tgs[n2].isDirty[n3] = true;
                        ++n3;
                    }
                }
            }
            VirtualUniverse.mc.addToTransformFreeList(this.t3ds[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.tgs[n2].processChildLocalToVworld(this.dirtyTransformGroups, this.keySet);
            ++n2;
        }
        this.transformList.clear();
        this.traverseList.clear();
    }

    private void sortTransformGroups() {
        class Sort {
            private final /* synthetic */ TransformStructure this$0;

            Sort(TransformStructure transformStructure) {
                this.this$0 = transformStructure;
            }

            void sorting() {
                if (this.this$0.traverseList.arraySize() < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.this$0.traverseList.arraySize() - 1);
                }
            }

            final void insertSort() {
                int n = 0;
                while (n < this.this$0.traverseList.arraySize()) {
                    int n2 = n;
                    while (n2 > 0 && this.this$0.tgs[n2 - 1].maxTransformLevel > this.this$0.tgs[n2].maxTransformLevel) {
                        TransformGroupRetained transformGroupRetained = this.this$0.tgs[n2];
                        this.this$0.tgs[n2] = this.this$0.tgs[n2 - 1];
                        this.this$0.tgs[n2 - 1] = transformGroupRetained;
                        Transform3D transform3D = this.this$0.t3ds[n2];
                        this.this$0.t3ds[n2] = this.this$0.t3ds[n2 - 1];
                        this.this$0.t3ds[n2 - 1] = transform3D;
                        --n2;
                    }
                    ++n;
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.this$0.tgs[(n + n2) / 2].maxTransformLevel;
                while (true) {
                    if ((double)this.this$0.tgs[n3].maxTransformLevel < d) {
                        ++n3;
                        continue;
                    }
                    while (d < (double)this.this$0.tgs[n4].maxTransformLevel) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        TransformGroupRetained transformGroupRetained = this.this$0.tgs[n3];
                        this.this$0.tgs[n3] = this.this$0.tgs[n4];
                        this.this$0.tgs[n4] = transformGroupRetained;
                        Transform3D transform3D = this.this$0.t3ds[n3];
                        this.this$0.t3ds[n3] = this.this$0.t3ds[n4];
                        this.this$0.t3ds[n4] = transform3D;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(this).sorting();
    }

    public void updateObject() {
        this.processLastLocalToVworld();
    }

    void processLastLocalToVworld() {
        int n = this.dirtyTransformGroups.size();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            TransformGroupRetained transformGroupRetained;
            TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)this.dirtyTransformGroups.get(n2);
            synchronized (transformGroupRetained2) {
                if (transformGroupRetained.childLocalToVworld != null) {
                    if (transformGroupRetained.inSharedGroup) {
                        HashKey hashKey = (HashKey)this.keySet.get(n3++);
                        int n4 = 0;
                        while (n4 < transformGroupRetained.localToVworldKeys.length) {
                            if (transformGroupRetained.localToVworldKeys[n4].equals((Object)hashKey)) break;
                            ++n4;
                        }
                        if (n4 < transformGroupRetained.localToVworldKeys.length) {
                            transformGroupRetained.childLocalToVworldIndex[n4][0] = transformGroupRetained.childLocalToVworldIndex[n4][1];
                        }
                    } else {
                        transformGroupRetained.childLocalToVworldIndex[0][0] = transformGroupRetained.childLocalToVworldIndex[0][1];
                    }
                }
            }
            ++n2;
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    void processGeometryAtomVwcBounds(long l) {
        Object object;
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        int n = this.objectList.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.objectList.get(n2);
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object2 = objectArray[n3];
                synchronized (object2) {
                    if (objectArray[n3] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n3];
                        shape3DRetained = geometryAtom.source;
                        if (geometryAtom.xformStrUpdateTime != l && !geometryAtom.source.useSwitchVwcBounds) {
                            geometryAtom.xformStrUpdateTime = l;
                            object = shape3DRetained.bounds;
                            synchronized (object) {
                                shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.getCurrentLocalToVworld(0));
                            }
                            if (shape3DRetained.collisionBound != null) {
                                shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                            }
                        }
                    } else if (objectArray[n3] instanceof SwitchRetained) {
                        object = (SwitchRetained)objectArray[n3];
                        ((SwitchRetained)object).vwcBounds.transform(((SwitchRetained)object).bounds, ((NodeRetained)object).getCurrentLocalToVworld());
                    } else if (objectArray[n3] instanceof GroupRetained) {
                        object = (GroupRetained)objectArray[n3];
                        Bounds bounds = ((GroupRetained)object).sourceNode.collisionBound != null ? ((GroupRetained)object).sourceNode.collisionBound : ((GroupRetained)object).sourceNode.getEffectiveBounds();
                        ((GroupRetained)object).collisionVwcBounds.transform(bounds, ((NodeRetained)object).getCurrentLocalToVworld());
                    }
                }
                ++n3;
            }
            ++n2;
        }
        this.objectList.clear();
        int n4 = 0;
        while (n4 < this.collisionObjectList.size()) {
            Object[] objectArray = (Object[])this.objectList.get(n4);
            int n5 = 0;
            while (n5 < objectArray.length) {
                object = objectArray[n5];
                synchronized (object) {
                    if (objectArray[n5] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n5];
                        shape3DRetained = geometryAtom.source;
                        if (shape3DRetained.collisionVwcBound != null) {
                            shape3DRetained.collisionVwcBound.transform(shape3DRetained.collisionBound, shape3DRetained.getCurrentLocalToVworld(0));
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        this.collisionObjectList.clear();
    }

    void processRegionBoundChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    void processBoundsChanged(Object[] objectArray, Bounds bounds) {
        int n = 0;
        while (n < objectArray.length) {
            GeometryAtom geometryAtom = (GeometryAtom)objectArray[n];
            Shape3DRetained shape3DRetained = geometryAtom.source;
            shape3DRetained.bounds = bounds;
            if (shape3DRetained.collisionBound == null) {
                shape3DRetained.collisionVwcBound = shape3DRetained.vwcBounds;
            }
            ++n;
        }
        this.objectList.add(objectArray);
    }

    void processCollisionBoundChanged(J3dMessage j3dMessage) {
        Bounds bounds = (Bounds)j3dMessage.args[1];
        if (j3dMessage.args[0] instanceof GroupRetained) {
            GroupRetained groupRetained = (GroupRetained)j3dMessage.args[0];
            if (groupRetained.mirrorGroup != null) {
                this.objectList.add(groupRetained.mirrorGroup);
            }
        } else {
            Object[] objectArray = (Object[])j3dMessage.args[0];
            int n = 0;
            while (n < objectArray.length) {
                GeometryAtom geometryAtom = (GeometryAtom)objectArray[n];
                Shape3DRetained shape3DRetained = geometryAtom.source;
                shape3DRetained.collisionBound = bounds;
                shape3DRetained.collisionVwcBound = shape3DRetained.collisionBound != null ? (Bounds)shape3DRetained.collisionBound.clone() : shape3DRetained.vwcBounds;
                ++n;
            }
            this.collisionObjectList.add(objectArray);
        }
    }

    void processBoundsAutoComputeChanged(J3dMessage j3dMessage) {
        this.processBoundsChanged((Object[])j3dMessage.args[0], (Bounds)j3dMessage.args[1]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

