/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.VirtualUniverse;

class TextureUnitStateRetained
extends NodeComponentRetained {
    static final int TEXTURE_CHANGED = 1;
    static final int TEXTURE_ATTRS_CHANGED = 2;
    static final int TEXCOORD_GEN_CHANGED = 4;
    static final int ALL_STATE_CHANGED = 8;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texGen = null;
    boolean texCrdGenPresent = false;
    boolean noTexCoordSrc = false;

    TextureUnitStateRetained() {
    }

    final void setTextureUnitStateComponent(NodeComponent nodeComponent, NodeComponentRetained nodeComponentRetained, int n) {
        if (this.source.isLive()) {
            if (nodeComponent != null && ((NodeComponentRetained)nodeComponent.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("TextureUnitState6"));
            }
            if (nodeComponent == null && nodeComponentRetained == null || nodeComponent != null && nodeComponent.retained == nodeComponentRetained) {
                return;
            }
            if (nodeComponentRetained != null) {
                nodeComponentRetained.clearLive(this.refCount);
                nodeComponentRetained.removeMirrorUsers(this);
            }
            if (nodeComponent != null) {
                ((NodeComponentRetained)nodeComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
                ((NodeComponentRetained)nodeComponent.retained).copyMirrorUsers(this);
            }
            if (n != -1) {
                this.sendMessage(n, nodeComponent == null ? null : ((NodeComponentRetained)nodeComponent.retained).mirror);
            }
        } else if (this.getInImmCtx() && nodeComponent != null && nodeComponent.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("TextureUnitState7"));
        }
    }

    final void initTextureUnitState(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this.initTexture(texture);
        this.initTextureAttributes(textureAttributes);
        this.initTexCoordGeneration(texCoordGeneration);
    }

    final void setTextureUnitState(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this.setTextureUnitStateComponent(texture, this.texture, -1);
        this.setTextureUnitStateComponent(textureAttributes, this.texAttrs, -1);
        this.setTextureUnitStateComponent(texCoordGeneration, this.texGen, -1);
        Object[] objectArray = new Object[]{texture == null ? null : ((TextureRetained)texture.retained).mirror, textureAttributes == null ? null : ((TextureAttributesRetained)textureAttributes.retained).mirror, texCoordGeneration == null ? null : ((TexCoordGenerationRetained)texCoordGeneration.retained).mirror};
        this.sendMessage(8, objectArray);
        this.initTextureUnitState(texture, textureAttributes, texCoordGeneration);
    }

    final void initTexture(Texture texture) {
        this.texture = texture == null ? null : (TextureRetained)texture.retained;
    }

    final void setTexture(Texture texture) {
        this.setTextureUnitStateComponent(texture, this.texture, 1);
        this.initTexture(texture);
    }

    final void initTextureAttributes(TextureAttributes textureAttributes) {
        this.texAttrs = textureAttributes == null ? null : (TextureAttributesRetained)textureAttributes.retained;
    }

    final void setTextureAttributes(TextureAttributes textureAttributes) {
        this.setTextureUnitStateComponent(textureAttributes, this.texAttrs, 2);
        this.initTextureAttributes(textureAttributes);
    }

    final void initTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        this.texGen = texCoordGeneration == null ? null : (TexCoordGenerationRetained)texCoordGeneration.retained;
    }

    final void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        this.setTextureUnitStateComponent(texCoordGeneration, this.texGen, 4);
        this.initTexCoordGeneration(texCoordGeneration);
    }

    Texture getTexture() {
        return this.texture == null ? null : (Texture)this.texture.source;
    }

    TextureAttributes getTextureAttributes() {
        return this.texAttrs == null ? null : (TextureAttributes)this.texAttrs.source;
    }

    TexCoordGeneration getTexCoordGeneration() {
        return this.texGen == null ? null : (TexCoordGeneration)this.texGen.source;
    }

    native void updateTextureUnitState(int var1, int var2, boolean var3);

    void updateNative(int n, Canvas3D canvas3D, boolean bl, boolean bl2) {
        if (this.texture == null || this.isTextureEnabled() && this.noTexCoordSrc) {
            canvas3D.resetTexture(canvas3D.ctx, n);
            canvas3D.texAttrs = null;
            canvas3D.texCoordGeneration = null;
            return;
        }
        this.updateTextureUnitState(canvas3D.ctx, n, true);
        if (bl || (canvas3D.canvasDirty & 0x400) != 0 || canvas3D.texture != this.texture) {
            this.texture.updateNative(canvas3D);
            if (n <= 0) {
                canvas3D.texture = this.texture;
            }
        }
        if (bl || canvas3D.texAttrs != this.texAttrs) {
            if (this.texAttrs == null) {
                canvas3D.resetTextureAttributes(canvas3D.ctx);
                canvas3D.setBlendFunc(canvas3D.ctx, 1, 0);
            } else {
                this.texAttrs.updateNative(canvas3D, bl2, this.texture.format);
            }
            if (n <= 0) {
                canvas3D.texAttrs = this.texAttrs;
            }
        }
        if (bl || canvas3D.texCoordGeneration != this.texGen) {
            if (this.texGen == null) {
                canvas3D.resetTexCoordGeneration(canvas3D.ctx);
            } else {
                this.texGen.updateNative(canvas3D.ctx, canvas3D.vworldToEc);
            }
            if (n <= 0) {
                canvas3D.texCoordGeneration = this.texGen;
            }
        }
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            TextureUnitStateRetained textureUnitStateRetained = new TextureUnitStateRetained();
            this.mirror = textureUnitStateRetained;
        }
        this.mirror.source = this.source;
        this.initMirrorObject();
    }

    synchronized void initMirrorObject() {
        TextureUnitStateRetained textureUnitStateRetained = (TextureUnitStateRetained)this.mirror;
        textureUnitStateRetained.texture = this.texture != null ? (TextureRetained)this.texture.mirror : null;
        textureUnitStateRetained.texAttrs = this.texAttrs != null ? (TextureAttributesRetained)this.texAttrs.mirror : null;
        textureUnitStateRetained.texGen = this.texGen != null ? (TexCoordGenerationRetained)this.texGen.mirror : null;
        textureUnitStateRetained.evaluateTexCrdSrc();
    }

    synchronized void updateMirrorObject(int n, Object object) {
        TextureUnitStateRetained textureUnitStateRetained = (TextureUnitStateRetained)this.mirror;
        if ((n & 1) != 0) {
            textureUnitStateRetained.texture = (TextureRetained)object;
        } else if ((n & 2) != 0) {
            textureUnitStateRetained.texAttrs = (TextureAttributesRetained)object;
        } else if ((n & 4) != 0) {
            textureUnitStateRetained.texGen = (TexCoordGenerationRetained)object;
        } else if ((n & 8) != 0) {
            Object[] objectArray = (Object[])object;
            textureUnitStateRetained.texture = (TextureRetained)objectArray[0];
            textureUnitStateRetained.texAttrs = (TextureAttributesRetained)objectArray[1];
            textureUnitStateRetained.texGen = (TexCoordGenerationRetained)objectArray[2];
        }
        textureUnitStateRetained.evaluateTexCrdSrc();
    }

    boolean equivalent(TextureUnitStateRetained textureUnitStateRetained) {
        return this == textureUnitStateRetained || textureUnitStateRetained != null && this.texture == textureUnitStateRetained.texture && (this.texAttrs == textureUnitStateRetained.texAttrs || this.texAttrs != null && this.texAttrs.equivalent(textureUnitStateRetained.texAttrs)) && (this.texGen == textureUnitStateRetained.texGen || this.texGen != null && this.texGen.equivalent(textureUnitStateRetained.texGen));
    }

    protected Object clone() {
        TextureUnitStateRetained textureUnitStateRetained = (TextureUnitStateRetained)super.clone();
        if (this.texAttrs != null) {
            textureUnitStateRetained.texAttrs = (TextureAttributesRetained)this.texAttrs.clone();
        }
        if (this.texGen != null) {
            textureUnitStateRetained.texGen = (TexCoordGenerationRetained)this.texGen.clone();
        }
        return textureUnitStateRetained;
    }

    protected void set(TextureUnitStateRetained textureUnitStateRetained) {
        this.texture = textureUnitStateRetained.texture;
        if (textureUnitStateRetained.texAttrs == null) {
            this.texAttrs = null;
        } else if (this.texAttrs == null) {
            this.texAttrs = (TextureAttributesRetained)textureUnitStateRetained.texAttrs.clone();
        } else {
            this.texAttrs.set(textureUnitStateRetained.texAttrs);
        }
        if (textureUnitStateRetained.texGen == null) {
            this.texGen = null;
        } else if (this.texGen == null) {
            this.texGen = (TexCoordGenerationRetained)textureUnitStateRetained.texGen.clone();
        } else {
            this.texGen.set(textureUnitStateRetained.texGen);
        }
        this.texCrdGenPresent = textureUnitStateRetained.texCrdGenPresent;
    }

    protected void set(TextureRetained textureRetained, TextureAttributesRetained textureAttributesRetained, TexCoordGenerationRetained texCoordGenerationRetained) {
        this.texture = textureRetained;
        this.texAttrs = textureAttributesRetained;
        this.texGen = texCoordGenerationRetained;
        this.evaluateTexCrdSrc();
    }

    synchronized void addAMirrorUser(Shape3DRetained shape3DRetained) {
        super.addAMirrorUser(shape3DRetained);
        if (this.texture != null) {
            this.texture.addAMirrorUser(shape3DRetained);
        }
        if (this.texAttrs != null) {
            this.texAttrs.addAMirrorUser(shape3DRetained);
        }
        if (this.texGen != null) {
            this.texGen.addAMirrorUser(shape3DRetained);
        }
    }

    synchronized void removeAMirrorUser(Shape3DRetained shape3DRetained) {
        super.removeAMirrorUser(shape3DRetained);
        if (this.texture != null) {
            this.texture.removeAMirrorUser(shape3DRetained);
        }
        if (this.texAttrs != null) {
            this.texAttrs.removeAMirrorUser(shape3DRetained);
        }
        if (this.texGen != null) {
            this.texGen.removeAMirrorUser(shape3DRetained);
        }
    }

    synchronized void removeMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.removeMirrorUsers(nodeComponentRetained);
        if (this.texture != null) {
            this.texture.removeMirrorUsers(nodeComponentRetained);
        }
        if (this.texAttrs != null) {
            this.texAttrs.removeMirrorUsers(nodeComponentRetained);
        }
        if (this.texGen != null) {
            this.texGen.removeMirrorUsers(nodeComponentRetained);
        }
    }

    synchronized void copyMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.copyMirrorUsers(nodeComponentRetained);
        if (this.texture != null) {
            this.texture.copyMirrorUsers(nodeComponentRetained);
        }
        if (this.texAttrs != null) {
            this.texAttrs.copyMirrorUsers(nodeComponentRetained);
        }
        if (this.texGen != null) {
            this.texGen.copyMirrorUsers(nodeComponentRetained);
        }
    }

    void setLive(boolean bl, int n) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("AppearanceRetained42"));
        }
        if (n > 1 && bl != this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("AppearanceRetained44"));
        }
        if (this.texture != null) {
            this.texture.setLive(bl, n);
        }
        if (this.texAttrs != null) {
            this.texAttrs.setLive(bl, n);
        }
        if (this.texGen != null) {
            this.texGen.setLive(bl, n);
        }
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.texture != null) {
            this.texture.clearLive(n);
        }
        if (this.texAttrs != null) {
            this.texAttrs.clearLive(n);
        }
        if (this.texGen != null) {
            this.texGen.clearLive(n);
        }
    }

    boolean isStatic() {
        return !(!this.source.capabilities.equals(SceneGraphObjectRetained.emptyBitSet) || this.texture != null && !this.texture.isStatic() || this.texAttrs != null && !this.texAttrs.isStatic() || this.texGen != null && !this.texGen.isStatic());
    }

    boolean equals(TextureUnitStateRetained textureUnitStateRetained) {
        return textureUnitStateRetained == this || textureUnitStateRetained != null && (this.texture == textureUnitStateRetained.texture || this.texture != null && this.texture.equals(textureUnitStateRetained.texture)) && (this.texAttrs == textureUnitStateRetained.texAttrs || this.texAttrs != null && this.texAttrs.equals(textureUnitStateRetained.texAttrs)) && (this.texGen == textureUnitStateRetained.texGen || this.texGen != null && this.texGen.equals(textureUnitStateRetained.texGen));
    }

    void setInImmCtx(boolean bl) {
        if (this.texture != null) {
            this.texture.setInImmCtx(bl);
        }
        if (this.texAttrs != null) {
            this.texAttrs.setInImmCtx(bl);
        }
        if (this.texGen != null) {
            this.texGen.setInImmCtx(bl);
        }
    }

    boolean getInImmCtx() {
        return this.inImmCtx || this.texture != null && this.texture.getInImmCtx() || this.texAttrs != null && this.texAttrs.getInImmCtx() || this.texGen != null && this.texGen.getInImmCtx();
    }

    boolean isLive() {
        return this.source.isLive() || this.texture != null && this.texture.source.isLive() || this.texAttrs != null && this.texAttrs.source.isLive() || this.texGen != null && this.texGen.source.isLive();
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 47;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 47;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }

    boolean isTextureEnabled() {
        return this.texture != null && this.texture.enable;
    }

    final boolean isSpecularDisabled() {
        return VirtualUniverse.mc.isD3D() && this.texture != null && (this.texAttrs == null || this.texAttrs != null && this.texAttrs.disableSpecular);
    }

    final boolean needBlend2Pass() {
        return VirtualUniverse.mc.isD3D() && this.texAttrs != null && this.texAttrs.textureMode == 4 && this.texture != null && this.texture.format != 3 && this.texture.format != 1;
    }

    protected void evaluateTexCrdSrc() {
        this.texCrdGenPresent = this.texGen != null && this.texGen.enable;
    }
}

