/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponent3DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Texture3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

abstract class TextureRetained
extends NodeComponentRetained {
    static final int ENABLE_CHANGED = 1;
    static final int COLOR_CHANGED = 2;
    static final int IMAGE_CHANGED = 4;
    static final int STATE_CHANGED = 8;
    static final int UPDATE_IMAGE = 16;
    static final int IMAGES_CHANGED = 32;
    int boundaryModeS = 3;
    int boundaryModeT = 3;
    int minFilter = 2;
    int magFilter = 2;
    int isDirty = 65535;
    Color4f boundaryColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int objectId = -1;
    int mipmapMode = 1;
    int format = 5;
    int width = 1;
    int height = 1;
    ImageComponentRetained[] images;
    boolean imagesLoaded;
    int numLevels;
    int mipmapLevels;
    boolean enable = true;
    boolean userSpecifiedEnable = true;
    boolean isAlphaNeedUpdate = false;
    int resourceDirtyMask = -1;
    int resourceCreationMask = 0;
    int textureBinRefCount = 0;
    private int texTimestamp = 0;
    Object resourceLock = new Object();

    TextureRetained() {
    }

    void initialize(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mipmapMode = n6;
        this.format = n;
        this.width = n2;
        this.height = n4;
        this.mipmapLevels = n3 > n5 ? n3 + 1 : n5 + 1;
        this.numLevels = n6 != 1 ? this.mipmapLevels : 1;
        this.images = new ImageComponentRetained[this.numLevels];
        int n7 = 0;
        while (n7 < this.numLevels) {
            this.images[n7] = null;
            ++n7;
        }
        this.imagesLoaded = false;
    }

    final int getFormat() {
        return this.format;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int numMipMapLevels() {
        return this.numLevels;
    }

    final void initBoundaryModeS(int n) {
        this.boundaryModeS = n;
    }

    final int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    final void initBoundaryModeT(int n) {
        this.boundaryModeT = n;
    }

    final int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    final void initMinFilter(int n) {
        this.minFilter = n;
    }

    final int getMinFilter() {
        return this.minFilter;
    }

    final void initMagFilter(int n) {
        this.magFilter = n;
    }

    final int getMagFilter() {
        return this.magFilter;
    }

    final void initImage(int n, ImageComponent imageComponent) {
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (this.source instanceof Texture2D) {
            if (imageComponent instanceof ImageComponent3D) {
                throw new IllegalArgumentException(J3dI18N.getString("Texture8"));
            }
        } else if (imageComponent instanceof ImageComponent2D) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture14"));
        }
        if (this.source.isLive()) {
            if (((ImageComponentRetained)imageComponent.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("TextureRetained2"));
            }
            if (this.images[n] != null) {
                this.images[n].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        if (this instanceof Texture2DRetained) {
            ((ImageComponent2DRetained)imageComponent.retained).setTextureRef();
        } else {
            ((ImageComponent3DRetained)imageComponent.retained).setTextureRef();
        }
        this.images[n] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void checkImageSize(int n, ImageComponent imageComponent) {
        if (imageComponent != null) {
            int n2 = ((ImageComponentRetained)imageComponent.retained).height;
            int n3 = ((ImageComponentRetained)imageComponent.retained).width;
            int n4 = 1;
            int n5 = 0;
            while (n5 < n) {
                ++n5;
                n4 *= 2;
            }
            int n6 = this.height / n4;
            int n7 = this.width / n4;
            if (n6 < 1) {
                n6 = 1;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            if (n6 != n2 || n7 != n3) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
            }
        }
    }

    final void checkSizes(ImageComponentRetained[] imageComponentRetainedArray) {
        if (imageComponentRetainedArray != null && imageComponentRetainedArray.length > 1) {
            int n = imageComponentRetainedArray[0].width / 2;
            int n2 = imageComponentRetainedArray[0].height / 2;
            int n3 = 1;
            while (n3 < imageComponentRetainedArray.length) {
                int n4 = imageComponentRetainedArray[n3].width;
                int n5 = imageComponentRetainedArray[n3].height;
                if (n < 1) {
                    n = 1;
                }
                if (n2 < 1) {
                    n2 = 1;
                }
                if (n4 != n && n5 != n2) {
                    throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
                }
                n = n4 / 2;
                n2 = n5 / 2;
                ++n3;
            }
        }
    }

    final void setImage(int n, ImageComponent imageComponent) {
        this.checkImageSize(n, imageComponent);
        this.initImage(n, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n), imageComponent};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n < this.numLevels) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.bImage[0] == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.imageYup == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    final void initImages(ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.numLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        int n = 0;
        while (n < imageComponentArray.length) {
            this.initImage(n, imageComponentArray[n]);
            ++n;
        }
    }

    final void setImages(ImageComponent[] imageComponentArray) {
        ImageComponentRetained[] imageComponentRetainedArray = new ImageComponentRetained[imageComponentArray.length];
        int n = 0;
        while (n < imageComponentArray.length) {
            imageComponentRetainedArray[n] = (ImageComponentRetained)imageComponentArray[n].retained;
            ++n;
        }
        this.checkSizes(imageComponentRetainedArray);
        this.initImages(imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        n = 0;
        while (n < imageComponentArray.length) {
            imageComponentArray2[n] = imageComponentArray[n];
            ++n;
        }
        this.sendMessage(32, imageComponentArray2);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            n = 0;
            while (this.enable && n < this.numLevels) {
                if (imageComponentArray[n] != null) {
                    ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n].retained;
                    if (imageComponentRetained.isByReference()) {
                        if (imageComponentRetained.bImage[0] == null) {
                            this.enable = false;
                        }
                    } else if (imageComponentRetained.imageYup == null) {
                        this.enable = false;
                    }
                }
                ++n;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n) {
        return this.images != null && this.images[n] != null ? (ImageComponent)this.images[n].source : null;
    }

    final ImageComponent[] getImages() {
        if (this.images == null) {
            return null;
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images.length];
        int n = 0;
        while (n < this.images.length) {
            imageComponentArray[n] = this.images[n] != null ? (ImageComponent)this.images[n].source : null;
            ++n;
        }
        return imageComponentArray;
    }

    final void initMipMapMode(int n) {
        this.mipmapMode = n;
        int n2 = n != 1 ? this.mipmapLevels : 1;
        if (n2 == this.numLevels) {
            return;
        }
        ImageComponentRetained[] imageComponentRetainedArray = new ImageComponentRetained[n2];
        if (n2 >= this.numLevels) {
            int n3 = 0;
            while (n3 < this.numLevels) {
                imageComponentRetainedArray[n3] = this.images[n3];
                ++n3;
            }
            int n4 = n3;
            while (n4 < n2) {
                imageComponentRetainedArray[n4] = null;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < this.numLevels) {
                imageComponentRetainedArray[n5] = this.images[n5];
                ++n5;
            }
        }
        this.images = imageComponentRetainedArray;
        this.numLevels = n2;
    }

    final int getMipMapMode() {
        return this.mipmapMode;
    }

    final void initEnable(boolean bl) {
        this.userSpecifiedEnable = bl;
    }

    final void setEnable(boolean bl) {
        int n = 0;
        this.initEnable(bl);
        this.enable = bl;
        while (this.enable && n < this.numLevels) {
            if (this.images[n].isByReference()) {
                if (this.images[n].bImage[0] == null) {
                    this.enable = false;
                }
            } else if (this.images[n].imageYup == null) {
                this.enable = false;
            }
            ++n;
        }
        this.sendMessage(1, this.enable ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.userSpecifiedEnable;
    }

    final void initBoundaryColor(Color4f color4f) {
        this.boundaryColor.set((Tuple4f)color4f);
    }

    final void initBoundaryColor(float f, float f2, float f3, float f4) {
        this.boundaryColor.set(f, f2, f3, f4);
    }

    final void getBoundaryColor(Color4f color4f) {
        color4f.set((Tuple4f)this.boundaryColor);
    }

    native void freeTexture(int var1);

    void setLive(boolean bl, int n) {
        int n2;
        this.checkSizes(this.images);
        this.enable = this.userSpecifiedEnable;
        super.doSetLive(bl, n);
        if (this.images != null) {
            n2 = 0;
            while (n2 < this.numLevels) {
                if (this.images[n2] == null) {
                    throw new IllegalArgumentException(J3dI18N.getString("TextureRetained3") + n2);
                }
                this.images[n2].setLive(bl, n);
                ++n2;
            }
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        VirtualUniverse.mc.processMessage(j3dMessage);
        if (this.userSpecifiedEnable) {
            n2 = 0;
            while (this.enable && n2 < this.numLevels) {
                if (this.images[n2].isByReference()) {
                    if (this.images[n2].bImage[0] == null) {
                        this.enable = false;
                    }
                } else if (this.images[n2].imageYup == null) {
                    this.enable = false;
                }
                ++n2;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
        super.markAsLive();
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.images != null) {
            int n2 = 0;
            while (n2 < this.numLevels) {
                this.images[n2].clearLive(n);
                ++n2;
            }
        }
    }

    native void bindTexture(int var1, int var2, boolean var3);

    native int updateTextureFields(int var1, int var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10);

    native void updateTextureImage(int var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8);

    native void updateTextureSubImage(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, byte[] var12);

    void freeTextureId() {
        VirtualUniverse.mc.freeTexture2DId(this.objectId);
        this.objectId = -1;
    }

    void updateNative(Canvas3D canvas3D) {
        boolean bl = false;
        if (canvas3D.useSharedCtx) {
            if ((this.resourceCreationMask & canvas3D.screen.renderer.rendererBit) == 0) {
                bl = true;
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
            }
        } else if ((this.resourceCreationMask & canvas3D.canvasBit) == 0) {
            bl = true;
        }
        if (VirtualUniverse.mc.isD3D()) {
            if (this.objectId > 0) {
                this.updateTextureFields(canvas3D.ctx, this.objectId, this.minFilter, this.magFilter, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
            }
            if (this.texTimestamp != VirtualUniverse.mc.resendTexTimestamp) {
                this.texTimestamp = VirtualUniverse.mc.resendTexTimestamp;
                bl = true;
            }
        }
        if (bl) {
            Object object = this.resourceLock;
            synchronized (object) {
                if (this.objectId == -1) {
                    this.objectId = VirtualUniverse.mc.getTexture2DId();
                }
            }
            this.updateTextureFields(canvas3D.ctx, this.objectId, this.minFilter, this.magFilter, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
            int n = 0;
            while (n < this.numLevels) {
                ImageComponentRetained imageComponentRetained = this.images[n];
                this.updateTextureImage(canvas3D.ctx, this.numLevels, n, this.format, imageComponentRetained.storedFormat, imageComponentRetained.width, imageComponentRetained.height, imageComponentRetained.imageYup);
                if (imageComponentRetained.imageYupClass == 2) {
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = imageComponentRetained.width;
                    int n5 = imageComponentRetained.height;
                    int n6 = imageComponentRetained.minTileX * imageComponentRetained.tilew + imageComponentRetained.tileGridXOffset + imageComponentRetained.tilew;
                    int n7 = imageComponentRetained.minTileY * imageComponentRetained.tileh + imageComponentRetained.tileGridYOffset + imageComponentRetained.tileh;
                    int n8 = n6 - imageComponentRetained.minX;
                    int n9 = n7 - imageComponentRetained.minY;
                    if (n4 < n8) {
                        n8 = n4;
                    }
                    if (n5 < n9) {
                        n9 = n5;
                    }
                    int n10 = n8;
                    int n11 = imageComponentRetained.tilew - n8;
                    int n12 = imageComponentRetained.tileh - n9;
                    int n13 = imageComponentRetained.minTileY;
                    while (n13 < imageComponentRetained.minTileY + imageComponentRetained.numYTiles) {
                        n2 = 0;
                        n4 = this.width;
                        n8 = n10;
                        n11 = imageComponentRetained.tilew - n8;
                        int n14 = imageComponentRetained.minTileX;
                        while (n14 < imageComponentRetained.minTileX + imageComponentRetained.numXTiles) {
                            Raster raster = imageComponentRetained.bImage[0].getTile(n14, n13);
                            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                            this.updateTextureSubImage(canvas3D.ctx, n, n2, n3, this.format, imageComponentRetained.storedFormat, n11, n12, imageComponentRetained.tilew, n8, n9, byArray);
                            n2 += n8;
                            n11 = 0;
                            n8 = (n4 -= n8) < imageComponentRetained.tilew ? n4 : imageComponentRetained.tilew;
                            ++n14;
                        }
                        n3 += n9;
                        n12 = 0;
                        n9 = (n5 -= n9) < imageComponentRetained.tileh ? n5 : imageComponentRetained.tileh;
                        ++n13;
                    }
                }
                ++n;
            }
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object2 = this.resourceLock;
                synchronized (object2) {
                    this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
                }
            }
            Object object3 = this.resourceLock;
            synchronized (object3) {
                this.resourceCreationMask |= canvas3D.canvasBit;
            }
        }
        this.bindTexture(canvas3D.ctx, this.objectId, this.enable);
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this instanceof Texture3DRetained) {
                Texture3DRetained texture3DRetained = (Texture3DRetained)this;
                Texture3D texture3D = new Texture3D(texture3DRetained.mipmapMode, texture3DRetained.format, texture3DRetained.width, texture3DRetained.height, texture3DRetained.depth);
                this.mirror = (Texture3DRetained)texture3D.retained;
            } else {
                Texture2D texture2D = new Texture2D(this.mipmapMode, this.format, this.width, this.height);
                this.mirror = (Texture2DRetained)texture2D.retained;
            }
            ((TextureRetained)this.mirror).objectId = -1;
        }
        this.initMirrorObject();
    }

    synchronized void initMirrorObject() {
        TextureRetained textureRetained;
        this.mirror.source = this.source;
        if (this instanceof Texture3DRetained) {
            textureRetained = (Texture3DRetained)this;
            ((Texture3DRetained)this.mirror).boundaryModeR = textureRetained.boundaryModeR;
            ((Texture3DRetained)this.mirror).depth = textureRetained.depth;
        }
        textureRetained = (TextureRetained)this.mirror;
        textureRetained.boundaryModeS = this.boundaryModeS;
        textureRetained.boundaryModeT = this.boundaryModeT;
        textureRetained.minFilter = this.minFilter;
        textureRetained.magFilter = this.magFilter;
        textureRetained.boundaryColor.set((Tuple4f)this.boundaryColor);
        textureRetained.enable = this.enable;
        textureRetained.userSpecifiedEnable = this.enable;
        textureRetained.imagesLoaded = this.imagesLoaded;
        textureRetained.enable = this.enable;
        textureRetained.resourceDirtyMask = -1;
        if (this.mipmapMode == 1 && (this.minFilter == 1 || this.minFilter == 4 || this.minFilter == 5)) {
            textureRetained.numLevels = this.mipmapLevels;
            if (textureRetained.images.length < this.mipmapLevels) {
                textureRetained.images = new ImageComponentRetained[this.mipmapLevels];
            }
            textureRetained.images[0] = this.images[0];
            int n = 1;
            while (n < this.mipmapLevels) {
                textureRetained.images[n] = this.createNextLevelImage(textureRetained.images[n - 1]);
                ++n;
            }
        } else {
            textureRetained.numLevels = this.numLevels;
            if (this.images != null) {
                System.arraycopy(this.images, 0, textureRetained.images, 0, this.images.length);
            }
        }
    }

    synchronized void updateMirrorObject(int n, Object object) {
        if ((n & 1) != 0) {
            ((TextureRetained)this.mirror).enable = (Boolean)object;
        } else if ((n & 4) != 0) {
            Object[] objectArray = (Object[])object;
            ImageComponent imageComponent = (ImageComponent)objectArray[1];
            ((TextureRetained)this.mirror).images[((Integer)objectArray[0]).intValue()] = (ImageComponentRetained)(imageComponent == null ? null : imageComponent.retained);
            this.updateResourceCreationMask();
        } else if ((n & 0x20) != 0) {
            ImageComponent[] imageComponentArray = (ImageComponent[])object;
            int n2 = 0;
            while (n2 < imageComponentArray.length) {
                ((TextureRetained)this.mirror).images[n2] = (ImageComponentRetained)(imageComponentArray[n2] == null ? null : imageComponentArray[n2].retained);
                ++n2;
            }
            this.updateResourceCreationMask();
        } else if ((n & 0x10) != 0) {
            this.updateResourceCreationMask();
        }
    }

    void updateResourceCreationMask() {
        ((TextureRetained)this.mirror).resourceCreationMask = 0;
    }

    final ImageComponentRetained createNextLevelImage(ImageComponentRetained imageComponentRetained) {
        int n;
        int n2;
        int n3;
        int n4;
        ImageComponentRetained imageComponentRetained2 = null;
        if (imageComponentRetained.width > 1) {
            n4 = imageComponentRetained.width >> 1;
            n3 = 2;
        } else {
            n4 = 1;
            n3 = 1;
        }
        if (imageComponentRetained.height > 1) {
            n2 = imageComponentRetained.height >> 1;
            n = 2;
        } else {
            n2 = 1;
            n = 1;
        }
        int n5 = imageComponentRetained.bytesPerPixelStored;
        if (imageComponentRetained instanceof ImageComponent2DRetained) {
            imageComponentRetained2 = new ImageComponent2DRetained();
            imageComponentRetained2.processParams(imageComponentRetained.format, n4, n2, 1);
            imageComponentRetained2.imageYup = new byte[n4 * n2 * n5];
            imageComponentRetained2.alphaChanged = imageComponentRetained.alphaChanged;
            imageComponentRetained2.lastAlpha = imageComponentRetained.lastAlpha;
            imageComponentRetained2.storedFormat = imageComponentRetained2.internalFormat;
            this.scaleImage(n4, n2, n3, n, imageComponentRetained.width, 0, 0, n5, imageComponentRetained2.imageYup, imageComponentRetained.imageYup);
        } else {
            int n6 = ((ImageComponent3DRetained)imageComponentRetained).depth;
            imageComponentRetained2 = new ImageComponent3DRetained();
            imageComponentRetained2.processParams(imageComponentRetained.format, n4, n2, n6);
            imageComponentRetained2.imageYup = new byte[n4 * n2 * n5];
            imageComponentRetained2.alphaChanged = imageComponentRetained.alphaChanged;
            imageComponentRetained2.lastAlpha = imageComponentRetained.lastAlpha;
            imageComponentRetained2.storedFormat = imageComponentRetained2.internalFormat;
            int n7 = 0;
            while (n7 < n6) {
                this.scaleImage(n4, n2, n3, n, imageComponentRetained.width, n7 * n4 * n2 * n5, n7 * imageComponentRetained.width * imageComponentRetained.height * n5, n5, imageComponentRetained2.imageYup, imageComponentRetained.imageYup);
                ++n7;
            }
        }
        return imageComponentRetained2;
    }

    final void scaleImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, byte[] byArray2) {
        int n9 = 0;
        int n10 = 0;
        int n11 = n8 * n5;
        int n12 = n8 << 1;
        if (n4 == 1) {
            int n13 = 0;
            while (n13 < n) {
                int n14 = 0;
                while (n14 < n8) {
                    byArray[n6 + n9 + n14] = (byte)((byArray2[n7 + n10 + n14] & 0xFF) + (byArray2[n7 + n10 + n14 + n8] & 0xFF) + 1 >> 1);
                    ++n14;
                }
                n9 += n8;
                n10 += n12;
                ++n13;
            }
        } else if (n3 == 1) {
            int n15 = 0;
            while (n15 < n2) {
                int n16 = 0;
                while (n16 < n8) {
                    byArray[n6 + n9 + n16] = (byte)((byArray2[n7 + n10 + n16] & 0xFF) + (byArray2[n7 + n10 + n16 + n11] & 0xFF) + 1 >> 1);
                    ++n16;
                }
                n9 += n8;
                n10 += n11;
                ++n15;
            }
        } else {
            int n17 = 0;
            while (n17 < n2) {
                int n18 = 0;
                while (n18 < n) {
                    int n19 = 0;
                    while (n19 < n8) {
                        byArray[n6 + n9 + n19] = (byte)((byArray2[n7 + n10 + n19] & 0xFF) + (byArray2[n7 + n10 + n19 + n8] & 0xFF) + (byArray2[n7 + n10 + n19 + n11] & 0xFF) + (byArray2[n7 + n10 + n19 + n11 + n8] & 0xFF) + 2 >> 2);
                        ++n19;
                    }
                    n9 += n8;
                    n10 += n12;
                    ++n18;
                }
                n10 += n11;
                ++n17;
            }
        }
    }

    void incTextureBinRefCount() {
        ++this.textureBinRefCount;
    }

    void decTextureBinRefCount() {
        --this.textureBinRefCount;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 15;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }
}

