/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.VirtualUniverse;

class TextureBin
implements ObjectUpdate {
    TextureUnitStateRetained[] texUnitState = null;
    int lastActiveTexUnitIndex;
    int numActiveTexUnit;
    int numImages;
    ImageComponentRetained[] images = null;
    RenderBin renderBin = null;
    AttributeBin attributeBin = null;
    TextureBin next = null;
    TextureBin prev = null;
    int equivalent = 0;
    HashMap addRMs = new HashMap();
    HashMap renderMoleculeMap = new HashMap();
    RenderMolecule rmlist;
    boolean onUpdateList = false;
    boolean inTextureBinList = false;

    TextureBin(TextureUnitStateRetained[] textureUnitStateRetainedArray, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.reset(textureUnitStateRetainedArray);
    }

    void reset(TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        int n = 0;
        this.prev = null;
        this.next = null;
        this.onUpdateList = false;
        this.inTextureBinList = false;
        this.numActiveTexUnit = 0;
        this.lastActiveTexUnitIndex = 0;
        if (textureUnitStateRetainedArray != null) {
            if (this.texUnitState == null || this.texUnitState.length != textureUnitStateRetainedArray.length) {
                this.texUnitState = new TextureUnitStateRetained[textureUnitStateRetainedArray.length];
            }
            int n2 = 0;
            while (n2 < textureUnitStateRetainedArray.length) {
                if (textureUnitStateRetainedArray[n2] == null) {
                    this.texUnitState[n2] = null;
                } else {
                    if (this.texUnitState[n2] == null) {
                        this.texUnitState[n2] = new TextureUnitStateRetained();
                    }
                    this.texUnitState[n2].set(textureUnitStateRetainedArray[n2]);
                    if (this.texUnitState[n2].isTextureEnabled()) {
                        ++this.numActiveTexUnit;
                        this.lastActiveTexUnitIndex = n2;
                    }
                    if (this.texUnitState[n2].texture != null && this.texUnitState[n2].texture instanceof Texture2DRetained) {
                        n += this.texUnitState[n2].texture.numLevels;
                    }
                }
                ++n2;
            }
            if (n > this.numImages) {
                this.images = new ImageComponentRetained[n];
            }
            this.numImages = n;
            n = 0;
            if (!this.inTextureBinList) {
                this.renderBin.addTextureBin(this);
                this.inTextureBinList = true;
            }
        } else {
            this.numImages = 0;
            this.texUnitState = null;
        }
    }

    boolean equals(TextureUnitStateRetained[] textureUnitStateRetainedArray, RenderAtom renderAtom) {
        boolean bl;
        int n;
        int n2;
        boolean bl2 = false;
        if (renderAtom.geometryAtom.geoType <= 14) {
            GeometryRetained geometryRetained = null;
            n2 = 0;
            while (geometryRetained == null && n2 < renderAtom.geometryAtom.geometryArray.length) {
                geometryRetained = renderAtom.geometryAtom.geometryArray[n2];
                ++n2;
            }
            n = ((GeometryArrayRetained)geometryRetained).vertexFormat;
        } else {
            n = 0;
        }
        boolean bl3 = bl = (n & 0x60) != 0;
        if (this.texUnitState == null && textureUnitStateRetainedArray == null) {
            return true;
        }
        if (this.texUnitState == null || textureUnitStateRetainedArray == null) {
            return false;
        }
        if (textureUnitStateRetainedArray.length != this.texUnitState.length) {
            return false;
        }
        n2 = 0;
        while (n2 < this.texUnitState.length) {
            if (this.texUnitState[n2] == null) {
                if (textureUnitStateRetainedArray[n2] != null) {
                    return false;
                }
            } else {
                boolean bl4;
                if (!this.texUnitState[n2].equivalent(textureUnitStateRetainedArray[n2])) {
                    return false;
                }
                boolean bl5 = bl4 = !textureUnitStateRetainedArray[n2].texCrdGenPresent && !bl;
                if (this.texUnitState[n2].noTexCoordSrc != bl4) {
                    return false;
                }
            }
            ++n2;
        }
        if (!this.inTextureBinList) {
            this.renderBin.addTextureBin(this);
            this.inTextureBinList = true;
        }
        return true;
    }

    public void updateObject() {
        Collection collection = this.addRMs.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RenderMolecule renderMolecule;
            boolean bl = false;
            ArrayList arrayList = (ArrayList)iterator.next();
            RenderMolecule renderMolecule2 = (RenderMolecule)arrayList.get(0);
            RenderMolecule renderMolecule3 = (RenderMolecule)this.renderMoleculeMap.get(renderMolecule2.localToVworld);
            if (renderMolecule3 == null) {
                renderMolecule3 = renderMolecule2;
                this.renderMoleculeMap.put(renderMolecule2.localToVworld, renderMolecule3);
                if (this.rmlist == null) {
                    this.rmlist = renderMolecule2;
                    renderMolecule2.nextMap = null;
                    renderMolecule2.prevMap = null;
                    this.rmlist.dirtyAttrsAcrossRms = 63;
                } else {
                    renderMolecule2.nextMap = this.rmlist;
                    this.rmlist.prevMap = renderMolecule2;
                    this.rmlist = renderMolecule2;
                    this.rmlist.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule2);
                }
            } else {
                renderMolecule = this.insertRenderMolecule(renderMolecule2, renderMolecule3);
                if (renderMolecule != null) {
                    if (renderMolecule3.prevMap != null) {
                        renderMolecule3.prevMap.nextMap = renderMolecule;
                    }
                    renderMolecule.prevMap = renderMolecule3.prevMap;
                    renderMolecule3.prevMap = null;
                    renderMolecule3 = renderMolecule;
                    bl = true;
                }
            }
            int n = 1;
            while (n < arrayList.size()) {
                renderMolecule2 = (RenderMolecule)arrayList.get(n);
                renderMolecule = this.insertRenderMolecule(renderMolecule2, renderMolecule3);
                if (renderMolecule != null) {
                    if (renderMolecule3.prevMap != null) {
                        renderMolecule3.prevMap.nextMap = renderMolecule;
                    }
                    renderMolecule.prevMap = renderMolecule3.prevMap;
                    renderMolecule3.prevMap = null;
                    renderMolecule3 = renderMolecule;
                    bl = true;
                }
                ++n;
            }
            if (!bl) continue;
            this.renderMoleculeMap.put(renderMolecule2.localToVworld, renderMolecule3);
            if (renderMolecule3.prevMap != null) {
                renderMolecule3.checkEquivalenceWithLeftNeighbor(renderMolecule3.prevMap);
                continue;
            }
            this.rmlist = renderMolecule3;
            this.rmlist.dirtyAttrsAcrossRms = 63;
        }
        this.addRMs.clear();
        this.onUpdateList = false;
    }

    RenderMolecule insertRenderMolecule(RenderMolecule renderMolecule, RenderMolecule renderMolecule2) {
        RenderMolecule renderMolecule3 = renderMolecule2;
        while (renderMolecule3 != null) {
            if (renderMolecule3.definingMaterial == renderMolecule.definingMaterial || renderMolecule3.definingMaterial != null && renderMolecule3.definingMaterial.equivalent(renderMolecule.definingMaterial)) {
                RenderMolecule renderMolecule4;
                renderMolecule.next = renderMolecule3;
                renderMolecule.prev = renderMolecule3.prev;
                if (renderMolecule3.prev == null) {
                    renderMolecule4 = renderMolecule2 = renderMolecule;
                } else {
                    renderMolecule3.prev.next = renderMolecule;
                    renderMolecule4 = null;
                }
                renderMolecule3.prev = renderMolecule;
                renderMolecule.checkEquivalenceWithBothNeighbors();
                return renderMolecule4;
            }
            renderMolecule3 = renderMolecule3.next;
        }
        renderMolecule.next = renderMolecule2;
        renderMolecule2.prev = renderMolecule;
        renderMolecule2 = renderMolecule;
        renderMolecule.checkEquivalenceWithBothNeighbors();
        return renderMolecule2;
    }

    void addRenderMolecule(RenderMolecule renderMolecule, RenderBin renderBin) {
        ArrayList<RenderMolecule> arrayList;
        renderMolecule.textureBin = this;
        if (this.renderMoleculeMap.isEmpty() && this.addRMs.isEmpty()) {
            renderMolecule.doTextureEnableChecking();
        }
        if ((arrayList = (ArrayList<RenderMolecule>)this.addRMs.get(renderMolecule.localToVworld)) == null) {
            arrayList = new ArrayList<RenderMolecule>();
            this.addRMs.put(renderMolecule.localToVworld, arrayList);
        }
        arrayList.add(renderMolecule);
        if (!this.onUpdateList) {
            this.onUpdateList = true;
            renderBin.objUpdateList.add(this);
        }
    }

    void removeRenderMolecule(RenderMolecule renderMolecule) {
        int n;
        boolean bl = false;
        renderMolecule.textureBin = null;
        ArrayList arrayList = (ArrayList)this.addRMs.get(renderMolecule.localToVworld);
        if (arrayList != null && (n = arrayList.indexOf(renderMolecule)) != -1) {
            arrayList.remove(n);
            if (arrayList.isEmpty()) {
                this.addRMs.remove(renderMolecule.localToVworld);
            }
            renderMolecule.prev = null;
            renderMolecule.next = null;
            this.renderBin.renderMoleculeFreelist.add(renderMolecule);
            bl = true;
        }
        if (!bl) {
            if (renderMolecule.prev != null && renderMolecule.next != null) {
                renderMolecule.prev.next = renderMolecule.next;
                renderMolecule.next.prev = renderMolecule.prev;
                renderMolecule.next.checkEquivalenceWithLeftNeighbor(renderMolecule.prev);
            } else if (renderMolecule.prev != null && renderMolecule.next == null) {
                renderMolecule.prev.next = renderMolecule.next;
                renderMolecule.prev.nextMap = renderMolecule.nextMap;
                if (renderMolecule.nextMap != null) {
                    renderMolecule.nextMap.prevMap = renderMolecule.prev;
                    renderMolecule.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule.prev);
                }
            } else if (renderMolecule.prev == null && renderMolecule.next != null) {
                renderMolecule.next.prev = null;
                renderMolecule.next.prevMap = renderMolecule.prevMap;
                if (renderMolecule.prevMap != null) {
                    renderMolecule.prevMap.nextMap = renderMolecule.next;
                    renderMolecule.next.checkEquivalenceWithLeftNeighbor(renderMolecule.prevMap);
                } else {
                    this.rmlist = renderMolecule.next;
                    this.rmlist.dirtyAttrsAcrossRms = 63;
                }
                this.renderMoleculeMap.put(renderMolecule.localToVworld, renderMolecule.next);
            } else if (renderMolecule.prev == null && renderMolecule.next == null) {
                if (renderMolecule.prevMap != null) {
                    renderMolecule.prevMap.nextMap = renderMolecule.nextMap;
                } else {
                    this.rmlist = renderMolecule.nextMap;
                    if (renderMolecule.nextMap != null) {
                        this.rmlist.dirtyAttrsAcrossRms = 63;
                    }
                }
                if (renderMolecule.nextMap != null) {
                    renderMolecule.nextMap.prevMap = renderMolecule.prevMap;
                    if (renderMolecule.prevMap != null) {
                        renderMolecule.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule.prevMap);
                    }
                }
                this.renderMoleculeMap.remove(renderMolecule.localToVworld);
            }
            renderMolecule.prev = null;
            renderMolecule.next = null;
            renderMolecule.prevMap = null;
            renderMolecule.nextMap = null;
            this.renderBin.removeRenderMolecule(renderMolecule);
        }
        if (this.renderMoleculeMap.isEmpty() && this.addRMs.isEmpty()) {
            if (this.inTextureBinList) {
                this.inTextureBinList = false;
                this.renderBin.removeTextureBin(this);
            }
            this.attributeBin.removeTextureBin(this);
            this.texUnitState = null;
            int n2 = 0;
            while (n2 < this.numImages) {
                this.images[n2] = null;
                ++n2;
            }
        }
    }

    void render(Canvas3D canvas3D) {
        boolean bl = false;
        boolean bl2 = false;
        canvas3D.textureBin = this;
        if (this.texUnitState == null) {
            if (canvas3D.multiTexAccelerated) {
                int n = 0;
                while (n < canvas3D.numTexUnitSupported) {
                    canvas3D.resetTexture(canvas3D.ctx, n);
                    ++n;
                }
                canvas3D.activeTextureUnitState(canvas3D.ctx, 0);
            } else {
                canvas3D.resetTexture(canvas3D.ctx, -1);
            }
            this.render(canvas3D, 0);
        } else {
            int n;
            bl = this.numActiveTexUnit != 1 || this.lastActiveTexUnitIndex != 0;
            boolean bl3 = false;
            if (VirtualUniverse.mc.isD3D()) {
                n = 0;
                while (n < this.texUnitState.length) {
                    if (this.texUnitState[n] != null && this.texUnitState[n].isTextureEnabled() && this.texUnitState[n].needBlend2Pass()) {
                        bl3 = true;
                        break;
                    }
                    ++n;
                }
            }
            if (canvas3D.numTexUnitSupported >= this.numActiveTexUnit && canvas3D.multiTexAccelerated && !bl3) {
                n = 0;
                int n2 = 0;
                while (n2 < this.texUnitState.length) {
                    if (this.texUnitState[n2] != null && this.texUnitState[n2].isTextureEnabled()) {
                        this.texUnitState[n2].updateNative(n, canvas3D, bl, false);
                        canvas3D.setTexUnitStateMap(n2, n++);
                        if (!bl2) {
                            bl2 = this.texUnitState[n2].isSpecularDisabled();
                        }
                    } else {
                        canvas3D.setTexUnitStateMap(n2, -1);
                    }
                    ++n2;
                }
                int n3 = n;
                while (n3 < canvas3D.numTexUnitSupported) {
                    canvas3D.resetTexture(canvas3D.ctx, n3);
                    ++n3;
                }
                canvas3D.activeTextureUnitState(canvas3D.ctx, 0);
                if (bl2 && VirtualUniverse.mc.isD3D()) {
                    canvas3D.setSpecular(canvas3D.ctx, false);
                    this.render(canvas3D, -1);
                    canvas3D.setSpecular(canvas3D.ctx, true);
                } else {
                    this.render(canvas3D, -1);
                }
            } else {
                n = 0;
                boolean bl4 = false;
                boolean bl5 = false;
                if (this.numActiveTexUnit < 1) {
                    canvas3D.resetTexture(canvas3D.ctx, -1);
                    this.render(canvas3D, 0);
                } else if (this.numActiveTexUnit == 1) {
                    this.texUnitState[this.lastActiveTexUnitIndex].updateNative(-1, canvas3D, bl, false);
                    if (!this.texUnitState[this.lastActiveTexUnitIndex].needBlend2Pass()) {
                        if (this.texUnitState[this.lastActiveTexUnitIndex].isSpecularDisabled()) {
                            canvas3D.setSpecular(canvas3D.ctx, false);
                            this.render(canvas3D, this.lastActiveTexUnitIndex);
                            canvas3D.setSpecular(canvas3D.ctx, true);
                        } else {
                            this.render(canvas3D, this.lastActiveTexUnitIndex);
                        }
                    } else {
                        boolean bl6 = bl5 = this.attributeBin.environmentSet.fog != null;
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, false);
                        }
                        this.render(canvas3D, this.lastActiveTexUnitIndex);
                        this.texUnitState[this.lastActiveTexUnitIndex].texAttrs.updateBlend2Pass(canvas3D.ctx);
                        canvas3D.setSpecular(canvas3D.ctx, false);
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                        }
                        canvas3D.setDepthFunc(canvas3D.ctx, 1);
                        this.render(canvas3D, this.lastActiveTexUnitIndex);
                        canvas3D.setSpecular(canvas3D.ctx, true);
                        this.texUnitState[this.lastActiveTexUnitIndex].texAttrs.restoreBlend1Pass(canvas3D.ctx);
                        canvas3D.setDepthFunc(canvas3D.ctx, 0);
                    }
                } else {
                    bl5 = this.attributeBin.environmentSet.fog != null;
                    RenderMolecule renderMolecule = this.rmlist;
                    while (renderMolecule != null) {
                        bl4 = false;
                        n = 0;
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, false);
                        }
                        int n4 = 0;
                        while (n4 < this.texUnitState.length) {
                            if (this.texUnitState[n4] != null && this.texUnitState[n4].isTextureEnabled()) {
                                this.texUnitState[n4].updateNative(-1, canvas3D, bl, bl4);
                                if (bl4 && n == 0) {
                                    canvas3D.setDepthFunc(canvas3D.ctx, 1);
                                    n = 1;
                                }
                                bl4 = true;
                                if (!this.texUnitState[n4].needBlend2Pass()) {
                                    if (n4 == this.lastActiveTexUnitIndex && bl5) {
                                        canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                                    }
                                    if (this.texUnitState[n4].isSpecularDisabled()) {
                                        canvas3D.setSpecular(canvas3D.ctx, false);
                                        renderMolecule.render(canvas3D, n4);
                                        canvas3D.setSpecular(canvas3D.ctx, true);
                                    } else {
                                        renderMolecule.render(canvas3D, n4);
                                    }
                                } else {
                                    this.render(canvas3D, n4);
                                    this.texUnitState[n4].texAttrs.updateBlend2Pass(canvas3D.ctx);
                                    canvas3D.setSpecular(canvas3D.ctx, false);
                                    if (n == 0) {
                                        canvas3D.setDepthFunc(canvas3D.ctx, 1);
                                        n = 1;
                                    }
                                    if (n4 == this.lastActiveTexUnitIndex && bl5) {
                                        canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                                    }
                                    this.render(canvas3D, n4);
                                    canvas3D.setSpecular(canvas3D.ctx, true);
                                    this.texUnitState[n4].texAttrs.restoreBlend1Pass(canvas3D.ctx);
                                }
                            }
                            ++n4;
                        }
                        if (n != 0) {
                            canvas3D.setDepthFunc(canvas3D.ctx, 0);
                            renderMolecule.renderTransparencyAttributes(canvas3D);
                        }
                        renderMolecule = renderMolecule.next == null ? renderMolecule.nextMap : renderMolecule.next;
                    }
                }
            }
        }
        canvas3D.canvasDirty &= 0xFFFFFBFF;
    }

    void render(Canvas3D canvas3D, int n) {
        RenderMolecule renderMolecule = this.rmlist;
        while (renderMolecule != null) {
            renderMolecule.render(canvas3D, n);
            renderMolecule = renderMolecule.next == null ? renderMolecule.nextMap : renderMolecule.next;
        }
    }
}

