/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.Font3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.TriangleArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    int[] charIndex;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryRetained[] geometryList = new GeometryRetained[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;
    static char[] unicodeBlocks = new char[]{'\u0000', '\u007f', '\u0080', '\u00ff', '\u0100', '\u017f', '\u0180', '\u024f', '\u0250', '\u02af', '\u02b0', '\u02ff', '\u0300', '\u036f', '\u0370', '\u03ff', '\u0400', '\u04ff', '\u0530', '\u058f', '\u0590', '\u05ff', '\u0600', '\u06ff', '\u0900', '\u097f', '\u0980', '\u09ff', '\u0a00', '\u0a7f', '\u0a80', '\u0aff', '\u0b00', '\u0b7f', '\u0b80', '\u0bff', '\u0c00', '\u0c7f', '\u0c80', '\u0cff', '\u0d00', '\u0d7f', '\u0e00', '\u0e7f', '\u0e80', '\u0eff', '\u0f00', '\u0fbf', '\u10a0', '\u10ff', '\u1100', '\u11ff', '\u1e00', '\u1eff', '\u1f00', '\u1fff', '\u2000', '\u206f', '\u2070', '\u209f', '\u20a0', '\u20cf', '\u20d0', '\u20ff', '\u2100', '\u214f', '\u2150', '\u218f', '\u2190', '\u21ff', '\u2200', '\u22ff', '\u2300', '\u23ff', '\u2400', '\u243f', '\u2440', '\u245f', '\u2460', '\u24ff', '\u2500', '\u257f', '\u2580', '\u259f', '\u25a0', '\u25ff', '\u2600', '\u26ff', '\u2700', '\u27bf', '\u3000', '\u303f', '\u3040', '\u309f', '\u30a0', '\u30ff', '\u3100', '\u312f', '\u3130', '\u318f', '\u3190', '\u319f', '\u3200', '\u32ff', '\u3300', '\u33ff', '\u4e00', '\u9fff', '\uac00', '\ud7a3', '\ud800', '\udb7f', '\udb80', '\udbff', '\udc00', '\udfff', '\ue000', '\uf8ff', '\uf900', '\ufaff', '\ufb00', '\ufb4f', '\ufb50', '\ufdff', '\ufe20', '\ufe2f', '\ufe30', '\ufe4f', '\ufe50', '\ufe6f', '\ufe70', '\ufeff', '\uff00', '\uffef', '\ufeff', '\ufeff', '\ufff0', '\uffff'};

    Text3DRetained() {
        this.geoType = 16;
    }

    synchronized void computeBoundingBox() {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3f vector3f = new Vector3f((Tuple3f)this.position);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        point3d.set((Tuple3f)vector3f);
        point3d2.set((Tuple3f)vector3f);
        if (this.numChars != 0) {
            Rectangle2D.Float float_;
            GlyphMetrics glyphMetrics;
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[0]]).getGlyphMetrics(0);
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                point3d2.x += (double)float_.width;
                point3d2.y += (double)float_.height;
            }
            int n3 = 1;
            while (n3 < n2) {
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[n]]).getGlyphMetrics(0);
                f = glyphMetrics.getAdvance();
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                f += this.charSpacing;
                f2 = this.font3D.charHeights[this.charIndex[n]];
                switch (this.path) {
                    case 1: {
                        point3d2.x += (double)f;
                        if (!(point3d2.y < (double)(f2 + vector3f.y))) break;
                        point3d2.y = vector3f.y + f2;
                        break;
                    }
                    case 0: {
                        point3d.x -= (double)f;
                        if (!(point3d2.y < (double)(f2 + vector3f.y))) break;
                        point3d2.y = vector3f.y + f2;
                        break;
                    }
                    case 2: {
                        point3d2.y += (double)f2;
                        if (!(point3d2.x < (double)(float_.width + vector3f.x))) break;
                        point3d2.x = vector3f.x + float_.width;
                        break;
                    }
                    case 3: {
                        point3d.y -= (double)f2;
                        if (!(point3d2.x < (double)(float_.width + vector3f.x))) break;
                        point3d2.x = vector3f.x + float_.width;
                    }
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d = point3d2.x - point3d.x;
                double d2 = point3d2.y - point3d.y;
                if (this.alignment == 0) {
                    d *= 0.5;
                    d2 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        point3d.x -= d;
                        point3d2.x -= d;
                        break;
                    }
                    case 0: {
                        point3d.x += d;
                        point3d2.x += d;
                        break;
                    }
                    case 2: {
                        point3d.y -= d2;
                        point3d2.y -= d2;
                        break;
                    }
                    case 3: {
                        point3d.y += d2;
                        point3d2.y += d2;
                    }
                }
            }
        }
        point3d.z = 0.0;
        point3d2.z = this.font3D == null || this.font3D.fontExtrusion == null ? point3d.z : point3d.z + (double)this.font3D.fontExtrusion.length;
    }

    void update() {
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final void setFont3D(Font3D font3D) {
        this.font3D = font3D;
        this.updateCharacterData();
        this.sendDataChangedMessage();
    }

    final String getString() {
        return this.string;
    }

    final void setString(String string) {
        this.string = string;
        this.numChars = string == null ? 0 : string.length();
        this.updateCharacterData();
        this.sendDataChangedMessage();
    }

    final void getPosition(Point3f point3f) {
        point3f.set((Tuple3f)this.position);
    }

    final void setPosition(Point3f point3f) {
        this.position.set((Tuple3f)point3f);
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void setAlignment(int n) {
        this.alignment = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final int getPath() {
        return this.path;
    }

    final void setPath(int n) {
        this.path = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void getBoundingBox(BoundingBox boundingBox) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            boundingBox.setLower(this.lower);
            boundingBox.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final void setCharacterSpacing(float f) {
        this.charSpacing = f;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void sendDataChangedMessage() {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                J3dMessage[] j3dMessageArray;
                ArrayList arrayList3 = this.universeList;
                synchronized (arrayList3) {
                    int n = this.universeList.size();
                    j3dMessageArray = new J3dMessage[n];
                    int n2 = 0;
                    while (n2 < n) {
                        j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n2].type = 26;
                        j3dMessageArray[n2].threads = 8384;
                        ArrayList arrayList4 = (ArrayList)this.userLists.get(n2);
                        this.newGeometryAtomList.clear();
                        this.oldGeometryAtomList.clear();
                        int n3 = 0;
                        while (n3 < arrayList4.size()) {
                            int n4;
                            BHLeafInterface bHLeafInterface;
                            arrayList.clear();
                            arrayList2.clear();
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList4.get(n3);
                            if (shape3DRetained.boundsAutoCompute) {
                                shape3DRetained.getCombineBounds((BoundingBox)shape3DRetained.bounds);
                            }
                            int n5 = shape3DRetained.geometryList.size();
                            int n6 = 0;
                            while (n6 < n5) {
                                GeometryRetained geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n6);
                                if (geometryRetained == this) break;
                                ++n6;
                            }
                            if (n6 < n5) {
                                GeometryRetained geometryRetained;
                                bHLeafInterface = Shape3DRetained.getGeomAtom(shape3DRetained);
                                GeometryAtom geometryAtom = new GeometryAtom();
                                this.oldGeometryAtomList.add(bHLeafInterface);
                                arrayList.add((GeometryAtom)bHLeafInterface);
                                int n7 = 0;
                                n4 = 0;
                                while (n4 < n5) {
                                    GeometryRetained geometryRetained2 = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                                    if (geometryRetained2 != null) {
                                        geometryRetained = (Text3DRetained)geometryRetained2;
                                        n7 += geometryRetained.numChars;
                                    } else {
                                        ++n7;
                                    }
                                    ++n4;
                                }
                                geometryAtom.geometryArray = new GeometryRetained[n7];
                                geometryAtom.lastLocalTransformArray = new Transform3D[n7];
                                n7 = 0;
                                geometryAtom.locale = shape3DRetained.locale;
                                geometryAtom.visible = shape3DRetained.visible;
                                geometryAtom.source = shape3DRetained;
                                int n8 = 0;
                                geometryRetained = null;
                                while (n8 < n5) {
                                    geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n8);
                                    if (geometryRetained != null) {
                                        geometryAtom.geoType = geometryRetained.geoType;
                                        geometryAtom.alphaEditable = shape3DRetained.isAlphaEditable(geometryRetained);
                                        break;
                                    }
                                    ++n8;
                                }
                                while (n8 < n5) {
                                    geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n8);
                                    if (geometryRetained == null) {
                                        geometryAtom.geometryArray[n8] = null;
                                    } else {
                                        GeometryRetained geometryRetained3 = geometryRetained;
                                        int n9 = 0;
                                        while (n9 < geometryRetained3.numChars) {
                                            if (geometryRetained3.font3D.fontData[geometryRetained3.charIndex[n9]] != null) {
                                                geometryAtom.geometryArray[n7] = (GeometryArrayRetained)geometryRetained3.font3D.fontData[geometryRetained3.charIndex[n9]].retained;
                                                geometryAtom.lastLocalTransformArray[n7] = geometryRetained3.charTransforms[n9];
                                            } else {
                                                geometryAtom.geometryArray[n7] = null;
                                                geometryAtom.lastLocalTransformArray[n7] = null;
                                            }
                                            ++n9;
                                            ++n7;
                                        }
                                    }
                                    ++n8;
                                }
                                this.newGeometryAtomList.add(geometryAtom);
                                arrayList2.add(geometryAtom);
                                Shape3DRetained.setGeomAtom(shape3DRetained, geometryAtom);
                            }
                            if (shape3DRetained.parentList != null) {
                                n4 = 0;
                                while (n4 < shape3DRetained.parentList.size()) {
                                    bHLeafInterface = (TransformGroupRetained)shape3DRetained.parentList.get(n4);
                                    ((TransformGroupRetained)bHLeafInterface).updateTargets(arrayList, arrayList2);
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                        j3dMessageArray[n2].args[0] = this.oldGeometryAtomList.toArray();
                        j3dMessageArray[n2].args[1] = this.newGeometryAtomList.toArray();
                        j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                    }
                }
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
        }
    }

    final void sendTransformChangedMessage() {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList2 = this.universeList;
                synchronized (arrayList2) {
                    int n = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n];
                    int n2 = 0;
                    while (n2 < n) {
                        j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n2].type = 25;
                        j3dMessageArray[n2].threads = 8384;
                        ArrayList arrayList3 = (ArrayList)this.userLists.get(n2);
                        int n3 = 0;
                        while (n3 < arrayList3.size()) {
                            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList3.get(n3);
                            int n4 = 0;
                            while (n4 < shape3DRetained.geometryList.size()) {
                                GeometryRetained geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                                if (geometryRetained == this) break;
                                ++n4;
                            }
                            if (n4 < shape3DRetained.geometryList.size()) {
                                arrayList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                            }
                            ++n3;
                        }
                        j3dMessageArray[n2].args[0] = arrayList.toArray();
                        j3dMessageArray[n2].args[1] = this.charTransforms;
                        j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
            }
        }
    }

    final synchronized void updateCharacterData() {
        int n = unicodeBlocks.length - 2;
        char c = '\u0000';
        this.charIndex = new int[this.numChars];
        this.geometryList = new GeometryArrayRetained[this.numChars];
        if (this.numChars != 0 && this.font3D != null) {
            char[] cArray = new char[this.numChars];
            this.string.getChars(0, this.numChars, cArray, 0);
            int n2 = 0;
            while (n2 < n) {
                if (cArray[0] >= unicodeBlocks[n2] && cArray[0] < unicodeBlocks[n2 + 1]) {
                    c = unicodeBlocks[n2];
                    break;
                }
                n2 += 2;
            }
            n2 = 0;
            while (n2 < this.numChars) {
                cArray[n2] = (char)(cArray[n2] - c);
                this.charIndex[n2] = cArray[n2] >= this.font3D.numGlyphs || cArray[n2] < '\u0000' ? this.font3D.numGlyphs - 1 : cArray[n2];
                this.font3D.triangulateGlyphs(this.charIndex[n2], this.string.charAt(n2));
                this.geometryList[n2] = this.font3D.fontData[this.charIndex[n2]] != null ? (GeometryRetained)this.font3D.fontData[this.charIndex[n2]].retained : null;
                ++n2;
            }
        }
        this.updateTransformData();
    }

    final synchronized void updateTransformData() {
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f((Tuple3f)this.position);
        this.lower.set((Tuple3f)vector3f);
        this.upper.set((Tuple3f)vector3f);
        this.charTransforms = new Transform3D[this.numChars];
        int n3 = 0;
        while (n3 < this.numChars) {
            this.charTransforms[n3] = VirtualUniverse.mc.getTransform3D(null);
            ++n3;
        }
        if (this.numChars != 0) {
            Rectangle2D.Float float_;
            GlyphMetrics glyphMetrics;
            this.charTransforms[0].set(vector3f);
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[0]]).getGlyphMetrics(0);
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                this.upper.x += (double)float_.width;
                this.upper.y += (double)float_.height;
            }
            n3 = 1;
            while (n3 < n2) {
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[n]]).getGlyphMetrics(0);
                f = glyphMetrics.getAdvance();
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                f += this.charSpacing;
                f2 = this.font3D.charHeights[this.charIndex[n]];
                switch (this.path) {
                    case 1: {
                        vector3f.x += f;
                        this.upper.x += (double)f;
                        if (!(this.upper.y < (double)(f2 + vector3f.y))) break;
                        this.upper.y = vector3f.y + f2;
                        break;
                    }
                    case 0: {
                        vector3f.x -= f;
                        this.lower.x -= (double)f;
                        if (!(this.upper.y < (double)(f2 + vector3f.y))) break;
                        this.upper.y = vector3f.y + f2;
                        break;
                    }
                    case 2: {
                        vector3f.y += f2;
                        this.upper.y += (double)f2;
                        if (!(this.upper.x < (double)(float_.width + vector3f.x))) break;
                        this.upper.x = vector3f.x + float_.width;
                        break;
                    }
                    case 3: {
                        vector3f.y -= f2;
                        this.lower.y -= (double)f2;
                        if (!(this.upper.x < (double)(float_.width + vector3f.x))) break;
                        this.upper.x = vector3f.x + float_.width;
                    }
                }
                if (n3 < this.numChars) {
                    this.charTransforms[n3].set(vector3f);
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d = this.upper.x - this.lower.x;
                double d2 = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    d *= 0.5;
                    d2 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] - d;
                            ++n3;
                        }
                        this.lower.x -= d;
                        this.upper.x -= d;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] + d;
                            ++n3;
                        }
                        this.lower.x += d;
                        this.upper.x += d;
                        break;
                    }
                    case 2: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] - d2;
                            ++n3;
                        }
                        this.lower.y -= d2;
                        this.upper.y -= d2;
                        break;
                    }
                    case 3: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] + d2;
                            ++n3;
                        }
                        this.lower.y += d2;
                        this.upper.y += d2;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
        this.getBoundingBox(this.geoBounds);
    }

    void setLive(boolean bl, int n) {
        this.updateCharacterData();
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    boolean intersect(PickShape pickShape) {
        Transform3D transform3D = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D.invert(this.charTransforms[n]);
                PickShape pickShape2 = pickShape.transform(transform3D);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(pickShape2)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(pickShape2)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(pickShape2)) {
                        return true;
                    }
                } else {
                    throw new RuntimeException(J3dI18N.getString("Text3DRetained1"));
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        Transform3D transform3D = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        boolean bl = false;
        boolean bl2 = false;
        double[] dArray2 = new double[1];
        Point3d point3d2 = new Point3d();
        int n = 0;
        dArray[0] = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n2]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n2]].retained;
                transform3D.invert(this.charTransforms[n2]);
                PickRay pickRay2 = (PickRay)((PickShape)pickRay).transform(transform3D);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    bl2 = ((TriangleArrayRetained)geometryArrayRetained).intersect(pickRay2, dArray2, point3d2);
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    bl2 = ((TriangleStripArrayRetained)geometryArrayRetained).intersect(pickRay2, dArray2, point3d2);
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    bl2 = ((TriangleFanArrayRetained)geometryArrayRetained).intersect(pickRay2, dArray2, point3d2);
                } else {
                    throw new RuntimeException(J3dI18N.getString("Text3DRetained1"));
                }
                if (bl2) {
                    bl = true;
                    if (dArray2[0] < dArray[0]) {
                        n = n2;
                        dArray[0] = dArray2[0];
                        point3d.x = point3d2.x;
                        point3d.y = point3d2.y;
                        point3d.z = point3d2.z;
                    }
                }
            }
            ++n2;
        }
        if (bl) {
            this.charTransforms[n].transform(point3d);
            return true;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D3.set(transform3D);
                transform3D3.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    void setModelViewMatrix(Transform3D transform3D, Transform3D transform3D2) {
        this.vpcToEc = transform3D;
        this.drawTransform = transform3D2;
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int[] nArray, int n2) {
        Transform3D transform3D = new Transform3D();
        int n3 = 0;
        while (n3 < this.geometryList.length) {
            transform3D.set(this.drawTransform);
            transform3D.mul(this.charTransforms[n3]);
            canvas3D.setModelViewMatrix(canvas3D.ctx, this.vpcToEc.mat, transform3D);
            this.geometryList[n3].execute(canvas3D, renderAtom, bl, bl2, f, bl3, n, bl4, nArray, n2);
            ++n3;
        }
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if (compileState.switchLevel > 0 && (this.source.capabilities.get(1) || this.source.capabilities.get(3) || this.source.capabilities.get(5) || this.source.capabilities.get(7) || this.source.capabilities.get(9) || this.source.capabilities.get(11))) {
            compileState.switchVwcBoundsSharable = false;
        }
    }
}

