/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;

class TexCoordGenerationRetained
extends NodeComponentRetained {
    static final int MODE_CHANGED = 1;
    static final int FORMAT_CHANGED = 2;
    static final int PLANE_S_CHANGED = 4;
    static final int PLANE_T_CHANGED = 8;
    static final int PLANE_R_CHANGED = 16;
    static final int ENABLE_CHANGED = 32;
    int genMode = 0;
    int format = 0;
    Vector4f planeS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    Vector4f planeT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    Vector4f planeR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    boolean enable = true;

    TexCoordGenerationRetained() {
    }

    final void initEnable(boolean bl) {
        this.enable = bl;
    }

    final void setEnable(boolean bl) {
        this.initEnable(bl);
        this.sendMessage(32, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.enable;
    }

    final void initFormat(int n) {
        this.format = n;
    }

    final int getFormat() {
        return this.format;
    }

    final void initGenMode(int n) {
        this.genMode = n;
    }

    final int getGenMode() {
        return this.genMode;
    }

    final void initPlaneS(Vector4f vector4f) {
        this.planeS.set((Tuple4f)vector4f);
    }

    final void getPlaneS(Vector4f vector4f) {
        vector4f.set((Tuple4f)this.planeS);
    }

    final void initPlaneT(Vector4f vector4f) {
        this.planeT.set((Tuple4f)vector4f);
    }

    final void getPlaneT(Vector4f vector4f) {
        vector4f.set((Tuple4f)this.planeT);
    }

    final void initPlaneR(Vector4f vector4f) {
        this.planeR.set((Tuple4f)vector4f);
    }

    final void getPlaneR(Vector4f vector4f) {
        vector4f.set((Tuple4f)this.planeR);
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TexCoordGenerationRetained texCoordGenerationRetained = new TexCoordGenerationRetained();
                texCoordGenerationRetained.set(this);
                texCoordGenerationRetained.source = this.source;
                this.mirror = texCoordGenerationRetained;
            }
        } else {
            ((TexCoordGenerationRetained)this.mirror).set(this);
        }
    }

    native void updateNative(int var1, boolean var2, int var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, double[] var17);

    void updateNative(int n, Transform3D transform3D) {
        if (VirtualUniverse.mc.isD3D()) {
            Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(transform3D);
            transform3D2.invert();
            this.updateNative(n, this.enable, this.genMode, this.format, this.planeS.x, this.planeS.y, this.planeS.z, this.planeS.w, this.planeT.x, this.planeT.y, this.planeT.z, this.planeT.w, this.planeR.x, this.planeR.y, this.planeR.z, this.planeR.w, transform3D2.mat);
            VirtualUniverse.mc.addToTransformFreeList(transform3D2);
        } else {
            this.updateNative(n, this.enable, this.genMode, this.format, this.planeS.x, this.planeS.y, this.planeS.z, this.planeS.w, this.planeT.x, this.planeT.y, this.planeT.z, this.planeT.w, this.planeR.x, this.planeR.y, this.planeR.z, this.planeR.w, transform3D.mat);
        }
    }

    synchronized void initMirrorObject() {
        ((TexCoordGenerationRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        if ((n & 0x20) != 0) {
            ((TexCoordGenerationRetained)this.mirror).enable = (Boolean)object;
        }
    }

    boolean equivalent(TexCoordGenerationRetained texCoordGenerationRetained) {
        return this == texCoordGenerationRetained || texCoordGenerationRetained != null && texCoordGenerationRetained.genMode == this.genMode && texCoordGenerationRetained.format == this.format && texCoordGenerationRetained.enable == this.enable && texCoordGenerationRetained.planeS.equals((Tuple4f)this.planeS) && texCoordGenerationRetained.planeT.equals((Tuple4f)this.planeT) && texCoordGenerationRetained.planeR.equals((Tuple4f)this.planeR);
    }

    protected Object clone() {
        TexCoordGenerationRetained texCoordGenerationRetained = (TexCoordGenerationRetained)super.clone();
        texCoordGenerationRetained.planeS = new Vector4f(this.planeS);
        texCoordGenerationRetained.planeT = new Vector4f(this.planeT);
        texCoordGenerationRetained.planeR = new Vector4f(this.planeR);
        return texCoordGenerationRetained;
    }

    protected void set(TexCoordGenerationRetained texCoordGenerationRetained) {
        this.genMode = texCoordGenerationRetained.genMode;
        this.format = texCoordGenerationRetained.format;
        this.enable = texCoordGenerationRetained.enable;
        this.planeS.set((Tuple4f)texCoordGenerationRetained.planeS);
        this.planeT.set((Tuple4f)texCoordGenerationRetained.planeT);
        this.planeR.set((Tuple4f)texCoordGenerationRetained.planeR);
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 14;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 14;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }
}

