/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedQuadArrayRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderMolecule
implements ObjectUpdate {
    static final int POINT = 1;
    static final int LINE = 2;
    static final int SURFACE = 4;
    static final int RASTER = 8;
    static final int COMPRESSED = 16;
    static final int POINTATTRS = 1;
    static final int LINEATTRS = 2;
    static final int POLYGONATTRS = 4;
    static final int MATERIAL = 8;
    static final int TRANSPARENCY = 16;
    static final int COLORINGATTRS = 32;
    static final int ALL_DIRTY_BITS = 63;
    int dirtyAttrsAcrossRms = 63;
    PolygonAttributesRetained definingPolygonAttributes = null;
    LineAttributesRetained definingLineAttributes = null;
    PointAttributesRetained definingPointAttributes = null;
    TextureBin textureBin = null;
    Transform3D[] localToVworld = null;
    int[] localToVworldIndex = null;
    MaterialRetained definingMaterial = null;
    ColoringAttributesRetained definingColoringAttributes = null;
    TransparencyAttributesRetained definingTransparency = null;
    Transform3D[] trans = null;
    boolean isNonUniformScale = false;
    int numRenderAtoms = 0;
    RenderAtom addRAs = null;
    RenderAtom removeRAs = null;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    int geometryType = -1;
    boolean enableLighting = false;
    int primaryMoleculeType = 0;
    static int COMPRESSED_MOLECULE = 1;
    static int TEXT3D_MOLECULE = 2;
    static int DLIST_MOLECULE = 4;
    static int RASTER_MOLECULE = 8;
    static int ORIENTEDSHAPE3D_MOLECULE = 16;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    int vertexFormat = -1;
    RenderMethod primaryRenderMethod = null;
    RenderMethod secondaryRenderMethod = null;
    RenderBin renderBin = null;
    RenderMolecule next = null;
    RenderMolecule prev = null;
    RenderAtomListInfo primaryRenderAtomList = null;
    RenderAtomListInfo separateDlistRenderAtomList = null;
    RenderAtomListInfo vertexArrayRenderAtomList = null;
    BoundingBox vwcBounds = null;
    RenderMolecule nextMap = null;
    RenderMolecule prevMap = null;
    VertexArrayRenderMethod cachedVertexArrayRenderMethod = (VertexArrayRenderMethod)VirtualUniverse.mc.getVertexArrayRenderMethod();
    boolean isQuadGeometryArray = false;
    int displayListId = 0;
    Integer displayListIdObj = null;
    int onUpdateList = 0;
    static int NEW_RENDERATOMS_UPDATE = 1;
    static int BOUNDS_RECOMPUTE_UPDATE = 2;
    static int LOCALE_TRANSLATION = 4;
    static int UPDATE_BACKGROUND_TRANSFORM = 8;
    boolean doInfinite;
    Transform3D[] infLocalToVworld;
    boolean useAlpha = false;
    Locale locale = null;
    Transform3D[] localeLocalToVworld = null;
    Vector3d localeTranslation = new Vector3d();
    boolean primaryChanged = false;

    RenderMolecule(GeometryAtom geometryAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, RenderingAttributesRetained renderingAttributesRetained, TextureUnitStateRetained[] textureUnitStateRetainedArray, Transform3D[] transform3DArray, int[] nArray, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.reset(geometryAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, renderingAttributesRetained, textureUnitStateRetainedArray, transform3DArray, nArray);
    }

    void reset(GeometryAtom geometryAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, RenderingAttributesRetained renderingAttributesRetained, TextureUnitStateRetained[] textureUnitStateRetainedArray, Transform3D[] transform3DArray, int[] nArray) {
        this.primaryMoleculeType = 0;
        this.numRenderAtoms = 0;
        this.onUpdateList = 0;
        this.dirtyAttrsAcrossRms = 63;
        this.primaryRenderMethod = null;
        this.isNonUniformScale = false;
        this.primaryChanged = false;
        GeometryRetained geometryRetained = null;
        int n = 0;
        while (geometryRetained == null && n < geometryAtom.geometryArray.length) {
            geometryRetained = geometryAtom.geometryArray[n];
            ++n;
        }
        if (geometryAtom.geoType <= 14 || geometryAtom.geoType == 16) {
            if (geometryAtom.source instanceof OrientedShape3DRetained) {
                this.primaryRenderMethod = VirtualUniverse.mc.getOrientedShape3DRenderMethod();
                this.primaryMoleculeType = ORIENTEDSHAPE3D_MOLECULE;
            } else if (geometryAtom.geoType == 16) {
                this.primaryRenderMethod = VirtualUniverse.mc.getText3DRenderMethod();
                this.primaryMoleculeType = TEXT3D_MOLECULE;
            } else {
                this.secondaryRenderMethod = this.cachedVertexArrayRenderMethod;
            }
        } else if (geometryAtom.geoType == 17) {
            this.primaryRenderMethod = VirtualUniverse.mc.getCompressedGeometryRenderMethod();
            this.primaryMoleculeType = COMPRESSED_MOLECULE;
        } else if (geometryRetained instanceof RasterRetained) {
            this.primaryRenderMethod = VirtualUniverse.mc.getDefaultRenderMethod();
            this.primaryMoleculeType = RASTER_MOLECULE;
        }
        this.prev = null;
        this.next = null;
        this.prevMap = null;
        this.nextMap = null;
        this.primaryRenderAtomList = null;
        this.vertexArrayRenderAtomList = null;
        block0 : switch (geometryAtom.geoType) {
            case 3: 
            case 10: {
                this.geometryType = 1;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                this.geometryType = 2;
                break;
            }
            case 15: {
                this.geometryType = 8;
                break;
            }
            case 17: {
                this.geometryType = 16;
                switch (((CompressedGeometryRetained)geometryRetained).getBufferType()) {
                    case 0: {
                        this.geometryType |= 1;
                        break block0;
                    }
                    case 1: {
                        this.geometryType |= 2;
                        break block0;
                    }
                }
                this.geometryType |= 4;
                break;
            }
            default: {
                this.geometryType = 4;
                if (polygonAttributesRetained == null) break;
                if (polygonAttributesRetained.polygonMode == 0) {
                    this.geometryType |= 1;
                    break;
                }
                if (polygonAttributesRetained.polygonMode != 1) break;
                this.geometryType |= 2;
            }
        }
        this.isQuadGeometryArray = geometryRetained instanceof QuadArrayRetained || geometryRetained instanceof IndexedQuadArrayRetained;
        this.localToVworld = transform3DArray;
        this.localToVworldIndex = nArray;
        this.doInfinite = geometryAtom.source.inBackgroundGroup;
        if (this.doInfinite) {
            if (this.infLocalToVworld == null) {
                this.infLocalToVworld = new Transform3D[2];
                this.infLocalToVworld[0] = this.infLocalToVworld[1] = new Transform3D();
            }
            this.localToVworld[0].getRotation(this.infLocalToVworld[0]);
        }
        if (polygonAttributesRetained != null) {
            if (this.definingPolygonAttributes != null) {
                this.definingPolygonAttributes.set(polygonAttributesRetained);
            } else {
                this.definingPolygonAttributes = (PolygonAttributesRetained)polygonAttributesRetained.clone();
            }
            this.polygonMode = this.definingPolygonAttributes.polygonMode;
        } else {
            this.polygonMode = 2;
            this.definingPolygonAttributes = null;
        }
        if (lineAttributesRetained != null) {
            if (this.definingLineAttributes != null) {
                this.definingLineAttributes.set(lineAttributesRetained);
            } else {
                this.definingLineAttributes = (LineAttributesRetained)lineAttributesRetained.clone();
            }
            this.lineAA = this.definingLineAttributes.lineAntialiasing;
        } else {
            this.lineAA = false;
            this.definingLineAttributes = null;
        }
        if (pointAttributesRetained != null) {
            if (this.definingPointAttributes != null) {
                this.definingPointAttributes.set(pointAttributesRetained);
            } else {
                this.definingPointAttributes = (PointAttributesRetained)pointAttributesRetained.clone();
            }
            this.pointAA = this.definingPointAttributes.pointAntialiasing;
        } else {
            this.pointAA = false;
            this.definingPointAttributes = null;
        }
        boolean bl = true;
        if (geometryRetained instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
            this.vertexFormat = geometryArrayRetained.vertexFormat;
            if ((this.vertexFormat & 2) == 0) {
                bl = false;
            }
        } else if (geometryRetained instanceof CompressedGeometryRetained) {
            this.vertexFormat = ((CompressedGeometryRetained)geometryRetained).getVertexFormat();
            if ((this.vertexFormat & 2) == 0) {
                bl = false;
            }
        } else {
            this.vertexFormat = -1;
        }
        if (materialRetained != null) {
            if (this.definingMaterial != null) {
                this.definingMaterial.set(materialRetained);
            } else {
                this.definingMaterial = (MaterialRetained)materialRetained.clone();
            }
            if ((this.geometryType & 8) != 0) {
                this.enableLighting = false;
                this.dRed = 1.0f;
                this.dGreen = 1.0f;
                this.dBlue = 1.0f;
            } else {
                this.enableLighting = bl ? this.definingMaterial.lightingEnable : false;
                this.dRed = this.definingMaterial.diffuseColor.x;
                this.dGreen = this.definingMaterial.diffuseColor.y;
                this.dBlue = this.definingMaterial.diffuseColor.z;
            }
        } else {
            this.enableLighting = false;
            this.definingMaterial = null;
            this.dRed = 1.0f;
            this.dGreen = 1.0f;
            this.dBlue = 1.0f;
        }
        if (coloringAttributesRetained != null) {
            if (this.definingColoringAttributes != null) {
                this.definingColoringAttributes.set(coloringAttributesRetained);
            } else {
                this.definingColoringAttributes = (ColoringAttributesRetained)coloringAttributesRetained.clone();
            }
            this.red = coloringAttributesRetained.color.x;
            this.green = coloringAttributesRetained.color.y;
            this.blue = coloringAttributesRetained.color.z;
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
            this.definingColoringAttributes = null;
        }
        if (transparencyAttributesRetained != null) {
            if (this.definingTransparency != null) {
                this.definingTransparency.set(transparencyAttributesRetained);
            } else {
                this.definingTransparency = (TransparencyAttributesRetained)transparencyAttributesRetained.clone();
            }
            this.alpha = 1.0f - transparencyAttributesRetained.transparency;
        } else {
            this.alpha = 1.0f;
            this.definingTransparency = null;
        }
        this.locale = geometryAtom.source.locale;
        if (this.locale != this.renderBin.locale) {
            if (this.localeLocalToVworld == null) {
                this.localeLocalToVworld = new Transform3D[2];
            }
            this.localeLocalToVworld[0] = this.localeLocalToVworld[1] = VirtualUniverse.mc.getTransform3D(null);
            geometryAtom.locale.hiRes.difference(this.renderBin.locale.hiRes, this.localeTranslation);
            this.translate();
        } else {
            this.localeLocalToVworld = this.localToVworld;
        }
        this.trans = this.doInfinite ? this.infLocalToVworld : this.localeLocalToVworld;
        this.isNonUniformScale = !this.trans[this.localToVworldIndex[0]].isCongruent();
        this.evalAlphaUsage(renderingAttributesRetained, textureUnitStateRetainedArray);
    }

    void doTextureEnableChecking() {
        int n = 0;
        if (this.vertexFormat != -1 && this.primaryMoleculeType != COMPRESSED_MOLECULE) {
            n = this.vertexFormat;
        }
        if (this.textureBin.texUnitState != null) {
            TextureUnitStateRetained[] textureUnitStateRetainedArray = this.textureBin.texUnitState;
            int n2 = 0;
            while (n2 < textureUnitStateRetainedArray.length) {
                if (textureUnitStateRetainedArray[n2] != null) {
                    textureUnitStateRetainedArray[n2].noTexCoordSrc = (textureUnitStateRetainedArray[n2].texGen == null || !textureUnitStateRetainedArray[n2].texGen.enable) && (n & 0x60) == 0;
                }
                ++n2;
            }
        }
    }

    boolean equals(RenderAtom renderAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, Transform3D[] transform3DArray) {
        int n = 0;
        GeometryAtom geometryAtom = renderAtom.geometryAtom;
        boolean bl = false;
        if (this.localToVworld != transform3DArray) {
            return false;
        }
        if (this.locale != renderAtom.geometryAtom.source.locale) {
            return false;
        }
        GeometryRetained geometryRetained = null;
        int n2 = 0;
        while (geometryRetained == null && n2 < geometryAtom.geometryArray.length) {
            geometryRetained = geometryAtom.geometryArray[n2];
            ++n2;
        }
        block0 : switch (geometryAtom.geoType) {
            case 3: 
            case 10: {
                n = 1;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                n = 2;
                break;
            }
            case 15: {
                n = 8;
                break;
            }
            case 17: {
                n = 16;
                switch (((CompressedGeometryRetained)geometryRetained).getBufferType()) {
                    case 0: {
                        n |= 1;
                        break block0;
                    }
                    case 1: {
                        n |= 2;
                        break block0;
                    }
                }
                n |= 4;
                break;
            }
            default: {
                n = 4;
                if (polygonAttributesRetained == null) break;
                if (polygonAttributesRetained.polygonMode == 0) {
                    n |= 1;
                    break;
                }
                if (polygonAttributesRetained.polygonMode != 1) break;
                n |= 2;
            }
        }
        if (this.geometryType != n) {
            return false;
        }
        if (geometryAtom.geoType == 16 && this.primaryMoleculeType != 0 && (this.primaryMoleculeType & TEXT3D_MOLECULE) == 0) {
            return false;
        }
        if (geometryRetained instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
            if (this.vertexFormat != geometryArrayRetained.vertexFormat) {
                return false;
            }
            if (VirtualUniverse.mc.isD3D() && (geometryRetained instanceof QuadArrayRetained || geometryRetained instanceof IndexedQuadArrayRetained) && !this.isQuadGeometryArray) {
                return false;
            }
        } else if (geometryRetained instanceof CompressedGeometryRetained ? this.vertexFormat != ((CompressedGeometryRetained)geometryRetained).getVertexFormat() : this.vertexFormat != -1) {
            return false;
        }
        if (!(this.definingPolygonAttributes == polygonAttributesRetained || this.definingPolygonAttributes != null && this.definingPolygonAttributes.equivalent(polygonAttributesRetained))) {
            return false;
        }
        if (!(this.definingLineAttributes == lineAttributesRetained || this.definingLineAttributes != null && this.definingLineAttributes.equivalent(lineAttributesRetained))) {
            return false;
        }
        if (!(this.definingPointAttributes == pointAttributesRetained || this.definingPointAttributes != null && this.definingPointAttributes.equivalent(pointAttributesRetained))) {
            return false;
        }
        if (!(this.definingMaterial == materialRetained || this.definingMaterial != null && this.definingMaterial.equivalent(materialRetained))) {
            return false;
        }
        if (!(this.definingColoringAttributes == coloringAttributesRetained || this.definingColoringAttributes != null && this.definingColoringAttributes.equivalent(coloringAttributesRetained))) {
            return false;
        }
        return this.definingTransparency == transparencyAttributesRetained || this.definingTransparency != null && this.definingTransparency.equivalent(transparencyAttributesRetained);
    }

    /*
     * Unable to fully structure code
     */
    public void updateRemoveRenderAtoms() {
        if (this.numRenderAtoms != 0 || this.removeRAs != null || this.addRAs != null) ** GOTO lbl66
        if ((this.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0) {
            VirtualUniverse.mc.freeDisplayListId(this.displayListIdObj);
            this.displayListId = 0;
            this.displayListIdObj = null;
        }
        this.textureBin.removeRenderMolecule(this);
        return;
lbl-1000:
        // 1 sources

        {
            var2_1 = this.removeRAs;
            var2_1.removed = null;
            --this.numRenderAtoms;
            var4_3 = 0;
            while (var4_3 < var2_1.rListInfo.length) {
                var3_2 = var2_1.rListInfo[var4_3];
                if (var3_2.geometry != null) {
                    if ((var3_2.groupType & RenderAtom.PRIMARY) != 0) {
                        this.primaryChanged = true;
                        if (var3_2.prev == null) {
                            this.primaryRenderAtomList = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = null;
                            }
                        } else {
                            var3_2.prev.next = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = var3_2.prev;
                            }
                        }
                        if (this.primaryMoleculeType == RenderMolecule.TEXT3D_MOLECULE) {
                            if (!var3_2.renderAtom.inRenderBin()) {
                                VirtualUniverse.mc.addToTransformFreeList(var3_2.localToVworld);
                            }
                        } else if (this.primaryMoleculeType == 8) {
                            var5_4 = (RasterRetained)var3_2.geometry;
                            this.renderBin.removeGeometryFromLockList(var5_4);
                            if (var5_4.image != null && var5_4.image.isByReference() && var5_4.image.isByReference()) {
                                this.renderBin.removeNodeComponent(var5_4.image);
                            }
                        }
                    } else if ((var3_2.groupType & RenderAtom.SEPARATE_DLIST) != 0) {
                        if (var3_2.prev == null) {
                            this.separateDlistRenderAtomList = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = null;
                            }
                        } else {
                            var3_2.prev.next = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = var3_2.prev;
                            }
                        }
                        this.renderBin.removeGeometryDlist(var3_2);
                    } else {
                        if (var3_2.prev == null) {
                            this.vertexArrayRenderAtomList = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = null;
                            }
                        } else {
                            var3_2.prev.next = var3_2.next;
                            if (var3_2.next != null) {
                                var3_2.next.prev = var3_2.prev;
                            }
                        }
                        if (!(var3_2.geometry instanceof IndexedGeometryArrayRetained)) {
                            this.renderBin.removeGeometryFromLockList(var3_2.geometry);
                        }
                    }
                    var3_2.prev = null;
                    var3_2.next = null;
                }
                ++var4_3;
            }
            this.removeRAs = this.removeRAs.nextRemove;
            var2_1.nextRemove = null;
            var2_1.prevRemove = null;
            if (!var2_1.isOriented()) continue;
            this.renderBin.orientedRAs.remove(this.renderBin.orientedRAs.indexOf(var2_1));
lbl66:
            // 3 sources

            ** while (this.removeRAs != null)
        }
lbl67:
        // 1 sources

        if (this.addRAs == null) {
            if (this.numRenderAtoms == 0) {
                if ((this.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0) {
                    this.renderBin.addDisplayListResourceFreeList(this);
                    this.renderBin.removeDirtyRenderMolecule(this);
                    this.vwcBounds.set(null);
                    this.displayListId = 0;
                    this.displayListIdObj = null;
                }
                if (this.locale != this.renderBin.locale) {
                    VirtualUniverse.mc.addToTransformFreeList(this.localeLocalToVworld[0]);
                    this.localeLocalToVworld = null;
                }
                this.textureBin.removeRenderMolecule(this);
            } else if ((this.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0 && this.primaryChanged) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                var3_2 = this.primaryRenderAtomList;
                while (var3_2 != null) {
                    this.vwcBounds.combine(var3_2.renderAtom.localeVwcBounds);
                    var3_2 = var3_2.next;
                }
                this.primaryChanged = false;
            }
        }
    }

    public void updateObject() {
        if (this.addRAs != null) {
            RenderAtomListInfo renderAtomListInfo;
            while (this.addRAs != null) {
                ++this.numRenderAtoms;
                RenderAtom renderAtom = this.addRAs;
                renderAtom.renderMolecule = this;
                renderAtom.added = null;
                int n = 0;
                while (n < renderAtom.rListInfo.length) {
                    renderAtomListInfo = renderAtom.rListInfo[n];
                    if (renderAtomListInfo.geometry != null) {
                        GeometryRetained geometryRetained;
                        if ((renderAtomListInfo.groupType & RenderAtom.PRIMARY) != 0) {
                            this.primaryChanged = true;
                            if (this.primaryRenderAtomList == null) {
                                this.primaryRenderAtomList = renderAtomListInfo;
                            } else {
                                renderAtomListInfo.next = this.primaryRenderAtomList;
                                this.primaryRenderAtomList.prev = renderAtomListInfo;
                                this.primaryRenderAtomList = renderAtomListInfo;
                            }
                            if (this.primaryMoleculeType == 8) {
                                geometryRetained = (RasterRetained)renderAtomListInfo.geometry;
                                this.renderBin.addGeometryToLockList(geometryRetained);
                                if (geometryRetained.image != null && geometryRetained.image.isByReference()) {
                                    this.renderBin.addNodeComponent(geometryRetained.image);
                                }
                            }
                        } else if ((renderAtomListInfo.groupType & RenderAtom.SEPARATE_DLIST) != 0) {
                            if (this.separateDlistRenderAtomList == null) {
                                this.separateDlistRenderAtomList = renderAtomListInfo;
                            } else {
                                renderAtomListInfo.next = this.separateDlistRenderAtomList;
                                this.separateDlistRenderAtomList.prev = renderAtomListInfo;
                                this.separateDlistRenderAtomList = renderAtomListInfo;
                            }
                            this.renderBin.addGeometryDlist(renderAtomListInfo);
                        } else {
                            if (this.vertexArrayRenderAtomList == null) {
                                this.vertexArrayRenderAtomList = renderAtomListInfo;
                            } else {
                                renderAtomListInfo.next = this.vertexArrayRenderAtomList;
                                this.vertexArrayRenderAtomList.prev = renderAtomListInfo;
                                this.vertexArrayRenderAtomList = renderAtomListInfo;
                            }
                            if (!(renderAtomListInfo.geometry instanceof IndexedGeometryArrayRetained)) {
                                this.renderBin.addGeometryToLockList(renderAtomListInfo.geometry);
                            }
                            geometryRetained = (GeometryArrayRetained)renderAtomListInfo.geometry;
                            if ((((GeometryArrayRetained)geometryRetained).vertexFormat & 0x80) != 0 && ((GeometryArrayRetained)geometryRetained).c4fAllocated == 0 && (((GeometryArrayRetained)geometryRetained).vertexFormat & 4) != 0 && this.useAlpha && !this.renderBin.multiScreen) {
                                this.renderBin.addDirtyReferenceGeometry(renderAtomListInfo.geometry);
                            }
                        }
                    }
                    ++n;
                }
                this.addRAs = this.addRAs.nextAdd;
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
                if (!renderAtom.isOriented()) continue;
                this.renderBin.orientedRAs.add(renderAtom);
            }
            if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0 && this.primaryChanged) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                renderAtomListInfo = this.primaryRenderAtomList;
                while (renderAtomListInfo != null) {
                    this.vwcBounds.combine(renderAtomListInfo.renderAtom.localeVwcBounds);
                    renderAtomListInfo = renderAtomListInfo.next;
                }
                this.primaryChanged = false;
            }
            if (this.locale != this.renderBin.locale) {
                this.translate();
            }
        } else {
            if ((this.onUpdateList & LOCALE_TRANSLATION) != 0) {
                this.translate();
            }
            if ((this.onUpdateList & UPDATE_BACKGROUND_TRANSFORM) != 0) {
                int n = this.localToVworldIndex[0];
                this.localeLocalToVworld[n].getRotation(this.infLocalToVworld[n]);
            }
            if ((this.onUpdateList & BOUNDS_RECOMPUTE_UPDATE) != 0) {
                this.vwcBounds.set(null);
                RenderAtomListInfo renderAtomListInfo = this.primaryRenderAtomList;
                while (renderAtomListInfo != null) {
                    this.vwcBounds.combine(renderAtomListInfo.renderAtom.localeVwcBounds);
                    renderAtomListInfo = renderAtomListInfo.next;
                }
            }
        }
        this.onUpdateList = 0;
    }

    boolean canBeInDisplayList(GeometryRetained geometryRetained, GeometryAtom geometryAtom) {
        boolean bl = false;
        if (geometryRetained instanceof GeometryArrayRetained) {
            bl = ((GeometryArrayRetained)geometryRetained).texCoordSetMap != null && ((GeometryArrayRetained)geometryRetained).texCoordSetMap.length > 1;
        }
        return geometryRetained.canBeInDisplayList(geometryAtom.alphaEditable, bl);
    }

    boolean geoNotAltered(GeometryArrayRetained geometryArrayRetained) {
        boolean bl;
        boolean bl2 = bl = (geometryArrayRetained.vertexFormat & 4) != 0;
        if (this.textureBin.attributeBin.ignoreVertexColors) {
            return false;
        }
        return !this.useAlpha || !bl;
    }

    void addRenderAtom(RenderAtom renderAtom, RenderBin renderBin) {
        renderAtom.envSet = this.textureBin.attributeBin.environmentSet;
        renderAtom.renderMolecule = this;
        renderAtom.dirtyMask &= ~RenderAtom.NEED_SEPARATE_LOCALE_VWC_BOUNDS;
        int n = 0;
        while (n < renderAtom.rListInfo.length) {
            RenderAtomListInfo renderAtomListInfo = renderAtom.rListInfo[n];
            if (renderAtomListInfo.geometry != null) {
                if ((this.primaryMoleculeType & (COMPRESSED_MOLECULE | RASTER_MOLECULE | TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) != 0) {
                    renderAtomListInfo.groupType = RenderAtom.OTHER;
                } else if (this.canBeInDisplayList(renderAtomListInfo.geometry, renderAtomListInfo.renderAtom.geometryAtom)) {
                    if (((GeometryArrayRetained)renderAtomListInfo.geometry).dlistId == -1 || renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform != null) {
                        renderAtomListInfo.groupType = RenderAtom.DLIST;
                        if (this.primaryRenderMethod == null) {
                            this.primaryMoleculeType = DLIST_MOLECULE;
                            this.renderBin.renderMoleculeList.add(this);
                            this.vwcBounds = new BoundingBox((Bounds)null);
                            this.primaryRenderMethod = VirtualUniverse.mc.getDisplayListRenderMethod();
                            if (this.displayListId == 0) {
                                this.displayListIdObj = VirtualUniverse.mc.getDisplayListId();
                                this.displayListId = this.displayListIdObj;
                            }
                        }
                    } else if (this.geoNotAltered((GeometryArrayRetained)renderAtomListInfo.geometry)) {
                        renderAtomListInfo.groupType = RenderAtom.SEPARATE_DLIST;
                    } else {
                        renderAtomListInfo.groupType = RenderAtom.VARRAY;
                        if (this.secondaryRenderMethod == null) {
                            this.secondaryRenderMethod = this.cachedVertexArrayRenderMethod;
                        }
                    }
                } else {
                    renderAtomListInfo.groupType = RenderAtom.VARRAY;
                    if (this.secondaryRenderMethod == null) {
                        this.secondaryRenderMethod = this.cachedVertexArrayRenderMethod;
                    }
                }
                if (renderAtom.needSeparateLocaleVwcBounds() || renderAtomListInfo.groupType != RenderAtom.DLIST) {
                    renderAtom.dirtyMask |= RenderAtom.NEED_SEPARATE_LOCALE_VWC_BOUNDS;
                }
            }
            ++n;
        }
        if (renderAtom.removed == this) {
            if (renderAtom == this.removeRAs) {
                this.removeRAs = renderAtom.nextRemove;
                if (this.removeRAs != null) {
                    this.removeRAs.prevRemove = null;
                }
                renderAtom.nextRemove = null;
                renderAtom.prevRemove = null;
            } else {
                renderAtom.prevRemove.nextRemove = renderAtom.nextRemove;
                if (renderAtom.nextRemove != null) {
                    renderAtom.nextRemove.prevRemove = renderAtom.prevRemove;
                }
                renderAtom.nextRemove = null;
                renderAtom.prevRemove = null;
            }
            renderAtom.removed = null;
            if (this.removeRAs == null) {
                renderBin.removeRenderAtomInRMList.remove(renderBin.removeRenderAtomInRMList.indexOf(this));
            }
        } else {
            if (this.addRAs == null) {
                this.addRAs = renderAtom;
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
            } else {
                renderAtom.nextAdd = this.addRAs;
                renderAtom.prevAdd = null;
                this.addRAs.prevAdd = renderAtom;
                this.addRAs = renderAtom;
            }
            renderAtom.added = this;
            if (this.onUpdateList == 0) {
                renderBin.objUpdateList.add(this);
            }
            this.onUpdateList |= NEW_RENDERATOMS_UPDATE;
        }
    }

    void removeRenderAtom(RenderAtom renderAtom) {
        renderAtom.renderMolecule = null;
        if (renderAtom.added == this) {
            if (renderAtom == this.addRAs) {
                this.addRAs = renderAtom.nextAdd;
                if (this.addRAs != null) {
                    this.addRAs.prevAdd = null;
                }
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
            } else {
                renderAtom.prevAdd.nextAdd = renderAtom.nextAdd;
                if (renderAtom.nextAdd != null) {
                    renderAtom.nextAdd.prevAdd = renderAtom.prevAdd;
                }
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
            }
            renderAtom.added = null;
            renderAtom.envSet = null;
        } else {
            if (this.removeRAs == null) {
                this.removeRAs = renderAtom;
                renderAtom.nextRemove = null;
                renderAtom.prevRemove = null;
            } else {
                renderAtom.nextRemove = this.removeRAs;
                renderAtom.prevRemove = null;
                this.removeRAs.prevRemove = renderAtom;
                this.removeRAs = renderAtom;
            }
            renderAtom.removed = this;
        }
        if (!this.renderBin.removeRenderAtomInRMList.contains(this)) {
            this.renderBin.removeRenderAtomInRMList.add(this);
        }
    }

    void recalcBounds() {
        if (this.primaryRenderMethod == VirtualUniverse.mc.getDisplayListRenderMethod()) {
            this.vwcBounds.set(null);
            RenderAtomListInfo renderAtomListInfo = this.primaryRenderAtomList;
            while (renderAtomListInfo != null) {
                this.vwcBounds.combine(renderAtomListInfo.renderAtom.localeVwcBounds);
                renderAtomListInfo = renderAtomListInfo.next;
            }
        }
    }

    void evalAlphaUsage(RenderingAttributesRetained renderingAttributesRetained, TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = this.definingTransparency != null && this.definingTransparency.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && this.definingTransparency.transparencyMode != 3);
        if (textureUnitStateRetainedArray != null) {
            int n = 0;
            while (!bl2 && n < textureUnitStateRetainedArray.length) {
                if (textureUnitStateRetainedArray[n] != null && textureUnitStateRetainedArray[n].texAttrs != null) {
                    bl2 = bl2 || textureUnitStateRetainedArray[n].texAttrs.textureMode == 4;
                }
                ++n;
            }
        }
        boolean bl4 = renderingAttributesRetained != null && renderingAttributesRetained.alphaTestFunction != 0;
        this.useAlpha = bl || bl4 || bl2;
    }

    boolean renderSizeSupport(RenderAtomListInfo renderAtomListInfo) {
        if (VirtualUniverse.mc.isD3D()) {
            while (renderAtomListInfo != null) {
                if (((GeometryArrayRetained)renderAtomListInfo.geometry).validVertexCount > 65535) {
                    return false;
                }
                renderAtomListInfo = renderAtomListInfo.next;
            }
        }
        return true;
    }

    void render(Canvas3D canvas3D, int n) {
        RenderAtomListInfo renderAtomListInfo;
        boolean bl = false;
        if (this.primaryRenderAtomList != null) {
            bl = this.primaryRenderAtomList.renderAtom.geometryAtom.source.lastSwitchOn;
        } else if (this.vertexArrayRenderAtomList != null) {
            bl = this.vertexArrayRenderAtomList.renderAtom.geometryAtom.source.lastSwitchOn;
        } else if (this.separateDlistRenderAtomList != null) {
            bl = this.separateDlistRenderAtomList.renderAtom.geometryAtom.source.lastSwitchOn;
        }
        if (!bl) {
            return;
        }
        int n2 = this.geometryType | 8 | 0x20 | 0x10;
        if ((canvas3D.canvasDirty & n2) != 0) {
            if ((this.geometryType & 4) != 0) {
                if (this.definingPolygonAttributes == null) {
                    canvas3D.resetPolygonAttributes(canvas3D.ctx);
                } else {
                    this.definingPolygonAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.polygonAttributes = this.definingPolygonAttributes;
            }
            if ((this.geometryType & 2) != 0) {
                if (this.definingLineAttributes == null) {
                    canvas3D.resetLineAttributes(canvas3D.ctx);
                } else {
                    this.definingLineAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.lineAttributes = this.definingLineAttributes;
            }
            if ((this.geometryType & 1) != 0) {
                if (this.definingPointAttributes == null) {
                    canvas3D.resetPointAttributes(canvas3D.ctx);
                } else {
                    this.definingPointAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.pointAttributes = this.definingPointAttributes;
            }
            if (this.definingMaterial == null) {
                canvas3D.updateMaterial(canvas3D.ctx, this.red, this.green, this.blue, this.alpha);
            } else {
                this.definingMaterial.updateNative(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            }
            canvas3D.material = this.definingMaterial;
            if (this.definingTransparency == null) {
                canvas3D.resetTransparency(canvas3D.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
            } else {
                this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
            }
            canvas3D.transparency = this.definingTransparency;
            if (this.definingColoringAttributes == null) {
                canvas3D.resetColoringAttributes(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            } else {
                this.definingColoringAttributes.updateNative(canvas3D.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
            }
            canvas3D.coloringAttributes = this.definingColoringAttributes;
        } else if (canvas3D.renderMolecule != this && this.dirtyAttrsAcrossRms != 0) {
            if ((this.dirtyAttrsAcrossRms & 8) != 0) {
                if (this.definingMaterial == null) {
                    canvas3D.updateMaterial(canvas3D.ctx, this.red, this.green, this.blue, this.alpha);
                } else {
                    this.definingMaterial.updateNative(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                }
                canvas3D.material = this.definingMaterial;
            }
            if ((this.dirtyAttrsAcrossRms & 0x10) != 0) {
                if (this.definingTransparency == null) {
                    canvas3D.resetTransparency(canvas3D.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
                } else {
                    this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
                }
                canvas3D.transparency = this.definingTransparency;
            }
            if ((this.dirtyAttrsAcrossRms & 4) != 0) {
                if (this.definingPolygonAttributes == null) {
                    canvas3D.resetPolygonAttributes(canvas3D.ctx);
                } else {
                    this.definingPolygonAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.polygonAttributes = this.definingPolygonAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 2) != 0) {
                if (this.definingLineAttributes == null) {
                    canvas3D.resetLineAttributes(canvas3D.ctx);
                } else {
                    this.definingLineAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.lineAttributes = this.definingLineAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 1) != 0) {
                if (this.definingPointAttributes == null) {
                    canvas3D.resetPointAttributes(canvas3D.ctx);
                } else {
                    this.definingPointAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.pointAttributes = this.definingPointAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 0x20) != 0) {
                if (this.definingColoringAttributes == null) {
                    canvas3D.resetColoringAttributes(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                } else {
                    this.definingColoringAttributes.updateNative(canvas3D.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                }
                canvas3D.coloringAttributes = this.definingColoringAttributes;
            }
            canvas3D.renderMolecule = this;
        }
        canvas3D.canvasDirty &= ~n2;
        canvas3D.renderMolecule = this;
        Transform3D transform3D = this.trans[this.localToVworldIndex[0]];
        boolean bl2 = true;
        if (VirtualUniverse.mc.isD3D()) {
            if (this.definingPolygonAttributes != null && this.isQuadGeometryArray && this.definingPolygonAttributes.polygonMode == 1) {
                bl2 = false;
            } else if (canvas3D.texCoordGeneration != null && canvas3D.texCoordGeneration.genMode == 0) {
                bl2 = false;
            }
        }
        if ((this.primaryMoleculeType & (TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) == 0) {
            if (canvas3D.modelMatrix != transform3D) {
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vworldToEc.mat, transform3D);
            }
            if (this.primaryRenderAtomList != null) {
                if (this.primaryRenderMethod != VirtualUniverse.mc.getDisplayListRenderMethod() || bl2 && this.renderSizeSupport(this.primaryRenderAtomList)) {
                    this.primaryRenderMethod.render(this, canvas3D);
                } else {
                    renderAtomListInfo = this.vertexArrayRenderAtomList;
                    this.vertexArrayRenderAtomList = this.primaryRenderAtomList;
                    this.cachedVertexArrayRenderMethod.setVertexFormat(this);
                    this.cachedVertexArrayRenderMethod.render(this, canvas3D, n);
                    this.cachedVertexArrayRenderMethod.disableGlobalAlpha(canvas3D.ctx, this);
                    this.vertexArrayRenderAtomList = renderAtomListInfo;
                }
            }
        } else {
            if (this.primaryRenderAtomList != null) {
                if (this.primaryRenderMethod != VirtualUniverse.mc.getDisplayListRenderMethod() || bl2 && this.renderSizeSupport(this.primaryRenderAtomList)) {
                    this.primaryRenderMethod.render(this, canvas3D);
                } else {
                    renderAtomListInfo = this.vertexArrayRenderAtomList;
                    this.vertexArrayRenderAtomList = this.primaryRenderAtomList;
                    this.cachedVertexArrayRenderMethod.setVertexFormat(this);
                    this.cachedVertexArrayRenderMethod.render(this, canvas3D, n);
                    this.cachedVertexArrayRenderMethod.disableGlobalAlpha(canvas3D.ctx, this);
                    this.vertexArrayRenderAtomList = renderAtomListInfo;
                }
            }
            if ((this.separateDlistRenderAtomList != null || this.vertexArrayRenderAtomList != null) && canvas3D.modelMatrix != transform3D) {
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vworldToEc.mat, transform3D);
            }
        }
        if (this.separateDlistRenderAtomList != null) {
            if (bl2 && this.renderSizeSupport(this.separateDlistRenderAtomList)) {
                this.renderBin.dlistRenderMethod.renderSeparateDlists(this, canvas3D);
            } else {
                renderAtomListInfo = this.vertexArrayRenderAtomList;
                this.vertexArrayRenderAtomList = this.separateDlistRenderAtomList;
                this.cachedVertexArrayRenderMethod.setVertexFormat(this);
                this.cachedVertexArrayRenderMethod.render(this, canvas3D, n);
                this.cachedVertexArrayRenderMethod.disableGlobalAlpha(canvas3D.ctx, this);
                this.vertexArrayRenderAtomList = renderAtomListInfo;
            }
        }
        if (this.vertexArrayRenderAtomList != null) {
            this.cachedVertexArrayRenderMethod.setVertexFormat(this);
            this.cachedVertexArrayRenderMethod.render(this, canvas3D, n);
            this.cachedVertexArrayRenderMethod.disableGlobalAlpha(canvas3D.ctx, this);
        }
    }

    void renderTransparencyAttributes(Canvas3D canvas3D) {
        if (this.definingTransparency == null) {
            canvas3D.resetTransparency(canvas3D.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
        } else {
            this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
        }
    }

    void updateDisplayList(Canvas3D canvas3D) {
        if (this.primaryRenderAtomList != null) {
            ((DisplayListRenderMethod)this.primaryRenderMethod).buildDisplayList(this, canvas3D);
        }
    }

    void checkEquivalenceWithBothNeighbors() {
        RenderMolecule renderMolecule = this.prev;
        RenderMolecule renderMolecule2 = this.next;
        this.dirtyAttrsAcrossRms = 63;
        boolean bl = true;
        if (this.prev != null) {
            this.checkEquivalenceWithLeftNeighbor(this.prev);
        }
        if (this.next != null) {
            if ((this.vertexFormat & 4) == 0 || (this.vertexFormat & 4) != 0 && (this.next.vertexFormat & 4) != 0) {
                bl = false;
            }
            this.next.dirtyAttrsAcrossRms = 63;
            if (!bl && (this.next.definingMaterial == this.definingMaterial || this.next.definingMaterial != null && this.next.definingMaterial.equivalent(this.definingMaterial) && this.next.alpha == this.alpha && this.enableLighting == this.next.enableLighting && (this.enableLighting || !this.enableLighting && this.next.red == this.red && this.next.green == this.green && this.next.blue == this.blue))) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFF7;
            }
            if (this.next.definingPolygonAttributes == this.definingPolygonAttributes || this.next.definingPolygonAttributes != null && this.next.definingPolygonAttributes.equivalent(this.definingPolygonAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFB;
            }
            if (this.next.definingPointAttributes == this.definingPointAttributes || this.next.definingPointAttributes != null && this.next.definingPointAttributes.equivalent(this.definingPointAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFE;
            }
            if (this.next.definingLineAttributes == this.definingLineAttributes || this.next.definingLineAttributes != null && this.next.definingLineAttributes.equivalent(this.definingLineAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFD;
            }
            if (!bl && (this.next.definingColoringAttributes == this.definingColoringAttributes || this.next.definingColoringAttributes != null && this.next.definingColoringAttributes.equivalent(this.definingColoringAttributes))) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFDF;
            }
            if (this.next.definingTransparency == this.definingTransparency || this.next.definingTransparency != null && this.next.definingTransparency.equivalent(this.definingTransparency)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFEF;
            }
        }
    }

    void checkEquivalenceWithLeftNeighbor(RenderMolecule renderMolecule) {
        boolean bl = true;
        if ((renderMolecule.vertexFormat & 4) == 0 || (renderMolecule.vertexFormat & 4) != 0 && (this.vertexFormat & 4) != 0) {
            bl = false;
        }
        this.dirtyAttrsAcrossRms = 63;
        if (!bl && (renderMolecule.definingMaterial == this.definingMaterial || renderMolecule.definingMaterial != null && renderMolecule.definingMaterial.equivalent(this.definingMaterial) && renderMolecule.alpha == this.alpha && this.enableLighting == renderMolecule.enableLighting && (this.enableLighting || !this.enableLighting && renderMolecule.red == this.red && renderMolecule.green == this.green && renderMolecule.blue == this.blue))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFF7;
        }
        if (renderMolecule.definingPolygonAttributes == this.definingPolygonAttributes || renderMolecule.definingPolygonAttributes != null && renderMolecule.definingPolygonAttributes.equivalent(this.definingPolygonAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFB;
        }
        if (renderMolecule.definingPointAttributes == this.definingPointAttributes || renderMolecule.definingPointAttributes != null && renderMolecule.definingPointAttributes.equivalent(this.definingPointAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFE;
        }
        if (renderMolecule.definingLineAttributes == this.definingLineAttributes || renderMolecule.definingLineAttributes != null && renderMolecule.definingLineAttributes.equivalent(this.definingLineAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFD;
        }
        if (!bl && (renderMolecule.definingColoringAttributes == this.definingColoringAttributes || renderMolecule.definingColoringAttributes != null && renderMolecule.definingColoringAttributes.equivalent(this.definingColoringAttributes))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFDF;
        }
        if (renderMolecule.definingTransparency == this.definingTransparency || renderMolecule.definingTransparency != null && renderMolecule.definingTransparency.equivalent(this.definingTransparency)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFEF;
        }
    }

    void translate() {
        int n = this.localToVworldIndex[0];
        this.localeLocalToVworld[n].mat[0] = this.localToVworld[n].mat[0];
        this.localeLocalToVworld[n].mat[1] = this.localToVworld[n].mat[1];
        this.localeLocalToVworld[n].mat[2] = this.localToVworld[n].mat[2];
        this.localeLocalToVworld[n].mat[3] = this.localToVworld[n].mat[3] + this.localeTranslation.x;
        this.localeLocalToVworld[n].mat[4] = this.localToVworld[n].mat[4];
        this.localeLocalToVworld[n].mat[5] = this.localToVworld[n].mat[5];
        this.localeLocalToVworld[n].mat[6] = this.localToVworld[n].mat[6];
        this.localeLocalToVworld[n].mat[7] = this.localToVworld[n].mat[7] + this.localeTranslation.y;
        this.localeLocalToVworld[n].mat[8] = this.localToVworld[n].mat[8];
        this.localeLocalToVworld[n].mat[9] = this.localToVworld[n].mat[9];
        this.localeLocalToVworld[n].mat[10] = this.localToVworld[n].mat[10];
        this.localeLocalToVworld[n].mat[11] = this.localToVworld[n].mat[11] + this.localeTranslation.z;
        this.localeLocalToVworld[n].mat[12] = this.localToVworld[n].mat[12];
        this.localeLocalToVworld[n].mat[13] = this.localToVworld[n].mat[13];
        this.localeLocalToVworld[n].mat[14] = this.localToVworld[n].mat[14];
        this.localeLocalToVworld[n].mat[15] = this.localToVworld[n].mat[15];
    }
}

