/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class PointArrayRetained
extends GeometryArrayRetained {
    PointArrayRetained() {
        this.geoType = 3;
    }

    boolean intersect(PickShape pickShape) {
        int n = 0;
        double[] dArray = new double[1];
        Vector3d vector3d = null;
        Point3d point3d = null;
        Point3d point3d2 = null;
        Bounds bounds = null;
        Point3d point3d3 = new Point3d();
        if (pickShape instanceof PickRay) {
            n = 1;
        } else if (pickShape instanceof PickSegment) {
            point3d = ((PickSegment)pickShape).start;
            point3d2 = ((PickSegment)pickShape).end;
            vector3d = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
            n = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n = 4;
            } else if (bounds instanceof BoundingSphere) {
                n = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("PointArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n = 7;
            } else if (pickShape instanceof PickCone) {
                n = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        int n3 = n2;
        while (n3 < this.validVertexCount) {
            super.getVertexData(n3, point3d3);
            switch (n) {
                case 1: {
                    if (!this.intersectPntAndRay(point3d3, ((PickRay)pickShape).origin, ((PickRay)pickShape).direction, dArray)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectPntAndRay(point3d3, point3d, vector3d, dArray) || !(dArray[0] <= 1.0)) break;
                    return true;
                }
                case 4: {
                    if (!((BoundingBox)((PickBounds)pickShape).bounds).intersect(point3d3)) break;
                    return true;
                }
                case 5: {
                    if (!((BoundingSphere)((PickBounds)pickShape).bounds).intersect(point3d3)) break;
                    return true;
                }
                case 6: {
                    if (!((BoundingPolytope)((PickBounds)pickShape).bounds).intersect(point3d3)) break;
                    return true;
                }
                case 7: {
                    if (!this.intersectCylinder(point3d3, (PickCylinder)pickShape, dArray)) break;
                    return true;
                }
                case 8: {
                    if (!this.intersectCone(point3d3, (PickCone)pickShape, dArray)) break;
                    return true;
                }
            }
            ++n3;
        }
        return n == 3;
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        double[] dArray2 = new double[1];
        boolean bl = false;
        Point3d point3d2 = new Point3d();
        dArray[0] = Double.MAX_VALUE;
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        int n2 = n;
        while (n2 < this.validVertexCount) {
            super.getVertexData(n2, point3d2);
            if (this.intersectPntAndRay(point3d2, pickRay.origin, pickRay.direction, dArray2)) {
                bl = true;
                if (dArray2[0] < dArray[0]) {
                    dArray[0] = dArray2[0];
                    point3d.x = point3d2.x;
                    point3d.y = point3d2.y;
                    point3d.z = point3d2.z;
                }
            }
            ++n2;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Point3d point3d = new Point3d();
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        int n2 = n;
        while (n2 < this.validVertexCount) {
            super.getVertexData(n2, point3d);
            transform3D.transform(point3d, point3d);
            switch (point3dArray.length) {
                case 1: {
                    if (point3dArray[0].x != point3d.x || point3dArray[0].y != point3d.y || point3dArray[0].z != point3d.z) break;
                    return true;
                }
                case 2: {
                    double[] dArray = new double[1];
                    Vector3d vector3d = new Vector3d();
                    vector3d.x = point3dArray[1].x - point3dArray[0].x;
                    vector3d.y = point3dArray[1].y - point3dArray[0].y;
                    vector3d.z = point3dArray[1].z - point3dArray[0].z;
                    if (!this.intersectPntAndRay(point3d, point3dArray[0], vector3d, dArray) || !(dArray[0] <= 1.0)) break;
                    return true;
                }
                case 3: {
                    if (!this.intersectTriPnt(point3dArray[0], point3dArray[1], point3dArray[2], point3d)) break;
                    return true;
                }
                case 4: {
                    if (this.intersectTriPnt(point3dArray[0], point3dArray[1], point3dArray[2], point3d)) {
                        return true;
                    }
                    if (!this.intersectTriPnt(point3dArray[0], point3dArray[2], point3dArray[3], point3d)) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[1];
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        int n2 = n;
        while (n2 < this.validVertexCount) {
            super.getVertexData(n2, point3dArray[0]);
            transform3D.transform(point3dArray[0], point3dArray[0]);
            if (geometryRetained.intersect(transform3D2, point3dArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        Point3d point3d = new Point3d();
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        int n2 = n;
        while (n2 < this.validVertexCount) {
            super.getVertexData(n2, point3d);
            transform3D.transform(point3d, point3d);
            if (bounds.intersect(point3d)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

