/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;

public class PhysicalEnvironment {
    int HeadIndex = 0;
    int RightHandIndex = 1;
    int LeftHandIndex = 2;
    int DominantHandIndex = 1;
    int NonDominantHandIndex = 2;
    Transform3D coexistenceToTrackerBase = new Transform3D();
    boolean trackingAvailable = false;
    int coexistenceCenterInPworldPolicy = 2;
    int peDirtyMask = 0x700000;
    int sensorCount;
    Sensor[] sensors;
    AudioDevice audioDevice = null;
    boolean sensorListChanged = false;
    Sensor[] sensorList = null;
    ArrayList users = new ArrayList();
    InputDeviceScheduler inputsched;
    Vector devices = new Vector(1);
    int activeViewRef = 0;
    static Hashtable physicalEnvMap = new Hashtable();

    public PhysicalEnvironment() {
        this(3);
    }

    synchronized void removeUser(View view) {
        int n = this.users.indexOf(view);
        if (n >= 0) {
            this.users.remove(n);
        }
    }

    synchronized void addUser(View view) {
        int n = this.users.indexOf(view);
        if (n < 0) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        int n = this.users.size() - 1;
        while (n >= 0) {
            View view = (View)this.users.get(n);
            view.repaint();
            --n;
        }
    }

    public PhysicalEnvironment(int n) {
        this.sensorCount = n;
        this.sensors = new Sensor[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.sensors[n2] = null;
            --n2;
        }
    }

    Sensor[] getSensorList() {
        Sensor[] sensorArray = this.sensors;
        synchronized (sensorArray) {
            if (this.sensorListChanged) {
                this.sensorList = new Sensor[this.sensors.length];
                int n = 0;
                while (n < this.sensors.length) {
                    this.sensorList[n] = this.sensors[n];
                    ++n;
                }
                this.sensorListChanged = false;
            }
            Sensor[] sensorArray2 = this.sensorList;
            return sensorArray2;
        }
    }

    public void setAudioDevice(AudioDevice audioDevice) {
        this.audioDevice = audioDevice;
    }

    public AudioDevice getAudioDevice() {
        return this.audioDevice;
    }

    public Enumeration getAllInputDevices() {
        return this.devices.elements();
    }

    public void addInputDevice(InputDevice inputDevice) {
        int n = inputDevice.getProcessingMode();
        if (n == 3 || n == 4 || n == 5) {
            Vector vector = this.devices;
            synchronized (vector) {
                this.devices.add(inputDevice);
                if (this.inputsched != null) {
                    this.inputsched.addInputDevice(inputDevice);
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment0"));
        }
    }

    public void removeInputDevice(InputDevice inputDevice) {
        this.devices.remove(inputDevice);
        Vector vector = this.devices;
        synchronized (vector) {
            if (this.inputsched != null) {
                this.inputsched.removeInputDevice(inputDevice);
            }
        }
    }

    public void setHeadIndex(int n) {
        this.HeadIndex = n;
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.computeTrackingAvailable();
            this.peDirtyMask |= 0x200000;
        }
        this.notifyUsers();
    }

    public int getHeadIndex() {
        return this.HeadIndex;
    }

    public void setRightHandIndex(int n) {
        this.RightHandIndex = n;
        this.notifyUsers();
    }

    public int getRightHandIndex() {
        return this.RightHandIndex;
    }

    public void setLeftHandIndex(int n) {
        this.LeftHandIndex = n;
        this.notifyUsers();
    }

    public int getLeftHandIndex() {
        return this.LeftHandIndex;
    }

    public void setDominantHandIndex(int n) {
        this.DominantHandIndex = n;
        this.notifyUsers();
    }

    public int getDominantHandIndex() {
        return this.DominantHandIndex;
    }

    public void setNonDominantHandIndex(int n) {
        this.NonDominantHandIndex = n;
        this.notifyUsers();
    }

    public int getNonDominantHandIndex() {
        return this.NonDominantHandIndex;
    }

    public void setSensor(int n, Sensor sensor) {
        Sensor[] sensorArray = this.sensors;
        synchronized (sensorArray) {
            this.sensors[n] = sensor;
            this.sensorListChanged = true;
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.computeTrackingAvailable();
            this.peDirtyMask |= 0x200000;
        }
        this.notifyUsers();
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public void setCoexistenceToTrackerBase(Transform3D transform3D) {
        if (!transform3D.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalEnvironment1"));
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceToTrackerBase.setWithLock(transform3D);
            this.peDirtyMask |= 0x100000;
        }
        this.notifyUsers();
    }

    public void getCoexistenceToTrackerBase(Transform3D transform3D) {
        transform3D.set(this.coexistenceToTrackerBase);
    }

    public boolean getTrackingAvailable() {
        return this.trackingAvailable;
    }

    public void setCoexistenceCenterInPworldPolicy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("PhysicalEnvironment2"));
            }
        }
        PhysicalEnvironment physicalEnvironment = this;
        synchronized (physicalEnvironment) {
            this.coexistenceCenterInPworldPolicy = n;
            this.peDirtyMask |= 0x400000;
        }
        this.notifyUsers();
    }

    public int getCoexistenceCenterInPworldPolicy() {
        return this.coexistenceCenterInPworldPolicy;
    }

    public int getSensorCount() {
        return this.sensorCount;
    }

    public void setSensorCount(int n) {
        Sensor[] sensorArray = new Sensor[n];
        int n2 = 0;
        Sensor[] sensorArray2 = this.sensors;
        synchronized (sensorArray2) {
            int n3 = Math.min(n, this.sensorCount);
            while (n2 < n3) {
                sensorArray[n2] = this.sensors[n2++];
            }
            while (n2 < n) {
                sensorArray[n2++] = null;
            }
            this.sensorCount = n;
            this.sensorListChanged = true;
            this.sensors = sensorArray;
        }
        this.notifyUsers();
    }

    private void computeTrackingAvailable() {
        Sensor[] sensorArray = this.sensors;
        synchronized (sensorArray) {
            this.trackingAvailable = this.HeadIndex < this.sensors.length && this.sensors[this.HeadIndex] != null;
        }
    }
}

