/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.SetLiveState;

class OrderedGroupRetained
extends GroupRetained {
    int[] orderedChildIdTable;
    private int orderedChildIdCount = 0;
    private ArrayList orderedChildIdFreeList = new ArrayList();
    OrderedBin[] orderedBin = new OrderedBin[0];
    Integer newChildId;
    int childCount = 0;

    OrderedGroupRetained() {
        this.nodeType = 20;
    }

    Integer getOrderedChildId() {
        Integer n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            if (this.orderedChildIdFreeList.size() == 0) {
                n = new Integer(this.orderedChildIdCount);
                ++this.orderedChildIdCount;
            } else {
                n = (Integer)this.orderedChildIdFreeList.remove(0);
            }
        }
        return n;
    }

    void freeOrderedChildId(int n) {
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            this.orderedChildIdFreeList.add(new Integer(n));
        }
    }

    int getOrderedChildCount() {
        int n;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            n = this.orderedChildIdCount;
        }
        return n;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
    }

    void setOrderedBin(OrderedBin orderedBin, int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (orderedBinArray) {
            this.orderedBin[n] = orderedBin;
        }
    }

    OrderedBin getOrderedBin(int n) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (orderedBinArray) {
            if (n >= this.orderedBin.length) {
                OrderedBin[] orderedBinArray2 = new OrderedBin[n + 1];
                int n2 = 0;
                while (n2 < this.orderedBin.length) {
                    orderedBinArray2[n2] = this.orderedBin[n2];
                    ++n2;
                }
                orderedBinArray2[n] = null;
                this.orderedBin = orderedBinArray2;
            }
        }
        return this.orderedBin[n];
    }

    void updateChildIdTableInserted(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.orderedChildIdTable != null) {
            n4 = this.orderedChildIdTable.length;
            n3 = 0;
            while (n3 < n4) {
                if (this.orderedChildIdTable[n3] != -1 && this.orderedChildIdTable[n3] >= n) {
                    int n5 = n3;
                    this.orderedChildIdTable[n5] = this.orderedChildIdTable[n5] + 1;
                }
                ++n3;
            }
        }
        if (n2 >= n4) {
            int[] nArray = new int[n2 + 1];
            if (n4 > 0) {
                System.arraycopy(this.orderedChildIdTable, 0, nArray, 0, this.orderedChildIdTable.length);
            } else {
                n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = -1;
                    ++n3;
                }
            }
            this.orderedChildIdTable = nArray;
        }
        this.orderedChildIdTable[n2] = n;
    }

    void updateChildIdTableRemoved(int n) {
        if (this.orderedChildIdTable == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.orderedChildIdTable.length) {
            if (this.orderedChildIdTable[n2] != -1) {
                if (this.orderedChildIdTable[n2] > n) {
                    int n3 = n2;
                    this.orderedChildIdTable[n3] = this.orderedChildIdTable[n3] - 1;
                } else if (this.orderedChildIdTable[n2] == n) {
                    this.orderedChildIdTable[n2] = -1;
                    this.freeOrderedChildId(n2);
                }
            }
            ++n2;
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.refCount == 0) {
            setLiveState.notifyThreads |= 0x1000;
            setLiveState.nodeList.add(this);
        }
    }

    void clearDerivedDataStructures() {
        int n = 0;
        while (n < this.orderedBin.length) {
            if (this.orderedBin[n] != null) {
                this.orderedBin[n].source = null;
                this.orderedBin[n] = null;
            }
            ++n;
        }
        if (this.orderedChildIdTable != null) {
            n = 0;
            while (n < this.orderedChildIdTable.length) {
                if (this.orderedChildIdTable[n] != -1) {
                    this.orderedChildIdTable[n] = -1;
                    this.freeOrderedChildId(n);
                }
                ++n;
            }
            this.orderedChildIdTable = null;
        }
    }

    void incrChildCount() {
        ++this.childCount;
    }

    void decrChildCount() {
        --this.childCount;
    }

    void printTable(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            System.out.print(" " + nArray[n]);
            ++n;
        }
        System.out.println("");
    }
}

