/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

abstract class NodeRetained
extends SceneGraphObjectRetained {
    static final int BACKGROUND = 1;
    static final int CLIP = 2;
    static final int LINEARFOG = 3;
    static final int EXPONENTIALFOG = 4;
    static final int AMBIENTLIGHT = 5;
    static final int DIRECTIONALLIGHT = 6;
    static final int POINTLIGHT = 7;
    static final int SPOTLIGHT = 8;
    static final int LINK = 9;
    static final int MORPH = 10;
    static final int SHAPE = 11;
    static final int BACKGROUNDSOUND = 12;
    static final int POINTSOUND = 13;
    static final int CONESOUND = 14;
    static final int SOUNDSCAPE = 15;
    static final int VIEWPLATFORM = 16;
    static final int BEHAVIOR = 17;
    static final int SWITCH = 18;
    static final int BRANCHGROUP = 19;
    static final int ORDEREDGROUP = 20;
    static final int DECALGROUP = 21;
    static final int SHAREDGROUP = 22;
    static final int GROUP = 23;
    static final int TRANSFORMGROUP = 24;
    static final int BOUNDINGLEAF = 25;
    static final int MODELCLIP = 26;
    static final int ALTERNATEAPPEARANCE = 27;
    static final int ORIENTEDSHAPE3D = 28;
    static final int NUMNODES = 28;
    static final int CONTAINS_VIEWPLATFORM = 1;
    VirtualUniverse universe = null;
    Locale locale = null;
    NodeRetained parent = null;
    String nodeId = null;
    int nodeType;
    int refCount = 0;
    int childIndex = -1;
    boolean inSharedGroup = false;
    boolean pickable = true;
    boolean collidable = true;
    Transform3D[][] localToVworld = null;
    int[][] localToVworldIndex = null;
    static final int LAST_LOCAL_TO_VWORLD = 0;
    static final int CURRENT_LOCAL_TO_VWORLD = 1;
    ArrayList[] parentTransformGroups = null;
    HashKey[] localToVworldKeys = null;
    ArrayList transformTargets = null;
    ArrayList transformBLTargets = null;
    boolean boundsAutoCompute = true;
    Bounds localBounds;
    Bounds apiBounds;
    Object changeLock = new Object();
    ArrayList branchGroupPaths = new ArrayList(1);
    BackgroundRetained geometryBackground = null;
    GroupRetained parentTransformLink = null;
    GroupRetained parentSwitchLink = null;
    TransformGroupRetained staticTransform = null;
    Integer orderedId = null;

    NodeRetained() {
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
    }

    void setBounds(Bounds bounds) {
        this.apiBounds = bounds;
        if (this.source.isLive()) {
            if (!this.boundsAutoCompute) {
                if (bounds != null) {
                    this.localBounds = (Bounds)bounds.clone();
                    if (this.staticTransform != null) {
                        this.localBounds.transform(this.staticTransform.transform);
                    }
                } else {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
            }
        } else if (bounds != null) {
            this.localBounds = (Bounds)bounds.clone();
            if (this.staticTransform != null) {
                this.localBounds.transform(this.staticTransform.transform);
            }
        } else {
            this.localBounds = new BoundingBox((Bounds)null);
        }
    }

    Bounds getEffectiveBounds() {
        Bounds bounds = null;
        if (this.localBounds != null && !this.localBounds.isEmpty()) {
            bounds = (Bounds)this.localBounds.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    Bounds getBounds() {
        return this.apiBounds;
    }

    void computeCombineBounds(Bounds bounds) {
    }

    void setBoundsAutoCompute(boolean bl) {
        this.boundsAutoCompute = bl;
    }

    boolean getBoundsAutoCompute() {
        return this.boundsAutoCompute;
    }

    void setParent(NodeRetained nodeRetained) {
        this.parent = nodeRetained;
    }

    NodeRetained getParent() {
        return this.parent;
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentLocalToVworld(hashKey));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeLocalToVworld(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey, Transform3D transform3D) {
        if (nodeRetained2 instanceof SharedGroupRetained) {
            String string = hashKey.getLastNodeId();
            SharedGroupRetained sharedGroupRetained = (SharedGroupRetained)nodeRetained2;
            int n = 0;
            while (n < sharedGroupRetained.parents.size()) {
                if (string.equals(((NodeRetained)sharedGroupRetained.parents.elementAt((int)n)).nodeId)) {
                    this.computeLocalToVworld(nodeRetained, (NodeRetained)sharedGroupRetained.parents.elementAt(n), hashKey, transform3D);
                    return;
                }
                ++n;
            }
            throw new RuntimeException(J3dI18N.getString("NodeRetained4"));
        }
        Object object = nodeRetained2.getParent();
        if (object == null) {
            if (((BranchGroupRetained)nodeRetained2).locale == null) throw new RuntimeException(J3dI18N.getString("NodeRetained5"));
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(nodeRetained, (NodeRetained)object, hashKey, transform3D);
        }
        if (nodeRetained2 instanceof TransformGroupRetained && nodeRetained2 != nodeRetained) {
            object = VirtualUniverse.mc.getTransform3D(null);
            ((TransformGroupRetained)nodeRetained2).transform.getWithLock((Transform3D)object);
            transform3D.mul((Transform3D)object);
            VirtualUniverse.mc.addToTransformFreeList((Transform3D)object);
            return;
        } else {
            if (nodeRetained2 != nodeRetained || this.staticTransform == null) return;
            transform3D.mul(this.staticTransform.transform);
        }
    }

    void getLocalToVworld(Transform3D transform3D) {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        if (this.localToVworld == null) {
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(this, this, null, transform3D);
        }
    }

    void getLocalToVworld(SceneGraphPath sceneGraphPath, Transform3D transform3D) {
        HashKey hashKey = new HashKey("");
        if (!this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained1"));
        }
        sceneGraphPath.validate(hashKey);
        this.computeLocalToVworld(this, this, hashKey, transform3D);
    }

    void getLocalToVworld(Transform3D transform3D, HashKey hashKey) {
        HashKey hashKey2 = new HashKey(hashKey);
        this.computeLocalToVworld(this, this, hashKey2, transform3D);
    }

    Transform3D getCurrentLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][1]];
        }
        return new Transform3D();
    }

    Transform3D getCurrentLocalToVworld(int n) {
        return this.localToVworld[n][this.localToVworldIndex[n][1]];
    }

    Transform3D getCurrentLocalToVworld(HashKey hashKey) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][1]];
            }
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (n >= 0) {
                return this.localToVworld[n][this.localToVworldIndex[n][1]];
            }
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][0]];
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld(int n) {
        return this.localToVworld[n][this.localToVworldIndex[n][0]];
    }

    Transform3D getLastLocalToVworld(HashKey hashKey) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][0]];
            }
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (n >= 0) {
                return this.localToVworld[n][this.localToVworldIndex[n][0]];
            }
        }
        return new Transform3D();
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
    }

    void setLocalToVworld(SetLiveState setLiveState) {
        Object object;
        int n;
        if (!this.inSharedGroup) {
            if (this.localToVworld == null) {
                this.localToVworld = new Transform3D[1][];
                this.localToVworldIndex = new int[1][];
                this.parentTransformGroups = new ArrayList[1];
            }
            this.localToVworld[0] = setLiveState.currentTransforms[0];
            this.localToVworldIndex[0] = setLiveState.currentTransformsIndex[0];
            this.parentTransformGroups[0] = (ArrayList)setLiveState.parentTransformGroups[0].clone();
            this.branchGroupPaths.add(setLiveState.branchGroupPaths.get(0));
            this.setAuxData(setLiveState, 0, 0);
            return;
        }
        if (this.localToVworld == null) {
            this.localToVworld = new Transform3D[setLiveState.keys.length][];
            this.localToVworldIndex = new int[setLiveState.keys.length][];
            this.parentTransformGroups = new ArrayList[setLiveState.keys.length];
            this.localToVworldKeys = new HashKey[setLiveState.keys.length];
            n = 0;
        } else {
            n = this.localToVworld.length + setLiveState.keys.length;
            object = new Transform3D[n][];
            HashKey[] hashKeyArray = new HashKey[n];
            ArrayList[] arrayListArray = new ArrayList[n];
            int[][] nArrayArray = new int[n][];
            n = this.localToVworld.length;
            System.arraycopy(this.localToVworld, 0, object, 0, this.localToVworld.length);
            System.arraycopy(this.localToVworldIndex, 0, nArrayArray, 0, this.localToVworldIndex.length);
            System.arraycopy(this.localToVworldKeys, 0, hashKeyArray, 0, this.localToVworldKeys.length);
            System.arraycopy(this.parentTransformGroups, 0, arrayListArray, 0, this.parentTransformGroups.length);
            this.localToVworld = object;
            this.localToVworldIndex = nArrayArray;
            this.parentTransformGroups = arrayListArray;
            this.localToVworldKeys = hashKeyArray;
        }
        object = new int[1];
        int n2 = n;
        int n3 = 0;
        while (n2 < this.localToVworld.length) {
            if (setLiveState.keys[n3].equals(this.localToVworldKeys, (int[])object, 0, n2)) {
                System.out.println("Found matching hashKey in setLocalToVworld.");
                System.out.println("We're in TROUBLE!!!");
            }
            if (object[0] == n2) {
                this.localToVworldKeys[n2] = setLiveState.keys[n3];
                this.localToVworld[n2] = setLiveState.currentTransforms[n3];
                this.localToVworldIndex[n2] = setLiveState.currentTransformsIndex[n3];
                this.parentTransformGroups[n2] = (ArrayList)setLiveState.parentTransformGroups[n3].clone();
            } else {
                reference var6_5 = object[0] + true;
                int n4 = n2 - object[0];
                System.arraycopy(this.localToVworldKeys, (int)object[0], this.localToVworldKeys, (int)var6_5, n4);
                System.arraycopy(this.localToVworld, (int)object[0], this.localToVworld, (int)var6_5, n4);
                System.arraycopy(this.localToVworldIndex, (int)object[0], this.localToVworldIndex, (int)var6_5, n4);
                System.arraycopy(this.parentTransformGroups, (int)object[0], this.parentTransformGroups, (int)var6_5, n4);
                this.localToVworldKeys[object[0]] = setLiveState.keys[n3];
                this.localToVworld[object[0]] = setLiveState.currentTransforms[n3];
                this.localToVworldIndex[object[0]] = setLiveState.currentTransformsIndex[n3];
                this.parentTransformGroups[object[0]] = (ArrayList)setLiveState.parentTransformGroups[n3].clone();
            }
            this.branchGroupPaths.add((int)object[0], setLiveState.branchGroupPaths.get(n3));
            this.setAuxData(setLiveState, n3, (int)object[0]);
            ++n2;
            ++n3;
        }
    }

    void removeLocalToVworldForTG(HashKey[] hashKeyArray) {
        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this;
        int n = 0;
        Transform3D[][] transform3DArrayArray = null;
        HashKey[] hashKeyArray2 = null;
        ArrayList[] arrayListArray = null;
        Transform3D[][] transform3DArrayArray2 = null;
        int[][] nArrayArray = null;
        int[][] nArrayArray2 = null;
        int[] nArray = null;
        boolean[] blArray = null;
        if (hashKeyArray.length == this.localToVworld.length) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            transformGroupRetained.isDirty = null;
            this.parentTransformGroups = null;
            transformGroupRetained.childLocalToVworld = null;
            transformGroupRetained.childLocalToVworldIndex = null;
            transformGroupRetained.transformLevels = null;
            transformGroupRetained.isDirty = null;
            this.branchGroupPaths.clear();
            return;
        }
        int n2 = this.localToVworld.length - hashKeyArray.length;
        transform3DArrayArray = new Transform3D[n2][];
        hashKeyArray2 = new HashKey[n2];
        arrayListArray = new ArrayList[n2];
        transform3DArrayArray2 = new Transform3D[n2][];
        nArrayArray = new int[n2][];
        nArrayArray2 = new int[n2][];
        nArray = new int[n2];
        blArray = new boolean[n2];
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        while (n3 < this.localToVworld.length) {
            int n4 = 0;
            while (n4 < hashKeyArray.length) {
                HashKey hashKey = hashKeyArray[n4];
                if (!this.localToVworldKeys[n3].equals((Object)hashKey)) {
                    transform3DArrayArray[n] = this.localToVworld[n3];
                    nArrayArray[n] = this.localToVworldIndex[n3];
                    hashKeyArray2[n] = this.localToVworldKeys[n3];
                    arrayListArray[n] = this.parentTransformGroups[n3];
                    transform3DArrayArray2[n] = transformGroupRetained.childLocalToVworld[n3];
                    nArrayArray2[n] = transformGroupRetained.childLocalToVworldIndex[n3];
                    nArray[n] = transformGroupRetained.transformLevels[n3];
                    blArray[n] = transformGroupRetained.isDirty[n3];
                    arrayList.add(this.branchGroupPaths.get(n3));
                    ++n;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        this.localToVworld = transform3DArrayArray;
        this.localToVworldIndex = nArrayArray;
        this.localToVworldKeys = hashKeyArray2;
        this.parentTransformGroups = arrayListArray;
        transformGroupRetained.childLocalToVworld = transform3DArrayArray2;
        transformGroupRetained.childLocalToVworldIndex = nArrayArray2;
        transformGroupRetained.transformLevels = nArray;
        transformGroupRetained.isDirty = blArray;
        this.branchGroupPaths = arrayList;
    }

    void removeLocalToVworld(HashKey[] hashKeyArray) {
        Transform3D[][] transform3DArrayArray = null;
        HashKey[] hashKeyArray2 = null;
        ArrayList[] arrayListArray = null;
        Object var5_5 = null;
        int[][] nArrayArray = null;
        Object var7_7 = null;
        int n = 0;
        if (hashKeyArray.length == this.localToVworld.length) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            this.parentTransformGroups = null;
            this.branchGroupPaths.clear();
            return;
        }
        int n2 = this.localToVworld.length - hashKeyArray.length;
        transform3DArrayArray = new Transform3D[n2][];
        hashKeyArray2 = new HashKey[n2];
        arrayListArray = new ArrayList[n2];
        nArrayArray = new int[n2][];
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        while (n3 < this.localToVworld.length) {
            int n4 = 0;
            while (n4 < hashKeyArray.length) {
                HashKey hashKey = hashKeyArray[n4];
                if (!this.localToVworldKeys[n3].equals((Object)hashKey)) {
                    transform3DArrayArray[n] = this.localToVworld[n3];
                    nArrayArray[n] = this.localToVworldIndex[n3];
                    hashKeyArray2[n] = this.localToVworldKeys[n3];
                    arrayListArray[n] = this.parentTransformGroups[n3];
                    arrayList.add(this.branchGroupPaths.get(n3));
                    ++n;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        this.localToVworld = transform3DArrayArray;
        this.localToVworldIndex = nArrayArray;
        this.localToVworldKeys = hashKeyArray2;
        this.parentTransformGroups = arrayListArray;
        this.branchGroupPaths = arrayList;
    }

    void setPickable(boolean bl) {
        if (this.pickable == bl) {
            return;
        }
        this.pickable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findPickableFlags(blArray);
                this.updatePickable(this.localToVworldKeys, blArray);
            }
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (!this.pickable) {
                blArray[n] = false;
            }
            ++n;
        }
    }

    boolean getPickable() {
        return this.pickable;
    }

    void setCollidable(boolean bl) {
        if (this.collidable == bl) {
            return;
        }
        this.collidable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findCollidableFlags(blArray);
                this.updateCollidable(this.localToVworldKeys, blArray);
            }
        }
    }

    boolean getCollidable() {
        return this.collidable;
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (!this.collidable) {
                blArray[n] = false;
            }
            ++n;
        }
    }

    void notifySceneGraphChanged(boolean bl) {
    }

    void recombineAbove() {
    }

    synchronized void updateLocalToVworld() {
    }

    void setLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.doSetLive(setLiveState);
        if (n <= 0) {
            super.markAsLive();
        }
    }

    void doSetLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.refCount += setLiveState.refCount;
        if (this.universe != null && this.universe != setLiveState.universe) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained3"));
        }
        if (setLiveState.locale == null) {
            System.out.println("NodeRetained.setLive() locale is null");
        }
        this.locale = setLiveState.locale;
        this.inSharedGroup = setLiveState.inSharedGroup;
        this.universe = setLiveState.universe;
        ++setLiveState.universe.numNodes;
        this.parentTransformLink = setLiveState.parentTransformLink;
        this.parentSwitchLink = setLiveState.parentSwitchLink;
        int n2 = 0;
        while (n2 < setLiveState.pickable.length) {
            if (!this.pickable) {
                setLiveState.pickable[n2] = false;
            }
            if (!this.collidable) {
                setLiveState.collidable[n2] = false;
            }
            ++n2;
        }
        if (n <= 0) {
            super.doSetLive(setLiveState);
        }
        if (this.inBackgroundGroup) {
            this.geometryBackground = setLiveState.geometryBackground;
        }
        if (this.nodeType != 24) {
            this.setLocalToVworld(setLiveState);
        }
    }

    void clearLive(SetLiveState setLiveState) {
        this.refCount -= setLiveState.refCount;
        if (this.refCount <= 0) {
            super.clearLive();
            if (this.nodeId != null) {
                this.universe.nodeIdFreeList.addElement(this.nodeId);
                this.nodeId = null;
            }
        }
        --this.universe.numNodes;
        if (this.inSharedGroup) {
            if (this.nodeType != 24) {
                this.removeLocalToVworld(setLiveState.keys);
            } else {
                this.removeLocalToVworldForTG(setLiveState.keys);
            }
        } else {
            this.branchGroupPaths.clear();
        }
        if (this.refCount <= 0) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            this.parentTransformGroups = null;
            this.transformTargets = null;
            this.transformBLTargets = null;
            if (!(this instanceof TransformGroupRetained) && !(this instanceof LinkRetained)) {
                this.parentTransformLink = null;
                this.parentSwitchLink = null;
            }
            this.geometryBackground = null;
            this.locale = null;
            this.geometryBackground = null;
        }
    }

    void findPickableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.pickable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            int n = 0;
            while (n < blArray.length) {
                block12: {
                    nodeRetained = this;
                    blArray[n] = true;
                    HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                    do {
                        if (nodeRetained instanceof SharedGroupRetained) {
                            String string = hashKey.getLastNodeId();
                            Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                            int n2 = vector.size();
                            NodeRetained nodeRetained2 = nodeRetained;
                            int n3 = 0;
                            while (n3 < n2) {
                                NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n3);
                                if (nodeRetained3.nodeId.equals(string)) {
                                    nodeRetained = nodeRetained3;
                                    break;
                                }
                                ++n3;
                            }
                            if (nodeRetained2 == nodeRetained) {
                                return;
                            }
                        } else {
                            nodeRetained = nodeRetained.parent;
                        }
                        if (nodeRetained == null) break block12;
                    } while (nodeRetained.pickable);
                    blArray[n] = false;
                }
                ++n;
            }
        }
    }

    void findCollidableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.collidable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            int n = 0;
            while (n < blArray.length) {
                block12: {
                    nodeRetained = this;
                    blArray[n] = true;
                    HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                    do {
                        if (nodeRetained instanceof SharedGroupRetained) {
                            String string = hashKey.getLastNodeId();
                            Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                            int n2 = vector.size();
                            NodeRetained nodeRetained2 = nodeRetained;
                            int n3 = 0;
                            while (n3 < n2) {
                                NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n3);
                                if (nodeRetained3.nodeId.equals(string)) {
                                    nodeRetained = nodeRetained3;
                                    break;
                                }
                                ++n3;
                            }
                            if (nodeRetained == nodeRetained2) {
                                return;
                            }
                        } else {
                            nodeRetained = nodeRetained.parent;
                        }
                        if (nodeRetained == null) break block12;
                    } while (nodeRetained.collidable);
                    blArray[n] = false;
                }
                ++n;
            }
        }
    }

    void findTransformLevels(int[] nArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            nArray[0] = -1;
            while (nodeRetained != null) {
                if (nodeRetained.nodeType == 24) {
                    TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
                    nArray[0] = transformGroupRetained.transformLevels[0];
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                nodeRetained = this;
                nArray[n] = -1;
                HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                while (nodeRetained != null) {
                    int n2;
                    if (nodeRetained instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                        int n3 = vector.size();
                        NodeRetained nodeRetained2 = nodeRetained;
                        n2 = 0;
                        while (n2 < n3) {
                            NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n2);
                            if (nodeRetained3.nodeId.equals(string)) {
                                nodeRetained = nodeRetained3;
                                break;
                            }
                            ++n2;
                        }
                        if (nodeRetained2 == nodeRetained) {
                            return;
                        }
                    } else if (nodeRetained.nodeType == 24) {
                        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
                        if (transformGroupRetained.inSharedGroup) {
                            n2 = hashKey.equals(transformGroupRetained.localToVworldKeys, 0, transformGroupRetained.localToVworldKeys.length);
                            nArray[n] = transformGroupRetained.transformLevels[n2];
                            break;
                        }
                        nArray[n] = transformGroupRetained.transformLevels[0];
                        break;
                    }
                    nodeRetained = nodeRetained.parent;
                }
                ++n;
            }
        }
    }

    boolean isStatic() {
        return !this.source.getCapability(11) && !this.source.getCapability(1) && !this.source.getCapability(0) && !this.source.getCapability(3) && !this.source.getCapability(4) && !this.source.getCapability(5) && !this.source.getCapability(6) && !this.source.getCapability(7) && !this.source.getCapability(8) && !this.source.getCapability(9) && !this.source.getCapability(10);
    }

    void merge(CompileState compileState) {
        this.staticTransform = compileState.staticTransform;
        if (compileState.parentGroup != null) {
            compileState.parentGroup.compiledChildrenList.add(this);
        }
        this.parent = compileState.parentGroup;
        if (this.staticTransform != null) {
            this.mergeTransform(this.staticTransform);
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.localBounds != null) {
            this.localBounds.transform(transformGroupRetained.transform);
        }
    }
}

