/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.Morph;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArray;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class MorphRetained
extends LeafRetained
implements GeometryUpdater {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int UPDATE_MORPH = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int APPEARANCEOVERRIDE_CHANGED = 32;
    private static final double TOLERANCE = 1.0E-4;
    ArrayList mirrorShape3D = new ArrayList();
    static final int targetThreads = 192;
    AppearanceRetained appearance = null;
    GeometryArrayRetained[] geometryArrays;
    int numGeometryArrays = 0;
    int vCount = 0;
    double[] weights;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    Bounds bounds = null;
    BoundingBox vwcBounds = new BoundingBox();
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    GeometryArray morphedGeometryArray = null;
    float[] Mcoord = null;
    float[] Mcolor = null;
    float[] Mnormal = null;
    float[][] MtexCoord = null;
    boolean appearanceOverrideEnable = false;

    MorphRetained() {
        this.nodeType = 10;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void setGeometryArrays(GeometryArray[] geometryArrayArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.numGeometryArrays != 0 && this.numGeometryArrays != geometryArrayArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained0"));
        }
        if (geometryArrayArray.length != 0) {
            n = ((GeometryArrayRetained)geometryArrayArray[0].retained).vertexFormat;
            n4 = ((GeometryArrayRetained)geometryArrayArray[0].retained).texCoordSetCount;
            n3 = ((GeometryArrayRetained)geometryArrayArray[0].retained).geoType;
            n2 = geometryArrayArray[0] instanceof IndexedGeometryArray ? ((GeometryArrayRetained)geometryArrayArray[0].retained).vertexCount : ((GeometryArrayRetained)geometryArrayArray[0].retained).validVertexCount;
        }
        if (this.numGeometryArrays == 0) {
            this.geometryArrays = new GeometryArrayRetained[geometryArrayArray.length];
            this.numGeometryArrays = geometryArrayArray.length;
        }
        int n5 = 0;
        while (n5 < this.numGeometryArrays) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[n5].retained;
            if (geometryArrayRetained instanceof IndexedGeometryArrayRetained ? n != geometryArrayRetained.vertexFormat || n2 != geometryArrayRetained.vertexCount || n4 != geometryArrayRetained.texCoordSetCount : n != geometryArrayRetained.vertexFormat || n2 != geometryArrayRetained.validVertexCount || n4 != geometryArrayRetained.texCoordSetCount) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (n3 != geometryArrayRetained.geoType) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained2"));
            }
            if (((Morph)this.source).isLive()) {
                if (geometryArrayRetained.getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("MorphRetained3"));
                }
                if (this.geometryArrays[n5] != null) {
                    this.geometryArrays[n5].clearLive(this.refCount);
                    this.geometryArrays[n5].removeMorphUser(this);
                }
                geometryArrayRetained.setLive(this.inBackgroundGroup, this.refCount);
                geometryArrayRetained.addMorphUser(this);
            }
            this.geometryArrays[n5] = geometryArrayRetained;
            ++n5;
        }
        this.vCount = n2;
        if (this.weights == null) {
            this.weights = new double[this.numGeometryArrays];
            this.weights[0] = 1.0;
            this.Mcoord = new float[this.vCount * 3];
            if ((n & 0xC) == 4) {
                this.Mcolor = new float[this.vCount * 3];
            } else if ((n & 0xC) == 12) {
                this.Mcolor = new float[this.vCount * 4];
            }
            if ((n & 2) != 0) {
                this.Mnormal = new float[this.vCount * 3];
            }
            if ((n & 0x20) != 0) {
                this.MtexCoord = new float[n4][this.vCount * 2];
            } else if ((n & 0x40) != 0) {
                this.MtexCoord = new float[n4][this.vCount * 3];
            }
        }
        this.initMorphedGeometry();
        if (this.source.isLive()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.setMorphGeometry(this.morphedGeometryArray, this.mirrorShape3D);
            J3dMessage j3dMessage = null;
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x400;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    GeometryArray getGeometryArray(int n) {
        return (GeometryArray)this.geometryArrays[n].source;
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Morph)this.source).isLive()) {
            int n;
            if (appearance != null && ((AppearanceRetained)appearance.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("MorphRetained4"));
            }
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                n = this.mirrorShape3D.size() - 1;
                while (n >= 0) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(n));
                    --n;
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                n = this.mirrorShape3D.size();
                int n2 = 0;
                while (n2 < n) {
                    this.appearance.addAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(n2));
                    ++n2;
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            if (bl) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 16;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(2);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = appearance == null ? null : this.appearance.mirror.clone();
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Morph)this.source).isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 16;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(32);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = bl ? Boolean.TRUE : Boolean.FALSE;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.invert(transform3D);
        PickShape pickShape2 = pickShape.transform(transform3D2);
        VirtualUniverse.mc.addToTransformFreeList(transform3D2);
        if (((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry == null) {
            return ((GeometryRetained)this.morphedGeometryArray.retained).intersect(pickShape2);
        }
        return ((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry.intersect(pickShape2);
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.invert(transform3D);
        PickRay pickRay2 = (PickRay)((PickShape)pickRay).transform(transform3D2);
        VirtualUniverse.mc.addToTransformFreeList(transform3D2);
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry == null) {
            if (((GeometryRetained)this.morphedGeometryArray.retained).intersect(pickRay2, dArray, point3d)) {
                GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
                return true;
            }
        } else if (((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry.intersect(pickRay2, dArray, point3d)) {
            GeometryRetained.processDistance(pickRay, dArray, transform3D, point3d, vector3d);
            return true;
        }
        return false;
    }

    void setWeights(double[] dArray) {
        double d = 0.0;
        if (dArray.length != this.numGeometryArrays) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained7"));
        }
        int n = dArray.length - 1;
        while (n >= 0) {
            d += dArray[n];
            --n;
        }
        if (Math.abs(d - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained8"));
        }
        n = this.numGeometryArrays - 1;
        while (n >= 0) {
            this.weights[n] = dArray[n];
            --n;
        }
        if (this.source.isLive()) {
            ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
            J3dMessage j3dMessage = null;
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x400;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    double[] getWeights() {
        return (double[])this.weights.clone();
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    Bounds bounds = (Bounds)geometryArrayRetained.geoBounds.clone();
                    return bounds;
                }
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    bounds.combine(geometryArrayRetained.geoBounds);
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    void updateMorphedGeometryArray(GeometryArrayRetained geometryArrayRetained) {
        if (geometryArrayRetained instanceof IndexedGeometryArrayRetained ? geometryArrayRetained.vertexCount != this.vCount : geometryArrayRetained.validVertexCount != this.vCount) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
    }

    public void updateData(Geometry geometry) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        float[] fArray = new float[3];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        int n8 = this.geometryArrays[0].vertexFormat;
        int n9 = this.geometryArrays[0].geoType;
        n7 = this.geometryArrays[0].getTexCoordSetCount();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl3 = false;
        int n13 = 0;
        while (n13 < this.vCount) {
            int n14 = n10++;
            int n15 = n10++;
            this.Mcoord[n10++] = 0.0f;
            this.Mcoord[n15] = 0.0f;
            this.Mcoord[n14] = 0.0f;
            if ((n8 & 0xC) == 4) {
                int n16 = n12++;
                int n17 = n12++;
                this.Mcolor[n12++] = 0.0f;
                this.Mcolor[n17] = 0.0f;
                this.Mcolor[n16] = 0.0f;
            } else if ((n8 & 0xC) == 12) {
                int n18 = n12++;
                int n19 = n12++;
                int n20 = n12++;
                this.Mcolor[n12++] = 0.0f;
                this.Mcolor[n20] = 0.0f;
                this.Mcolor[n19] = 0.0f;
                this.Mcolor[n18] = 0.0f;
            }
            if ((n8 & 2) != 0) {
                int n21 = n11++;
                int n22 = n11++;
                this.Mnormal[n11++] = 0.0f;
                this.Mnormal[n22] = 0.0f;
                this.Mnormal[n21] = 0.0f;
            }
            ++n13;
        }
        if ((n8 & 0x60) != 0) {
            n6 = 0;
            while (n6 < n7) {
                n5 = 0;
                n13 = 0;
                while (n13 < this.vCount) {
                    int n23 = n5++;
                    this.MtexCoord[n6][n5++] = 0.0f;
                    this.MtexCoord[n6][n23] = 0.0f;
                    if ((n8 & 0x40) != 0) {
                        this.MtexCoord[n6][n5++] = 0.0f;
                    }
                    ++n13;
                }
                ++n6;
            }
        }
        if ((n8 & 0x80) == 0) {
            n4 = 0;
            while (n4 < this.numGeometryArrays) {
                double d = this.weights[n4];
                if (d != 0.0) {
                    n10 = 0;
                    n11 = 0;
                    n12 = 0;
                    n3 = 0;
                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialVertexIndex();
                    n2 = n3 + this.vCount;
                    n13 = n3;
                    while (n13 < n2) {
                        this.geometryArrays[n4].getCoordinate(n13, fArray);
                        int n24 = n10++;
                        this.Mcoord[n24] = (float)((double)this.Mcoord[n24] + (double)fArray[0] * d);
                        int n25 = n10++;
                        this.Mcoord[n25] = (float)((double)this.Mcoord[n25] + (double)fArray[1] * d);
                        int n26 = n10++;
                        this.Mcoord[n26] = (float)((double)this.Mcoord[n26] + (double)fArray[2] * d);
                        ++n13;
                    }
                    if ((n8 & 4) != 0) {
                        n13 = n3;
                        while (n13 < n2) {
                            this.geometryArrays[n4].getColor(n13, fArray2);
                            int n27 = n12++;
                            this.Mcolor[n27] = (float)((double)this.Mcolor[n27] + (double)fArray2[0] * d);
                            int n28 = n12++;
                            this.Mcolor[n28] = (float)((double)this.Mcolor[n28] + (double)fArray2[1] * d);
                            int n29 = n12++;
                            this.Mcolor[n29] = (float)((double)this.Mcolor[n29] + (double)fArray2[2] * d);
                            if ((n8 & 8) != 0) {
                                int n30 = n12++;
                                this.Mcolor[n30] = (float)((double)this.Mcolor[n30] + (double)fArray2[3] * d);
                            }
                            ++n13;
                        }
                    }
                    if ((n8 & 2) != 0) {
                        n13 = n3;
                        while (n13 < n2) {
                            this.geometryArrays[n4].getNormal(n13, fArray3);
                            int n31 = n11++;
                            this.Mnormal[n31] = (float)((double)this.Mnormal[n31] + (double)fArray3[0] * d);
                            int n32 = n11++;
                            this.Mnormal[n32] = (float)((double)this.Mnormal[n32] + (double)fArray3[1] * d);
                            int n33 = n11++;
                            this.Mnormal[n33] = (float)((double)this.Mnormal[n33] + (double)fArray3[2] * d);
                            ++n13;
                        }
                    }
                    if ((n8 & 0x60) != 0) {
                        n6 = 0;
                        while (n6 < n7) {
                            n = 0;
                            n13 = n3;
                            while (n13 < n2) {
                                this.geometryArrays[n4].getTextureCoordinate(n6, n13, fArray4);
                                float[] fArray5 = this.MtexCoord[n6];
                                int n34 = n++;
                                fArray5[n34] = (float)((double)fArray5[n34] + (double)fArray4[0] * d);
                                float[] fArray6 = this.MtexCoord[n6];
                                int n35 = n++;
                                fArray6[n35] = (float)((double)fArray6[n35] + (double)fArray4[1] * d);
                                if ((n8 & 0x40) != 0) {
                                    float[] fArray7 = this.MtexCoord[n6];
                                    int n36 = n++;
                                    fArray7[n36] = (float)((double)fArray7[n36] + (double)fArray4[2] * d);
                                }
                                ++n13;
                            }
                            ++n6;
                        }
                    }
                }
                ++n4;
            }
        } else {
            int n37;
            n = 0;
            int n38 = 0;
            if ((n8 & 0x60) != 0) {
                n = 2;
                if ((n8 & 0x40) != 0) {
                    n = 3;
                }
            }
            if ((n8 & 4) != 0) {
                n38 = 3;
                if ((n8 & 8) != 0) {
                    n38 = 4;
                }
            }
            if ((n8 & 0x100) != 0) {
                int n39 = this.geometryArrays[0].stride();
                int n40 = this.geometryArrays[0].colorOffset();
                int n41 = this.geometryArrays[0].normalOffset();
                int n42 = this.geometryArrays[0].coordinateOffset();
                int n43 = 0;
                n4 = 0;
                while (n4 < this.numGeometryArrays) {
                    double d = this.weights[n4];
                    if (d != 0.0) {
                        n10 = 0;
                        n11 = 0;
                        n12 = 0;
                        bl3 = false;
                        float[] fArray8 = this.geometryArrays[n4].getInterleavedVertices();
                        if ((n8 & 0x60) != 0) {
                            n6 = 0;
                            while (n6 < n7) {
                                n37 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                n43 = n37 * n39 + n6 * n;
                                int n44 = 0;
                                n13 = 0;
                                while (n13 < this.vCount) {
                                    float[] fArray9 = this.MtexCoord[n6];
                                    int n45 = n44++;
                                    fArray9[n45] = (float)((double)fArray9[n45] + (double)fArray8[n43] * d);
                                    float[] fArray10 = this.MtexCoord[n6];
                                    int n46 = n44++;
                                    fArray10[n46] = (float)((double)fArray10[n46] + (double)fArray8[n43 + 1] * d);
                                    if ((n8 & 0x40) != 0) {
                                        float[] fArray11 = this.MtexCoord[n6];
                                        int n47 = n44++;
                                        fArray11[n47] = (float)((double)fArray11[n47] + (double)fArray8[n43 + 2] * d);
                                    }
                                    ++n13;
                                    n43 += n39;
                                }
                                ++n6;
                            }
                        }
                        if ((n8 & 4) != 0) {
                            n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                            n43 = n3 * n39 + n40;
                            n13 = 0;
                            while (n13 < this.vCount) {
                                int n48 = n12++;
                                this.Mcolor[n48] = (float)((double)this.Mcolor[n48] + (double)fArray8[n43] * d);
                                int n49 = n12++;
                                this.Mcolor[n49] = (float)((double)this.Mcolor[n49] + (double)fArray8[n43 + 1] * d);
                                int n50 = n12++;
                                this.Mcolor[n50] = (float)((double)this.Mcolor[n50] + (double)fArray8[n43 + 2] * d);
                                if ((n8 & 8) != 0) {
                                    int n51 = n12++;
                                    this.Mcolor[n51] = (float)((double)this.Mcolor[n51] + (double)fArray8[n43 + 3] * d);
                                }
                                ++n13;
                                n43 += n39;
                            }
                        }
                        if ((n8 & 2) != 0) {
                            n2 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialNormalIndex();
                            n43 = n2 * n39 + n41;
                            n13 = 0;
                            while (n13 < this.vCount) {
                                int n52 = n11++;
                                this.Mnormal[n52] = (float)((double)this.Mnormal[n52] + (double)fArray8[n43] * d);
                                int n53 = n11++;
                                this.Mnormal[n53] = (float)((double)this.Mnormal[n53] + (double)fArray8[n43 + 1] * d);
                                int n54 = n11++;
                                this.Mnormal[n54] = (float)((double)this.Mnormal[n54] + (double)fArray8[n43 + 2] * d);
                                ++n13;
                                n43 += n39;
                            }
                        }
                        n5 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialCoordIndex();
                        n43 = n5 * n39 + n42;
                        n13 = 0;
                        while (n13 < this.vCount) {
                            int n55 = n10++;
                            this.Mcoord[n55] = (float)((double)this.Mcoord[n55] + (double)fArray8[n43] * d);
                            int n56 = n10++;
                            this.Mcoord[n56] = (float)((double)this.Mcoord[n56] + (double)fArray8[n43 + 1] * d);
                            int n57 = n10++;
                            this.Mcoord[n57] = (float)((double)this.Mcoord[n57] + (double)fArray8[n43 + 2] * d);
                            ++n13;
                            n43 += n39;
                        }
                    }
                    ++n4;
                }
            } else {
                float f = 0.003921569f;
                n4 = 0;
                while (n4 < this.numGeometryArrays) {
                    double d = this.weights[n4];
                    if (d != 0.0) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        if ((n8 & 0x60) != 0) {
                            switch (this.geometryArrays[n4].vertexType & 0x7000) {
                                case 4096: {
                                    n6 = 0;
                                    while (n6 < n7) {
                                        float[] fArray12 = this.geometryArrays[n4].getTexCoordRefFloat(n6);
                                        n37 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        n37 *= n;
                                        int n58 = 0;
                                        n13 = 0;
                                        while (n13 < this.vCount) {
                                            float[] fArray13 = this.MtexCoord[n6];
                                            int n59 = n58++;
                                            fArray13[n59] = (float)((double)fArray13[n59] + (double)fArray12[n37++] * d);
                                            float[] fArray14 = this.MtexCoord[n6];
                                            int n60 = n58++;
                                            fArray14[n60] = (float)((double)fArray14[n60] + (double)fArray12[n37++] * d);
                                            if ((n8 & 0x40) != 0) {
                                                float[] fArray15 = this.MtexCoord[n6];
                                                int n61 = n58++;
                                                fArray15[n61] = (float)((double)fArray15[n61] + (double)fArray12[n37++] * d);
                                            }
                                            ++n13;
                                        }
                                        ++n6;
                                    }
                                    break;
                                }
                                case 8192: {
                                    n6 = 0;
                                    while (n6 < n7) {
                                        int n62 = 0;
                                        float[] fArray16 = this.geometryArrays[n4].getTexCoordRefFloat(n6);
                                        n37 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        objectArray2 = this.geometryArrays[n4].getTexCoordRef2f(n6);
                                        n13 = 0;
                                        while (n13 < this.vCount) {
                                            float[] fArray17 = this.MtexCoord[n6];
                                            int n63 = n62++;
                                            fArray17[n63] = (float)((double)fArray17[n63] + (double)objectArray2[n37].x * d);
                                            float[] fArray18 = this.MtexCoord[n6];
                                            int n64 = n62++;
                                            fArray18[n64] = (float)((double)fArray18[n64] + (double)objectArray2[n37].y * d);
                                            ++n13;
                                            ++n37;
                                        }
                                        ++n6;
                                    }
                                    break;
                                }
                                case 16384: {
                                    n6 = 0;
                                    while (n6 < n7) {
                                        int n65 = 0;
                                        TexCoord3f[] texCoord3fArray = this.geometryArrays[n4].getTexCoordRef3f(n6);
                                        n37 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        n13 = 0;
                                        while (n13 < this.vCount) {
                                            float[] fArray19 = this.MtexCoord[n6];
                                            int n66 = n65++;
                                            fArray19[n66] = (float)((double)fArray19[n66] + (double)texCoord3fArray[n37].x * d);
                                            float[] fArray20 = this.MtexCoord[n6];
                                            int n67 = n65++;
                                            fArray20[n67] = (float)((double)fArray20[n67] + (double)texCoord3fArray[n37].y * d);
                                            float[] fArray21 = this.MtexCoord[n6];
                                            int n68 = n65++;
                                            fArray21[n68] = (float)((double)fArray21[n68] + (double)texCoord3fArray[n37].z * d);
                                            ++n13;
                                            ++n37;
                                        }
                                        ++n6;
                                    }
                                    break;
                                }
                            }
                        }
                        if ((n8 & 4) != 0) {
                            double d2 = (double)f * d;
                            n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                            switch (this.geometryArrays[n4].vertexType & 0x3F0) {
                                case 16: {
                                    objectArray2 = this.geometryArrays[n4].getColorRefFloat();
                                    n12 = 0;
                                    n3 *= n38;
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n69 = n12++;
                                        this.Mcolor[n69] = (float)((double)this.Mcolor[n69] + (double)objectArray2[n3++] * d);
                                        int n70 = n12++;
                                        this.Mcolor[n70] = (float)((double)this.Mcolor[n70] + (double)objectArray2[n3++] * d);
                                        int n71 = n12++;
                                        this.Mcolor[n71] = (float)((double)this.Mcolor[n71] + (double)objectArray2[n3++] * d);
                                        if ((n8 & 8) != 0) {
                                            int n72 = n12++;
                                            this.Mcolor[n72] = (float)((double)this.Mcolor[n72] + (double)objectArray2[n3++] * d);
                                        }
                                        ++n13;
                                    }
                                    break;
                                }
                                case 32: {
                                    objectArray = this.geometryArrays[n4].getColorRefByte();
                                    n12 = 0;
                                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                                    n3 *= n38;
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n73 = n12++;
                                        this.Mcolor[n73] = (float)((double)this.Mcolor[n73] + (double)(objectArray[n3++] & 0xFF) * d2);
                                        int n74 = n12++;
                                        this.Mcolor[n74] = (float)((double)this.Mcolor[n74] + (double)(objectArray[n3++] & 0xFF) * d2);
                                        int n75 = n12++;
                                        this.Mcolor[n75] = (float)((double)this.Mcolor[n75] + (double)(objectArray[n3++] & 0xFF) * d2);
                                        if ((n8 & 8) != 0) {
                                            int n76 = n12++;
                                            this.Mcolor[n76] = (float)((double)this.Mcolor[n76] + (double)(objectArray[n3++] & 0xFF) * d2);
                                        }
                                        ++n13;
                                    }
                                    break;
                                }
                                case 64: {
                                    Color3f[] color3fArray = this.geometryArrays[n4].getColorRef3f();
                                    n12 = 0;
                                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n77 = n12++;
                                        this.Mcolor[n77] = (float)((double)this.Mcolor[n77] + (double)color3fArray[n3].x * d);
                                        int n78 = n12++;
                                        this.Mcolor[n78] = (float)((double)this.Mcolor[n78] + (double)color3fArray[n3].y * d);
                                        int n79 = n12++;
                                        this.Mcolor[n79] = (float)((double)this.Mcolor[n79] + (double)color3fArray[n3].z * d);
                                        ++n13;
                                        ++n3;
                                    }
                                    break;
                                }
                                case 128: {
                                    Color4f[] color4fArray = this.geometryArrays[n4].getColorRef4f();
                                    n12 = 0;
                                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n80 = n12++;
                                        this.Mcolor[n80] = (float)((double)this.Mcolor[n80] + (double)color4fArray[n3].x * d);
                                        int n81 = n12++;
                                        this.Mcolor[n81] = (float)((double)this.Mcolor[n81] + (double)color4fArray[n3].y * d);
                                        int n82 = n12++;
                                        this.Mcolor[n82] = (float)((double)this.Mcolor[n82] + (double)color4fArray[n3].z * d);
                                        int n83 = n12++;
                                        this.Mcolor[n83] = (float)((double)this.Mcolor[n83] + (double)color4fArray[n3].w * d);
                                        ++n13;
                                        ++n3;
                                    }
                                    break;
                                }
                                case 256: {
                                    Color3b[] color3bArray = this.geometryArrays[n4].getColorRef3b();
                                    n12 = 0;
                                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n84 = n12++;
                                        this.Mcolor[n84] = (float)((double)this.Mcolor[n84] + (double)(color3bArray[n3].x & 0xFF) * d2);
                                        int n85 = n12++;
                                        this.Mcolor[n85] = (float)((double)this.Mcolor[n85] + (double)(color3bArray[n3].y & 0xFF) * d2);
                                        int n86 = n12++;
                                        this.Mcolor[n86] = (float)((double)this.Mcolor[n86] + (double)(color3bArray[n3].z & 0xFF) * d2);
                                        ++n13;
                                        ++n3;
                                    }
                                    break;
                                }
                                case 512: {
                                    Color4b[] color4bArray = this.geometryArrays[n4].getColorRef4b();
                                    n12 = 0;
                                    n3 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialColorIndex();
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n87 = n12++;
                                        this.Mcolor[n87] = (float)((double)this.Mcolor[n87] + (double)(color4bArray[n3].x & 0xFF) * d2);
                                        int n88 = n12++;
                                        this.Mcolor[n88] = (float)((double)this.Mcolor[n88] + (double)(color4bArray[n3].y & 0xFF) * d2);
                                        int n89 = n12++;
                                        this.Mcolor[n89] = (float)((double)this.Mcolor[n89] + (double)(color4bArray[n3].z & 0xFF) * d2);
                                        int n90 = n12++;
                                        this.Mcolor[n90] = (float)((double)this.Mcolor[n90] + (double)(color4bArray[n3].w & 0xFF) * d2);
                                        ++n13;
                                        ++n3;
                                    }
                                    break;
                                }
                            }
                        }
                        if ((n8 & 2) != 0) {
                            n11 = 0;
                            n2 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialNormalIndex();
                            switch (this.geometryArrays[n4].vertexType & 0xC00) {
                                case 1024: {
                                    float[] fArray22 = this.geometryArrays[n4].getNormalRefFloat();
                                    n2 *= 3;
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n91 = n11++;
                                        this.Mnormal[n91] = (float)((double)this.Mnormal[n91] + (double)fArray22[n2++] * d);
                                        int n92 = n11++;
                                        this.Mnormal[n92] = (float)((double)this.Mnormal[n92] + (double)fArray22[n2++] * d);
                                        int n93 = n11++;
                                        this.Mnormal[n93] = (float)((double)this.Mnormal[n93] + (double)fArray22[n2++] * d);
                                        ++n13;
                                    }
                                    break;
                                }
                                case 2048: {
                                    Vector3f[] vector3fArray = this.geometryArrays[n4].getNormalRef3f();
                                    n13 = 0;
                                    while (n13 < this.vCount) {
                                        int n94 = n11++;
                                        this.Mnormal[n94] = (float)((double)this.Mnormal[n94] + (double)vector3fArray[n2].x * d);
                                        int n95 = n11++;
                                        this.Mnormal[n95] = (float)((double)this.Mnormal[n95] + (double)vector3fArray[n2].y * d);
                                        int n96 = n11++;
                                        this.Mnormal[n96] = (float)((double)this.Mnormal[n96] + (double)vector3fArray[n2].z * d);
                                        ++n13;
                                        ++n2;
                                    }
                                    break;
                                }
                            }
                        }
                        n10 = 0;
                        n5 = this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained ? 0 : this.geometryArrays[n4].getInitialCoordIndex();
                        switch (this.geometryArrays[n4].vertexType & 0xF) {
                            case 1: {
                                float[] fArray23 = this.geometryArrays[n4].getCoordRefFloat();
                                n5 *= 3;
                                n13 = 0;
                                while (n13 < this.vCount) {
                                    int n97 = n10++;
                                    this.Mcoord[n97] = (float)((double)this.Mcoord[n97] + (double)fArray23[n5++] * d);
                                    int n98 = n10++;
                                    this.Mcoord[n98] = (float)((double)this.Mcoord[n98] + (double)fArray23[n5++] * d);
                                    int n99 = n10++;
                                    this.Mcoord[n99] = (float)((double)this.Mcoord[n99] + (double)fArray23[n5++] * d);
                                    ++n13;
                                }
                                break;
                            }
                            case 2: {
                                double[] dArray = this.geometryArrays[n4].getCoordRefDouble();
                                n5 *= 3;
                                n13 = 0;
                                while (n13 < this.vCount) {
                                    int n100 = n10++;
                                    this.Mcoord[n100] = (float)((double)this.Mcoord[n100] + (double)((float)dArray[n5++]) * d);
                                    int n101 = n10++;
                                    this.Mcoord[n101] = (float)((double)this.Mcoord[n101] + (double)((float)dArray[n5++]) * d);
                                    int n102 = n10++;
                                    this.Mcoord[n102] = (float)((double)this.Mcoord[n102] + (double)((float)dArray[n5++]) * d);
                                    ++n13;
                                }
                                break;
                            }
                            case 4: {
                                objectArray2 = this.geometryArrays[n4].getCoordRef3f();
                                n13 = 0;
                                while (n13 < this.vCount) {
                                    int n103 = n10++;
                                    this.Mcoord[n103] = (float)((double)this.Mcoord[n103] + (double)objectArray2[n5].x * d);
                                    int n104 = n10++;
                                    this.Mcoord[n104] = (float)((double)this.Mcoord[n104] + (double)objectArray2[n5].y * d);
                                    int n105 = n10++;
                                    this.Mcoord[n105] = (float)((double)this.Mcoord[n105] + (double)objectArray2[n5].z * d);
                                    ++n13;
                                    ++n5;
                                }
                                break;
                            }
                            case 8: {
                                objectArray = this.geometryArrays[n4].getCoordRef3d();
                                n13 = 0;
                                while (n13 < this.vCount) {
                                    int n106 = n10++;
                                    this.Mcoord[n106] = (float)((double)this.Mcoord[n106] + (double)((float)objectArray[n5].x) * d);
                                    int n107 = n10++;
                                    this.Mcoord[n107] = (float)((double)this.Mcoord[n107] + (double)((float)objectArray[n5].y) * d);
                                    int n108 = n10++;
                                    this.Mcoord[n108] = (float)((double)this.Mcoord[n108] + (double)((float)objectArray[n5].z) * d);
                                    ++n13;
                                    ++n5;
                                }
                                break;
                            }
                        }
                    }
                    ++n4;
                }
            }
        }
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometry.retained;
        geometryArrayRetained.setCoordRefFloat(this.Mcoord);
        if ((n8 & 4) != 0) {
            geometryArrayRetained.setColorRefFloat(this.Mcolor);
        }
        if ((n8 & 2) != 0) {
            geometryArrayRetained.setNormalRefFloat(this.Mnormal);
        }
        if ((n8 & 0x60) != 0) {
            n6 = 0;
            while (n6 < n7) {
                geometryArrayRetained.setTexCoordRefFloat(n6, this.MtexCoord[n6]);
                ++n6;
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n;
        int n2 = (Integer)objectArray[1];
        ArrayList arrayList = (ArrayList)objectArray[2];
        if (n2 == 2) {
            n = arrayList.size() - 1;
            while (n >= 0) {
                ((Shape3DRetained)arrayList.get((int)n)).appearance = (AppearanceRetained)objectArray[3];
                --n;
            }
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearanceOverrideEnable = (Boolean)objectArray[3];
                ++n;
            }
        }
    }

    void setLive(SetLiveState setLiveState) {
        ContainsNodes containsNodes;
        Shape3DRetained shape3DRetained;
        Object object;
        GeometryArrayRetained geometryArrayRetained = null;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        int n = 0;
        while (n < this.numGeometryArrays) {
            if (this.geometryArrays[n].getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("MorphRetained9"));
            }
            object = this.geometryArrays[n].liveStateLock;
            synchronized (object) {
                this.geometryArrays[n].setLive(this.inBackgroundGroup, setLiveState.refCount);
                this.geometryArrays[n].addMorphUser(this);
            }
            ++n;
        }
        if (this.morphedGeometryArray == null) {
            this.initMorphedGeometry();
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).setLive(this.inBackgroundGroup, setLiveState.refCount);
        geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        if (geometryArrayRetained != null) {
            geometryArrayRetained.computeBoundingBox();
            if (this.boundsAutoCompute) {
                this.localBounds.setWithLock(geometryArrayRetained.geoBounds);
            }
        }
        if (this.inSharedGroup) {
            n = 0;
            while (n < setLiveState.keys.length) {
                shape3DRetained = new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n];
                shape3DRetained.localToVworld = new Transform3D[1][];
                shape3DRetained.localToVworldIndex = new int[1][];
                int n2 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) {
                    System.out.println("MorphRetained : Can't find hashKey");
                }
                shape3DRetained.localToVworld[0] = this.localToVworld[n2];
                shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[n2];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n2);
                shape3DRetained.isPickable = setLiveState.pickable[n];
                shape3DRetained.isCollidable = setLiveState.collidable[n];
                shape3DRetained.initMirrorShape3D(setLiveState, this, n);
                this.mirrorShape3D.add(shape3DRetained);
                arrayList.add(shape3DRetained);
                setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                if (setLiveState.transformTargets != null) {
                    setLiveState.transformTargets[n].addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                    setLiveState.transformTargetThreads |= 0x20C0;
                }
                if (setLiveState.switchLevels[n] >= 0) {
                    shape3DRetained.clearCompositeSwitchMask();
                    shape3DRetained.isNewSwitchLeaf = true;
                    containsNodes = setLiveState.containsNodesList.getContainsNodes(n2);
                    containsNodes.geoNodes.add(shape3DRetained);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n];
                }
                ++n;
            }
        } else {
            shape3DRetained = new Shape3DRetained();
            shape3DRetained.localToVworld = new Transform3D[1][];
            shape3DRetained.localToVworldIndex = new int[1][];
            shape3DRetained.localToVworld[0] = this.localToVworld[0];
            shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            shape3DRetained.initMirrorShape3D(setLiveState, this, 0);
            this.mirrorShape3D.add(shape3DRetained);
            arrayList.add(shape3DRetained);
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets[0].addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                setLiveState.transformTargetThreads |= 0x20C0;
            }
            if (setLiveState.switchLevels[0] >= 0) {
                shape3DRetained.clearCompositeSwitchMask();
                shape3DRetained.isNewSwitchLeaf = true;
                containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.geoNodes.add(shape3DRetained);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
        }
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                if (this.appearance.getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("Shape3DRetained2"));
                }
                this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
                this.appearance.initMirrorObject();
                if (this.appearance.renderingAttributes != null) {
                    this.visible = this.appearance.renderingAttributes.visible;
                }
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    Shape3DRetained shape3DRetained2 = (Shape3DRetained)arrayList.get(n3);
                    shape3DRetained2.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser(shape3DRetained2);
                    ++n3;
                }
            }
        } else {
            int n4 = 0;
            while (n4 < arrayList.size()) {
                Shape3DRetained shape3DRetained3 = (Shape3DRetained)arrayList.get(n4);
                shape3DRetained3.appearance = null;
                ++n4;
            }
        }
        setLiveState.notifyThreads |= 0x4C0;
        if (this.refCount == 1 && this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 1024;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        super.markAsLive();
    }

    void clearLive(SetLiveState setLiveState) {
        ContainsNodes containsNodes;
        Shape3DRetained shape3DRetained;
        Object object;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.clearLive(setLiveState);
        int n = 0;
        while (n < this.numGeometryArrays) {
            object = this.geometryArrays[n].liveStateLock;
            synchronized (object) {
                this.geometryArrays[n].clearLive(setLiveState.refCount);
                this.geometryArrays[n].removeMorphUser(this);
            }
            ++n;
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).clearLive(setLiveState.refCount);
        if (this.inSharedGroup) {
            Object[] objectArray = this.mirrorShape3D.toArray();
            n = 0;
            while (n < setLiveState.keys.length) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    shape3DRetained = (Shape3DRetained)objectArray[n2];
                    if (shape3DRetained.key.equals((Object)setLiveState.keys[n])) {
                        this.mirrorShape3D.remove(n2);
                        if (setLiveState.containsNodesList != null && (containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n])) != null) {
                            ((AbstractCollection)containsNodes.geoNodes).remove(shape3DRetained);
                        }
                        if (this.appearance != null) {
                            arrayList.add(shape3DRetained);
                        }
                        setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (setLiveState.containsNodesList != null && (containsNodes = setLiveState.containsNodesList.getContainsNodes(0)) != null) {
                ((AbstractCollection)containsNodes.geoNodes).remove(shape3DRetained);
            }
            if (this.appearance != null) {
                arrayList.add(shape3DRetained);
            }
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
        }
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(setLiveState.refCount);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)arrayList.get(n3));
                    ++n3;
                }
            }
        }
        setLiveState.notifyThreads |= 0x10C0;
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals((Object)shape3DRetained.key)) {
                        shape3DRetained.isPickable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals((Object)shape3DRetained.key)) {
                        shape3DRetained.isCollidable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(n);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            if (bl) {
                this.localBounds = new BoundingBox();
            }
            this.localBounds = this.getBounds();
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
                j3dMessage.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void updateBounds() {
        this.localBounds = this.getEffectiveBounds();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 37;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void initMorphedGeometry() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        int n5 = (this.geometryArrays[0].getVertexFormat() | 0x80) & 0xFFFFFEFF;
        n3 = this.geometryArrays[0].getTexCoordSetCount();
        n4 = this.geometryArrays[0].getTexCoordSetMapLength();
        if (n4 > 0) {
            nArray = new int[n4];
            this.geometryArrays[0].getTexCoordSetMap(nArray);
        }
        int n6 = this.geometryArrays[0].geoType;
        switch (n6) {
            case 1: {
                this.morphedGeometryArray = new QuadArray(this.vCount, n5, n3, nArray);
                break;
            }
            case 2: {
                this.morphedGeometryArray = new TriangleArray(this.vCount, n5, n3, nArray);
                break;
            }
            case 3: {
                this.morphedGeometryArray = new PointArray(this.vCount, n5, n3, nArray);
                break;
            }
            case 4: {
                this.morphedGeometryArray = new LineArray(this.vCount, n5, n3, nArray);
                break;
            }
            case 5: {
                n2 = ((TriangleStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleStripArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleStripArray(this.vCount, n5, n3, nArray, nArray2);
                break;
            }
            case 6: {
                n2 = ((TriangleFanArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleFanArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleFanArray(this.vCount, n5, n3, nArray, nArray2);
                break;
            }
            case 7: {
                n2 = ((LineStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((LineStripArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new LineStripArray(this.vCount, n5, n3, nArray, nArray2);
                break;
            }
            case 8: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedQuadArray(this.vCount, n5, n3, nArray, n);
                break;
            }
            case 9: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedTriangleArray(this.vCount, n5, n3, nArray, n);
                break;
            }
            case 10: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedPointArray(this.vCount, n5, n3, nArray, n);
                break;
            }
            case 11: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedLineArray(this.vCount, n5, n3, nArray, n);
                break;
            }
            case 12: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedTriangleStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleStripArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleStripArray(this.vCount, n5, n3, nArray, n, nArray2);
                break;
            }
            case 13: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedTriangleFanArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleFanArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleFanArray(this.vCount, n5, n3, nArray, n, nArray2);
                break;
            }
            case 14: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedLineStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedLineStripArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedLineStripArray(this.vCount, n5, n3, nArray, n, nArray2);
            }
        }
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this.geometryArrays[0];
            IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)this.morphedGeometryArray;
            if ((n5 & 1) != 0) {
                indexedGeometryArray.setCoordinateIndices(0, indexedGeometryArrayRetained.indexCoord);
            }
            if ((n5 & 2) != 0) {
                indexedGeometryArray.setNormalIndices(0, indexedGeometryArrayRetained.indexNormal);
            }
            if ((n5 & 4) != 0) {
                indexedGeometryArray.setColorIndices(0, indexedGeometryArrayRetained.indexColor);
            }
            if ((n5 & 0x60) != 0) {
                int n7 = 0;
                while (n7 < n3) {
                    indexedGeometryArray.setTextureCoordinateIndices(n7, 0, (int[])indexedGeometryArrayRetained.indexTexCoord[n7]);
                    ++n7;
                }
            }
        }
        this.morphedGeometryArray.setCapability(1);
        this.morphedGeometryArray.setCapability(3);
        this.morphedGeometryArray.setCapability(5);
        this.morphedGeometryArray.setCapability(7);
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
    }

    void getMirrorShape3D(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList.add(shape3DRetained);
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        compileState.keepTG = true;
    }

    ArrayList getGeomAtomsList() {
        ArrayList<GeometryAtom> arrayList = new ArrayList<GeometryAtom>();
        int n = 0;
        while (n < this.mirrorShape3D.size()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
            arrayList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
            ++n;
        }
        return arrayList;
    }
}

