/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector4d;

class ModelClipRetained
extends LeafRetained {
    static final int PLANE_CHANGED = 1;
    static final int PLANES_CHANGED = 2;
    static final int ENABLE_CHANGED = 4;
    static final int ENABLES_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int BOUNDINGLEAF_CHANGED = 32;
    static final int SCOPE_CHANGED = 64;
    static final int INIT_MIRROR = 128;
    static final int CLEAR_MIRROR = 256;
    static final int LAST_DEFINED_BIT = 256;
    Vector4d[] planes = new Vector4d[6];
    boolean[] enables = new boolean[6];
    Vector4d[] xformPlanes = new Vector4d[6];
    boolean enableFlag = false;
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    Vector scopes = new Vector();
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    boolean inImmCtx = false;
    ModelClipRetained mirrorModelClip = null;
    ModelClipRetained sgModelClip = null;
    static final int targetThreads = 4224;
    ArrayList environmentSets = new ArrayList();

    ModelClipRetained() {
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        int n = 0;
        while (n < 6) {
            this.xformPlanes[n] = new Vector4d(this.planes[n]);
            ++n;
        }
        this.enables[5] = true;
        this.enables[4] = true;
        this.enables[3] = true;
        this.enables[2] = true;
        this.enables[1] = true;
        this.enables[0] = true;
    }

    void initPlanes(Vector4d[] vector4dArray) {
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getNormalTransform();
            int n = 0;
            while (n < 6) {
                this.planes[n].set((Tuple4d)vector4dArray[n]);
                transform3D.transform(this.planes[n], this.xformPlanes[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < 6) {
                this.planes[n].set((Tuple4d)vector4dArray[n]);
                this.xformPlanes[n].set((Tuple4d)this.planes[n]);
                ++n;
            }
        }
    }

    void setPlanes(Vector4d[] vector4dArray) {
        Vector4d[] vector4dArray2 = new Vector4d[6];
        this.initPlanes(vector4dArray);
        int n = 0;
        while (n < 6) {
            vector4dArray2[n] = new Vector4d(this.xformPlanes[n]);
            ++n;
        }
        this.sendMessage(2, vector4dArray2, null);
    }

    void initPlane(int n, Vector4d vector4d) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getNormalTransform();
            this.planes[n].set((Tuple4d)vector4d);
            transform3D.transform(this.planes[n], this.xformPlanes[n]);
        } else {
            this.planes[n].set((Tuple4d)vector4d);
            this.xformPlanes[n].set((Tuple4d)vector4d);
        }
    }

    void setPlane(int n, Vector4d vector4d) {
        this.initPlane(n, vector4d);
        this.sendMessage(1, new Integer(n), new Vector4d(this.xformPlanes[n]));
    }

    void getPlanes(Vector4d[] vector4dArray) {
        int n = 0;
        while (n < 6) {
            vector4dArray[n].set((Tuple4d)this.planes[n]);
            ++n;
        }
    }

    void getPlane(int n, Vector4d vector4d) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        vector4d.set((Tuple4d)this.planes[n]);
    }

    void initEnables(boolean[] blArray) {
        this.enables[0] = blArray[0];
        this.enables[1] = blArray[1];
        this.enables[2] = blArray[2];
        this.enables[3] = blArray[3];
        this.enables[4] = blArray[4];
        this.enables[5] = blArray[5];
    }

    void setEnables(boolean[] blArray) {
        Boolean[] booleanArray = new Boolean[6];
        this.initEnables(blArray);
        booleanArray[0] = blArray[0] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[1] = blArray[1] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[2] = blArray[2] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[3] = blArray[3] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[4] = blArray[4] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[5] = blArray[5] ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(8, booleanArray, null);
    }

    void initEnable(int n, boolean bl) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        this.enables[n] = bl;
    }

    void setEnable(int n, boolean bl) {
        this.initEnable(n, bl);
        this.sendMessage(4, new Integer(n), bl ? Boolean.TRUE : Boolean.FALSE);
    }

    void getEnables(boolean[] blArray) {
        blArray[0] = this.enables[0];
        blArray[1] = this.enables[1];
        blArray[2] = this.enables[2];
        blArray[3] = this.enables[3];
        blArray[4] = this.enables[4];
        blArray[5] = this.enables[5];
    }

    boolean getEnable(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        return this.enables[n];
    }

    void initInfluencingBounds(Bounds bounds) {
        if (bounds != null) {
            this.regionOfInfluence = (Bounds)bounds.clone();
            if (this.staticTransform != null) {
                this.regionOfInfluence.transform(this.staticTransform.transform);
            }
        } else {
            this.regionOfInfluence = null;
        }
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(16, bounds != null ? (Bounds)bounds.clone() : null, null);
    }

    Bounds getInfluencingBounds() {
        Bounds bounds = null;
        if (this.regionOfInfluence != null) {
            bounds = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorModelClip);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorModelClip);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(32, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group group, int n) {
        this.scopes.setElementAt((GroupRetained)group.retained, n);
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedModelClip(this.mirrorModelClip, arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.initScope(group, n);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    void initInsertScope(Node node, int n) {
        GroupRetained groupRetained = (GroupRetained)node.retained;
        groupRetained.setScope();
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
    }

    void insertScope(Node node, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        this.initInsertScope(node, n);
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    void initRemoveScope(int n) {
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        groupRetained.removeScope();
        this.scopes.removeElementAt(n);
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.initRemoveScope(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    Group getScope(int n) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n)).source;
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    void initAddScope(Group group) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.addElement((GroupRetained)group.retained);
        groupRetained.setScope();
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    int numScopes() {
        return this.scopes.size();
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    native void update(int var1, int var2, boolean var3, double var4, double var6, double var8, double var10);

    void update(Canvas3D canvas3D, int n) {
        canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vworldToEc.mat, this.getLastLocalToVworld());
        this.update(canvas3D.ctx, n, this.getLastLocalToVworld());
    }

    void update(int n, int n2, Transform3D transform3D) {
        if (!VirtualUniverse.mc.isD3D()) {
            int n3 = 0;
            while (n3 < 6) {
                this.update(n, n3, (n2 & 1 << n3) != 0, this.xformPlanes[n3].x, this.xformPlanes[n3].y, this.xformPlanes[n3].z, this.xformPlanes[n3].w);
                ++n3;
            }
            return;
        }
        Transform3D transform3D2 = new Transform3D(transform3D);
        transform3D2.invert();
        transform3D2.transpose();
        int n4 = 0;
        while (n4 < 6) {
            if ((n2 & 1 << n4) != 0) {
                Vector4d vector4d = new Vector4d(this.xformPlanes[n4].x, this.xformPlanes[n4].y, this.xformPlanes[n4].z, this.xformPlanes[n4].w);
                vector4d.normalize();
                transform3D2.transform(vector4d);
                this.update(n, n4, true, vector4d.x, vector4d.y, vector4d.z, vector4d.w);
            } else {
                this.update(n, n4, false, 0.0, 0.0, 0.0, 0.0);
            }
            ++n4;
        }
    }

    void initMirrorObject(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[2];
        Boolean bl = (Boolean)objectArray2[0];
        ArrayList arrayList = (ArrayList)objectArray2[1];
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)((Object[])objectArray[4])[0];
        Bounds bounds = (Bounds)((Object[])objectArray[4])[1];
        int n = 0;
        while (n < arrayList.size()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(n);
            shape3DRetained.addModelClip(this.mirrorModelClip);
            ++n;
        }
        this.mirrorModelClip.isScoped = bl;
        if (boundingLeafRetained != null) {
            this.mirrorModelClip.boundingLeaf = boundingLeafRetained.mirrorBoundingLeaf;
            this.mirrorModelClip.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorModelClip.boundingLeaf = null;
            this.mirrorModelClip.region = null;
        }
        if (bounds != null) {
            this.mirrorModelClip.regionOfInfluence = bounds;
            if (this.mirrorModelClip.region == null) {
                this.mirrorModelClip.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorModelClip.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorModelClip.regionOfInfluence = null;
        }
        boolean[] blArray = (boolean[])((Object[])objectArray[4])[2];
        int n2 = 0;
        while (n2 < blArray.length) {
            this.mirrorModelClip.enables[n2] = blArray[n2];
            ++n2;
        }
        this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
    }

    void updateMirrorObject(Object[] objectArray) {
        block3: {
            int n;
            block4: {
                block2: {
                    n = (Integer)objectArray[1];
                    if ((n & 2) == 0) break block2;
                    Vector4d[] vector4dArray = (Vector4d[])objectArray[2];
                    int n2 = 0;
                    while (n2 < 6) {
                        this.mirrorModelClip.xformPlanes[n2].set((Tuple4d)vector4dArray[n2]);
                        ++n2;
                    }
                    break block3;
                }
                if ((n & 1) == 0) break block4;
                int n3 = (Integer)objectArray[2];
                this.mirrorModelClip.xformPlanes[n3].set((Tuple4d)((Vector4d)objectArray[3]));
                break block3;
            }
            if ((n & 0x80) == 0) break block3;
            Vector4d[] vector4dArray = (Vector4d[])objectArray[3];
            int n4 = 0;
            while (n4 < 6) {
                this.mirrorModelClip.xformPlanes[n4].set((Tuple4d)vector4dArray[n4]);
                ++n4;
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        Object[] objectArray2;
        int n = (Integer)objectArray[1];
        if ((n & 0x20) != 0) {
            this.mirrorModelClip.boundingLeaf = (BoundingLeafRetained)objectArray[2];
            if (objectArray[2] != null) {
                this.mirrorModelClip.region = this.mirrorModelClip.boundingLeaf.transformedRegion;
            } else if (this.mirrorModelClip.regionOfInfluence != null) {
                this.mirrorModelClip.region = this.mirrorModelClip.regionOfInfluence.copy(this.mirrorModelClip.region);
                this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorModelClip.region = null;
            }
        }
        if ((n & 0x10) != 0) {
            this.mirrorModelClip.regionOfInfluence = (Bounds)objectArray[2];
            if (this.mirrorModelClip.boundingLeaf == null) {
                if (objectArray[2] != null) {
                    this.mirrorModelClip.region = this.mirrorModelClip.regionOfInfluence.copy(this.mirrorModelClip.region);
                    this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorModelClip.region = null;
                }
            }
        }
        if ((n & 0x40) != 0) {
            Shape3DRetained shape3DRetained;
            int n2;
            objectArray2 = (Object[])objectArray[2];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                this.mirrorModelClip.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList.size()) {
                    shape3DRetained = (Shape3DRetained)arrayList.get(n2);
                    shape3DRetained.addModelClip(this.mirrorModelClip);
                    ++n2;
                }
            }
            if (arrayList2 != null) {
                this.mirrorModelClip.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    shape3DRetained = (Shape3DRetained)arrayList2.get(n2);
                    shape3DRetained.removeModelClip(this.mirrorModelClip);
                    ++n2;
                }
            }
        }
        if ((n & 8) != 0) {
            objectArray2 = (Boolean[])objectArray[2];
            this.mirrorModelClip.enables[0] = (Boolean)objectArray2[0];
            this.mirrorModelClip.enables[1] = (Boolean)objectArray2[1];
            this.mirrorModelClip.enables[2] = (Boolean)objectArray2[2];
            this.mirrorModelClip.enables[3] = (Boolean)objectArray2[3];
            this.mirrorModelClip.enables[4] = (Boolean)objectArray2[4];
            this.mirrorModelClip.enables[5] = (Boolean)objectArray2[5];
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        } else if ((n & 4) != 0) {
            int n3 = (Integer)objectArray[2];
            this.mirrorModelClip.enables[n3] = (Boolean)objectArray[3];
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        }
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    void setLive(SetLiveState setLiveState) {
        Object object;
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("ModelClipRetained7"));
        }
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ModelClipRetained0"));
        }
        if (this.mirrorModelClip == null) {
            this.mirrorModelClip = (ModelClipRetained)this.clone();
            this.mirrorModelClip.boundingLeaf = null;
            this.mirrorModelClip.sgModelClip = this;
        }
        setLiveState.nodeList.add(this.mirrorModelClip);
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorModelClip);
        }
        if (setLiveState.switchLevels[0] >= 0) {
            this.mirrorModelClip.clearCompositeSwitchMask();
            this.mirrorModelClip.isNewSwitchLeaf = true;
            object = setLiveState.containsNodesList.getContainsNodes(0);
            ((ContainsNodes)object).envNodes.add(this.mirrorModelClip);
        }
        if (setLiveState.transformTargets != null) {
            setLiveState.transformTargets[0].add(this.mirrorModelClip);
            setLiveState.transformTargetThreads |= 0x1080;
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
        object = VirtualUniverse.mc.getMessage();
        ((J3dMessage)object).threads = 4096;
        ((J3dMessage)object).universe = this.universe;
        ((J3dMessage)object).type = 36;
        ((J3dMessage)object).args[0] = this;
        ((J3dMessage)object).args[1] = new Integer(128);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.scopes.size()) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
            this.tempKey.reset();
            groupRetained.addAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
            ++n;
        }
        Object[] objectArray = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, arrayList};
        ((J3dMessage)object).args[2] = objectArray;
        ((J3dMessage)object).args[3] = this.xformPlanes.clone();
        Object[] objectArray2 = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.enables.clone()};
        ((J3dMessage)object).args[4] = objectArray2;
        VirtualUniverse.mc.processMessage((J3dMessage)object);
    }

    void clearLive(SetLiveState setLiveState) {
        Object object;
        super.clearLive(setLiveState);
        setLiveState.notifyThreads |= 0x1080;
        if (setLiveState.containsNodesList != null && (object = setLiveState.containsNodesList.getContainsNodes(0)) != null) {
            ((AbstractCollection)((ContainsNodes)object).envNodes).remove(this.mirrorModelClip);
        }
        if (this.mirrorModelClip.boundingLeaf != null) {
            this.mirrorModelClip.boundingLeaf.removeUser(this.mirrorModelClip);
        }
        setLiveState.nodeList.add(this.mirrorModelClip);
        if (this.scopes.size() > 0) {
            object = VirtualUniverse.mc.getMessage();
            ((J3dMessage)object).threads = 4096;
            ((J3dMessage)object).universe = this.universe;
            ((J3dMessage)object).type = 36;
            ((J3dMessage)object).args[0] = this;
            ((J3dMessage)object).args[1] = new Integer(256);
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < this.scopes.size()) {
                GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
                this.tempKey.reset();
                groupRetained.removeAllNodesForScopedModelClip(this.mirrorModelClip, arrayList, this.tempKey);
                ++n;
            }
            ((J3dMessage)object).args[2] = arrayList;
            VirtualUniverse.mc.processMessage((J3dMessage)object);
        }
    }

    void clearMirrorObject(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[2];
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList.get(n);
            shape3DRetained.removeModelClip(this.mirrorModelClip);
            ++n;
        }
        this.mirrorModelClip.isScoped = false;
    }

    protected Object clone() {
        ModelClipRetained modelClipRetained = (ModelClipRetained)super.clone();
        modelClipRetained.planes = new Vector4d[6];
        int n = 0;
        while (n < 6) {
            modelClipRetained.planes[n] = new Vector4d(this.planes[n]);
            modelClipRetained.xformPlanes[n] = new Vector4d(this.xformPlanes[n]);
            ++n;
        }
        modelClipRetained.enables = new boolean[6];
        this.getEnables(modelClipRetained.enables);
        modelClipRetained.enableFlag = modelClipRetained.enables[0] | modelClipRetained.enables[1] | modelClipRetained.enables[2] | modelClipRetained.enables[3] | modelClipRetained.enables[4] | modelClipRetained.enables[5];
        modelClipRetained.inImmCtx = false;
        modelClipRetained.region = null;
        modelClipRetained.sgModelClip = null;
        modelClipRetained.mirrorModelClip = null;
        modelClipRetained.environmentSets = new ArrayList();
        if (this.regionOfInfluence != null) {
            modelClipRetained.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
        }
        return modelClipRetained;
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgModelClip.getCurrentLocalToVworld());
        }
    }

    void printPlane(int n, String string) {
        System.err.println(string + " : < " + this.planes[n].toString() + " > " + this.enables[n]);
    }

    void printPlanes(String string, Vector4d[] vector4dArray) {
        System.err.println(string);
        this.printPlane(0, "[0]");
        this.printPlane(1, "[1]");
        this.printPlane(2, "[2]");
        this.printPlane(3, "[3]");
        this.printPlane(4, "[4]");
        this.printPlane(5, "[5]");
    }

    void printEnables(String string, boolean[] blArray) {
        System.err.println(string);
        System.err.println("[0] : < " + blArray[0] + " >");
        System.err.println("[1] : < " + blArray[1] + " >");
        System.err.println("[2] : < " + blArray[2] + " >");
        System.err.println("[3] : < " + blArray[3] + " >");
        System.err.println("[4] : < " + blArray[4] + " >");
        System.err.println("[5] : < " + blArray[5] + " >");
    }

    final void sendMessage(int n, Object object, Object object2) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 36;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(transformGroupRetained.transform);
        }
        Transform3D transform3D = transformGroupRetained.getNormalTransform();
        int n = 0;
        while (n < 6) {
            transform3D.transform(this.planes[n], this.xformPlanes[n]);
            ++n;
        }
    }
}

