/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class MaterialRetained
extends NodeComponentRetained {
    Color3f ambientColor = new Color3f(0.2f, 0.2f, 0.2f);
    Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f diffuseColor = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f specularColor = new Color3f(1.0f, 1.0f, 1.0f);
    float shininess = 64.0f;
    boolean lightingEnable = true;
    static final int AMBIENT_COLOR_CHANGED = 1;
    static final int EMISSIVE_COLOR_CHANGED = 2;
    static final int DIFFUSE_COLOR_CHANGED = 4;
    static final int SPECULAR_COLOR_CHANGED = 8;
    static final int SHININESS_CHANGED = 16;
    static final int ENABLE_CHANGED = 32;
    int tag1;
    int tag2;
    int tag3;

    MaterialRetained() {
    }

    void createMaterial(Color3f color3f, Color3f color3f2, Color3f color3f3, Color3f color3f4, float f) {
        this.ambientColor.set((Tuple3f)color3f);
        this.emissiveColor.set((Tuple3f)color3f2);
        this.diffuseColor.set((Tuple3f)color3f3);
        this.specularColor.set((Tuple3f)color3f4);
        this.shininess = f;
    }

    final void initAmbientColor(Color3f color3f) {
        this.ambientColor.set((Tuple3f)color3f);
    }

    final void setAmbientColor(Color3f color3f) {
        this.initAmbientColor(color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    final void initAmbientColor(float f, float f2, float f3) {
        this.ambientColor.set(f, f2, f3);
    }

    final void setAmbientColor(float f, float f2, float f3) {
        this.initAmbientColor(f, f2, f3);
        this.sendMessage(1, new Color3f(f, f2, f3));
    }

    final void getAmbientColor(Color3f color3f) {
        color3f.set((Tuple3f)this.ambientColor);
    }

    final void initEmissiveColor(Color3f color3f) {
        this.emissiveColor.set((Tuple3f)color3f);
    }

    final void setEmissiveColor(Color3f color3f) {
        this.initEmissiveColor(color3f);
        this.sendMessage(2, new Color3f(color3f));
    }

    final void initEmissiveColor(float f, float f2, float f3) {
        this.emissiveColor.set(f, f2, f3);
    }

    final void setEmissiveColor(float f, float f2, float f3) {
        this.initEmissiveColor(f, f2, f3);
        this.sendMessage(2, new Color3f(f, f2, f3));
    }

    final void getEmissiveColor(Color3f color3f) {
        color3f.set((Tuple3f)this.emissiveColor);
    }

    final void initDiffuseColor(Color3f color3f) {
        this.diffuseColor.set((Tuple3f)color3f);
    }

    final void setDiffuseColor(Color3f color3f) {
        this.initDiffuseColor(color3f);
        this.sendMessage(4, new Color3f(color3f));
    }

    final void initDiffuseColor(float f, float f2, float f3) {
        this.diffuseColor.set(f, f2, f3);
    }

    final void setDiffuseColor(float f, float f2, float f3) {
        this.initDiffuseColor(f, f2, f3);
        this.sendMessage(4, new Color3f(f, f2, f3));
    }

    final void initDiffuseColor(float f, float f2, float f3, float f4) {
        this.diffuseColor.set(f, f2, f3);
    }

    final void setDiffuseColor(float f, float f2, float f3, float f4) {
        this.initDiffuseColor(f, f2, f3);
        this.sendMessage(4, new Color3f(f, f2, f3));
    }

    final void getDiffuseColor(Color3f color3f) {
        color3f.set((Tuple3f)this.diffuseColor);
    }

    final void initSpecularColor(Color3f color3f) {
        this.specularColor.set((Tuple3f)color3f);
    }

    final void setSpecularColor(Color3f color3f) {
        this.initSpecularColor(color3f);
        this.sendMessage(8, new Color3f(color3f));
    }

    final void initSpecularColor(float f, float f2, float f3) {
        this.specularColor.set(f, f2, f3);
    }

    final void setSpecularColor(float f, float f2, float f3) {
        this.initSpecularColor(f, f2, f3);
        this.sendMessage(8, new Color3f(f, f2, f3));
    }

    final void getSpecularColor(Color3f color3f) {
        color3f.set((Tuple3f)this.specularColor);
    }

    final void initShininess(float f) {
        this.shininess = f < 1.0f ? 1.0f : (f > 128.0f ? 128.0f : f);
    }

    final void setShininess(float f) {
        this.initShininess(f);
        this.sendMessage(16, new Float(this.shininess));
    }

    final float getShininess() {
        return this.shininess;
    }

    void initLightingEnable(boolean bl) {
        this.lightingEnable = bl;
    }

    void setLightingEnable(boolean bl) {
        this.initLightingEnable(bl);
        this.sendMessage(32, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    boolean getLightingEnable() {
        return this.lightingEnable;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                MaterialRetained materialRetained = new MaterialRetained();
                materialRetained.set(this);
                materialRetained.source = this.source;
                this.mirror = materialRetained;
            }
        } else {
            ((MaterialRetained)this.mirror).set(this);
        }
    }

    native void updateNative(int var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, boolean var19);

    void updateNative(int n, float f, float f2, float f3, float f4, boolean bl) {
        this.updateNative(n, f, f2, f3, f4, this.ambientColor.x, this.ambientColor.y, this.ambientColor.z, this.emissiveColor.x, this.emissiveColor.y, this.emissiveColor.z, this.diffuseColor.x, this.diffuseColor.y, this.diffuseColor.z, this.specularColor.x, this.specularColor.y, this.specularColor.z, this.shininess, bl);
    }

    synchronized void initMirrorObject() {
        MaterialRetained materialRetained = (MaterialRetained)this.mirror;
        materialRetained.set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        MaterialRetained materialRetained = (MaterialRetained)this.mirror;
        if ((n & 1) != 0) {
            materialRetained.ambientColor = (Color3f)object;
        } else if ((n & 2) != 0) {
            materialRetained.emissiveColor = (Color3f)object;
        } else if ((n & 4) != 0) {
            materialRetained.diffuseColor = (Color3f)object;
        } else if ((n & 8) != 0) {
            materialRetained.specularColor = (Color3f)object;
        } else if ((n & 0x10) != 0) {
            materialRetained.shininess = ((Float)object).floatValue();
        } else if ((n & 0x20) != 0) {
            materialRetained.lightingEnable = (Boolean)object;
        }
    }

    void computeTags() {
        this.tag1 = this.ambientColor.hashCode() ^ this.emissiveColor.hashCode() ^ this.specularColor.hashCode() ^ new Float(this.shininess).hashCode() ^ new Boolean(this.lightingEnable).hashCode();
        Color3f color3f = new Color3f(this.ambientColor.x, this.emissiveColor.x, this.specularColor.x);
        Color3f color3f2 = new Color3f(this.ambientColor.y, this.emissiveColor.y, this.specularColor.y);
        Color3f color3f3 = new Color3f(this.ambientColor.z, this.emissiveColor.z, this.specularColor.z);
        this.tag2 = color3f.hashCode() ^ color3f2.hashCode() ^ color3f3.hashCode();
        color3f = new Color3f(this.ambientColor.x, this.emissiveColor.y, this.specularColor.z);
        color3f2 = new Color3f(this.ambientColor.z, this.emissiveColor.y, this.specularColor.x);
        this.tag3 = color3f.hashCode() ^ color3f2.hashCode();
    }

    boolean equivalent(MaterialRetained materialRetained) {
        return materialRetained != null && this.lightingEnable == materialRetained.lightingEnable && this.ambientColor.equals((Tuple3f)materialRetained.ambientColor) && this.emissiveColor.equals((Tuple3f)materialRetained.emissiveColor) && this.diffuseColor.equals((Tuple3f)materialRetained.diffuseColor) && this.specularColor.equals((Tuple3f)materialRetained.specularColor) && this.shininess == materialRetained.shininess;
    }

    protected Object clone() {
        MaterialRetained materialRetained = (MaterialRetained)super.clone();
        materialRetained.ambientColor = new Color3f(this.ambientColor);
        materialRetained.emissiveColor = new Color3f(this.emissiveColor);
        materialRetained.diffuseColor = new Color3f(this.diffuseColor);
        materialRetained.specularColor = new Color3f(this.specularColor);
        return materialRetained;
    }

    protected void set(MaterialRetained materialRetained) {
        this.ambientColor.set((Tuple3f)materialRetained.ambientColor);
        this.emissiveColor.set((Tuple3f)materialRetained.emissiveColor);
        this.diffuseColor.set((Tuple3f)materialRetained.diffuseColor);
        this.specularColor.set((Tuple3f)materialRetained.specularColor);
        this.shininess = materialRetained.shininess;
        this.lightingEnable = materialRetained.lightingEnable;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 13;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 13;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }
}

