/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.VirtualUniverse;

final class J3DGraphics2DImpl
extends J3DGraphics2D {
    private Graphics2D offScreenGraphics2D = null;
    private Graphics2D defaultGraphics2D = null;
    private BufferedImage g3dImage = null;
    private boolean isFlushed = true;
    private Dimension size = new Dimension(0, 0);
    private Canvas3D canvas3d = null;
    private int widPower;
    private int heiPower;
    private int texWidth;
    private int texHeight;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private int objectId = -1;
    private boolean isJ3dG2dDrawPixel = true;
    private Color FG = new Color(0.0f, 0.0f, 0.0f, 0.0f);

    J3DGraphics2DImpl(Canvas3D canvas3D) {
        this.canvas3d = canvas3D;
        this.canvas3d.getSize(this.size);
        this.xmin = 0;
        this.ymin = 0;
        this.xmax = this.size.width;
        this.ymax = this.size.height;
        this.isJ3dG2dDrawPixel = VirtualUniverse.mc.isJ3dG2dDrawPixel;
        if (this.isJ3dG2dDrawPixel) {
            this.texWidth = this.size.width;
            this.texHeight = this.size.height;
        } else {
            this.widPower = J3DGraphics2DImpl.getRoundOffPowerOf2(this.size.width);
            this.heiPower = J3DGraphics2DImpl.getRoundOffPowerOf2(this.size.height);
            this.texWidth = (int)Math.pow(2.0, this.widPower);
            this.texHeight = (int)Math.pow(2.0, this.heiPower);
        }
        this.g3dImage = new BufferedImage(this.texWidth, this.texHeight, 2);
        this.offScreenGraphics2D = this.g3dImage.createGraphics();
        this.defaultGraphics2D = this.g3dImage.createGraphics();
        this.defaultGraphics2D.setColor(this.FG);
        this.defaultGraphics2D.setComposite(AlphaComposite.Src);
        this.defaultGraphics2D.fillRect(0, 0, this.texWidth, this.texHeight);
    }

    public void flush(boolean bl) {
        if (!this.isFlushed) {
            if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
                return;
            }
            if (this.canvas3d.view.inCanvasCallback) {
                this.doFlush();
            } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 23, null, null);
                if (bl) {
                    // empty if block
                }
            } else {
                this.sendRenderMessage(true, 23, null, null);
                if (bl) {
                    // empty if block
                }
            }
            this.isFlushed = true;
        }
    }

    void doFlush() {
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, this.g3dImage, false, false);
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
        if (this.isJ3dG2dDrawPixel) {
            imageComponent2DRetained.setRasterRef();
            this.canvas3d.composite(this.canvas3d.ctx, this.xmin, this.ymin, this.xmax, this.ymax, this.texWidth, this.texHeight, imageComponent2DRetained.imageYdown);
        } else {
            if (this.objectId == -1) {
                this.objectId = VirtualUniverse.mc.getTexture2DId();
            }
            imageComponent2DRetained.setTextureRef();
            this.canvas3d.texturemapping(this.canvas3d.ctx, this.xmin, this.ymin, this.xmax, this.ymax, this.texWidth, this.texHeight, 2, this.objectId, imageComponent2DRetained.imageYup);
        }
        this.defaultGraphics2D.setComposite(AlphaComposite.Src);
        this.defaultGraphics2D.fillRect(0, 0, this.texWidth, this.texHeight);
    }

    private void sendRenderMessage(boolean bl, int n, Object object, Object object2) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = this.canvas3d;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        while (!this.canvas3d.view.inRenderThreadData) {
            try {
                Thread.currentThread();
                Thread.sleep(0L, 10);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(j3dMessage);
        if (bl) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    private void validate() {
        this.isFlushed = false;
        boolean bl = false;
        Canvas3D canvas3D = this.canvas3d;
        synchronized (canvas3D) {
            if (this.canvas3d.resizeGraphics2D) {
                bl = true;
                this.canvas3d.resizeGraphics2D = false;
            }
        }
        if (bl) {
            this.canvas3d.getSize(this.size);
            this.xmin = 0;
            this.ymin = 0;
            this.xmax = this.size.width;
            this.ymax = this.size.height;
            if (this.isJ3dG2dDrawPixel) {
                this.texWidth = this.size.width;
                this.texHeight = this.size.height;
            } else {
                this.widPower = J3DGraphics2DImpl.getRoundOffPowerOf2(this.size.width);
                this.heiPower = J3DGraphics2DImpl.getRoundOffPowerOf2(this.size.height);
                this.texWidth = (int)Math.pow(2.0, this.widPower);
                this.texHeight = (int)Math.pow(2.0, this.heiPower);
            }
            Graphics2D graphics2D = this.offScreenGraphics2D;
            this.g3dImage = new BufferedImage(this.texWidth, this.texHeight, 2);
            this.offScreenGraphics2D = this.g3dImage.createGraphics();
            this.defaultGraphics2D = this.g3dImage.createGraphics();
            this.defaultGraphics2D.setColor(this.FG);
            this.copyGraphics2D(graphics2D, this.offScreenGraphics2D);
            this.defaultGraphics2D.setComposite(AlphaComposite.Src);
            this.defaultGraphics2D.fillRect(0, 0, this.texWidth, this.texHeight);
        }
    }

    private void copyGraphics2D(Graphics2D graphics2D, Graphics2D graphics2D2) {
        graphics2D2.setColor(graphics2D.getColor());
        graphics2D2.setFont(graphics2D.getFont());
        graphics2D2.setClip(graphics2D.getClip());
    }

    private void setDimensionDefault() {
        this.xmin = 0;
        this.ymin = 0;
        this.xmax = this.size.width;
        this.ymax = this.size.height;
    }

    public final void clip(Shape shape) {
        this.offScreenGraphics2D.clip(shape);
    }

    public FontMetrics getFontMetrics() {
        return this.offScreenGraphics2D.getFontMetrics();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.offScreenGraphics2D.getClipBounds(rectangle);
    }

    static int getRoundOffPowerOf2(int n) {
        if (n < 1) {
            return -1;
        }
        int n2 = 0;
        int n3 = n;
        while (n2 < 32) {
            if ((n3 & Integer.MIN_VALUE) != 0) {
                if ((n3 & Integer.MAX_VALUE) == 0) {
                    return 31 - n2;
                }
                return 32 - n2;
            }
            n3 <<= 1;
            ++n2;
        }
        return -1;
    }

    public Rectangle getClipRect() {
        return this.offScreenGraphics2D.getClipRect();
    }

    public String toString() {
        return this.offScreenGraphics2D.toString();
    }

    public final AffineTransform getTransform() {
        return this.offScreenGraphics2D.getTransform();
    }

    public final Color getColor() {
        return this.offScreenGraphics2D.getColor();
    }

    public final Composite getComposite() {
        return this.offScreenGraphics2D.getComposite();
    }

    public final Font getFont() {
        return this.offScreenGraphics2D.getFont();
    }

    public final FontMetrics getFontMetrics(Font font) {
        return this.offScreenGraphics2D.getFontMetrics(font);
    }

    public final FontRenderContext getFontRenderContext() {
        return this.offScreenGraphics2D.getFontRenderContext();
    }

    public final GraphicsConfiguration getDeviceConfiguration() {
        return this.offScreenGraphics2D.getDeviceConfiguration();
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.offScreenGraphics2D.getRenderingHint(key);
    }

    public final Paint getPaint() {
        return this.offScreenGraphics2D.getPaint();
    }

    public final Rectangle getClipBounds() {
        return this.offScreenGraphics2D.getClipBounds();
    }

    public final RenderingHints getRenderingHints() {
        return this.offScreenGraphics2D.getRenderingHints();
    }

    public final Shape getClip() {
        return this.offScreenGraphics2D.getClip();
    }

    public final Stroke getStroke() {
        return this.offScreenGraphics2D.getStroke();
    }

    public final boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.setDimensionDefault();
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, affineTransform, imageObserver);
    }

    public final void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (n < this.xmin) {
            this.xmin = n;
        }
        if (n2 < this.ymin) {
            this.ymin = n2;
        }
        this.xmax = this.size.width;
        this.ymax = this.size.height;
        this.validate();
        this.offScreenGraphics2D.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    public final boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.xmax < n) {
            this.xmax = n;
        }
        if (this.ymax < n2) {
            this.ymax = n2;
        }
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n < this.xmin) {
            this.xmin = n;
        }
        if (n2 < this.ymin) {
            this.ymin = n2;
        }
        if (n + n3 > this.xmax) {
            this.xmax = n + n3;
        }
        if (n2 + n4 > this.ymax) {
            this.ymax = n2 + n4;
        }
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n < this.xmin) {
            this.xmin = n;
        }
        if (n2 < this.ymin) {
            this.ymin = n2;
        }
        if (n + n3 > this.xmax) {
            this.xmax = n + n3;
        }
        if (n2 + n4 > this.ymax) {
            this.ymax = n2 + n4;
        }
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public final void drawImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawImage(bufferedImage, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.setDimensionDefault();
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.setDimensionDefault();
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public final boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (n < this.xmin) {
            this.xmin = n;
        }
        if (n2 < this.ymin) {
            this.ymin = n2;
        }
        this.xmax = this.size.width;
        this.ymax = this.size.height;
        this.validate();
        return this.offScreenGraphics2D.drawImage(image, n, n2, color, imageObserver);
    }

    public final boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.validate();
        return this.offScreenGraphics2D.hit(rectangle, shape, bl);
    }

    public final void addRenderingHints(Map map) {
        this.offScreenGraphics2D.addRenderingHints(map);
    }

    public final void clipRect(int n, int n2, int n3, int n4) {
        this.offScreenGraphics2D.clipRect(n, n2, n3, n4);
    }

    public final void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.offScreenGraphics2D.copyArea(n, n2, n3, n4, n5, n6);
    }

    public final void dispose() {
        this.offScreenGraphics2D.dispose();
    }

    public final void draw(Shape shape) {
        this.validate();
        this.offScreenGraphics2D.draw(shape);
    }

    public final void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawArc(n, n2, n3, n4, n5, n6);
    }

    public final void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawGlyphVector(glyphVector, f, f2);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        if (n < this.xmin) {
            this.xmin = n;
        }
        if (n2 < this.ymin) {
            this.ymin = n2;
        }
        if (n3 > this.xmax) {
            this.xmax = n3;
        }
        if (n4 > this.ymax) {
            this.ymax = n4;
        }
        this.validate();
        this.offScreenGraphics2D.drawLine(n, n2, n3, n4);
    }

    public final void drawOval(int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawOval(n, n2, n3, n4);
    }

    public final void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawPolygon(nArray, nArray2, n);
    }

    public final void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawPolyline(nArray, nArray2, n);
    }

    public final void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawRenderableImage(renderableImage, affineTransform);
    }

    public final void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawRenderedImage(renderedImage, affineTransform);
    }

    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawString(attributedCharacterIterator, n, n2);
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawString(attributedCharacterIterator, f, f2);
    }

    public final void drawString(String string, float f, float f2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawString(string, f, f2);
    }

    public final void drawString(String string, int n, int n2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawString(string, n, n2);
    }

    public final void fill(Shape shape) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fill(shape);
    }

    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillArc(n, n2, n3, n4, n5, n6);
    }

    public final void fillOval(int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillOval(n, n2, n3, n4);
    }

    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public final void rotate(double d) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.rotate(d);
    }

    public final void rotate(double d, double d2, double d3) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.rotate(d, d2, d3);
    }

    public final void scale(double d, double d2) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.scale(d, d2);
    }

    public final void setClip(Shape shape) {
        this.offScreenGraphics2D.setClip(shape);
    }

    public final void setClip(int n, int n2, int n3, int n4) {
        this.offScreenGraphics2D.setClip(n, n2, n3, n4);
    }

    public final void setColor(Color color) {
        this.offScreenGraphics2D.setColor(color);
    }

    public final void setComposite(Composite composite) {
        this.offScreenGraphics2D.setComposite(composite);
    }

    public final void setFont(Font font) {
        this.offScreenGraphics2D.setFont(font);
    }

    public final void setPaint(Paint paint) {
        this.offScreenGraphics2D.setPaint(paint);
    }

    public final void setPaintMode() {
        this.offScreenGraphics2D.setPaintMode();
    }

    public final void setRenderingHint(RenderingHints.Key key, Object object) {
        this.offScreenGraphics2D.setRenderingHint(key, object);
    }

    public final void setRenderingHints(Map map) {
        this.offScreenGraphics2D.setRenderingHints(map);
    }

    public final void setStroke(Stroke stroke) {
        this.offScreenGraphics2D.setStroke(stroke);
    }

    public final void setTransform(AffineTransform affineTransform) {
        this.offScreenGraphics2D.setTransform(affineTransform);
    }

    public final void setXORMode(Color color) {
        this.offScreenGraphics2D.setXORMode(color);
    }

    public final void shear(double d, double d2) {
        this.validate();
        this.offScreenGraphics2D.shear(d, d2);
    }

    public final void transform(AffineTransform affineTransform) {
        this.validate();
        this.offScreenGraphics2D.transform(affineTransform);
    }

    public final void translate(double d, double d2) {
        this.validate();
        this.offScreenGraphics2D.translate(d, d2);
    }

    public final void translate(int n, int n2) {
        this.validate();
        this.offScreenGraphics2D.translate(n, n2);
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        this.validate();
        return this.offScreenGraphics2D.hitClip(n, n2, n3, n4);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.draw3DRect(n, n2, n3, n4, bl);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawChars(cArray, n, n2, n3, n4);
    }

    public void drawPolygon(Polygon polygon) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawPolygon(polygon);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.drawRect(n, n2, n3, n4);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fill3DRect(n, n2, n3, n4, bl);
    }

    public void fillPolygon(Polygon polygon) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillPolygon(polygon);
    }

    public final void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillPolygon(nArray, nArray2, n);
    }

    public final void fillRect(int n, int n2, int n3, int n4) {
        this.setDimensionDefault();
        this.validate();
        this.offScreenGraphics2D.fillRect(n, n2, n3, n4);
    }

    public void finalize() {
        this.validate();
        this.offScreenGraphics2D.finalize();
    }
}

