/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

class IndexedQuadArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedQuadArrayRetained() {
        this.geoType = 8;
    }

    boolean intersect(PickShape pickShape) {
        int n = 0;
        boolean bl = true;
        double[] dArray = new double[1];
        Bounds bounds = null;
        Point3d[] point3dArray = new Point3d[4];
        if (pickShape instanceof PickRay) {
            n = 1;
        } else if (pickShape instanceof PickSegment) {
            n = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n = 4;
            } else if (bounds instanceof BoundingSphere) {
                n = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedQuadArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n = 7;
            } else if (pickShape instanceof PickCone) {
                n = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n2 = 0;
        while (n2 < 4) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        int n3 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        n2 = n3;
        while (n2 < this.validVertexCount) {
            int n4 = n2;
            while (n4 < n2 + 4) {
                int n5 = n4 - n2;
                super.getVertexData(this.indexCoord[n4], point3dArray[n5]);
                ++n4;
            }
            switch (n) {
                case 1: {
                    if (!this.intersectRay(point3dArray, (PickRay)pickShape, dArray)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectSegment(point3dArray, ((PickSegment)pickShape).start, ((PickSegment)pickShape).end, dArray)) break;
                    return true;
                }
                case 4: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 5: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 6: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 7: {
                    if (!this.intersectCylinder(point3dArray, (PickCylinder)pickShape, dArray)) break;
                    return true;
                }
                case 8: {
                    if (!this.intersectCone(point3dArray, (PickCone)pickShape, dArray)) break;
                    return true;
                }
            }
            n2 += 4;
        }
        return n == 3;
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        double[] dArray2 = new double[1];
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[4];
        Point3d point3d2 = new Point3d();
        dArray[0] = Double.MAX_VALUE;
        int n = 0;
        while (n < 4) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        n = n2;
        while (n < this.validVertexCount) {
            int n3 = n;
            while (n3 < n + 4) {
                int n4 = n3 - n;
                super.getVertexData(this.indexCoord[n3], point3dArray[n4]);
                ++n3;
            }
            if (this.intersectRay(point3dArray, pickRay, dArray2, point3d2)) {
                bl = true;
                if (dArray2[0] < dArray[0]) {
                    dArray[0] = dArray2[0];
                    point3d.x = point3d2.x;
                    point3d.y = point3d2.y;
                    point3d.z = point3d2.z;
                }
            }
            n += 4;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[4];
        double[] dArray = new double[1];
        int n = 0;
        while (n < 4) {
            point3dArray2[n] = new Point3d();
            ++n;
        }
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        n = n2;
        while (n < this.validVertexCount) {
            int n3 = n;
            while (n3 < n + 4) {
                int n4 = n3 - n;
                super.getVertexData(this.indexCoord[n3], point3dArray2[n4]);
                transform3D.transform(point3dArray2[n4], point3dArray2[n4]);
                ++n3;
            }
            switch (point3dArray.length) {
                case 1: {
                    if (this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0])) {
                        return true;
                    }
                    if (!this.intersectTriPnt(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0])) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray)) break;
                    return true;
                }
                case 3: {
                    if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) {
                        return true;
                    }
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[1], point3dArray[2])) break;
                    return true;
                }
                case 4: {
                    if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) {
                        return true;
                    }
                    if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3])) {
                        return true;
                    }
                    if (this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[1], point3dArray[2])) {
                        return true;
                    }
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[2], point3dArray[3])) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
            n += 4;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[4];
        int n = 0;
        while (n < 4) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        n = n2;
        while (n < this.validVertexCount) {
            int n3 = n;
            while (n3 < n + 4) {
                int n4 = n3 - n;
                super.getVertexData(this.indexCoord[n3], point3dArray[n4]);
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n3;
            }
            if (geometryRetained.intersect(transform3D2, point3dArray)) {
                return true;
            }
            n += 4;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[4];
        int n2 = 0;
        while (n2 < 4) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        if (bounds instanceof BoundingBox) {
            n = 1;
        } else if (bounds instanceof BoundingSphere) {
            n = 2;
        }
        int n3 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        n2 = n3;
        while (n2 < this.validVertexCount) {
            int n4 = n2;
            while (n4 < n2 + 4) {
                int n5 = n4 - n2;
                super.getVertexData(this.indexCoord[n4], point3dArray[n5]);
                transform3D.transform(point3dArray[n5], point3dArray[n5]);
                ++n4;
            }
            switch (n) {
                case 0: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)bounds)) break;
                    return true;
                }
                case 1: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)bounds)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)bounds)) break;
                    return true;
                }
            }
            n2 += 4;
        }
        return false;
    }
}

