/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponentRetained;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    int format;
    int width;
    int height;
    byte[] imageYdown;
    byte[] imageYup;
    int bytesPerPixel;
    boolean usedByRaster = false;
    boolean usedByTexture = false;
    boolean byReference = false;
    boolean yUp = false;
    RenderedImage[] bImage;
    boolean[] imageDirty;
    float lastAlpha = 1.0f;
    boolean alphaChanged = false;
    int storedFormat;
    int bytesPerPixelStored;
    int internalFormat;
    boolean imageYupAllocated = false;
    boolean imageYdownAllocated = false;
    boolean imageYupCacheDirty = false;
    boolean imageYdownCacheDirty = false;
    static final int BYTE_RGBA = 1;
    static final int BYTE_ABGR = 2;
    static final int BYTE_GRAY = 4;
    static final int USHORT_GRAY = 8;
    static final int BYTE_LA = 16;
    static final int BYTE_BGR = 32;
    static final int BYTE_RGB = 64;
    int imageYupClass = 0;
    int imageYdownClass = 0;
    static final int BUFFERED_IMAGE = 1;
    static final int RENDERED_IMAGE = 2;
    GeometryLock geomLock = new GeometryLock();
    int minTileX = 0;
    int minTileY = 0;
    int minTileZ = 0;
    int tilew = 0;
    int tileh = 0;
    int tiled = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    int numZTiles = 0;
    int tileGridXOffset = 0;
    int tileGridYOffset = 0;
    int minX = 0;
    int minY = 0;

    ImageComponentRetained() {
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int getFormat() {
        return this.format;
    }

    void processParams(int n, int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
        }
        this.format = n;
        this.width = n2;
        this.height = n3;
        this.imageDirty = new boolean[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.imageDirty[n5] = false;
            ++n5;
        }
        this.bImage = new RenderedImage[n4];
        switch (n) {
            case 1: {
                this.bytesPerPixel = 3;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 2: {
                this.bytesPerPixel = 4;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 3: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 4: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 5: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 6: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 9: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 7: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 8: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 10: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 1;
                this.internalFormat = 4;
                break;
            }
        }
    }

    void setTextureRef() {
        this.usedByTexture = true;
    }

    void setRasterRef() {
        this.usedByRaster = true;
    }

    final void copyImage(RenderedImage renderedImage, byte[] byArray, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray = null;
        int n5 = this.width * this.bytesPerPixelStored;
        ColorModel colorModel = renderedImage.getColorModel();
        int n6 = renderedImage.getMinX();
        int n7 = renderedImage.getMinY();
        int n8 = renderedImage.getTileGridXOffset();
        int n9 = renderedImage.getTileGridYOffset();
        int n10 = renderedImage.getMinTileX();
        int n11 = renderedImage.getMinTileY();
        this.numXTiles = renderedImage.getNumXTiles();
        this.numYTiles = renderedImage.getNumYTiles();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        int n12 = this.tilew * this.bytesPerPixelStored;
        int n13 = n10 * this.tilew + n8 + this.tilew;
        int n14 = n11 * this.tileh + n9 + this.tileh;
        int n15 = this.width;
        int n16 = this.height;
        int n17 = n13 - n6;
        int n18 = n14 - n7;
        if (n15 < n17) {
            n17 = n15;
        }
        if (n16 < n18) {
            n18 = n16;
        }
        int n19 = n17;
        int n20 = this.tilew - n17;
        int n21 = this.tileh - n18;
        if (!this.yUp && bl || this.yUp && !bl) {
            n4 = (this.height - 1) * n5;
            n3 = -1;
            n2 = -n5;
        } else {
            n4 = 0;
            n3 = 1;
            n2 = n5;
        }
        Raster raster = renderedImage.getTile(n10, n11);
        if (raster.getTransferType() == 3) {
            objectArray = new int[4];
        } else if (raster.getTransferType() == 0) {
            objectArray = new byte[4];
        } else if (raster.getTransferType() == 1) {
            objectArray = new short[4];
        }
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                int n22 = n11;
                while (n22 < n11 + this.numYTiles) {
                    int n23 = n4;
                    n15 = this.width;
                    n17 = n19;
                    n20 = this.tilew - n17;
                    int n24 = n10;
                    while (n24 < n10 + this.numXTiles) {
                        raster = renderedImage.getTile(n24, n22);
                        int n25 = n23;
                        int n26 = 0;
                        int n27 = 0;
                        while (n27 < n18) {
                            int n28 = 0;
                            while (n28 < n17) {
                                raster.getDataElements(n20 + n28, n21 + n27, objectArray);
                                byArray[n25++] = (byte)colorModel.getRed(objectArray);
                                byArray[n25++] = (byte)colorModel.getGreen(objectArray);
                                byArray[n25++] = (byte)colorModel.getBlue(objectArray);
                                byArray[n25++] = (byte)colorModel.getAlpha(objectArray);
                                byte by = (byte)colorModel.getRed(objectArray);
                                byte by2 = (byte)colorModel.getGreen(objectArray);
                                byte by3 = (byte)colorModel.getBlue(objectArray);
                                ++n28;
                            }
                            n25 = n23 + (n26 += n2);
                            ++n27;
                        }
                        n20 = 0;
                        n23 += n17 * this.bytesPerPixelStored;
                        n17 = (n15 -= n17) < this.tilew ? n15 : this.tilew;
                        ++n24;
                    }
                    n21 = 0;
                    n4 += this.width * this.bytesPerPixelStored * n18 * n3;
                    n18 = (n16 -= n18) < this.tileh ? n16 : this.tileh;
                    ++n22;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                int n29 = n11;
                while (n29 < n11 + this.numYTiles) {
                    int n30 = n4;
                    n15 = this.width;
                    n17 = n19;
                    n20 = this.tilew - n17;
                    int n31 = n10;
                    while (n31 < n10 + this.numXTiles) {
                        raster = renderedImage.getTile(n31, n29);
                        int n32 = n30;
                        int n33 = 0;
                        int n34 = 0;
                        while (n34 < n18) {
                            int n35 = 0;
                            while (n35 < n17) {
                                raster.getDataElements(n20 + n35, n21 + n34, objectArray);
                                byArray[n32++] = (byte)colorModel.getRed(objectArray);
                                byArray[n32++] = (byte)colorModel.getGreen(objectArray);
                                byArray[n32++] = (byte)colorModel.getBlue(objectArray);
                                byArray[n32++] = -1;
                                ++n35;
                            }
                            n32 = n30 + (n33 += n2);
                            ++n34;
                        }
                        n20 = 0;
                        n30 += n17 * this.bytesPerPixelStored;
                        n17 = (n15 -= n17) < this.tilew ? n15 : this.tilew;
                        ++n31;
                    }
                    n21 = 0;
                    n4 += this.width * this.bytesPerPixelStored * n18 * n3;
                    n18 = (n16 -= n18) < this.tileh ? n16 : this.tileh;
                    ++n29;
                }
                break;
            }
            case 7: 
            case 8: {
                int n36 = n11;
                while (n36 < n11 + this.numYTiles) {
                    int n37 = n4;
                    n15 = this.width;
                    n17 = n19;
                    n20 = this.tilew - n17;
                    int n38 = n10;
                    while (n38 < n10 + this.numXTiles) {
                        raster = renderedImage.getTile(n38, n36);
                        int n39 = n37;
                        int n40 = 0;
                        int n41 = 0;
                        while (n41 < n18) {
                            int n42 = 0;
                            while (n42 < n17) {
                                raster.getDataElements(n20 + n42, n21 + n41, objectArray);
                                byArray[n39++] = (byte)colorModel.getRed(objectArray);
                                byArray[n39++] = (byte)colorModel.getAlpha(objectArray);
                                ++n42;
                            }
                            n39 = n37 + (n40 += n2);
                            ++n41;
                        }
                        n20 = 0;
                        n37 += n17 * this.bytesPerPixelStored;
                        n17 = (n15 -= n17) < this.tilew ? n15 : this.tilew;
                        ++n38;
                    }
                    n21 = 0;
                    n4 += this.width * this.bytesPerPixelStored * n18 * n3;
                    n18 = (n16 -= n18) < this.tileh ? n16 : this.tileh;
                    ++n36;
                }
                break;
            }
            case 10: {
                int n43 = n11;
                while (n43 < n11 + this.numYTiles) {
                    int n44 = n4;
                    n15 = this.width;
                    n17 = n19;
                    n20 = this.tilew - n17;
                    int n45 = n10;
                    while (n45 < n10 + this.numXTiles) {
                        raster = renderedImage.getTile(n45, n43);
                        int n46 = n44;
                        int n47 = 0;
                        int n48 = 0;
                        while (n48 < n18) {
                            int n49 = 0;
                            while (n49 < n17) {
                                raster.getDataElements(n20 + n49, n21 + n48, objectArray);
                                byArray[n46++] = (byte)colorModel.getRed(objectArray);
                                ++n49;
                            }
                            n46 = n44 + (n47 += n2);
                            ++n48;
                        }
                        n20 = 0;
                        n44 += n17 * this.bytesPerPixelStored;
                        n17 = (n15 -= n17) < this.tilew ? n15 : this.tilew;
                        ++n45;
                    }
                    n21 = 0;
                    n4 += this.width * this.bytesPerPixelStored * n18 * n3;
                    n18 = (n16 -= n18) < this.tileh ? n16 : this.tileh;
                    ++n43;
                }
                break;
            }
        }
    }

    final void copyImage(BufferedImage bufferedImage, byte[] byArray, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray = null;
        if (!this.yUp && bl || this.yUp && !bl) {
            n4 = n * this.width * this.height * this.bytesPerPixelStored;
            n3 = -1;
            n2 = this.height - 1;
        } else {
            n4 = 0;
            n3 = 1;
            n2 = 0;
        }
        int n5 = bufferedImage.getType();
        if (!(n5 != 2 && n5 != 1 || this.format != 2 && this.format != 1)) {
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n6 = n3 * this.width;
            n2 *= this.width;
            int n7 = n4;
            if (n5 == 2 && this.format == 2) {
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = n2;
                    int n10 = 0;
                    while (n10 < this.width) {
                        int n11 = nArray[n9];
                        byArray[n7++] = (byte)(n11 >> 16 & 0xFF);
                        byArray[n7++] = (byte)(n11 >> 8 & 0xFF);
                        byArray[n7++] = (byte)(n11 & 0xFF);
                        byArray[n7++] = (byte)(n11 >> 24 & 0xFF);
                        ++n10;
                        ++n9;
                    }
                    n2 += n6;
                    ++n8;
                }
            } else {
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n2;
                    int n14 = 0;
                    while (n14 < this.width) {
                        int n15 = nArray[n13];
                        byArray[n7++] = (byte)(n15 >> 16 & 0xFF);
                        byArray[n7++] = (byte)(n15 >> 8 & 0xFF);
                        byArray[n7++] = (byte)(n15 & 0xFF);
                        byArray[n7++] = -1;
                        ++n14;
                        ++n13;
                    }
                    n2 += n6;
                    ++n12;
                }
            }
        } else if (n5 == 10 && this.format == 10) {
            byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n16 = n3 * this.width;
            n2 *= this.width;
            int n17 = n4;
            int n18 = 0;
            while (n18 < this.height) {
                System.arraycopy(byArray2, n2, byArray, n17, this.width);
                ++n18;
                n17 += this.width;
                n2 += n16;
            }
        } else {
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorModel colorModel = bufferedImage.getColorModel();
            if (writableRaster.getTransferType() == 3) {
                objectArray = new int[4];
            } else if (writableRaster.getTransferType() == 0) {
                objectArray = new byte[4];
            } else if (writableRaster.getTransferType() == 1) {
                objectArray = new short[4];
            }
            switch (this.format) {
                case 2: 
                case 4: 
                case 6: {
                    int n19 = n4;
                    int n20 = n2;
                    int n21 = 0;
                    while (n21 < this.height) {
                        int n22 = 0;
                        while (n22 < this.width) {
                            writableRaster.getDataElements(n22, n20, objectArray);
                            byArray[n19++] = (byte)colorModel.getRed(objectArray);
                            byArray[n19++] = (byte)colorModel.getGreen(objectArray);
                            byArray[n19++] = (byte)colorModel.getBlue(objectArray);
                            byArray[n19++] = (byte)colorModel.getAlpha(objectArray);
                            ++n22;
                        }
                        ++n21;
                        n20 += n3;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: {
                    this.lastAlpha = 1.0f;
                    int n23 = n4;
                    int n24 = n2;
                    int n25 = 0;
                    while (n25 < this.height) {
                        int n26 = 0;
                        while (n26 < this.width) {
                            writableRaster.getDataElements(n26, n24, objectArray);
                            byArray[n23++] = (byte)colorModel.getRed(objectArray);
                            byArray[n23++] = (byte)colorModel.getGreen(objectArray);
                            byArray[n23++] = (byte)colorModel.getBlue(objectArray);
                            byArray[n23++] = -1;
                            ++n26;
                        }
                        ++n25;
                        n24 += n3;
                    }
                    break;
                }
                case 7: 
                case 8: {
                    int n27 = n4;
                    int n28 = n2;
                    int n29 = 0;
                    while (n29 < this.height) {
                        int n30 = 0;
                        while (n30 < this.width) {
                            writableRaster.getDataElements(n30, n28, objectArray);
                            byArray[n27++] = (byte)colorModel.getRed(objectArray);
                            byArray[n27++] = (byte)colorModel.getAlpha(objectArray);
                            ++n30;
                        }
                        ++n29;
                        n28 += n3;
                    }
                    break;
                }
                case 10: {
                    int n31 = n4;
                    int n32 = n2;
                    int n33 = 0;
                    while (n33 < this.height) {
                        int n34 = 0;
                        while (n34 < this.width) {
                            writableRaster.getDataElements(n34, n32, objectArray);
                            byArray[n31++] = (byte)colorModel.getRed(objectArray);
                            ++n34;
                        }
                        ++n33;
                        n32 += n3;
                    }
                    break;
                }
            }
        }
    }

    final void retrieveImage(byte[] byArray, int n, int n2) {
        this.retrieveImage(byArray, 0, 0, n, n2);
    }

    final int getBytesStored(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
            case 32: {
                n2 = 3;
                break;
            }
            case 64: {
                n2 = 3;
            }
        }
        return n2;
    }

    final void retrieveImage(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2;
        int n6 = n3 * this.bytesPerPixelStored;
        int n7 = this.width * this.bytesPerPixelStored;
        if (this.storedFormat == this.internalFormat) {
            if ((this.usedByTexture || !this.usedByRaster) && this.imageYup == null) {
                this.imageYup = new byte[this.height * n7];
            }
            if (this.usedByRaster && this.imageYdown == null) {
                this.imageYdown = new byte[this.height * n7];
            }
        }
        int n8 = n2 * n7 + n * this.bytesPerPixelStored;
        this.imageDirty[0] = true;
        int n9 = (this.height - n2 - 1) * n7 + n * this.bytesPerPixelStored;
        if (this.usedByRaster) {
            if (this.byReference && this.storedFormat != this.internalFormat) {
                byArray2 = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                this.imageDirty[0] = false;
            } else {
                byArray2 = this.imageYdown;
            }
            n5 = 0;
            while (n5 < n4) {
                System.arraycopy(byArray, n8, byArray2, n9, n6);
                ++n5;
                n8 += n7;
                n9 -= n7;
            }
        }
        if (this.usedByTexture || !this.usedByRaster) {
            if (this.byReference && this.storedFormat != this.internalFormat) {
                byArray2 = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                this.imageDirty[0] = false;
            } else {
                byArray2 = this.imageYup;
            }
            n9 = n8;
            n5 = 0;
            while (n5 < n4) {
                System.arraycopy(byArray, n8, byArray2, n9, n6);
                ++n5;
                n8 += n7;
                n9 += n7;
            }
        }
        if (this.byReference && this.imageDirty[0]) {
            this.imageDirty[0] = false;
            if (this.usedByTexture || !this.usedByRaster) {
                this.copyBufferedImageWithFormatConversion(true, 0);
            } else {
                this.copyBufferedImageWithFormatConversion(false, 0);
            }
        }
    }

    final void retrieveBufferedImage(int n) {
        if (this.bImage[n] == null) {
            this.bImage[n] = this.format == 2 || this.format == 6 || this.format == 4 || this.format == 7 || this.format == 8 ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
        }
        if (this.usedByTexture || !this.usedByRaster) {
            this.copyToBufferedImage(this.imageYup, n, true);
        } else {
            this.copyToBufferedImage(this.imageYdown, n, false);
        }
        this.imageDirty[n] = false;
    }

    final void copyBufferedImageWithFormatConversion(boolean bl, int n) {
        byte[] byArray;
        int n2;
        int n3;
        int n4;
        int n5;
        BufferedImage bufferedImage = (BufferedImage)this.bImage[n];
        int n6 = bufferedImage.getType();
        if (!this.yUp) {
            if (bl) {
                n5 = -1 * this.width;
                n4 = (this.height - 1) * this.width;
                n3 = this.height - 1;
                n2 = -1;
                byArray = this.imageYup;
            } else {
                n5 = this.width;
                n4 = 0;
                n3 = 0;
                n2 = 1;
                byArray = this.imageYdown;
            }
        } else if (bl) {
            n5 = this.width;
            n4 = 0;
            n3 = 0;
            n2 = 1;
            byArray = this.imageYup;
        } else {
            n5 = -1 * this.width;
            n4 = (this.height - 1) * this.width;
            n3 = this.height - 1;
            n2 = -1;
            byArray = this.imageYdown;
        }
        switch (n6) {
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n7 = 0;
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = n4;
                    int n10 = 0;
                    while (n10 < this.width) {
                        nArray[n9] = (byArray[n7 + 3] & 0xFF) << 24 | (byArray[n7] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF;
                        ++n10;
                        n7 += 4;
                        ++n9;
                    }
                    ++n8;
                    n4 += n5;
                }
                break;
            }
            case 1: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n11 = 0;
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n4;
                    int n14 = 0;
                    while (n14 < this.width) {
                        nArray[n13] = 0xFF000000 | (byArray[n11] & 0xFF) << 16 | (byArray[n11 + 1] & 0xFF) << 8 | byArray[n11 + 2] & 0xFF;
                        ++n14;
                        n11 += 4;
                        ++n13;
                    }
                    ++n12;
                    n4 += n5;
                }
                break;
            }
            case 6: {
                byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n15 = 0;
                int n16 = 0;
                while (n16 < this.height) {
                    int n17 = n4;
                    int n18 = 0;
                    while (n18 < this.width) {
                        byArray2[n17++] = byArray[n15 + 3];
                        byArray2[n17++] = byArray[n15 + 2];
                        byArray2[n17++] = byArray[n15 + 1];
                        byArray2[n17++] = byArray[n15];
                        ++n18;
                        n15 += 4;
                    }
                    ++n16;
                    n4 += n5;
                }
                break;
            }
            case 4: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n19 = 0;
                int n20 = 0;
                while (n20 < this.height) {
                    int n21 = n4;
                    int n22 = 0;
                    while (n22 < this.width) {
                        nArray[n21] = 0xFF000000 | byArray[n19] & 0xFF | (byArray[n19 + 1] & 0xFF) << 8 | (byArray[n19 + 2] & 0xFF) << 16;
                        ++n22;
                        n19 += 4;
                        ++n21;
                    }
                    ++n20;
                    n4 += n5;
                }
                break;
            }
            case 10: {
                byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n23 = 0;
                int n24 = 0;
                while (n24 < this.height) {
                    System.arraycopy(byArray3, n4, byArray, n23, this.width);
                    n23 += this.width;
                    ++n24;
                    n4 += n5;
                }
                break;
            }
            case 11: {
                int n25 = 0;
                short[] sArray = ((DataBufferShort)bufferedImage.getRaster().getDataBuffer()).getData();
                int n26 = 0;
                while (n26 < this.height) {
                    int n27 = n4;
                    int n28 = 0;
                    while (n28 < this.width) {
                        sArray[n27] = byArray[n25];
                        ++n28;
                        ++n27;
                        ++n25;
                    }
                    ++n26;
                    n4 += n5;
                }
                break;
            }
            default: {
                int n29 = 0;
                int n30 = 0;
                while (n30 < this.height) {
                    int n31 = n3;
                    int n32 = 0;
                    while (n32 < this.width) {
                        int n33 = (byArray[n29 + 3] & 0xFF) << 24 | (byArray[n29] & 0xFF) << 16 | (byArray[n29 + 1] & 0xFF) << 8 | byArray[n29 + 2] & 0xFF;
                        bufferedImage.setRGB(n32, n31, n33);
                        ++n32;
                        n29 += 4;
                    }
                    ++n30;
                    n3 += n2;
                }
                break block0;
            }
        }
    }

    final void copyToBufferedImage(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (!this.yUp) {
            if (bl) {
                n4 = n * this.width * this.height * this.bytesPerPixelStored;
                n3 = -1 * this.width;
                n2 = (this.height - 1) * this.width;
            } else {
                n4 = 0;
                n3 = this.width;
                n2 = 0;
            }
        } else if (bl) {
            n4 = 0;
            n3 = this.width;
            n2 = 0;
        } else {
            n4 = n * this.width * this.height * this.bytesPerPixelStored;
            n3 = -1 * this.width;
            n2 = (this.height - 1) * this.width;
        }
        int[] nArray = ((DataBufferInt)((BufferedImage)this.bImage[n]).getRaster().getDataBuffer()).getData();
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                int n5 = n4;
                int n6 = 0;
                while (n6 < this.height) {
                    int n7 = n2;
                    int n8 = 0;
                    while (n8 < this.width) {
                        nArray[n7] = (byArray[n5 + 3] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n5 + 1] & 0xFF) << 8 | byArray[n5 + 2] & 0xFF;
                        ++n8;
                        n5 += 4;
                        ++n7;
                    }
                    ++n6;
                    n2 += n3;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                int n9 = n4;
                int n10 = 0;
                while (n10 < this.height) {
                    int n11 = n2;
                    int n12 = 0;
                    while (n12 < this.width) {
                        nArray[n11] = (byArray[n9] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9 + 2] & 0xFF;
                        ++n12;
                        n9 += 4;
                        ++n11;
                    }
                    ++n10;
                    n2 += n3;
                }
                break;
            }
            case 7: 
            case 8: {
                int n13 = n4;
                int n14 = 0;
                while (n14 < this.height) {
                    int n15 = n2;
                    int n16 = 0;
                    while (n16 < this.width) {
                        nArray[n15] = (byArray[n13 + 1] & 0xFF) << 24 | (byArray[n13] & 0xFF) << 16;
                        ++n16;
                        n13 += 2;
                        ++n15;
                    }
                    ++n14;
                    n2 += n3;
                }
                break;
            }
            case 10: {
                int n17 = n4;
                int n18 = 0;
                while (n18 < this.height) {
                    int n19 = n2;
                    int n20 = 0;
                    while (n20 < this.width) {
                        nArray[n19] = (byArray[n17] & 0xFF) << 16;
                        ++n20;
                        ++n17;
                        ++n19;
                    }
                    ++n18;
                    n2 += n3;
                }
                break;
            }
        }
    }

    Object getData(DataBuffer dataBuffer) {
        Object[] objectArray = null;
        switch (dataBuffer.getDataType()) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 3: {
                objectArray = ((DataBufferInt)dataBuffer).getData();
                break;
            }
            case 2: {
                objectArray = ((DataBufferShort)dataBuffer).getData();
            }
        }
        return objectArray;
    }

    final void setByReference(boolean bl) {
        this.byReference = bl;
    }

    final boolean isByReference() {
        return this.byReference;
    }

    final void setYUp(boolean bl) {
        this.yUp = bl;
    }

    final boolean isYUp() {
        return this.yUp;
    }
}

