/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponentRetained;

class ImageComponent3DRetained
extends ImageComponentRetained {
    int depth;

    ImageComponent3DRetained() {
    }

    void setDepth(int n) {
        this.depth = n;
    }

    final int getDepth() {
        return this.depth;
    }

    final void set(int n, BufferedImage bufferedImage) {
        if (this.imageYup == null) {
            this.imageYup = new byte[this.height * this.width * this.depth * this.bytesPerPixelStored];
        }
        this.imageDirty[n] = true;
        this.copyImage(bufferedImage, this.imageYup, true, n);
        this.storedFormat = this.internalFormat;
        if (this.byReference) {
            this.bImage[n] = bufferedImage;
        }
    }

    final void set(int n, RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            this.set(n, (BufferedImage)renderedImage);
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            WritableRaster writableRaster = renderedImage.copyData(null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.set(n, bufferedImage);
        }
    }

    final BufferedImage[] getImage() {
        int n;
        BufferedImage[] bufferedImageArray = new BufferedImage[this.bImage.length];
        if (!this.byReference) {
            n = 0;
            while (n < this.depth) {
                if (this.imageDirty[n]) {
                    this.retrieveBufferedImage(n);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.bImage.length) {
            bufferedImageArray[n] = (BufferedImage)this.bImage[n];
            ++n;
        }
        return bufferedImageArray;
    }

    final BufferedImage getImage(int n) {
        if (!this.byReference && this.imageDirty[n]) {
            this.retrieveBufferedImage(n);
        }
        return (BufferedImage)this.bImage[n];
    }
}

