/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;

class ImageComponent2DRetained
extends ImageComponentRetained {
    private int rasterRefCnt = 0;
    private int textureRefCnt = 0;
    int hashId = this.hashCode();
    int surfaceDirty = this.getInImmCtx() ? 1 : 2;
    static final int CLEAN = 0;
    static final int MODIFY = 1;
    static final int NOTLIVE = 2;

    native void freeD3DSurface(int var1);

    ImageComponent2DRetained() {
    }

    final void set(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        if (n != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n2 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        if (!this.byReference || this.byReference && this.willBeCopied(bufferedImage)) {
            int n3 = n2 * n * this.bytesPerPixelStored;
            if (this.usedByTexture || !this.usedByRaster) {
                if (this.imageYup == null || this.imageYup.length < n3) {
                    this.imageYup = new byte[n3];
                }
                this.copyImage(bufferedImage, this.imageYup, true, 0);
                this.imageYupClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            }
            if (this.usedByRaster) {
                if (this.imageYdown == null || this.imageYdown.length < n3) {
                    this.imageYdown = new byte[n3];
                }
                if (this.imageYup != null) {
                    this.setImageYdown(this.imageYup, this.imageYdown);
                } else {
                    this.copyImage(bufferedImage, this.imageYdown, false, 0);
                }
                this.imageYdownClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            }
            if (this.byReference) {
                this.geomLock.getLock();
                this.bImage[0] = bufferedImage;
                this.imageYupCacheDirty = !this.usedByTexture && this.usedByRaster;
                this.imageYdownCacheDirty = !this.usedByRaster;
                this.geomLock.unLock();
            } else {
                this.imageDirty[0] = true;
            }
        } else {
            this.geomLock.getLock();
            this.imageYupCacheDirty = true;
            this.imageYdownCacheDirty = true;
            this.bImage[0] = bufferedImage;
            this.geomLock.unLock();
        }
        if (this.source.isLive()) {
            this.freeSurface();
        }
    }

    boolean willBeCopied(RenderedImage renderedImage) {
        return this.shouldImageBeCopied(this.getImageType(renderedImage), 6, renderedImage);
    }

    final boolean shouldImageBeCopied(int n, int n2, RenderedImage renderedImage) {
        if (!this.byReference) {
            return true;
        }
        return !(VirtualUniverse.mc.isD3D() ? n == 6 && this.format == 2 || n == 5 && this.format == 1 || n == 10 && this.format == 10 || this.is4ByteRGBAOr3ByteRGB(renderedImage) : (n2 & 2) != 0 && n == 6 && this.format == 2 || (n2 & 4) != 0 && n == 5 && this.format == 1 || n == 10 && this.format == 10 || this.is4ByteRGBAOr3ByteRGB(renderedImage));
    }

    boolean is4ByteRGBAOr3ByteRGB(RenderedImage renderedImage) {
        boolean bl = false;
        int n = this.getImageType(renderedImage);
        if (n != 0) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5) {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl3 = true;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray2[n4] != 8) {
                        bl3 = false;
                        break;
                    }
                    ++n4;
                }
                if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                    if (n3 == 3) {
                        if (this.format == 1) {
                            bl = true;
                        }
                    } else if (nArray[3] == 3 && !bl2 && this.format == 2) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    final int getImageType(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getType();
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n2 != 5) {
            if (n2 == 6 && colorModel instanceof ComponentColorModel) {
                if (sampleModel.getDataType() == 0) {
                    n = 10;
                } else if (sampleModel.getDataType() == 1) {
                    n = 11;
                }
            }
        } else {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl2 = true;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray2[n4] != 8) {
                        bl2 = false;
                        break;
                    }
                    ++n4;
                }
                if (bl2 && nArray[0] == n3 - 1 && nArray[1] == n3 - 2 && nArray[2] == n3 - 3) {
                    if (n3 == 3) {
                        n = 5;
                    } else if (nArray[3] == 0) {
                        n = bl ? 7 : 6;
                    }
                }
            }
        }
        return n;
    }

    final int getStoredFormat(int n, RenderedImage renderedImage) {
        int n2 = 0;
        switch (n) {
            case 6: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 4;
                break;
            }
            case 11: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 32;
                break;
            }
            case 0: {
                if (!this.is4ByteRGBAOr3ByteRGB(renderedImage)) break;
                SampleModel sampleModel = renderedImage.getSampleModel();
                if (sampleModel.getNumBands() == 3) {
                    n2 = 64;
                    break;
                }
                n2 = 1;
                break;
            }
        }
        return n2;
    }

    final void set(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            this.set((BufferedImage)renderedImage);
        } else {
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            if (n != this.width) {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
            }
            if (n2 != this.height) {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
            }
            if (!this.byReference || this.byReference && this.willBeCopied(renderedImage)) {
                int n3 = n2 * n * this.bytesPerPixelStored;
                if (this.usedByTexture || !this.usedByRaster) {
                    if (this.imageYup == null || this.imageYup.length < n3) {
                        this.imageYup = new byte[n3];
                    }
                    this.copyImage(renderedImage, this.imageYup, true, 0);
                    this.imageYupClass = 1;
                    this.storedFormat = this.internalFormat;
                    this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                }
                if (this.usedByRaster) {
                    if (this.imageYdown == null || this.imageYdown.length < n3) {
                        this.imageYdown = new byte[n3];
                    }
                    if (this.imageYup != null) {
                        this.setImageYdown(this.imageYup, this.imageYdown);
                    } else {
                        this.copyImage(renderedImage, this.imageYdown, false, 0);
                    }
                    this.imageYdownClass = 1;
                    this.storedFormat = this.internalFormat;
                    this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                }
                if (this.byReference) {
                    this.geomLock.getLock();
                    this.bImage[0] = renderedImage;
                    this.imageYupCacheDirty = !this.usedByTexture && this.usedByRaster;
                    this.imageYdownCacheDirty = !this.usedByRaster;
                    this.geomLock.unLock();
                } else {
                    this.imageDirty[0] = true;
                }
            } else {
                this.geomLock.getLock();
                this.imageYupCacheDirty = true;
                this.imageYdownCacheDirty = true;
                this.bImage[0] = renderedImage;
                this.geomLock.unLock();
            }
        }
        if (this.source.isLive()) {
            this.freeSurface();
        }
    }

    final BufferedImage getImage() {
        if (!this.byReference && this.imageDirty[0]) {
            this.imageDirty[0] = false;
            this.retrieveBufferedImage(0);
        }
        return (BufferedImage)this.bImage[0];
    }

    final void setRasterRef() {
        if (this.usedByRaster) {
            return;
        }
        this.usedByRaster = true;
        if (this.format == 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained2"));
        }
        if (!this.byReference) {
            this.storedFormat = this.internalFormat;
            this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            if (this.imageYdown == null && this.imageYup != null) {
                this.imageYdown = new byte[this.height * this.width * this.bytesPerPixelStored];
                this.setImageYdown(this.imageYup, this.imageYdown);
                this.imageYdownClass = 1;
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYdownCacheDirty) {
                if (this.imageYdown == null) {
                    this.storedFormat = this.internalFormat;
                    this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                    this.imageYdown = new byte[this.height * this.width * this.bytesPerPixelStored];
                    if (this.imageYup != null) {
                        this.setImageYdown(this.imageYup, this.imageYdown);
                    } else if (this.bImage[0] instanceof BufferedImage) {
                        this.copyImage((BufferedImage)this.bImage[0], this.imageYdown, false, 0);
                    } else {
                        this.copyImage(this.bImage[0], this.imageYdown, false, 0);
                    }
                    this.imageYdownClass = 1;
                }
                this.imageYdownCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYdownCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final void setTextureRef() {
        if (this.usedByTexture) {
            return;
        }
        this.usedByTexture = true;
        if (!this.byReference) {
            this.storedFormat = this.internalFormat;
            this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            if (this.imageYup == null && this.imageYdown != null) {
                this.imageYup = new byte[this.height * this.width * this.bytesPerPixelStored];
                this.setImageYup(this.imageYdown, this.imageYup);
                this.imageYupClass = 1;
            }
            if (!this.usedByRaster) {
                this.imageYdown = null;
                this.imageYdownAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYupCacheDirty) {
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (this.imageYup == null) {
                    this.imageYup = new byte[this.height * this.width * this.bytesPerPixelStored];
                    if (this.imageYdown != null) {
                        this.setImageYup(this.imageYdown, this.imageYup);
                    } else if (this.bImage[0] instanceof BufferedImage) {
                        this.copyImage((BufferedImage)this.bImage[0], this.imageYup, true, 0);
                    } else {
                        this.copyImage(this.bImage[0], this.imageYup, true, 0);
                    }
                    this.imageYupClass = 1;
                }
                this.imageYupCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYupCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final void setImageYdown(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerPixelStored;
        int n2 = (this.height - 1) * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 -= n;
            n3 += n;
        }
    }

    final void copyImage(RenderedImage renderedImage, byte[] byArray, boolean bl) {
        int n;
        int n2 = renderedImage.getNumXTiles();
        int n3 = renderedImage.getNumYTiles();
        int n4 = renderedImage.getTileWidth();
        int n5 = renderedImage.getTileHeight();
        int n6 = n4 * this.bytesPerPixelStored;
        int n7 = renderedImage.getMinTileX();
        int n8 = renderedImage.getMinTileY();
        int n9 = 0;
        int n10 = n5 * n4 * n2 * this.bytesPerPixelStored;
        if (bl) {
            n9 = this.width * this.bytesPerPixelStored;
            n = (this.height - 1) * n9;
            n9 = -n9;
        } else {
            n = 0;
            n9 = this.width * this.bytesPerPixelStored;
        }
        int n11 = renderedImage.getMinX();
        int n12 = renderedImage.getMinY();
        int n13 = renderedImage.getTileGridXOffset();
        int n14 = renderedImage.getTileGridYOffset();
        int n15 = n7 * n4 + n13 + n4;
        int n16 = n8 * n5 + n14 + n5;
        int n17 = this.width;
        int n18 = this.height;
        int n19 = n15 - n11;
        int n20 = n16 - n12;
        if (n17 < n19) {
            n19 = n17;
        }
        if (n18 < n20) {
            n20 = n18;
        }
        int n21 = n19;
        int n22 = (n4 - n19) * this.bytesPerPixelStored;
        int n23 = n4 * (n5 - n20) * this.bytesPerPixelStored;
        int n24 = 0;
        int n25 = n22 + n23;
        int n26 = n8;
        while (n26 < n8 + n3) {
            int n27 = n;
            n19 = n21;
            n17 = this.width;
            int n28 = n7;
            while (n28 < n7 + n2) {
                Raster raster = renderedImage.getTile(n28, n26);
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n29 = n27;
                n24 = n19 * this.bytesPerPixelStored;
                int n30 = 0;
                while (n30 < n20) {
                    System.arraycopy(byArray2, n25, byArray, n29, n24);
                    n25 += n6;
                    n29 += n9;
                    ++n30;
                }
                n25 = n23;
                n27 += n19 * this.bytesPerPixelStored;
                n19 = (n17 -= n19) < n4 ? n17 : n4;
                ++n28;
            }
            n25 = n22;
            n23 = 0;
            n += n20 * n9;
            n20 = (n18 -= n20) < n5 ? n18 : n5;
            ++n26;
        }
    }

    final void setImageYup(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerPixelStored;
        int n2 = 0;
        int n3 = (this.height - 1) * n;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 += n;
            n3 -= n;
        }
    }

    final void evaluateExtensions(int n) {
        RenderedImage renderedImage = this.bImage[0];
        if (!this.imageYupCacheDirty && !this.imageYdownCacheDirty) {
            return;
        }
        int n2 = this.getImageType(renderedImage);
        if (this.usedByTexture || !this.usedByRaster) {
            if (!this.imageYupCacheDirty) {
                this.evaluateRaster(n2, n);
                return;
            }
            if (this.shouldImageBeCopied(n2, n, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelStored;
                if (this.imageYup == null || !this.imageYupAllocated) {
                    this.imageYup = new byte[n3];
                    this.imageYupAllocated = true;
                }
                this.copyImage(renderedImage, this.imageYup, true, 0);
                this.imageYupClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                this.imageYupCacheDirty = false;
            } else {
                if (!this.imageYupCacheDirty) {
                    this.evaluateRaster(n2, n);
                    return;
                }
                this.storedFormat = this.getStoredFormat(n2, renderedImage);
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (!this.yUp) {
                    this.storeTextureImageWithFlip(renderedImage);
                } else if (renderedImage instanceof BufferedImage) {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                    this.imageYup = byArray;
                    this.imageYupAllocated = false;
                    this.imageYupClass = 1;
                } else {
                    this.numXTiles = renderedImage.getNumXTiles();
                    this.numYTiles = renderedImage.getNumYTiles();
                    this.tilew = renderedImage.getTileWidth();
                    this.tileh = renderedImage.getTileHeight();
                    this.minTileX = renderedImage.getMinTileX();
                    this.minTileY = renderedImage.getMinTileY();
                    this.minX = renderedImage.getMinX();
                    this.minY = renderedImage.getMinY();
                    this.tileGridXOffset = renderedImage.getTileGridXOffset();
                    this.tileGridYOffset = renderedImage.getTileGridYOffset();
                    this.imageYupAllocated = false;
                    this.imageYupClass = 2;
                    this.imageYup = null;
                }
            }
            if (!this.usedByRaster) {
                this.imageYdown = null;
                this.imageYdownAllocated = false;
            }
        }
        this.evaluateRaster(n2, n);
    }

    void evaluateRaster(int n, int n2) {
        RenderedImage renderedImage = this.bImage[0];
        if (this.usedByRaster) {
            if (!this.imageYdownCacheDirty) {
                return;
            }
            if (this.shouldImageBeCopied(n, n2, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelStored;
                if (this.imageYdown == null || !this.imageYdownAllocated) {
                    this.imageYdown = new byte[n3];
                    this.imageYdownAllocated = true;
                }
                if (this.imageYup != null) {
                    this.setImageYdown(this.imageYup, this.imageYdown);
                } else {
                    this.copyImage(renderedImage, this.imageYdown, false, 0);
                }
                this.imageYdownCacheDirty = false;
                this.imageYdownClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            } else {
                if (!this.imageYdownCacheDirty) {
                    return;
                }
                this.storedFormat = this.getStoredFormat(n, renderedImage);
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (this.yUp) {
                    this.storeRasterImageWithFlip(renderedImage);
                } else if (renderedImage instanceof BufferedImage) {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                    this.imageYdown = byArray;
                    this.imageYdownAllocated = false;
                    this.imageYdownClass = 1;
                } else {
                    if (this.imageYdown == null || !this.imageYdownAllocated) {
                        int n4 = this.width * this.height * this.bytesPerPixelStored;
                        this.imageYdown = new byte[n4];
                        this.imageYdownAllocated = true;
                    }
                    this.imageYdownClass = 1;
                    this.imageYdownCacheDirty = false;
                    this.copyImage(renderedImage, this.imageYdown, false);
                }
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        }
    }

    void storeRasterImageWithFlip(RenderedImage renderedImage) {
        this.storedFormat = this.getStoredFormat(this.getImageType(renderedImage), renderedImage);
        this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
        if (renderedImage instanceof BufferedImage) {
            if (this.imageYdown == null || !this.imageYdownAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYdown = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
            this.setImageYdown(byArray, this.imageYdown);
        } else {
            if (this.imageYdown == null || !this.imageYdownAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYdown = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            this.copyImage(renderedImage, this.imageYdown, true);
        }
    }

    void storeTextureImageWithFlip(RenderedImage renderedImage) {
        this.storedFormat = this.getStoredFormat(this.getImageType(renderedImage), renderedImage);
        this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
        if (renderedImage instanceof BufferedImage) {
            byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.setImageYup(byArray, this.imageYup);
            this.imageYupCacheDirty = false;
        } else {
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.copyImage(renderedImage, this.imageYup, true);
            this.imageYupCacheDirty = false;
        }
    }

    void setLive(boolean bl, int n) {
        super.setLive(bl, n);
        this.surfaceDirty = 1;
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.refCount <= 0) {
            this.surfaceDirty = 2;
            this.freeSurface();
        }
    }

    void freeSurface() {
        if (VirtualUniverse.mc.isD3D()) {
            this.freeD3DSurface(this.hashId);
        }
    }

    protected void finalize() {
        this.freeSurface();
    }
}

