/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class GeometryStripArrayRetained
extends GeometryArrayRetained {
    int[] stripVertexCounts;
    int[] stripStartIndices;
    int[] compileNumStrips;
    int[] compileStripCountOffset;

    GeometryStripArrayRetained() {
    }

    void setStripVertexCounts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        this.geomLock.getLock();
        this.stripVertexCounts = new int[n];
        this.stripStartIndices = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.stripVertexCounts[n3] = nArray[n3];
            n2 += nArray[n3];
            ++n3;
        }
        if (n2 != this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArrayRetained0"));
        }
        if (this.initialVertexIndex + n2 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryStripArrayRetained0"));
        }
        this.stripStartIndices[0] = 0;
        n3 = 0;
        while (n3 < n - 1) {
            this.stripStartIndices[n3 + 1] = this.stripStartIndices[n3] + nArray[n3];
            ++n3;
        }
        this.geomLock.unLock();
    }

    void unIndexify(IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float[] fArray = null;
        if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryStripArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryStripArrayRetained.vertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 4;
                }
            } else if ((indexedGeometryStripArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryStripArrayRetained.interLeavedVertexData;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n4 = 4;
                } else if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 3;
                }
            }
            int n5 = 0;
            while (n5 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                int n6 = 0;
                while (n6 < indexedGeometryStripArrayRetained.stripIndexCounts[n5]) {
                    int n7 = n6 + n3;
                    n = n7 * this.stride;
                    if ((this.vertexFormat & 2) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexNormal[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                    }
                    if (n4 == 4) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                    } else if (n4 == 3) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexColor[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n4);
                        this.vertexData[n + this.colorOffset + 3] = 1.0f;
                    }
                    if ((this.vertexFormat & 0x60) != 0) {
                        int n8 = 0;
                        while (n8 < this.texCoordSetCount) {
                            System.arraycopy(fArray, ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n8])[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset + indexedGeometryStripArrayRetained.texCoordSetMapOffset[n8], this.vertexData, n + this.textureOffset + this.texCoordSetMapOffset[n8], this.texCoordStride);
                            ++n8;
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        System.arraycopy(fArray, indexedGeometryStripArrayRetained.indexCoord[n7] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                    }
                    ++n6;
                }
                n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n5];
                ++n5;
            }
        } else {
            int n9;
            int n10;
            int n11;
            if ((this.vertexFormat & 2) != 0) {
                n3 = 0;
                n = this.normalOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefNormals, indexedGeometryStripArrayRetained.indexNormal[n9] * 3, this.vertexData, n, 3);
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 2048: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexNormal[n10 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.v3fRefNormals[n9].z;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n3 = 0;
                n = this.colorOffset;
                int n12 = 3;
                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                    n12 = 4;
                }
                switch (indexedGeometryStripArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                if ((indexedGeometryStripArrayRetained.vertexFormat & 8) != 0) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n9] * n12, this.vertexData, n, 4);
                                } else {
                                    System.arraycopy(indexedGeometryStripArrayRetained.floatRefColors, indexedGeometryStripArrayRetained.indexColor[n9] * n12, this.vertexData, n, 3);
                                    this.vertexData[n + 3] = 1.0f;
                                }
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 32: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n3] * n12;
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 1] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 2] & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (indexedGeometryStripArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryStripArrayRetained.byteRefColors[n9 + 3] & 0xFF) * 0.003921569f : 1.0f;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 64: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c3fRefColors[n9].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c3fRefColors[n9].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c3fRefColors[n9].z;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 128: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.c4fRefColors[n9].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.c4fRefColors[n9].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.c4fRefColors[n9].z;
                                this.vertexData[n + 3] = indexedGeometryStripArrayRetained.c4fRefColors[n9].w;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 256: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c3bRefColors[n9].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = 1.0f;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 512: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexColor[n10 + n3];
                                this.vertexData[n] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].x & 0xFF) * 0.003921569f;
                                this.vertexData[n + 1] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].y & 0xFF) * 0.003921569f;
                                this.vertexData[n + 2] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].z & 0xFF) * 0.003921569f;
                                this.vertexData[n + 3] = (float)(indexedGeometryStripArrayRetained.c4bRefColors[n9].w & 0xFF) * 0.003921569f;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x60) != 0) {
                n3 = 0;
                n = this.textureOffset;
                switch (indexedGeometryStripArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        int n13;
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                n13 = 0;
                                n2 = n;
                                while (n13 < this.texCoordSetCount) {
                                    System.arraycopy(indexedGeometryStripArrayRetained.refTexCoords[n13], ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n13])[n9] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                    n2 += this.texCoordStride;
                                    ++n13;
                                }
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 8192: {
                        int n14;
                        int n13;
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                n13 = 0;
                                n2 = n;
                                while (n13 < this.texCoordSetCount) {
                                    n14 = ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n13])[n9];
                                    this.vertexData[n2] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n13])[n14].x;
                                    this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryStripArrayRetained.refTexCoords[n13])[n14].y;
                                    n2 += this.texCoordStride;
                                    ++n13;
                                }
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 16384: {
                        int n14;
                        int n13;
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                n13 = 0;
                                n2 = n;
                                while (n13 < this.texCoordSetCount) {
                                    n14 = ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n13])[n9];
                                    this.vertexData[n2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n13])[n14].x;
                                    this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n13])[n14].y;
                                    this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryStripArrayRetained.refTexCoords[n13])[n14].z;
                                    n2 += this.texCoordStride;
                                    ++n13;
                                }
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                n3 = 0;
                switch (indexedGeometryStripArrayRetained.vertexType & 0xF) {
                    case 1: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = n10 + n3;
                                System.arraycopy(indexedGeometryStripArrayRetained.floatRefCoords, indexedGeometryStripArrayRetained.indexCoord[n9] * 3, this.vertexData, n, 3);
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 2: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n3] * 3;
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9];
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9 + 1];
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.doubleRefCoords[n9 + 2];
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 4: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n3];
                                this.vertexData[n] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].x;
                                this.vertexData[n + 1] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].y;
                                this.vertexData[n + 2] = indexedGeometryStripArrayRetained.p3fRefCoords[n9].z;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                    case 8: {
                        n11 = 0;
                        while (n11 < indexedGeometryStripArrayRetained.stripIndexCounts.length) {
                            n10 = 0;
                            while (n10 < indexedGeometryStripArrayRetained.stripIndexCounts[n11]) {
                                n9 = indexedGeometryStripArrayRetained.indexCoord[n10 + n3];
                                this.vertexData[n] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].x;
                                this.vertexData[n + 1] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].y;
                                this.vertexData[n + 2] = (float)indexedGeometryStripArrayRetained.p3dRefCoords[n9].z;
                                n += this.stride;
                                ++n10;
                            }
                            n3 += indexedGeometryStripArrayRetained.stripIndexCounts[n11];
                            ++n11;
                        }
                        break;
                    }
                }
            }
        }
    }

    void updateD3Ddata(GeometryArrayRetained geometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        GeometryStripArrayRetained geometryStripArrayRetained = (GeometryStripArrayRetained)geometryArrayRetained;
        int n3 = 0;
        while (n3 < this.stripVertexCounts.length) {
            int n4;
            this.vertexData[n++] = this.stripVertexCounts[n3];
            if ((geometryStripArrayRetained.vertexFormat & 4) != 0) {
                if ((geometryStripArrayRetained.isDirty & 4) != 0) {
                    n4 = n2 * geometryStripArrayRetained.stride + geometryStripArrayRetained.colorOffset;
                    this.vertexData[n] = geometryStripArrayRetained.vertexData[n4];
                    this.vertexData[n + 1] = geometryStripArrayRetained.vertexData[n4 + 1];
                    this.vertexData[n + 2] = geometryStripArrayRetained.vertexData[n4 + 2];
                    this.vertexData[n + 3] = geometryStripArrayRetained.vertexData[n4 + 3];
                }
                n += 4;
            }
            int n5 = 0;
            while (n5 < this.stripVertexCounts[n3]) {
                if ((geometryStripArrayRetained.isDirty & 1) != 0) {
                    n4 = n2 * geometryStripArrayRetained.stride + geometryStripArrayRetained.coordinateOffset;
                    this.vertexData[n] = geometryStripArrayRetained.vertexData[n4];
                    this.vertexData[n + 1] = geometryStripArrayRetained.vertexData[n4 + 1];
                    this.vertexData[n + 2] = geometryStripArrayRetained.vertexData[n4 + 2];
                }
                n += 3;
                if ((geometryStripArrayRetained.isDirty & 2) != 0) {
                    if ((geometryStripArrayRetained.vertexFormat & 2) != 0) {
                        n4 = n2 * geometryStripArrayRetained.stride + geometryStripArrayRetained.normalOffset;
                        this.vertexData[n] = geometryStripArrayRetained.vertexData[n4];
                        this.vertexData[n + 1] = geometryStripArrayRetained.vertexData[n4 + 1];
                        this.vertexData[n + 2] = geometryStripArrayRetained.vertexData[n4 + 2];
                    } else {
                        this.vertexData[n] = 0.0f;
                        this.vertexData[n + 1] = 0.0f;
                        this.vertexData[n + 2] = 0.0f;
                    }
                }
                n += 3;
                if ((geometryStripArrayRetained.isDirty & 8) != 0) {
                    if ((geometryStripArrayRetained.vertexFormat & 0x60) != 0) {
                        n4 = n2 * geometryStripArrayRetained.stride + geometryStripArrayRetained.textureOffset;
                        this.vertexData[n] = geometryStripArrayRetained.vertexData[n4];
                        this.vertexData[n + 1] = geometryStripArrayRetained.vertexData[n4 + 1];
                    } else {
                        this.vertexData[n] = 0.0f;
                        this.vertexData[n + 1] = 0.0f;
                    }
                }
                n += 2;
                ++n5;
                ++n2;
            }
            ++n3;
        }
    }

    int getNumStrips() {
        return this.stripVertexCounts.length;
    }

    void getStripVertexCounts(int[] nArray) {
        int n = this.stripVertexCounts.length;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.stripVertexCounts[n2];
            ++n2;
        }
    }

    void getStripVertexCounts(int n, int[] nArray) {
        int n2 = this.compileStripCountOffset[n];
        int n3 = this.compileNumStrips[n];
        System.arraycopy(this.stripVertexCounts, n2, nArray, 0, n3);
    }

    int getNumStrips(int n) {
        return this.compileNumStrips[n];
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((GeometryStripArrayRetained)arrayList.get((int)n3)).stripVertexCounts.length;
            ++n3;
        }
        this.stripVertexCounts = new int[n2];
        this.stripStartIndices = new int[n2];
        int n4 = 0;
        int n5 = 0;
        this.compileNumStrips = new int[n];
        this.compileStripCountOffset = new int[n];
        int n6 = 0;
        while (n6 < n) {
            int n7;
            GeometryStripArrayRetained geometryStripArrayRetained = (GeometryStripArrayRetained)arrayList.get(n6);
            int[] nArray = geometryStripArrayRetained.stripVertexCounts;
            int[] nArray2 = geometryStripArrayRetained.stripStartIndices;
            this.compileNumStrips[n6] = n7 = nArray.length;
            this.compileStripCountOffset[n6] = n4;
            System.arraycopy(nArray, 0, this.stripVertexCounts, n4, n7);
            int n8 = 0;
            while (n8 < n7) {
                this.stripStartIndices[n8 + n4] = nArray2[n8] + n5;
                ++n8;
            }
            n4 += n7;
            n5 += geometryStripArrayRetained.vertexData.length / this.stride;
            ++n6;
        }
        super.mergeGeometryArrays(arrayList);
    }
}

