/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

abstract class GeometryRetained
extends NodeComponentRetained {
    static final int GEO_TYPE_NONE = -1;
    static final int GEO_TYPE_QUAD_SET = 1;
    static final int GEO_TYPE_TRI_SET = 2;
    static final int GEO_TYPE_POINT_SET = 3;
    static final int GEO_TYPE_LINE_SET = 4;
    static final int GEO_TYPE_TRI_STRIP_SET = 5;
    static final int GEO_TYPE_TRI_FAN_SET = 6;
    static final int GEO_TYPE_LINE_STRIP_SET = 7;
    static final int GEO_TYPE_INDEXED_QUAD_SET = 8;
    static final int GEO_TYPE_INDEXED_TRI_SET = 9;
    static final int GEO_TYPE_INDEXED_POINT_SET = 10;
    static final int GEO_TYPE_INDEXED_LINE_SET = 11;
    static final int GEO_TYPE_INDEXED_TRI_STRIP_SET = 12;
    static final int GEO_TYPE_INDEXED_TRI_FAN_SET = 13;
    static final int GEO_TYPE_INDEXED_LINE_STRIP_SET = 14;
    static final int GEO_TYPE_RASTER = 15;
    static final int GEO_TYPE_TEXT3D = 16;
    static final int GEO_TYPE_COMPRESSED = 17;
    static final int GEO_TYPE_TOTAL = 17;
    static final int GEO_TYPE_GEOMETRYARRAY = 14;
    BoundingBox geoBounds = new BoundingBox();
    int geoType = -1;
    int nativeId = -1;
    int isDirty = 65535;
    GeometryLock geomLock = new GeometryLock();
    Object liveStateLock = new Object();
    GeometryRetained mirrorGeometry = null;
    boolean isEditable = true;
    ArrayList universeList = new ArrayList();
    ArrayList userLists = new ArrayList();
    boolean noAlpha = false;

    GeometryRetained() {
    }

    abstract void update();

    private static int classType(GeometryRetained geometryRetained) {
        switch (geometryRetained.geoType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                return 1;
            }
            case 3: 
            case 10: {
                return 2;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 17: {
                return 6;
            }
        }
        return -1;
    }

    boolean isEquivalenceClass(GeometryRetained geometryRetained) {
        return GeometryRetained.classType(this) == GeometryRetained.classType(geometryRetained);
    }

    void addUser(Shape3DRetained shape3DRetained) {
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList arrayList = this.universeList;
        synchronized (arrayList) {
            if (this.universeList.contains(shape3DRetained.universe)) {
                int n = this.universeList.indexOf(shape3DRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.userLists.get(n);
                arrayList2.add(shape3DRetained);
            } else {
                this.universeList.add(shape3DRetained.universe);
                ArrayList<Shape3DRetained> arrayList3 = new ArrayList<Shape3DRetained>();
                arrayList3.add(shape3DRetained);
                this.userLists.add(arrayList3);
            }
        }
    }

    void removeUser(Shape3DRetained shape3DRetained) {
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList arrayList = this.universeList;
        synchronized (arrayList) {
            int n = this.universeList.indexOf(shape3DRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.userLists.get(n);
            arrayList2.remove(arrayList2.indexOf(shape3DRetained));
            if (arrayList2.size() == 0) {
                this.userLists.remove(n);
                this.universeList.remove(n);
            }
        }
    }

    public void updateObject() {
        this.update();
    }

    abstract void computeBoundingBox();

    void setLive(boolean bl, int n) {
        this.doSetLive(bl, n);
        super.markAsLive();
    }

    void doSetLive(boolean bl, int n) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("GeometryRetained0"));
        }
        this.update();
        this.computeBoundingBox();
        super.doSetLive(bl, n);
    }

    abstract void execute(Canvas3D var1, RenderAtom var2, boolean var3, boolean var4, float var5, boolean var6, int var7, boolean var8, int[] var9, int var10);

    int getVertexFormat() {
        return 0;
    }

    static void processDistance(PickRay pickRay, double[] dArray, Transform3D transform3D, Point3d point3d, Vector3d vector3d) {
        transform3D.transform(point3d);
        vector3d.x = point3d.x - pickRay.origin.x;
        vector3d.y = point3d.y - pickRay.origin.y;
        vector3d.z = point3d.z - pickRay.origin.z;
        dArray[0] = vector3d.length();
    }

    boolean intersect(PickShape pickShape) {
        throw new RuntimeException(J3dI18N.getString("GeometryRetained1"));
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        throw new RuntimeException(J3dI18N.getString("GeometryRetained1"));
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        return false;
    }

    boolean canBeInDisplayList(boolean bl, boolean bl2) {
        return VirtualUniverse.mc.isVertexBuffer && !this.isEditable && !bl && !bl2 && this instanceof GeometryArrayRetained && (((GeometryArrayRetained)this).vertexFormat & 0x80) == 0;
    }
}

