/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.LOD;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class DistanceLOD
extends LOD {
    private double[] distances;
    private Point3f position = new Point3f(0.0f, 0.0f, 0.0f);

    public DistanceLOD() {
        this.distances = new double[1];
        this.distances[0] = 0.0;
    }

    public DistanceLOD(float[] fArray) {
        this.distances = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            this.distances[n] = fArray[n];
            ++n;
        }
    }

    public DistanceLOD(float[] fArray, Point3f point3f) {
        this.distances = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            this.distances[n] = fArray[n];
            ++n;
        }
        this.position.set((Tuple3f)point3f);
    }

    public void setPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            ((NodeRetained)this.retained).staticTransform.transform.transform(point3f, this.position);
        } else {
            this.position.set((Tuple3f)point3f);
        }
    }

    public void getPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            Transform3D transform3D = ((NodeRetained)this.retained).staticTransform.getInvTransform();
            transform3D.transform(this.position, point3f);
        } else {
            point3f.set((Tuple3f)this.position);
        }
    }

    public int numDistances() {
        return this.distances.length;
    }

    public double getDistance(int n) {
        return this.distances[n];
    }

    public void setDistance(int n, double d) {
        this.distances[n] = d;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    public void processStimulus(Enumeration enumeration) {
        int n;
        double d = 0.0;
        int n2 = 0;
        Transform3D transform3D = new Transform3D();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        transform3D.set(((NodeRetained)this.retained).getCurrentLocalToVworld());
        transform3D.transform(this.position, point3f);
        View view = this.getView();
        if (view == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        ViewPlatform viewPlatform = view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        point3f2.x = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.x;
        point3f2.y = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.y;
        point3f2.z = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.z;
        d = point3f.distance(point3f2);
        d /= transform3D.getDistanceScale();
        int n3 = this.numSwitches();
        n2 = this.distances.length;
        if (d <= this.distances[0]) {
            n2 = 0;
        } else {
            n = 1;
            while (n < this.distances.length) {
                if (d > this.distances[n - 1] && d <= this.distances[n]) {
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        n = n3 - 1;
        while (n >= 0) {
            Switch switch_ = this.getSwitch(n);
            if (((SwitchRetained)switch_.retained).getWhichChild() != n2) {
                switch_.setWhichChild(n2);
            }
            --n;
        }
        this.wakeupOn(this.wakeupFrame);
    }

    public Node cloneNode(boolean bl) {
        DistanceLOD distanceLOD = new DistanceLOD();
        distanceLOD.duplicateNode(this, bl);
        return distanceLOD;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        DistanceLOD distanceLOD = (DistanceLOD)node;
        int n = distanceLOD.numDistances();
        this.distances = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.setDistance(n2, distanceLOD.getDistance(n2));
            ++n2;
        }
        Point3f point3f = new Point3f();
        distanceLOD.getPosition(point3f);
        this.setPosition(point3f);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

