/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompressedGeometryHeader;
import javax.media.j3d.GeometryDecompressorRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

class CompressedGeometryRetained
extends GeometryRetained {
    private static final int HEADER_LENGTH = 48;
    private static final int HEADER_MAJOR_VERSION_OFFSET = 0;
    private static final int HEADER_MINOR_VERSION_OFFSET = 1;
    private static final int HEADER_MINOR_MINOR_VERSION_OFFSET = 2;
    private static final int HEADER_BUFFER_TYPE_OFFSET = 3;
    private static final int HEADER_BUFFER_DATA_OFFSET = 4;
    static final byte TYPE_POINT = 1;
    static final byte TYPE_LINE = 2;
    static final byte TYPE_TRIANGLE = 4;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int packedVersion;
    int bufferType;
    int bufferContents;
    int renderFlags;
    int offset;
    int size;
    byte[] compressedGeometry;
    private boolean byReference = false;
    private byte[] originalCompressedGeometry = null;
    private static boolean hardwareDecompression = false;
    private GeometryRetained pickGeometry = null;

    native boolean decompressByRef(int var1);

    native boolean decompressHW(int var1, int var2, int var3);

    native void execute(int var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8);

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int[] nArray, int n2) {
        this.execute(canvas3D.ctx, this.packedVersion, this.bufferType, this.bufferContents, this.renderFlags, this.offset, this.size, this.compressedGeometry);
    }

    CompressedGeometryRetained() {
        this.geoType = 17;
        this.geoBounds.setUpper(1.0, 1.0, 1.0);
        this.geoBounds.setLower(-1.0, -1.0, -1.0);
    }

    void computeBoundingBox() {
    }

    void update() {
        this.isDirty = 0;
    }

    boolean isByReference() {
        return this.byReference;
    }

    private void createByCopy(byte[] byArray) {
        this.compressedGeometry = new byte[48 + this.size];
        this.compressedGeometry[0] = (byte)this.majorVersionNumber;
        this.compressedGeometry[1] = (byte)this.minorVersionNumber;
        this.compressedGeometry[2] = (byte)this.minorMinorVersionNumber;
        this.compressedGeometry[3] = (byte)this.bufferType;
        this.compressedGeometry[4] = (byte)this.bufferContents;
        System.arraycopy(byArray, this.offset, this.compressedGeometry, 48, this.size);
        this.offset = 48;
    }

    void createCompressedGeometry(CompressedGeometryHeader compressedGeometryHeader, byte[] byArray, boolean bl) {
        this.byReference = bl;
        if (compressedGeometryHeader.lowerBound != null) {
            this.geoBounds.setLower(compressedGeometryHeader.lowerBound);
        }
        if (compressedGeometryHeader.upperBound != null) {
            this.geoBounds.setUpper(compressedGeometryHeader.upperBound);
        }
        this.majorVersionNumber = compressedGeometryHeader.majorVersionNumber;
        this.minorVersionNumber = compressedGeometryHeader.minorVersionNumber;
        this.minorMinorVersionNumber = compressedGeometryHeader.minorMinorVersionNumber;
        this.packedVersion = compressedGeometryHeader.majorVersionNumber << 24 | compressedGeometryHeader.minorVersionNumber << 16 | compressedGeometryHeader.minorMinorVersionNumber << 8;
        switch (compressedGeometryHeader.bufferType) {
            case 0: {
                this.bufferType = 1;
                break;
            }
            case 1: {
                this.bufferType = 2;
                break;
            }
            case 2: {
                this.bufferType = 4;
            }
        }
        this.bufferContents = compressedGeometryHeader.bufferDataPresent;
        this.renderFlags = 0;
        this.size = compressedGeometryHeader.size;
        this.offset = compressedGeometryHeader.start;
        if (bl) {
            this.compressedGeometry = byArray;
            this.originalCompressedGeometry = byArray;
        } else {
            this.createByCopy(byArray);
            this.originalCompressedGeometry = null;
        }
    }

    GeometryRetained getGeometry(boolean bl) {
        if (bl) {
            GeometryDecompressorRetained geometryDecompressorRetained = new GeometryDecompressorRetained();
            this.mirrorGeometry = geometryDecompressorRetained.decompress(this);
            geometryDecompressorRetained.getBoundingBox(this.geoBounds);
            this.pickGeometry = this.mirrorGeometry;
        } else {
            if (hardwareDecompression) {
                return this;
            }
            if (this.decompressHW(0, this.majorVersionNumber, this.minorVersionNumber)) {
                hardwareDecompression = true;
                if (this.isByReference() && !this.decompressByRef(0)) {
                    this.createByCopy(this.compressedGeometry);
                }
                return this;
            }
            GeometryDecompressorRetained geometryDecompressorRetained = new GeometryDecompressorRetained();
            this.mirrorGeometry = geometryDecompressorRetained.decompress(this);
            geometryDecompressorRetained.getBoundingBox(this.geoBounds);
            this.pickGeometry = this.mirrorGeometry;
        }
        return this.mirrorGeometry;
    }

    GeometryRetained getPickGeometry() {
        if (this.pickGeometry != null) {
            return this.pickGeometry;
        }
        GeometryDecompressorRetained geometryDecompressorRetained = new GeometryDecompressorRetained();
        geometryDecompressorRetained.setDecompressPositionsOnly(true);
        this.pickGeometry = geometryDecompressorRetained.decompress(this);
        geometryDecompressorRetained.getBoundingBox(this.geoBounds);
        return this.pickGeometry;
    }

    boolean intersect(PickShape pickShape) {
        GeometryRetained geometryRetained = this.getPickGeometry();
        if (geometryRetained == null) {
            return false;
        }
        return geometryRetained.intersect(pickShape);
    }

    boolean intersect(PickRay pickRay, double[] dArray, Point3d point3d) {
        GeometryRetained geometryRetained = this.getPickGeometry();
        if (geometryRetained == null) {
            return false;
        }
        return geometryRetained.intersect(pickRay, dArray, point3d);
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        GeometryRetained geometryRetained = this.getPickGeometry();
        if (geometryRetained == null) {
            return false;
        }
        return geometryRetained.intersect(transform3D, point3dArray);
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        GeometryRetained geometryRetained = this.getPickGeometry();
        if (geometryRetained == null) {
            return false;
        }
        return geometryRetained.intersect(transform3D, bounds);
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        GeometryRetained geometryRetained2 = this.getPickGeometry();
        if (geometryRetained2 == null) {
            return false;
        }
        return geometryRetained2.intersect(transform3D, transform3D2, geometryRetained);
    }

    int getVertexFormat() {
        int n = 1;
        if ((this.bufferContents & 1) != 0) {
            n |= 2;
        }
        if ((this.bufferContents & 2) != 0) {
            n |= 4;
        }
        if ((this.bufferContents & 4) != 0) {
            n |= 8;
        }
        return n;
    }

    int getBufferType() {
        switch (this.bufferType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    void copy(byte[] byArray) {
        System.arraycopy(this.compressedGeometry, this.offset, byArray, 0, this.size);
    }

    byte[] getReference() {
        return this.originalCompressedGeometry;
    }

    void duplicate(CompressedGeometryRetained compressedGeometryRetained) {
        compressedGeometryRetained.majorVersionNumber = this.majorVersionNumber;
        compressedGeometryRetained.minorVersionNumber = this.minorVersionNumber;
        compressedGeometryRetained.minorMinorVersionNumber = this.minorMinorVersionNumber;
        compressedGeometryRetained.packedVersion = this.packedVersion;
        compressedGeometryRetained.bufferType = this.bufferType;
        compressedGeometryRetained.bufferContents = this.bufferContents;
        compressedGeometryRetained.renderFlags = this.renderFlags;
        compressedGeometryRetained.offset = this.offset;
        compressedGeometryRetained.size = this.size;
        compressedGeometryRetained.geoBounds.setLower(this.geoBounds.lower);
        compressedGeometryRetained.geoBounds.setUpper(this.geoBounds.upper);
        compressedGeometryRetained.pickGeometry = this.pickGeometry;
        compressedGeometryRetained.byReference = this.byReference;
        if (this.byReference) {
            compressedGeometryRetained.compressedGeometry = this.compressedGeometry;
            compressedGeometryRetained.originalCompressedGeometry = this.originalCompressedGeometry;
        } else {
            compressedGeometryRetained.compressedGeometry = new byte[this.compressedGeometry.length];
            System.arraycopy(this.compressedGeometry, 0, compressedGeometryRetained.compressedGeometry, 0, this.compressedGeometry.length);
            compressedGeometryRetained.originalCompressedGeometry = null;
        }
    }
}

