/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.vecmath.Color3f;

public class ColoringAttributes
extends NodeComponent {
    public static final int ALLOW_COLOR_READ = 0;
    public static final int ALLOW_COLOR_WRITE = 1;
    public static final int ALLOW_SHADE_MODEL_READ = 2;
    public static final int ALLOW_SHADE_MODEL_WRITE = 3;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int SHADE_FLAT = 2;
    public static final int SHADE_GOURAUD = 3;

    public ColoringAttributes() {
    }

    public ColoringAttributes(Color3f color3f, int n) {
        ((ColoringAttributesRetained)this.retained).initColor(color3f);
        ((ColoringAttributesRetained)this.retained).initShadeModel(n);
    }

    public ColoringAttributes(float f, float f2, float f3, int n) {
        ((ColoringAttributesRetained)this.retained).initColor(f, f2, f3);
        ((ColoringAttributesRetained)this.retained).initShadeModel(n);
    }

    public void setColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes0"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setColor(color3f);
        } else {
            ((ColoringAttributesRetained)this.retained).initColor(color3f);
        }
    }

    public void setColor(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes0"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setColor(f, f2, f3);
        } else {
            ((ColoringAttributesRetained)this.retained).initColor(f, f2, f3);
        }
    }

    public void getColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes2"));
        }
        ((ColoringAttributesRetained)this.retained).getColor(color3f);
    }

    public void setShadeModel(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes3"));
        }
        if (this.isLive()) {
            ((ColoringAttributesRetained)this.retained).setShadeModel(n);
        } else {
            ((ColoringAttributesRetained)this.retained).initShadeModel(n);
        }
    }

    public int getShadeModel() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ColoringAttributes4"));
        }
        return ((ColoringAttributesRetained)this.retained).getShadeModel();
    }

    void createRetained() {
        this.retained = new ColoringAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.duplicateNodeComponent(this);
        return coloringAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        ColoringAttributesRetained coloringAttributesRetained = (ColoringAttributesRetained)nodeComponent.retained;
        ColoringAttributesRetained coloringAttributesRetained2 = (ColoringAttributesRetained)this.retained;
        Color3f color3f = new Color3f();
        coloringAttributesRetained.getColor(color3f);
        coloringAttributesRetained2.initColor(color3f);
        coloringAttributesRetained2.initShadeModel(coloringAttributesRetained.getShadeModel());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ColoringAttributes:");
        String[] stringArray = new String[]{"FASTEST", "NICEST", "SHADE_FLAT", "SHADE_GOURAUD"};
        try {
            Color3f color3f = new Color3f();
            this.getColor(color3f);
            stringBuffer.append("Color=" + color3f);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append("Color=N/A");
        }
        try {
            stringBuffer.append(" ShadeModel=" + stringArray[this.getShadeModel()]);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            stringBuffer.append("ShadeModel=N/A");
        }
        return new String(stringBuffer);
    }
}

