/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.CanvasViewEventCatcher;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.DrawingSurfaceObjectDSI;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.EventCatcher;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3DGraphics2DImpl;
import javax.media.j3d.J3dGraphicsConfig;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.NativeWSInfo;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector4d;

public class Canvas3D
extends Canvas {
    public static final int FIELD_LEFT = 0;
    public static final int FIELD_RIGHT = 1;
    public static final int FIELD_ALL = 2;
    static final int POLYGONATTRS_DIRTY = 1;
    static final int LINEATTRS_DIRTY = 2;
    static final int POINTATTRS_DIRTY = 4;
    static final int MATERIAL_DIRTY = 8;
    static final int TRANSPARENCYATTRS_DIRTY = 16;
    static final int COLORINGATTRS_DIRTY = 32;
    static final int LIGHTBIN_DIRTY = 64;
    static final int LIGHTENABLES_DIRTY = 128;
    static final int AMBIENTLIGHT_DIRTY = 256;
    static final int ATTRIBUTEBIN_DIRTY = 512;
    static final int TEXTUREBIN_DIRTY = 1024;
    static final int TEXTURESETTINGBIN_DIRTY = 2048;
    static final int RENDERMOLECULE_DIRTY = 4096;
    static final int FOG_DIRTY = 8192;
    static final int MODELCLIP_DIRTY = 16384;
    static final int VWORLD_SCALE_DIRTY = 32768;
    static final int RESIZE = 1;
    static final int TOGGLEFULLSCREEN = 2;
    static final int NOCHANGE = 0;
    static final int RECREATED3D = 1;
    static final int RECREATEDDRAW = 2;
    boolean offScreen;
    Point offScreenCanvasLoc;
    Dimension offScreenCanvasSize;
    Point offScreenCanvasClippedLoc;
    Dimension offScreenCanvasClippedSize;
    boolean offScreenRendering;
    boolean waitingForOffScreenRendering;
    ImageComponent2D offScreenBuffer;
    byte[] byteBuffer;
    boolean useSharedCtx;
    boolean stereoAvailable;
    boolean stereoEnable;
    boolean useStereo;
    boolean rightStereoPass;
    int monoscopicViewPolicy;
    boolean doubleBufferAvailable;
    boolean doubleBufferEnable;
    boolean useDoubleBuffer;
    boolean sceneAntialiasingAvailable;
    boolean d3dAntialiasingSet;
    boolean texture3DAvailable;
    int textureColorTableSize;
    boolean multiTexAccelerated;
    int numTexUnitSupported;
    int[] texUnitStateMap;
    boolean textureColorTableAvailable;
    J3dQueryProps queryProps;
    Point3d leftManualEyeInImagePlate;
    Point3d rightManualEyeInImagePlate;
    View view;
    CanvasViewCache canvasViewCache;
    boolean raIsVisible;
    RenderAtom ra;
    static final int STEREO_DIRTY = 1;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 2;
    static final int EYE_IN_IMAGE_PLATE_DIRTY = 4;
    static final int MOVED_OR_RESIZED_DIRTY = 8;
    static final int BACKGROUND_DIRTY = 16;
    int cvDirtyMask;
    boolean resizeGraphics2D;
    boolean isRunning;
    boolean isRunningStatus;
    boolean active;
    boolean visible;
    Screen3D screen;
    boolean imageReady;
    int fogOn;
    GraphicsContext3D graphicsContext3D;
    boolean waiting;
    boolean swapDone;
    J3DGraphics2DImpl graphics2D;
    Object gfxCreationLock;
    Transform3D localToVWorldSrc;
    Transform3D vworldToEc;
    Transform3D vpcToEc;
    int window;
    int vid;
    NativeWSInfo nativeWSobj;
    boolean firstPaintCalled;
    boolean added;
    int ctx;
    long ctxTimeStamp;
    boolean localEyeLightingEnable;
    boolean ctxEyeLightingEnable;
    AppearanceRetained currentAppear;
    MaterialRetained currentMaterial;
    CachedFrustum viewFrustum;
    LightBin lightBin;
    EnvironmentSet environmentSet;
    AttributeBin attributeBin;
    TextureBin textureBin;
    RenderMolecule renderMolecule;
    PolygonAttributesRetained polygonAttributes;
    LineAttributesRetained lineAttributes;
    PointAttributesRetained pointAttributes;
    MaterialRetained material;
    TransparencyAttributesRetained transparency;
    ColoringAttributesRetained coloringAttributes;
    Transform3D modelMatrix;
    TextureRetained texture;
    TextureAttributesRetained texAttrs;
    TexCoordGenerationRetained texCoordGeneration;
    RenderingAttributesRetained renderingAttrs;
    AppearanceRetained appearance;
    int canvasDirty;
    ArrayList dirtyRenderMoleculeList;
    ArrayList dirtyRenderAtomList;
    ArrayList displayListResourceFreeList;
    ArrayList textureIdResourceFreeList;
    int canvasBit;
    Object cvLock;
    Object evaluateLock;
    Object dirtyMaskLock;
    boolean fullScreenMode;
    int reEvaluateCanvasCmd;
    static final int GLOBAL_ALPHA_SUN = 1;
    static final int EXT_ABGR = 2;
    static final int EXT_BGR = 4;
    static final int EXT_RESCALE_NORMAL = 8;
    static final int EXT_MULTI_DRAW_ARRAYS = 16;
    static final int SUN_MULTI_DRAW_ARRAYS = 32;
    static final int SUN_CONSTANT_DATA = 64;
    static final int ARB_MULTITEXTURE = 128;
    static final int SGI_TEXTURE_COLOR_TABLE = 256;
    static final int EXT_TEXTURE3D = 512;
    int extensionsSupported;
    LightRetained[] currentLights;
    boolean depthBufferWriteEnableOverride;
    boolean depthBufferEnableOverride;
    boolean depthBufferWriteEnable;
    boolean vfPlanesValid;
    EventCatcher eventCatcher;
    CanvasViewEventCatcher canvasViewEventCatcher;
    Container parent;
    boolean lightChanged;
    DrawingSurfaceObject drawingSurfaceObject;
    boolean validCtx;
    boolean validCanvas;
    boolean ctxChanged;
    private static GraphicsConfiguration defaultGcfg = null;

    native int getTextureUnitCount(int var1);

    native int getTextureColorTableSize(int var1);

    native int createContext(int var1, int var2, int var3, int var4, boolean var5);

    native int createQueryContext(int var1, int var2, int var3, boolean var4);

    native int destroyContext(int var1, int var2, int var3);

    native int createOffScreenBuffer(int var1, int var2, int var3, int var4, int var5);

    native int destroyOffScreenBuffer(int var1, int var2, int var3);

    native int readOffScreenBuffer(int var1, int var2, int var3, int var4);

    native boolean useSharedCtx();

    native void accum(int var1, float var2);

    native void accumReturn(int var1);

    native void clearAccum(int var1);

    native int getNumCtxLights(int var1);

    native boolean decal1stChildSetup(int var1);

    native void decalNthChildSetup(int var1);

    native void decalReset(int var1, boolean var2);

    native void ctxUpdateEyeLightingEnable(int var1, boolean var2);

    native void setDepthFunc(int var1, int var2);

    native void setBlendFunc(int var1, int var2, int var3);

    native void setFogEnableFlag(int var1, boolean var2);

    native int resizeD3DCanvas(int var1);

    native int toggleFullScreenMode(int var1);

    native void setFullSceneAntialiasing(int var1, boolean var2);

    native void setSpecular(int var1, boolean var2);

    native void setLightEnables(int var1, long var2, int var4);

    native void setSceneAmbient(int var1, float var2, float var3, float var4);

    native void disableFog(int var1);

    native void disableModelClip(int var1);

    native void resetRenderingAttributes(int var1, boolean var2, boolean var3);

    native void resetTextureNative(int var1, int var2);

    native void activeTextureUnitState(int var1, int var2);

    native void resetTexCoordGeneration(int var1);

    native void resetTextureAttributes(int var1);

    native void resetPolygonAttributes(int var1);

    native void resetLineAttributes(int var1);

    native void resetPointAttributes(int var1);

    native void resetTransparency(int var1, int var2, int var3, boolean var4, boolean var5);

    native void resetColoringAttributes(int var1, float var2, float var3, float var4, float var5, boolean var6);

    native void updateMaterial(int var1, float var2, float var3, float var4, float var5);

    native void syncRender(int var1, boolean var2);

    private static synchronized GraphicsConfiguration defaultGraphicsConfiguration() {
        if (defaultGcfg == null) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            defaultGcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(graphicsConfigTemplate3D);
        }
        return defaultGcfg;
    }

    private static synchronized GraphicsConfiguration compatibleGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            System.err.println(J3dI18N.getString("Canvas3D7"));
            return Canvas3D.defaultGraphicsConfiguration();
        }
        if (!J3dGraphicsConfig.isValidPixelFormat(graphicsConfiguration)) {
            System.err.println(J3dI18N.getString("Canvas3D17"));
            return Canvas3D.defaultGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration) {
        this(graphicsConfiguration, false);
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        graphicsConfiguration = Canvas3D.compatibleGraphicsConfiguration(graphicsConfiguration);
        super(graphicsConfiguration);
        this.offScreen = false;
        this.offScreenRendering = false;
        this.waitingForOffScreenRendering = false;
        this.offScreenBuffer = null;
        this.byteBuffer = new byte[1];
        this.useSharedCtx = true;
        this.stereoEnable = true;
        this.rightStereoPass = false;
        this.monoscopicViewPolicy = 2;
        this.doubleBufferEnable = true;
        this.d3dAntialiasingSet = false;
        this.multiTexAccelerated = false;
        this.numTexUnitSupported = 1;
        this.texUnitStateMap = null;
        this.textureColorTableAvailable = false;
        this.leftManualEyeInImagePlate = new Point3d(0.142, 0.135, 0.4572);
        this.rightManualEyeInImagePlate = new Point3d(0.208, 0.135, 0.4572);
        this.view = null;
        this.canvasViewCache = null;
        this.raIsVisible = false;
        this.ra = null;
        this.cvDirtyMask = 31;
        this.resizeGraphics2D = true;
        this.isRunning = true;
        this.isRunningStatus = true;
        this.active = false;
        this.visible = false;
        this.screen = null;
        this.imageReady = false;
        this.fogOn = 0;
        this.graphicsContext3D = null;
        this.waiting = false;
        this.swapDone = false;
        this.graphics2D = null;
        this.gfxCreationLock = new Object();
        this.localToVWorldSrc = null;
        this.vworldToEc = new Transform3D();
        this.window = 0;
        this.vid = 0;
        this.nativeWSobj = new NativeWSInfo();
        this.firstPaintCalled = false;
        this.added = false;
        this.ctx = 0;
        this.ctxTimeStamp = 0L;
        this.localEyeLightingEnable = false;
        this.ctxEyeLightingEnable = false;
        this.currentAppear = new AppearanceRetained();
        this.currentMaterial = new MaterialRetained();
        this.viewFrustum = new CachedFrustum();
        this.lightBin = null;
        this.environmentSet = null;
        this.attributeBin = null;
        this.textureBin = null;
        this.renderMolecule = null;
        this.polygonAttributes = null;
        this.lineAttributes = null;
        this.pointAttributes = null;
        this.material = null;
        this.transparency = null;
        this.coloringAttributes = null;
        this.modelMatrix = null;
        this.texture = null;
        this.texAttrs = null;
        this.texCoordGeneration = null;
        this.renderingAttrs = null;
        this.appearance = null;
        this.canvasDirty = 65535;
        this.dirtyRenderMoleculeList = new ArrayList();
        this.dirtyRenderAtomList = new ArrayList();
        this.displayListResourceFreeList = new ArrayList();
        this.textureIdResourceFreeList = new ArrayList();
        this.canvasBit = 0;
        this.cvLock = new Object();
        this.evaluateLock = new Object();
        this.dirtyMaskLock = new Object();
        this.fullScreenMode = false;
        this.reEvaluateCanvasCmd = 0;
        this.extensionsSupported = 0;
        this.currentLights = null;
        this.depthBufferWriteEnableOverride = false;
        this.depthBufferEnableOverride = false;
        this.depthBufferWriteEnable = true;
        this.vfPlanesValid = false;
        this.lightChanged = false;
        this.validCtx = false;
        this.validCanvas = false;
        this.ctxChanged = false;
        VirtualUniverse.createMC();
        this.drawingSurfaceObject = MasterControl.jvm14 ? new DrawingSurfaceObjectAWT(this, VirtualUniverse.mc.awt) : new DrawingSurfaceObjectDSI(this);
        this.offScreen = bl;
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        this.vid = this.nativeWSobj.getCanvasVid(graphicsConfiguration);
        if (bl) {
            this.screen = new Screen3D(graphicsDevice, bl);
            this.doubleBufferAvailable = false;
            this.stereoAvailable = false;
            this.added = true;
            Object object = this.dirtyMaskLock;
            synchronized (object) {
                this.cvDirtyMask |= 8;
            }
            this.firstPaintCalled = true;
            this.ctx = 0;
            this.evaluateActive();
            this.offScreenCanvasLoc = new Point(0, 0);
            this.offScreenCanvasSize = new Dimension(0, 0);
            this.offScreenCanvasClippedLoc = new Point(0, 0);
            this.offScreenCanvasClippedSize = new Dimension(0, 0);
            this.setLocation(this.offScreenCanvasLoc);
            this.setSize(this.offScreenCanvasSize);
        } else {
            this.eventCatcher = new EventCatcher(this);
            this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            Hashtable hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.screen = (Screen3D)VirtualUniverse.mc.deviceScreenMap.get(graphicsDevice);
                if (this.screen == null) {
                    this.screen = new Screen3D(graphicsDevice, bl);
                    VirtualUniverse.mc.deviceScreenMap.put(graphicsDevice, this.screen);
                }
            }
            this.doubleBufferAvailable = GraphicsConfigTemplate3D.hasDoubleBuffer(graphicsConfiguration);
            this.stereoAvailable = GraphicsConfigTemplate3D.hasStereo(graphicsConfiguration);
        }
        this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        this.sceneAntialiasingAvailable = GraphicsConfigTemplate3D.hasSceneAntialiasing(graphicsConfiguration);
        this.useSharedCtx = !VirtualUniverse.mc.sharedCtxOverride & this.useSharedCtx() | VirtualUniverse.mc.sharedCtxOverride & VirtualUniverse.mc.isSharedCtx;
    }

    void sendEventToBehaviorScheduler(AWTEvent aWTEvent) {
        VirtualUniverse virtualUniverse;
        ViewPlatform viewPlatform;
        if (this.view != null && (viewPlatform = this.view.getViewPlatform()) != null && (virtualUniverse = ((ViewPlatformRetained)viewPlatform.retained).universe) != null) {
            virtualUniverse.behaviorStructure.handleAWTEvent(aWTEvent);
        }
    }

    void redraw() {
        if (this.view != null && this.active && this.isRunning) {
            this.view.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (!this.firstPaintCalled && this.added) {
            this.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
            this.firstPaintCalled = true;
            this.visible = true;
            this.ctx = 0;
            this.ctxTimeStamp = 0L;
            this.evaluateActive();
        }
        this.redraw();
    }

    public void addNotify() {
        Component component;
        super.addNotify();
        this.screen.addUser(this);
        this.parent = this.getParent();
        while (!(this.parent instanceof Window)) {
            this.parent = this.parent.getParent();
        }
        ((Window)this.parent).addWindowListener(this.eventCatcher);
        if (VirtualUniverse.mc.isD3D()) {
            ((Window)this.parent).addComponentListener(this.eventCatcher);
        }
        if (this.canvasViewEventCatcher.parentList.size() > 0) {
            int n = 0;
            while (n < this.canvasViewEventCatcher.parentList.size()) {
                component = (Component)this.canvasViewEventCatcher.parentList.get(n);
                component.removeComponentListener(this.canvasViewEventCatcher);
                ++n;
            }
            this.canvasViewEventCatcher.parentList.clear();
        }
        component = this.getParent();
        while (component != null) {
            component.addComponentListener(this.canvasViewEventCatcher);
            this.canvasViewEventCatcher.parentList.add(component);
            component = component.getParent();
        }
        this.addComponentListener(this.canvasViewEventCatcher);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
        this.canvasBit = VirtualUniverse.mc.getCanvasBit();
        this.validCanvas = true;
        this.added = true;
        if (this.isRunning) {
            this.isRunningStatus = true;
        }
    }

    public void removeNotify() {
        DrawingSurfaceObjectAWT drawingSurfaceObjectAWT;
        Serializable serializable;
        this.validCtx = false;
        this.validCanvas = false;
        super.removeNotify();
        this.screen.removeUser(this);
        if (this.parent != null) {
            ((Window)this.parent).removeWindowListener(this.eventCatcher);
            if (VirtualUniverse.mc.isD3D()) {
                ((Window)this.parent).removeComponentListener(this.eventCatcher);
            }
        }
        if (this.eventCatcher != null) {
            this.removeComponentListener(this.eventCatcher);
            this.removeFocusListener(this.eventCatcher);
            this.removeKeyListener(this.eventCatcher);
            this.removeMouseListener(this.eventCatcher);
            this.removeMouseMotionListener(this.eventCatcher);
            this.eventCatcher.reset();
        }
        this.visible = false;
        if (!this.offScreen) {
            this.added = false;
            this.firstPaintCalled = false;
        }
        if (this.screen != null && this.screen.renderer != null && this.ctx != 0) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_CONTEXT, this);
        }
        this.evaluateActive();
        if (this.canvasViewEventCatcher.parentList.size() > 0) {
            int n = this.canvasViewEventCatcher.parentList.size() - 1;
            while (n >= 0) {
                serializable = (Component)this.canvasViewEventCatcher.parentList.get(n);
                serializable.removeComponentListener(this.canvasViewEventCatcher);
                --n;
            }
            this.canvasViewEventCatcher.parentList.clear();
        }
        this.removeComponentListener(this.canvasViewEventCatcher);
        VirtualUniverse.mc.freeCanvasBit(this.canvasBit);
        this.ra = null;
        this.graphicsContext3D = null;
        this.graphics2D = null;
        if (MasterControl.jvm14 && (serializable = (drawingSurfaceObjectAWT = (DrawingSurfaceObjectAWT)this.drawingSurfaceObject).getObject()) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_DRAWING_SURFACE, serializable);
        }
        if (this.parent != null) {
            this.parent.requestFocus();
        }
    }

    void evaluateActive() {
        Object object = this.evaluateLock;
        synchronized (object) {
            if ((this.visible || this.offScreen) && this.firstPaintCalled) {
                if (!this.active) {
                    this.active = true;
                    if (this.view != null) {
                        this.view.evaluateActive();
                    }
                }
            } else if (this.active) {
                this.active = false;
                if (this.view != null) {
                    this.view.evaluateActive();
                }
            }
        }
    }

    void setFrustumPlanes(Vector4d[] vector4dArray) {
        this.viewFrustum.set(vector4dArray);
    }

    void setLocalEyeLightingEnable(boolean bl) {
        this.localEyeLightingEnable = bl;
    }

    public Screen3D getScreen3D() {
        return this.screen;
    }

    public GraphicsContext3D getGraphicsContext3D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphicsContext3D == null) {
                this.graphicsContext3D = new GraphicsContext3D(this);
            }
        }
        return this.graphicsContext3D;
    }

    public J3DGraphics2D getGraphics2D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphics2D == null) {
                this.graphics2D = new J3DGraphics2DImpl(this);
            }
        }
        return this.graphics2D;
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void postSwap() {
    }

    public void renderField(int n) {
    }

    public final void stopRenderer() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            this.isRunning = false;
        }
    }

    public final void startRenderer() {
        if (!this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            this.isRunning = true;
        }
    }

    public final boolean isRendererRunning() {
        return this.isRunning;
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    public void setOffScreenBuffer(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (imageComponent2DRetained.byReference && !(imageComponent2DRetained.bImage[0] instanceof BufferedImage)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D15"));
        }
        if (imageComponent2DRetained.format == 10) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D16"));
        }
        if (this.offScreenCanvasSize.width != imageComponent2DRetained.width || this.offScreenCanvasSize.height != imageComponent2DRetained.height) {
            if (this.window != 0) {
                this.destroyContext(this.screen.display, this.window, this.ctx);
                this.destroyOffScreenBuffer(this.ctx, this.screen.display, this.window);
                this.window = 0;
            }
            this.offScreenCanvasSize.setSize(imageComponent2DRetained.width, imageComponent2DRetained.height);
            this.setSize(this.offScreenCanvasSize);
            this.window = this.createOffScreenBuffer(this.ctx, this.screen.display, this.vid, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
            this.ctx = 0;
        }
        if (this.ctx != 0) {
            this.destroyContext(this.screen.display, this.window, this.ctx);
            this.ctx = 0;
        }
        this.offScreenBuffer = imageComponent2D;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
    }

    public ImageComponent2D getOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return this.offScreenBuffer;
    }

    public void renderOffScreenBuffer() {
        int n;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenBuffer == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D10"));
        }
        Dimension dimension = this.screen.getSize();
        if (dimension.width <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D8"));
        }
        if (dimension.height <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D9"));
        }
        if (this.screen.getPhysicalScreenWidth() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D12"));
        }
        if (this.screen.getPhysicalScreenHeight() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D13"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (!this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D11"));
        }
        if (!this.active) {
            return;
        }
        if (this.offScreenCanvasLoc.x >= dimension.width || this.offScreenCanvasLoc.y >= dimension.height) {
            return;
        }
        if (this.offScreenCanvasLoc.x < 0) {
            this.offScreenCanvasClippedLoc.x = 0 - this.offScreenCanvasLoc.x;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width - this.offScreenCanvasClippedLoc.x;
            if (this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width;
            }
        } else {
            this.offScreenCanvasClippedLoc.x = 0;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width;
            if (this.offScreenCanvasLoc.x + this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width - this.offScreenCanvasLoc.x;
            }
        }
        if ((n = this.offScreenCanvasLoc.y + this.offScreenCanvasSize.height) < 0) {
            return;
        }
        if (n <= dimension.height) {
            this.offScreenCanvasClippedLoc.y = 0;
            this.offScreenCanvasClippedSize.height = this.offScreenCanvasLoc.y < 0 ? n : this.offScreenCanvasSize.height;
        } else if (n > dimension.height) {
            this.offScreenCanvasClippedSize.height = dimension.height - this.offScreenCanvasLoc.y;
            this.offScreenCanvasClippedLoc.y = n - dimension.height;
        }
        this.offScreenRendering = true;
        if (this.view.inCanvasCallback) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            this.screen.renderer.args = new Object[4];
            this.screen.renderer.args[0] = new Integer(3);
            this.screen.renderer.args[1] = this;
            this.screen.renderer.args[2] = this.view;
            this.screen.renderer.args[3] = null;
            this.screen.renderer.doWork(0L);
        } else if (Thread.currentThread() == this.view.universe.behaviorScheduler) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            VirtualUniverse.mc.setWorkForRequestRenderer();
        } else {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = this.offScreenBuffer;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    public void waitForOffScreenRendering() {
        while (this.offScreenRendering) {
            Thread.currentThread();
            Thread.yield();
        }
    }

    public void setOffScreenLocation(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(n, n2);
        }
    }

    public void setOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(point);
        }
    }

    public Point getOffScreenLocation() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return new Point(this.offScreenCanvasLoc);
    }

    public Point getOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (point == null) {
            return new Point(this.offScreenCanvasLoc);
        }
        point.setLocation(this.offScreenCanvasLoc);
        return point;
    }

    void endOffScreenRendering() {
        int n = this.offScreenCanvasSize.width * this.offScreenCanvasSize.height * ((ImageComponent2DRetained)this.offScreenBuffer.retained).bytesPerPixelStored;
        if (this.byteBuffer.length < n) {
            this.byteBuffer = new byte[n];
        }
        if (((ImageComponent2DRetained)this.offScreenBuffer.retained).isByReference()) {
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).geomLock.getLock();
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).evaluateExtensions(this.extensionsSupported);
            ((ImageComponent2DRetained)this.offScreenBuffer.retained).geomLock.unLock();
        }
        this.readOffScreenBuffer(this.ctx, ((ImageComponent2DRetained)this.offScreenBuffer.retained).storedFormat, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
        ((ImageComponent2DRetained)this.offScreenBuffer.retained).retrieveImage(this.byteBuffer, this.offScreenCanvasClippedLoc.x, this.offScreenCanvasClippedLoc.y, this.offScreenCanvasClippedSize.width, this.offScreenCanvasClippedSize.height);
    }

    public void swap() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D0"));
        }
        if (this.view != null && this.graphicsContext3D != null) {
            if (this.view.universe != null && Thread.currentThread() == this.view.universe.behaviorScheduler) {
                this.graphicsContext3D.sendRenderMessage(false, 2, null, null);
            } else {
                this.graphicsContext3D.sendRenderMessage(true, 2, null, null);
            }
        }
    }

    void doSwap() {
        if (this.firstPaintCalled && this.useDoubleBuffer) {
            try {
                if (!this.drawingSurfaceObject.renderLock(true)) {
                    return;
                }
                this.syncRender(this.ctx, true);
                this.swapBuffers(this.ctx, this.screen.display, this.window);
                this.drawingSurfaceObject.unLock(true);
            }
            catch (NullPointerException nullPointerException) {
                this.drawingSurfaceObject.unLock(true);
            }
        }
        this.view.universe.behaviorStructure.incElapsedFrames();
        if (this.reEvaluateCanvasCmd != 0) {
            this.d3dAntialiasingSet = false;
            int n = this.reEvaluateCanvasCmd == 1 ? this.resizeD3DCanvas(this.ctx) : this.toggleFullScreenMode(this.ctx);
            if (n != 0) {
                this.resetImmediateRendering(n);
            }
            this.reEvaluateCanvasCmd = 0;
        }
    }

    void makeCtxCurrent() {
        if (this.ctx != VirtualUniverse.mc.currentCtx) {
            this.useCtx(this.ctx, this.screen.display, this.window);
            VirtualUniverse.mc.currentCtx = this.ctx;
        }
    }

    void makeCtxCurrent(int n) {
        if (n != VirtualUniverse.mc.currentCtx) {
            this.useCtx(n, this.screen.display, this.window);
            VirtualUniverse.mc.currentCtx = n;
        }
    }

    native void useCtx(int var1, int var2, int var3);

    native void clear(int var1, float var2, float var3, float var4, ImageComponent2DRetained var5);

    native void textureclear(int var1, int var2, int var3, float var4, float var5, float var6, int var7, ImageComponent2DRetained var8);

    native void swapBuffers(int var1, int var2, int var3);

    native void setModelViewMatrix(int var1, double[] var2, double[] var3);

    native void setProjectionMatrix(int var1, double[] var2);

    native void setViewport(int var1, int var2, int var3, int var4, int var5);

    native void newDisplayList(int var1, int var2);

    native void endDisplayList(int var1);

    native void freeDisplayList(int var1, int var2);

    native void callDisplayList(int var1, int var2, boolean var3);

    native void freeTexture(int var1, int var2);

    native void composite(int var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8);

    native void texturemapping(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    public void setLeftManualEyeInImagePlate(Point3d point3d) {
        this.leftManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    public void setRightManualEyeInImagePlate(Point3d point3d) {
        this.rightManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    public void getLeftManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
    }

    public void getRightManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
    }

    public void getLeftEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getLeftEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
        }
    }

    public void getRightEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getRightEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
        }
    }

    public void getCenterEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getCenterEyeInImagePlate());
            }
        } else {
            Point3d point3d2 = new Point3d();
            point3d2.add((Tuple3d)this.leftManualEyeInImagePlate, (Tuple3d)this.rightManualEyeInImagePlate);
            point3d2.scale(0.5);
            point3d.set((Tuple3d)point3d2);
        }
    }

    public void getImagePlateToVworld(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getImagePlateToVworld());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    public void getPixelLocationInImagePlate(int n, int n2, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(n);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(n2);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    public void getPixelLocationInImagePlate(Point2d point2d, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(point2d.x);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(point2d.y);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    public void getPixelLocationFromImagePlate(Point3d point3d, Point2d point2d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationFromImagePlate(point3d, point2d);
            }
        } else {
            point2d.set(0.0, 0.0);
        }
    }

    public double getPhysicalWidth() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowWidth();
            }
        }
        return d;
    }

    public double getPhysicalHeight() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowHeight();
            }
        }
        return d;
    }

    public void getVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    void setView(View view) {
        boolean bl = false;
        if (this.view != null) {
            if (!this.offScreen) {
                this.stopRenderer();
            }
            bl = true;
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.view = view;
            if (view == null) {
                this.canvasViewCache = null;
            } else {
                this.canvasViewCache = new CanvasViewCache(this, this.screen.screenViewCache, view.viewCache);
                Object object2 = this.dirtyMaskLock;
                synchronized (object2) {
                    this.cvDirtyMask = 15;
                }
            }
        }
        if (bl) {
            this.startRenderer();
        }
    }

    public View getView() {
        return this.view;
    }

    public boolean getStereoAvailable() {
        return (Boolean)this.queryProperties().get("stereoAvailable");
    }

    public void setStereoEnable(boolean bl) {
        this.stereoEnable = bl;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 1;
        }
        this.redraw();
    }

    public boolean getStereoEnable() {
        return this.stereoEnable;
    }

    public void setMonoscopicViewPolicy(int n) {
        if (this.view != null && this.view.viewPolicy == 1 && this.monoscopicViewPolicy == 2 && !this.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        this.monoscopicViewPolicy = n;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 2;
        }
        this.redraw();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    public boolean getDoubleBufferAvailable() {
        return (Boolean)this.queryProperties().get("doubleBufferAvailable");
    }

    public void setDoubleBufferEnable(boolean bl) {
        this.doubleBufferEnable = bl;
        boolean bl2 = this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        if (Thread.currentThread() == this.screen.renderer) {
            this.setRenderMode(this.ctx, 2, this.useDoubleBuffer);
        }
        this.redraw();
    }

    public boolean getDoubleBufferEnable() {
        return this.doubleBufferEnable;
    }

    public boolean getSceneAntialiasingAvailable() {
        return (Boolean)this.queryProperties().get("sceneAntialiasingAvailable");
    }

    public final Map queryProperties() {
        int n = 0;
        if (this.queryProps == null) {
            if (this.ctx == 0) {
                if (!VirtualUniverse.mc.isD3D()) {
                    int n2;
                    if (this.window == 0) {
                        n = this.createOffScreenBuffer(this.ctx, this.screen.display, this.vid, 10, 10);
                        n2 = this.createQueryContext(this.screen.display, n, this.vid, true);
                    } else {
                        n2 = this.createQueryContext(this.screen.display, this.window, this.vid, this.offScreen);
                    }
                    if (this.textureColorTableAvailable) {
                        this.textureColorTableSize = this.getTextureColorTableSize(n2);
                        if (this.textureColorTableSize > 256) {
                            this.textureColorTableSize = 256;
                        }
                    }
                    if (this.window == 0) {
                        this.destroyOffScreenBuffer(n2, this.screen.display, n);
                        this.destroyContext(this.screen.display, n, n2);
                    } else {
                        this.destroyContext(this.screen.display, this.window, n2);
                    }
                }
            } else if (this.textureColorTableAvailable) {
                this.makeCtxCurrent();
                this.textureColorTableSize = this.getTextureColorTableSize(this.ctx);
                if (this.textureColorTableSize > 256) {
                    this.textureColorTableSize = 256;
                }
            }
            this.createQueryProps();
        }
        return this.queryProps;
    }

    private void createQueryProps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Comparable<Boolean>> arrayList2 = new ArrayList<Comparable<Boolean>>();
        arrayList.add("doubleBufferAvailable");
        arrayList2.add(new Boolean(this.doubleBufferAvailable));
        arrayList.add("stereoAvailable");
        arrayList2.add(new Boolean(this.stereoAvailable));
        arrayList.add("sceneAntialiasingAvailable");
        arrayList2.add(new Boolean(this.sceneAntialiasingAvailable));
        arrayList.add("texture3DAvailable");
        arrayList2.add(new Boolean(this.texture3DAvailable));
        arrayList.add("textureColorTableSize");
        arrayList2.add(new Integer(this.textureColorTableSize));
        arrayList.add("compressedGeometry.majorVersionNumber");
        arrayList2.add(new Integer(1));
        arrayList.add("compressedGeometry.minorVersionNumber");
        arrayList2.add(new Integer(0));
        arrayList.add("compressedGeometry.minorMinorVersionNumber");
        arrayList2.add(new Integer(2));
        this.queryProps = new J3dQueryProps(arrayList.toArray(new String[0]), arrayList2.toArray());
    }

    native void setRenderMode(int var1, int var2, boolean var3);

    native void setDepthBufferWriteEnable(int var1, boolean var2);

    void updateViewCache(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.firstPaintCalled && this.canvasViewCache != null) {
                this.canvasViewCache.snapshot();
                this.canvasViewCache.computeDerivedData(bl, canvasViewCache, boundingBox, bl2);
            }
        }
    }

    void setDepthBufferWriteEnableOverride(boolean bl) {
        this.depthBufferWriteEnableOverride = bl;
    }

    void setDepthBufferEnableOverride(boolean bl) {
        this.depthBufferEnableOverride = bl;
    }

    void resetTexture(int n, int n2) {
        this.resetTextureNative(n, n2);
        if (n2 <= 0) {
            this.texture = null;
        }
    }

    void resetTextureBin() {
        if (this.textureBin != null && this.textureBin.texUnitState != null) {
            int n = 0;
            while (n < this.textureBin.texUnitState.length) {
                TextureUnitStateRetained textureUnitStateRetained = this.textureBin.texUnitState[n];
                if (textureUnitStateRetained != null && textureUnitStateRetained.texture != null) {
                    textureUnitStateRetained.texture.resourceCreationMask = 0;
                    textureUnitStateRetained.texture.resourceDirtyMask = -1;
                }
                ++n;
            }
        }
    }

    void notifyD3DPeer(int n) {
        if (this.active) {
            if (this.isRunning) {
                if (this.view != null && this.view.active) {
                    VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
                    while (this.isRunningStatus) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int n2 = n == 1 ? this.resizeD3DCanvas(this.ctx) : this.toggleFullScreenMode(this.ctx);
                    this.d3dAntialiasingSet = false;
                    if (n2 != 0) {
                        this.resetRendering(n2);
                    }
                    VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
                }
            } else {
                this.reEvaluateCanvasCmd = n;
            }
        }
    }

    void resetRendering(int n) {
        this.resetTextureBin();
        this.reset();
        if (n != 0) {
            this.screen.renderer.needToRebuildDisplayList = true;
            this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
        }
        if (n == 2) {
            this.screen.renderer.needToResendTextureDown = true;
        }
    }

    void reset() {
        this.byteBuffer = new byte[1];
        this.currentAppear = new AppearanceRetained();
        this.currentMaterial = new MaterialRetained();
        this.viewFrustum = new CachedFrustum();
        this.canvasDirty = 65535;
        this.lightBin = null;
        this.environmentSet = null;
        this.attributeBin = null;
        this.textureBin = null;
        this.renderMolecule = null;
        this.polygonAttributes = null;
        this.lineAttributes = null;
        this.pointAttributes = null;
        this.material = null;
        this.transparency = null;
        this.coloringAttributes = null;
        this.texture = null;
        this.texAttrs = null;
        this.texCoordGeneration = null;
        this.renderingAttrs = null;
        this.dirtyRenderMoleculeList.clear();
        this.displayListResourceFreeList.clear();
        this.textureIdResourceFreeList.clear();
        this.currentLights = null;
    }

    void resetImmediateRendering(int n) {
        this.canvasDirty = 65535;
        this.ra = null;
        this.setSceneAmbient(this.ctx, 0.0f, 0.0f, 0.0f);
        this.disableFog(this.ctx);
        this.resetRenderingAttributes(this.ctx, false, false);
        this.resetTexture(this.ctx, -1);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        this.resetPolygonAttributes(this.ctx);
        this.resetLineAttributes(this.ctx);
        this.resetPointAttributes(this.ctx);
        this.resetTransparency(this.ctx, 4, 2, false, false);
        this.resetColoringAttributes(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.updateMaterial(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
        this.resetRendering(0);
        this.makeCtxCurrent();
        this.drawingSurfaceObject.contextValidated();
        if (n == 2) {
            this.screen.renderer.needToResendTextureDown = true;
            this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
        }
    }

    public Dimension getSize() {
        if (!this.fullScreenMode) {
            return super.getSize();
        }
        return new Dimension(this.screen.screenSize);
    }

    public Dimension getSize(Dimension dimension) {
        if (!this.fullScreenMode) {
            return super.getSize(dimension);
        }
        if (dimension == null) {
            return new Dimension(this.screen.screenSize);
        }
        dimension.setSize(this.screen.screenSize);
        return dimension;
    }

    public Point getLocationOnScreen() {
        if (!this.fullScreenMode) {
            return super.getLocationOnScreen();
        }
        return new Point();
    }

    public int getX() {
        if (!this.fullScreenMode) {
            return super.getX();
        }
        return 0;
    }

    public int getY() {
        if (!this.fullScreenMode) {
            return super.getY();
        }
        return 0;
    }

    public int getWidth() {
        if (!this.fullScreenMode) {
            return super.getWidth();
        }
        return this.screen.screenSize.width;
    }

    public int getHeight() {
        if (!this.fullScreenMode) {
            return super.getHeight();
        }
        return this.screen.screenSize.height;
    }

    public Point getLocation(Point point) {
        if (!this.fullScreenMode) {
            return super.getLocation(point);
        }
        if (point != null) {
            point.setLocation(0, 0);
            return point;
        }
        return new Point();
    }

    public Point getLocation() {
        if (!this.fullScreenMode) {
            return super.getLocation();
        }
        return new Point();
    }

    public Rectangle getBounds() {
        if (!this.fullScreenMode) {
            return super.getBounds();
        }
        return new Rectangle(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (!this.fullScreenMode) {
            return super.getBounds(rectangle);
        }
        if (rectangle != null) {
            rectangle.setBounds(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
            return rectangle;
        }
        return new Rectangle(0, 0, this.screen.screenSize.width, this.screen.screenSize.height);
    }

    void setModelViewMatrix(int n, double[] dArray, Transform3D transform3D) {
        this.setModelViewMatrix(n, dArray, transform3D.mat);
        if (!this.useStereo) {
            this.modelMatrix = transform3D;
        } else if (this.rightStereoPass) {
            this.modelMatrix = transform3D;
        }
    }

    void setDepthBufferWriteEnable(boolean bl) {
        this.depthBufferWriteEnable = bl;
        this.setDepthBufferWriteEnable(this.ctx, bl);
    }

    void setTexUnitStateMap(int n, int n2) {
        if (this.texUnitStateMap == null) {
            this.texUnitStateMap = new int[n + 10];
        } else if (this.texUnitStateMap.length < n) {
            int[] nArray = new int[n + 10];
            int n3 = 0;
            while (n3 < this.texUnitStateMap.length) {
                nArray[n3] = this.texUnitStateMap[n3];
                ++n3;
            }
            this.texUnitStateMap = nArray;
        }
        this.texUnitStateMap[n] = n2;
    }

    boolean supportGlobalAlpha() {
        return (this.extensionsSupported & 1) != 0;
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

