/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingSphere
extends Bounds {
    Point3d center;
    double radius;
    private boolean boundsIsEmpty = false;
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;
    private BoundingBox tmpBox = null;
    private BoundingPolytope tmpPolytope = null;

    public BoundingSphere(Point3d point3d, double d) {
        this.center = new Point3d(point3d);
        this.radius = d;
        this.boundId = 2;
        this.checkBoundsIsEmpty();
    }

    public BoundingSphere() {
        this.boundId = 2;
        this.center = new Point3d();
        this.radius = 1.0;
    }

    public BoundingSphere(Bounds bounds) {
        this.boundId = 2;
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
            this.center = new Point3d();
            this.radius = -1.0;
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.center = new Point3d(boundingSphere.center);
            this.radius = boundingSphere.radius;
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center = new Point3d();
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center = new Point3d();
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            int n = 1;
            while (n < boundingPolytope.nVerts) {
                double d = (boundingPolytope.verts[n].x - this.center.x) * (boundingPolytope.verts[n].x - this.center.x) + (boundingPolytope.verts[n].y - this.center.y) * (boundingPolytope.verts[n].y - this.center.y) + (boundingPolytope.verts[n].z - this.center.z) * (boundingPolytope.verts[n].z - this.center.z);
                double d2 = this.radius * this.radius;
                if (d > d2) {
                    double d3 = Math.sqrt(d);
                    this.radius = (this.radius + d3) * 0.5;
                    double d4 = d3 - this.radius;
                    double d5 = d4 / d3;
                    this.center.x += (boundingPolytope.verts[n].x - this.center.x) * d5;
                    this.center.y += (boundingPolytope.verts[n].y - this.center.y) * d5;
                    this.center.z += (boundingPolytope.verts[n].z - this.center.z) * d5;
                }
                ++n;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
        }
        this.checkBoundsIsEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BoundingSphere(Bounds[] var1_1) {
        super();
        var2_2 = 0;
        this.boundId = 2;
        this.center = new Point3d();
        if (var1_1 != null && var1_1.length > 0) ** GOTO lbl14
        this.boundsIsEmpty = true;
        this.radius = -1.0;
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl14:
            // 2 sources

            ** while (var1_1[var2_2] == null && var2_2 < var1_1.length)
        }
lbl15:
        // 1 sources

        if (var2_2 >= var1_1.length) {
            this.boundsIsEmpty = true;
            this.radius = -1.0;
            return;
        }
        this.set(var1_1[var2_2++]);
        while (var2_2 < var1_1.length) {
            if (var1_1[var2_2] != null && !var1_1[var2_2].isEmpty()) {
                if (var1_1[var2_2] instanceof BoundingSphere) {
                    var9_6 /* !! */  = (BoundingSphere)var1_1[var2_2];
                    var3_3 = Math.sqrt((this.center.x - var9_6 /* !! */ .center.x) * (this.center.x - var9_6 /* !! */ .center.x) + (this.center.y - var9_6 /* !! */ .center.y) * (this.center.y - var9_6 /* !! */ .center.y) + (this.center.z - var9_6 /* !! */ .center.z) * (this.center.z - var9_6 /* !! */ .center.z));
                    if (this.radius > var9_6 /* !! */ .radius) {
                        if (var3_3 + var9_6 /* !! */ .radius > this.radius) {
                            var7_5 = 0.5 * (this.radius - var9_6 /* !! */ .radius + var3_3);
                            var5_4 = var7_5 / var3_3;
                            this.radius = var7_5 + var9_6 /* !! */ .radius;
                            this.center.x = var9_6 /* !! */ .center.x + (this.center.x - var9_6 /* !! */ .center.x) * var5_4;
                            this.center.y = var9_6 /* !! */ .center.y + (this.center.y - var9_6 /* !! */ .center.y) * var5_4;
                            this.center.z = var9_6 /* !! */ .center.z + (this.center.z - var9_6 /* !! */ .center.z) * var5_4;
                        }
                    } else if (var3_3 + this.radius <= var9_6 /* !! */ .radius) {
                        this.center.x = var9_6 /* !! */ .center.x;
                        this.center.y = var9_6 /* !! */ .center.y;
                        this.center.z = var9_6 /* !! */ .center.z;
                        this.radius = var9_6 /* !! */ .radius;
                    } else {
                        var7_5 = 0.5 * (var9_6 /* !! */ .radius - this.radius + var3_3);
                        var5_4 = var7_5 / var3_3;
                        this.radius = var7_5 + this.radius;
                        this.center.x += (var9_6 /* !! */ .center.x - this.center.x) * var5_4;
                        this.center.y += (var9_6 /* !! */ .center.y - this.center.y) * var5_4;
                        this.center.z += (var9_6 /* !! */ .center.z - this.center.z) * var5_4;
                    }
                } else if (var1_1[var2_2] instanceof BoundingBox) {
                    var9_6 /* !! */  = (BoundingBox)var1_1[var2_2];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        var10_7 = 0;
                        while (var10_7 < 8) {
                            this.boxVerts[var10_7] = new Point3d();
                            ++var10_7;
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(var9_6 /* !! */ .lower.x, var9_6 /* !! */ .lower.y, var9_6 /* !! */ .lower.z);
                    this.boxVerts[1].set(var9_6 /* !! */ .lower.x, var9_6 /* !! */ .upper.y, var9_6 /* !! */ .lower.z);
                    this.boxVerts[2].set(var9_6 /* !! */ .upper.x, var9_6 /* !! */ .lower.y, var9_6 /* !! */ .lower.z);
                    this.boxVerts[3].set(var9_6 /* !! */ .upper.x, var9_6 /* !! */ .upper.y, var9_6 /* !! */ .lower.z);
                    this.boxVerts[4].set(var9_6 /* !! */ .lower.x, var9_6 /* !! */ .lower.y, var9_6 /* !! */ .upper.z);
                    this.boxVerts[5].set(var9_6 /* !! */ .lower.x, var9_6 /* !! */ .upper.y, var9_6 /* !! */ .upper.z);
                    this.boxVerts[6].set(var9_6 /* !! */ .upper.x, var9_6 /* !! */ .lower.y, var9_6 /* !! */ .upper.z);
                    this.boxVerts[7].set(var9_6 /* !! */ .upper.x, var9_6 /* !! */ .upper.y, var9_6 /* !! */ .upper.z);
                    this.combine(this.boxVerts);
                } else if (var1_1[var2_2] instanceof BoundingPolytope) {
                    var9_6 /* !! */  = (BoundingPolytope)var1_1[var2_2];
                    this.combine(var9_6 /* !! */ .verts);
                } else if (var1_1[var2_2] != null) {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
                }
            }
            ++var2_2;
        }
        this.checkBoundsIsEmpty();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.checkBoundsIsEmpty();
    }

    public void getCenter(Point3d point3d) {
        point3d.x = this.center.x;
        point3d.y = this.center.y;
        point3d.z = this.center.z;
    }

    public void setCenter(Point3d point3d) {
        this.center.x = point3d.x;
        this.center.y = point3d.y;
        this.center.z = point3d.z;
        this.checkBoundsIsNaN();
    }

    public void set(Bounds bounds) {
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.center.x = 0.0;
            this.center.y = 0.0;
            this.center.z = 0.0;
            this.radius = -1.0;
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.radius = boundingSphere.radius;
            this.center.x = boundingSphere.center.x;
            this.center.y = boundingSphere.center.y;
            this.center.z = boundingSphere.center.z;
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            int n = 1;
            while (n < boundingPolytope.nVerts) {
                double d = (boundingPolytope.verts[n].x - this.center.x) * (boundingPolytope.verts[n].x - this.center.x) + (boundingPolytope.verts[n].y - this.center.y) * (boundingPolytope.verts[n].y - this.center.y) + (boundingPolytope.verts[n].z - this.center.z) * (boundingPolytope.verts[n].z - this.center.z);
                double d2 = this.radius * this.radius;
                if (d > d2) {
                    double d3 = Math.sqrt(d);
                    this.radius = (this.radius + d3) * 0.5;
                    double d4 = d3 - this.radius;
                    double d5 = d4 / d3;
                    this.center.x += (boundingPolytope.verts[n].x - this.center.x) * d5;
                    this.center.y += (boundingPolytope.verts[n].y - this.center.y) * d5;
                    this.center.z += (boundingPolytope.verts[n].z - this.center.z) * d5;
                }
                ++n;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere2"));
        }
        this.checkBoundsIsEmpty();
    }

    public Object clone() {
        return new BoundingSphere(this.center, this.radius);
    }

    public boolean equals(Object object) {
        try {
            BoundingSphere boundingSphere = (BoundingSphere)object;
            return this.center.equals((Tuple3d)boundingSphere.center) && this.radius == boundingSphere.radius;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + Double.doubleToLongBits(this.radius);
        l = 31L * l + Double.doubleToLongBits(this.center.x);
        l = 31L * l + Double.doubleToLongBits(this.center.y);
        l = 31L * l + Double.doubleToLongBits(this.center.z);
        return (int)(l ^ l >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.isEmpty()) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(bounds);
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
            if (this.radius > boundingSphere.radius) {
                if (d + boundingSphere.radius > this.radius) {
                    double d2 = 0.5 * (this.radius - boundingSphere.radius + d);
                    double d3 = d2 / d;
                    this.radius = d2 + boundingSphere.radius;
                    this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d3;
                    this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d3;
                    this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d3;
                }
            } else if (d + this.radius <= boundingSphere.radius) {
                this.center.x = boundingSphere.center.x;
                this.center.y = boundingSphere.center.y;
                this.center.z = boundingSphere.center.z;
                this.radius = boundingSphere.radius;
            } else {
                double d4 = 0.5 * (boundingSphere.radius - this.radius + d);
                double d5 = d4 / d;
                this.radius = d4 + this.radius;
                this.center.x += (boundingSphere.center.x - this.center.x) * d5;
                this.center.y += (boundingSphere.center.y - this.center.y) * d5;
                this.center.z += (boundingSphere.center.z - this.center.z) * d5;
            }
        } else if (bounds instanceof BoundingBox) {
            double d;
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d6 = boundingBox.upper.x - this.center.x;
            double d7 = boundingBox.lower.x - this.center.x;
            double d8 = d6 * d6 > d7 * d7 ? boundingBox.upper.x : boundingBox.lower.x;
            d6 = boundingBox.upper.y - this.center.y;
            d7 = boundingBox.lower.y - this.center.y;
            double d9 = d6 * d6 > d7 * d7 ? boundingBox.upper.y : boundingBox.lower.y;
            double d10 = Math.sqrt((d8 - this.center.x) * (d8 - this.center.x) + (d9 - this.center.y) * (d9 - this.center.y) + ((d = (d6 = boundingBox.upper.z - this.center.z) * d6 > (d7 = boundingBox.lower.z - this.center.z) * d7 ? boundingBox.upper.z : boundingBox.lower.z) - this.center.z) * (d - this.center.z));
            if (d10 > this.radius) {
                this.radius = (d10 + this.radius) * 0.5;
                double d11 = d10 - this.radius;
                this.center.x = (this.radius * this.center.x + d11 * d8) / d10;
                this.center.y = (this.radius * this.center.y + d11 * d9) / d10;
                this.center.z = (this.radius * this.center.z + d11 * d) / d10;
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            }
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere3"));
        }
        this.checkBoundsIsEmpty();
    }

    private void combinePoint(double d, double d2, double d3) {
        double d4 = Math.sqrt((d - this.center.x) * (d - this.center.x) + (d2 - this.center.y) * (d2 - this.center.y) + (d3 - this.center.z) * (d3 - this.center.z));
        if (d4 > this.radius) {
            this.radius = (d4 + this.radius) * 0.5;
            double d5 = d4 - this.radius;
            this.center.x = (this.radius * this.center.x + d5 * d) / d4;
            this.center.y = (this.radius * this.center.y + d5 * d2) / d4;
            this.center.z = (this.radius * this.center.z + d5 * d3) / d4;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void combine(Bounds[] var1_1) {
        var23_2 = 0;
        if (var1_1 != null && var1_1.length > 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ++var23_2;
lbl5:
            // 2 sources

            ** while ((var1_1[var23_2] == null || var1_1[var23_2].isEmpty()) && var23_2 < var1_1.length)
        }
lbl6:
        // 1 sources

        if (var23_2 >= var1_1.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(var1_1[var23_2++]);
        }
        while (var23_2 < var1_1.length) {
            if (var1_1[var23_2] != null && !var1_1[var23_2].isEmpty()) {
                if (var1_1[var23_2] instanceof BoundingSphere) {
                    var2_3 = (BoundingSphere)var1_1[var23_2];
                    var7_7 = Math.sqrt((this.center.x - var2_3.center.x) * (this.center.x - var2_3.center.x) + (this.center.y - var2_3.center.y) * (this.center.y - var2_3.center.y) + (this.center.z - var2_3.center.z) * (this.center.z - var2_3.center.z));
                    if (this.radius > var2_3.radius) {
                        if (var7_7 + var2_3.radius > this.radius) {
                            var9_8 = 0.5 * (this.radius - var2_3.radius + var7_7);
                            var5_6 = var9_8 / var7_7;
                            this.radius = var9_8 + var2_3.radius;
                            this.center.x = var2_3.center.x + (this.center.x - var2_3.center.x) * var5_6;
                            this.center.y = var2_3.center.y + (this.center.y - var2_3.center.y) * var5_6;
                            this.center.z = var2_3.center.z + (this.center.z - var2_3.center.z) * var5_6;
                        }
                    } else if (var7_7 + this.radius <= var2_3.radius) {
                        this.center.x = var2_3.center.x;
                        this.center.y = var2_3.center.y;
                        this.center.z = var2_3.center.z;
                        this.radius = var2_3.radius;
                    } else {
                        var9_8 = 0.5 * (var2_3.radius - this.radius + var7_7);
                        var5_6 = var9_8 / var7_7;
                        this.radius = var9_8 + this.radius;
                        this.center.x += (var2_3.center.x - this.center.x) * var5_6;
                        this.center.y += (var2_3.center.y - this.center.y) * var5_6;
                        this.center.z += (var2_3.center.z - this.center.z) * var5_6;
                    }
                } else if (var1_1[var23_2] instanceof BoundingBox) {
                    var3_4 = (BoundingBox)var1_1[var23_2];
                    var11_9 = var3_4.upper.x - this.center.x;
                    var13_10 = var3_4.lower.x - this.center.x;
                    var15_11 = var11_9 * var11_9 > var13_10 * var13_10 ? var3_4.upper.x : var3_4.lower.x;
                    var11_9 = var3_4.upper.y - this.center.y;
                    var13_10 = var3_4.lower.y - this.center.y;
                    var17_12 = var11_9 * var11_9 > var13_10 * var13_10 ? var3_4.upper.y : var3_4.lower.y;
                    var7_7 = Math.sqrt((var15_11 - this.center.x) * (var15_11 - this.center.x) + (var17_12 - this.center.y) * (var17_12 - this.center.y) + ((var19_13 = (var11_9 = var3_4.upper.z - this.center.z) * var11_9 > (var13_10 = var3_4.lower.z - this.center.z) * var13_10 ? var3_4.upper.z : var3_4.lower.z) - this.center.z) * (var19_13 - this.center.z));
                    if (var7_7 > this.radius) {
                        this.radius = (var7_7 + this.radius) * 0.5;
                        var21_14 = var7_7 - this.radius;
                        this.center.x = (this.radius * this.center.x + var21_14 * var15_11) / var7_7;
                        this.center.y = (this.radius * this.center.y + var21_14 * var17_12) / var7_7;
                        this.center.z = (this.radius * this.center.z + var21_14 * var19_13) / var7_7;
                        this.combinePoint(var3_4.upper.x, var3_4.upper.y, var3_4.upper.z);
                        this.combinePoint(var3_4.upper.x, var3_4.upper.y, var3_4.lower.z);
                        this.combinePoint(var3_4.upper.x, var3_4.lower.y, var3_4.upper.z);
                        this.combinePoint(var3_4.upper.x, var3_4.lower.y, var3_4.lower.z);
                        this.combinePoint(var3_4.lower.x, var3_4.upper.y, var3_4.upper.z);
                        this.combinePoint(var3_4.lower.x, var3_4.upper.y, var3_4.lower.z);
                        this.combinePoint(var3_4.lower.x, var3_4.lower.y, var3_4.upper.z);
                        this.combinePoint(var3_4.lower.x, var3_4.lower.y, var3_4.lower.z);
                    }
                } else if (var1_1[var23_2] instanceof BoundingPolytope) {
                    var4_5 = (BoundingPolytope)var1_1[var23_2];
                    this.combine(var4_5.verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere4"));
                }
            }
            ++var23_2;
        }
        this.checkBoundsIsEmpty();
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsEmpty) {
            this.radius = -1.0;
            this.center.x = point3d.x;
            this.center.y = point3d.y;
            this.center.z = point3d.z;
        } else {
            double d = Math.sqrt((point3d.x - this.center.x) * (point3d.x - this.center.x) + (point3d.y - this.center.y) * (point3d.y - this.center.y) + (point3d.z - this.center.z) * (point3d.z - this.center.z));
            if (d > this.radius) {
                this.radius = (d + this.radius) * 0.5;
                double d2 = d - this.radius;
                this.center.x = (this.radius * this.center.x + d2 * point3d.x) / d;
                this.center.y = (this.radius * this.center.y + d2 * point3d.y) / d;
                this.center.z = (this.radius * this.center.z + d2 * point3d.z) / d;
            }
        }
        this.checkBoundsIsEmpty();
    }

    public void combine(Point3d[] point3dArray) {
        if (this.boundsIsEmpty) {
            this.center.x = point3dArray[0].x;
            this.center.y = point3dArray[0].y;
            this.center.z = point3dArray[0].z;
            this.radius = -1.0;
        }
        int n = 0;
        while (n < point3dArray.length) {
            double d = (point3dArray[n].x - this.center.x) * (point3dArray[n].x - this.center.x) + (point3dArray[n].y - this.center.y) * (point3dArray[n].y - this.center.y) + (point3dArray[n].z - this.center.z) * (point3dArray[n].z - this.center.z);
            double d2 = this.radius * this.radius;
            if (d > d2) {
                double d3 = Math.sqrt(d);
                this.radius = (this.radius + d3) * 0.5;
                double d4 = d3 - this.radius;
                this.center.x = (this.radius * this.center.x + d4 * point3dArray[n].x) / d3;
                this.center.y = (this.radius * this.center.y + d4 * point3dArray[n].y) / d3;
                this.center.z = (this.radius * this.center.z + d4 * point3dArray[n].z) / d3;
            }
            ++n;
        }
        this.checkBoundsIsEmpty();
    }

    boolean intersect(CachedFrustum cachedFrustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        int n = 0;
        while (n < 6) {
            double d = cachedFrustum.clipPlanes[n].x * this.center.x + cachedFrustum.clipPlanes[n].y * this.center.y + cachedFrustum.clipPlanes[n].z * this.center.z + cachedFrustum.clipPlanes[n].w;
            if (d < 0.0 && d + this.radius < 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean intersect(Vector4d[] vector4dArray) {
        if (this.boundsIsEmpty) {
            return false;
        }
        int n = 0;
        while (n < 6) {
            double d = vector4dArray[n].x * this.center.x + vector4dArray[n].y * this.center.y + vector4dArray[n].z * this.center.z + vector4dArray[n].w;
            if (d < 0.0 && d + this.radius < 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.isEmpty()) {
            this.boundsIsEmpty = true;
            return;
        }
        if (bounds instanceof BoundingSphere) {
            transform3D.transform(((BoundingSphere)bounds).center, this.center);
            double d = transform3D.getDistanceScale();
            this.radius = ((BoundingSphere)bounds).radius * d;
            if (Double.isNaN(this.radius)) {
                this.boundsIsEmpty = true;
                this.zeroVolume = true;
            }
        } else if (bounds instanceof BoundingBox) {
            if (this.tmpBox == null) {
                this.tmpBox = new BoundingBox((BoundingBox)bounds);
            } else {
                this.tmpBox.set((BoundingBox)bounds);
            }
            this.tmpBox.transform(transform3D);
            this.set(this.tmpBox);
        } else if (bounds instanceof BoundingPolytope) {
            if (this.tmpPolytope == null) {
                this.tmpPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            } else {
                this.tmpPolytope.set((BoundingPolytope)bounds);
            }
            this.tmpPolytope.transform(transform3D);
            this.set(this.tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere5"));
        }
    }

    public void transform(Transform3D transform3D) {
        transform3D.transform(this.center);
        double d = transform3D.getDistanceScale();
        this.radius *= d;
        this.checkBoundsIsEmpty();
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x * d3;
        vector3d2.y = vector3d.y * d3;
        vector3d2.z = vector3d.z * d3;
        double d4 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        if (d5 > 0.0) {
            double d6 = d4 - Math.sqrt(d5);
            point4d.x = point3d.x + vector3d2.x * d6;
            point4d.y = point3d.y + vector3d2.y * d6;
            point4d.z = point3d.z + vector3d2.z * d6;
            point4d.w = d6;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        double d = point3d.x - this.center.x;
        double d2 = point3d.y - this.center.y;
        double d3 = point3d.z - this.center.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 > this.radius * this.radius) {
            return false;
        }
        point4d.x = point3d.x;
        point4d.y = point3d.y;
        point4d.z = point3d.z;
        point4d.w = Math.sqrt(d4);
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        double d;
        Vector3d vector3d = new Vector3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        point3d3.x = this.center.x - point3d.x;
        point3d3.y = this.center.y - point3d.y;
        point3d3.z = this.center.z - point3d.z;
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d2 = 1.0 / Math.sqrt(vector3d2.x * vector3d2.x + vector3d2.y * vector3d2.y + vector3d2.z * vector3d2.z);
        vector3d.x = vector3d2.x * d2;
        vector3d.y = vector3d2.y * d2;
        vector3d.z = vector3d2.z * d2;
        double d3 = point3d3.x * point3d3.x + point3d3.y * point3d3.y + point3d3.z * point3d3.z;
        double d4 = this.radius * this.radius;
        if (d3 < d4) {
            return true;
        }
        double d5 = point3d3.x * vector3d.x + point3d3.y * vector3d.y + point3d3.z * vector3d.z;
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = d4 - d3 + d5 * d5;
        if (d6 > 0.0 && (d = d5 - Math.sqrt(d6)) * d <= (point3d2.x - point3d.x) * (point3d2.x - point3d.x) + (point3d2.y - point3d.y) * (point3d2.y - point3d.y) + (point3d2.z - point3d.z) * (point3d2.z - point3d.z)) {
            point4d.x = point3d.x + vector3d.x * d;
            point4d.y = point3d.y + vector3d.x * d;
            point4d.z = point3d.z + vector3d.x * d;
            point4d.w = d;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        point3d4.x = this.center.x - point3d.x;
        point3d4.y = this.center.y - point3d.y;
        point3d4.z = this.center.z - point3d.z;
        double d = point3d4.x * point3d4.x + point3d4.y * point3d4.y + point3d4.z * point3d4.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        point3d3.x = vector3d.x / d3;
        point3d3.y = vector3d.y / d3;
        point3d3.z = vector3d.z / d3;
        double d4 = point3d4.x * point3d3.x + point3d4.y * point3d3.y + point3d4.z * point3d3.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        if (d5 > 0.0) {
            double d6 = d4 - Math.sqrt(d5);
            point3d2.x = point3d.x + vector3d.x * d6;
            point3d2.y = point3d.y + vector3d.y * d6;
            point3d2.z = point3d.z + vector3d.z * d6;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d2 = this.radius * this.radius;
        if (d < d2) {
            return true;
        }
        double d3 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x / d3;
        vector3d2.y = vector3d.y / d3;
        vector3d2.z = vector3d.z / d3;
        double d4 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = d2 - d + d4 * d4;
        return d5 > 0.0;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        double d = point3d.x - this.center.x;
        double d2 = point3d.y - this.center.y;
        double d3 = point3d.z - this.center.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        return !(d4 > this.radius * this.radius);
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.isEmpty()) {
            return false;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = this.radius + boundingSphere.radius;
            d *= d;
            double d2 = this.center.distanceSquared(boundingSphere.center);
            return d2 <= d;
        }
        if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d = 0.0;
            double d3 = this.radius * this.radius;
            if (this.center.x < boundingBox.lower.x) {
                d = (this.center.x - boundingBox.lower.x) * (this.center.x - boundingBox.lower.x);
            } else if (this.center.x > boundingBox.upper.x) {
                d = (this.center.x - boundingBox.upper.x) * (this.center.x - boundingBox.upper.x);
            }
            if (this.center.y < boundingBox.lower.y) {
                d += (this.center.y - boundingBox.lower.y) * (this.center.y - boundingBox.lower.y);
            } else if (this.center.y > boundingBox.upper.y) {
                d += (this.center.y - boundingBox.upper.y) * (this.center.y - boundingBox.upper.y);
            }
            if (this.center.z < boundingBox.lower.z) {
                d += (this.center.z - boundingBox.lower.z) * (this.center.z - boundingBox.lower.z);
            } else if (this.center.z > boundingBox.upper.z) {
                d += (this.center.z - boundingBox.upper.z) * (this.center.z - boundingBox.upper.z);
            }
            return d <= d3;
        }
        if (bounds instanceof BoundingPolytope) {
            return this.intersect_ptope_sphere((BoundingPolytope)bounds, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        int n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].isEmpty()) {
                if (boundsArray[n] instanceof BoundingSphere) {
                    BoundingSphere boundingSphere = (BoundingSphere)boundsArray[n];
                    double d = this.radius + boundingSphere.radius;
                    d *= d;
                    double d2 = this.center.distanceSquared(boundingSphere.center);
                    if (d2 <= d) {
                        return true;
                    }
                } else if (boundsArray[n] instanceof BoundingBox) {
                    if (this.intersect(boundsArray[n])) {
                        return true;
                    }
                } else if (boundsArray[n] instanceof BoundingPolytope) {
                    if (this.intersect(boundsArray[n])) {
                        return true;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere7"));
                }
            }
            ++n;
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingSphere boundingSphere) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.isEmpty()) {
            boundingSphere.boundsIsEmpty = true;
            return false;
        }
        BoundingBox boundingBox = new BoundingBox();
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere2 = (BoundingSphere)bounds;
            double d = Math.sqrt((this.center.x - boundingSphere2.center.x) * (this.center.x - boundingSphere2.center.x) + (this.center.y - boundingSphere2.center.y) * (this.center.y - boundingSphere2.center.y) + (this.center.z - boundingSphere2.center.z) * (this.center.z - boundingSphere2.center.z));
            if (d > this.radius + boundingSphere2.radius) {
                boundingSphere.boundsIsEmpty = true;
                return false;
            }
            if (d + this.radius <= boundingSphere2.radius) {
                boundingSphere.center.x = this.center.x;
                boundingSphere.center.y = this.center.y;
                boundingSphere.center.z = this.center.z;
                boundingSphere.radius = this.radius;
                return true;
            }
            if (d + boundingSphere2.radius <= this.radius) {
                boundingSphere.center.x = boundingSphere2.center.x;
                boundingSphere.center.y = boundingSphere2.center.y;
                boundingSphere.center.z = boundingSphere2.center.z;
                boundingSphere.radius = boundingSphere2.radius;
                return true;
            }
            double d2 = (d * d + this.radius * this.radius - boundingSphere2.radius * boundingSphere2.radius) / (2.0 * d);
            boundingSphere.radius = Math.sqrt(this.radius * this.radius - d2 * d2);
            double d3 = d2 / d;
            boundingSphere.center.x = this.center.x + (boundingSphere2.center.x - this.center.x) * d3;
            boundingSphere.center.y = this.center.y + (boundingSphere2.center.y - this.center.y) * d3;
            boundingSphere.center.z = this.center.z + (boundingSphere2.center.z - this.center.z) * d3;
            return true;
        }
        if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox2 = (BoundingBox)bounds;
            if (this.intersect(boundingBox2)) {
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.boundsIsEmpty = true;
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope)) {
                BoundingBox boundingBox4 = new BoundingBox(this);
                BoundingBox boundingBox5 = new BoundingBox(boundingPolytope);
                boundingBox4.intersect((Bounds)boundingBox5, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.boundsIsEmpty = true;
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere8"));
    }

    public boolean intersect(Bounds[] boundsArray, BoundingSphere boundingSphere) {
        boolean bl = false;
        Point3d point3d = new Point3d();
        BoundingBox boundingBox = new BoundingBox();
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingSphere.boundsIsEmpty = true;
            return false;
        }
        int n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].isEmpty()) {
                Bounds bounds;
                if (boundsArray[n] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n];
                    double d = Math.sqrt((this.center.x - bounds.center.x) * (this.center.x - bounds.center.x) + (this.center.y - bounds.center.y) * (this.center.y - bounds.center.y) + (this.center.z - bounds.center.z) * (this.center.z - bounds.center.z));
                    if (!(d > this.radius + bounds.radius)) {
                        if (d + this.radius <= bounds.radius) {
                            if (bl) {
                                boundingSphere.combine(this);
                            } else {
                                boundingSphere.center.x = this.center.x;
                                boundingSphere.center.y = this.center.y;
                                boundingSphere.center.z = this.center.z;
                                boundingSphere.radius = this.radius;
                                bl = true;
                            }
                        } else if (d + bounds.radius <= this.radius) {
                            if (bl) {
                                boundingSphere.combine(bounds);
                            } else {
                                boundingSphere.center.x = this.center.x;
                                boundingSphere.center.y = this.center.y;
                                boundingSphere.center.z = this.center.z;
                                boundingSphere.radius = bounds.radius;
                                bl = true;
                            }
                        } else {
                            double d2 = (d * d + this.radius * this.radius - bounds.radius * bounds.radius) / (2.0 * d);
                            double d3 = Math.sqrt(this.radius * this.radius - d2 * d2);
                            double d4 = d2 / d;
                            point3d.x = this.center.x + (bounds.center.x - this.center.x) * d4;
                            point3d.y = this.center.y + (bounds.center.y - this.center.y) * d4;
                            point3d.z = this.center.z + (bounds.center.z - this.center.z) * d4;
                            if (bl) {
                                BoundingSphere boundingSphere2 = new BoundingSphere(point3d, d3);
                                boundingSphere.combine(boundingSphere2);
                            } else {
                                boundingSphere.setRadius(d3);
                                boundingSphere.setCenter(point3d);
                                bl = true;
                            }
                        }
                    }
                } else if (boundsArray[n] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.intersect(bounds)) {
                        BoundingBox boundingBox2 = new BoundingBox(this);
                        boundingBox2.intersect(bounds, boundingBox);
                        if (bl) {
                            boundingSphere.combine(boundingBox);
                        } else {
                            boundingSphere.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    if (this.intersect(bounds)) {
                        BoundingBox boundingBox3 = new BoundingBox(this);
                        BoundingBox boundingBox4 = new BoundingBox(bounds);
                        boundingBox3.intersect((Bounds)boundingBox4, boundingBox);
                        if (bl) {
                            boundingSphere.combine(boundingBox);
                        } else {
                            boundingSphere.set(boundingBox);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere9"));
                }
            }
            ++n;
        }
        if (!bl) {
            boundingSphere.boundsIsEmpty = true;
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        boolean bl = false;
        boolean bl2 = false;
        double d = 1.0E13;
        int n = 0;
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        int n2 = 0;
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && this.intersect(boundsArray[n2])) {
                double d2;
                Bounds bounds;
                bl2 = true;
                if (boundsArray[n2] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n2];
                    d2 = Math.sqrt((this.center.x - bounds.center.x) * (this.center.x - bounds.center.x) + (this.center.y - bounds.center.y) * (this.center.y - bounds.center.y) + (this.center.z - bounds.center.z) * (this.center.z - bounds.center.z));
                    if (d2 + bounds.radius <= this.radius) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else if (boundsArray[n2] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n2];
                    point3d.x = (((BoundingBox)bounds).upper.x + ((BoundingBox)bounds).lower.x) / 2.0;
                    point3d.y = (((BoundingBox)bounds).upper.y + ((BoundingBox)bounds).lower.y) / 2.0;
                    point3d.z = (((BoundingBox)bounds).upper.z + ((BoundingBox)bounds).lower.z) / 2.0;
                    d2 = Math.sqrt((this.center.x - point3d.x) * (this.center.x - point3d.x) + (this.center.y - point3d.y) * (this.center.y - point3d.y) + (this.center.z - point3d.z) * (this.center.z - point3d.z));
                    double d3 = (this.center.x - ((BoundingBox)bounds).lower.x) * (this.center.x - ((BoundingBox)bounds).lower.x) > (this.center.x - ((BoundingBox)bounds).upper.x) * (this.center.x - ((BoundingBox)bounds).upper.x) ? (this.center.x - ((BoundingBox)bounds).lower.x) * (this.center.x - ((BoundingBox)bounds).lower.x) : (this.center.x - ((BoundingBox)bounds).upper.x) * (this.center.x - ((BoundingBox)bounds).upper.x);
                    d3 = (this.center.y - ((BoundingBox)bounds).lower.y) * (this.center.y - ((BoundingBox)bounds).lower.y) > (this.center.y - ((BoundingBox)bounds).upper.y) * (this.center.y - ((BoundingBox)bounds).upper.y) ? (d3 += (this.center.y - ((BoundingBox)bounds).lower.y) * (this.center.y - ((BoundingBox)bounds).lower.y)) : (d3 += (this.center.y - ((BoundingBox)bounds).upper.y) * (this.center.y - ((BoundingBox)bounds).upper.y));
                    d3 = (this.center.z - ((BoundingBox)bounds).lower.z) * (this.center.z - ((BoundingBox)bounds).lower.z) > (this.center.z - ((BoundingBox)bounds).upper.z) * (this.center.z - ((BoundingBox)bounds).upper.z) ? (d3 += (this.center.z - ((BoundingBox)bounds).lower.z) * (this.center.z - ((BoundingBox)bounds).lower.z)) : (d3 += (this.center.z - ((BoundingBox)bounds).upper.z) * (this.center.z - ((BoundingBox)bounds).upper.z));
                    double d4 = this.radius * this.radius;
                    if (d3 <= d4) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else if (boundsArray[n2] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n2];
                    d2 = Math.sqrt((this.center.x - ((BoundingPolytope)bounds).centroid.x) * (this.center.x - ((BoundingPolytope)bounds).centroid.x) + (this.center.y - ((BoundingPolytope)bounds).centroid.y) * (this.center.y - ((BoundingPolytope)bounds).centroid.y) + (this.center.z - ((BoundingPolytope)bounds).centroid.z) * (this.center.z - ((BoundingPolytope)bounds).centroid.z));
                    boolean bl3 = true;
                    int n3 = 0;
                    while (n3 < ((BoundingPolytope)bounds).nVerts) {
                        double d5 = ((BoundingPolytope)bounds).verts[n3].x - this.center.x;
                        double d6 = ((BoundingPolytope)bounds).verts[n3].y - this.center.y;
                        double d7 = ((BoundingPolytope)bounds).verts[n3].z - this.center.z;
                        double d8 = d5 * d5 + d6 * d6 + d7 * d7;
                        if (d8 > this.radius * this.radius) {
                            bl3 = false;
                        }
                        ++n3;
                    }
                    if (bl3) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere10"));
                }
            }
            ++n2;
        }
        if (bl2) {
            return boundsArray[n];
        }
        return null;
    }

    public String toString() {
        return new String("Center=" + this.center + "  Radius=" + this.radius);
    }

    private void checkBoundsIsEmpty() {
        if (this.checkBoundsIsNaN()) {
            return;
        }
        if (this.radius < 0.0) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
        } else {
            this.boundsIsEmpty = false;
            this.zeroVolume = this.radius == 0.0;
        }
    }

    boolean checkBoundsIsNaN() {
        if (Double.isNaN(this.radius + this.center.x + this.center.y + this.center.z)) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
            return true;
        }
        return false;
    }

    Point3d getCenter() {
        return this.center;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            boundingSphere.radius = this.radius;
            boundingSphere.center.x = this.center.x;
            boundingSphere.center.y = this.center.y;
            boundingSphere.center.z = this.center.z;
            return boundingSphere;
        }
        return (Bounds)this.clone();
    }
}

