/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingBox
extends Bounds {
    Point3d lower;
    Point3d upper;
    private boolean boundsIsEmpty = false;
    private Point3d centroid = null;
    private static final double EPS = 1.0E-8;
    private BoundingSphere tmpSphere = null;
    private BoundingBox tmpBox = null;
    private BoundingPolytope tmpPolytope = null;
    private Point3d tmpP3d = new Point3d();

    public BoundingBox(Point3d point3d, Point3d point3d2) {
        this.boundId = 1;
        this.lower = new Point3d(point3d);
        this.upper = new Point3d(point3d2);
        this.checkBoundsIsEmpty();
    }

    public BoundingBox() {
        this.boundId = 1;
        this.lower = new Point3d(-1.0, -1.0, -1.0);
        this.upper = new Point3d(1.0, 1.0, 1.0);
    }

    public BoundingBox(Bounds bounds) {
        this.boundId = 1;
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
            this.lower = new Point3d(1.0, 1.0, 1.0);
            this.upper = new Point3d(-1.0, -1.0, -1.0);
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.lower = new Point3d(boundingSphere.center.x - boundingSphere.radius, boundingSphere.center.y - boundingSphere.radius, boundingSphere.center.z - boundingSphere.radius);
            this.upper = new Point3d(boundingSphere.center.x + boundingSphere.radius, boundingSphere.center.y + boundingSphere.radius, boundingSphere.center.z + boundingSphere.radius);
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.lower = new Point3d(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            this.upper = new Point3d(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (boundingPolytope.nVerts < 1) {
                this.lower = new Point3d(-1.0, -1.0, -1.0);
                this.upper = new Point3d(1.0, 1.0, 1.0);
            } else {
                this.lower = new Point3d(boundingPolytope.verts[0].x, boundingPolytope.verts[0].y, boundingPolytope.verts[0].z);
                this.upper = new Point3d(boundingPolytope.verts[0].x, boundingPolytope.verts[0].y, boundingPolytope.verts[0].z);
                int n = 1;
                while (n < boundingPolytope.nVerts) {
                    if (boundingPolytope.verts[n].x < this.lower.x) {
                        this.lower.x = boundingPolytope.verts[n].x;
                    }
                    if (boundingPolytope.verts[n].y < this.lower.y) {
                        this.lower.y = boundingPolytope.verts[n].y;
                    }
                    if (boundingPolytope.verts[n].z < this.lower.z) {
                        this.lower.z = boundingPolytope.verts[n].z;
                    }
                    if (boundingPolytope.verts[n].x > this.upper.x) {
                        this.upper.x = boundingPolytope.verts[n].x;
                    }
                    if (boundingPolytope.verts[n].y > this.upper.y) {
                        this.upper.y = boundingPolytope.verts[n].y;
                    }
                    if (boundingPolytope.verts[n].z > this.upper.z) {
                        this.upper.z = boundingPolytope.verts[n].z;
                    }
                    ++n;
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.checkBoundsIsEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BoundingBox(Bounds[] var1_1) {
        super();
        var2_2 = 0;
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.boundId = 1;
        if (var1_1 != null && var1_1.length > 0) ** GOTO lbl17
        this.boundsIsEmpty = true;
        this.zeroVolume = true;
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl17:
            // 2 sources

            ** while (var1_1[var2_2] == null && var2_2 < var1_1.length)
        }
lbl18:
        // 1 sources

        if (var2_2 >= var1_1.length) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
            return;
        }
        this.set(var1_1[var2_2++]);
        while (var2_2 < var1_1.length) {
            if (var1_1[var2_2] != null && !var1_1[var2_2].isEmpty()) {
                if (var1_1[var2_2] instanceof BoundingSphere) {
                    var3_3 /* !! */  = (BoundingSphere)var1_1[var2_2];
                    if (this.lower.x > var3_3 /* !! */ .center.x - var3_3 /* !! */ .radius) {
                        this.lower.x = var3_3 /* !! */ .center.x - var3_3 /* !! */ .radius;
                    }
                    if (this.lower.y > var3_3 /* !! */ .center.y - var3_3 /* !! */ .radius) {
                        this.lower.y = var3_3 /* !! */ .center.y - var3_3 /* !! */ .radius;
                    }
                    if (this.lower.z > var3_3 /* !! */ .center.z - var3_3 /* !! */ .radius) {
                        this.lower.z = var3_3 /* !! */ .center.z - var3_3 /* !! */ .radius;
                    }
                    if (this.upper.x < var3_3 /* !! */ .center.x + var3_3 /* !! */ .radius) {
                        this.upper.x = var3_3 /* !! */ .center.x + var3_3 /* !! */ .radius;
                    }
                    if (this.upper.y < var3_3 /* !! */ .center.y + var3_3 /* !! */ .radius) {
                        this.upper.y = var3_3 /* !! */ .center.y + var3_3 /* !! */ .radius;
                    }
                    if (this.upper.z < var3_3 /* !! */ .center.z + var3_3 /* !! */ .radius) {
                        this.upper.z = var3_3 /* !! */ .center.z + var3_3 /* !! */ .radius;
                    }
                } else if (var1_1[var2_2] instanceof BoundingBox) {
                    var3_3 /* !! */  = (BoundingBox)var1_1[var2_2];
                    if (this.lower.x > var3_3 /* !! */ .lower.x) {
                        this.lower.x = var3_3 /* !! */ .lower.x;
                    }
                    if (this.lower.y > var3_3 /* !! */ .lower.y) {
                        this.lower.y = var3_3 /* !! */ .lower.y;
                    }
                    if (this.lower.z > var3_3 /* !! */ .lower.z) {
                        this.lower.z = var3_3 /* !! */ .lower.z;
                    }
                    if (this.upper.x < var3_3 /* !! */ .upper.x) {
                        this.upper.x = var3_3 /* !! */ .upper.x;
                    }
                    if (this.upper.y < var3_3 /* !! */ .upper.y) {
                        this.upper.y = var3_3 /* !! */ .upper.y;
                    }
                    if (this.upper.z < var3_3 /* !! */ .upper.z) {
                        this.upper.z = var3_3 /* !! */ .upper.z;
                    }
                } else if (var1_1[var2_2] instanceof BoundingPolytope) {
                    var3_3 /* !! */  = (BoundingPolytope)var1_1[var2_2];
                    var2_2 = 0;
                    while (var2_2 < var3_3 /* !! */ .nVerts) {
                        if (var3_3 /* !! */ .verts[var2_2].x < this.lower.x) {
                            this.lower.x = var3_3 /* !! */ .verts[var2_2].x;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].y < this.lower.y) {
                            this.lower.y = var3_3 /* !! */ .verts[var2_2].y;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].z < this.lower.z) {
                            this.lower.z = var3_3 /* !! */ .verts[var2_2].z;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].x > this.upper.x) {
                            this.upper.x = var3_3 /* !! */ .verts[var2_2].x;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].y > this.upper.y) {
                            this.upper.y = var3_3 /* !! */ .verts[var2_2].y;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].z > this.upper.z) {
                            this.upper.z = var3_3 /* !! */ .verts[var2_2].z;
                        }
                        ++var2_2;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox1"));
                }
            }
            ++var2_2;
        }
        this.checkBoundsIsEmpty();
    }

    public void getLower(Point3d point3d) {
        point3d.x = this.lower.x;
        point3d.y = this.lower.y;
        point3d.z = this.lower.z;
    }

    public void setLower(double d, double d2, double d3) {
        this.lower.x = d;
        this.lower.y = d2;
        this.lower.z = d3;
        this.checkBoundsIsEmpty();
    }

    public void setLower(Point3d point3d) {
        this.lower.x = point3d.x;
        this.lower.y = point3d.y;
        this.lower.z = point3d.z;
        this.checkBoundsIsEmpty();
    }

    public void getUpper(Point3d point3d) {
        point3d.x = this.upper.x;
        point3d.y = this.upper.y;
        point3d.z = this.upper.z;
    }

    public void setUpper(double d, double d2, double d3) {
        this.upper.x = d;
        this.upper.y = d2;
        this.upper.z = d3;
        this.checkBoundsIsEmpty();
    }

    public void setUpper(Point3d point3d) {
        this.upper.x = point3d.x;
        this.upper.y = point3d.y;
        this.upper.z = point3d.z;
        this.checkBoundsIsEmpty();
    }

    public void set(Bounds bounds) {
        if (bounds == null) {
            this.boundsIsEmpty = true;
            return;
        }
        if (bounds.isEmpty()) {
            this.boundsIsEmpty = true;
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.lower.x = boundingSphere.center.x - boundingSphere.radius;
            this.lower.y = boundingSphere.center.y - boundingSphere.radius;
            this.lower.z = boundingSphere.center.z - boundingSphere.radius;
            this.upper.x = boundingSphere.center.x + boundingSphere.radius;
            this.upper.y = boundingSphere.center.y + boundingSphere.radius;
            this.upper.z = boundingSphere.center.z + boundingSphere.radius;
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.lower.x = boundingBox.lower.x;
            this.lower.y = boundingBox.lower.y;
            this.lower.z = boundingBox.lower.z;
            this.upper.x = boundingBox.upper.x;
            this.upper.y = boundingBox.upper.y;
            this.upper.z = boundingBox.upper.z;
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.lower.x = this.upper.x = boundingPolytope.verts[0].x;
            this.lower.y = this.upper.y = boundingPolytope.verts[0].y;
            this.lower.z = this.upper.z = boundingPolytope.verts[0].z;
            int n = 1;
            while (n < boundingPolytope.nVerts) {
                if (boundingPolytope.verts[n].x < this.lower.x) {
                    this.lower.x = boundingPolytope.verts[n].x;
                }
                if (boundingPolytope.verts[n].y < this.lower.y) {
                    this.lower.y = boundingPolytope.verts[n].y;
                }
                if (boundingPolytope.verts[n].z < this.lower.z) {
                    this.lower.z = boundingPolytope.verts[n].z;
                }
                if (boundingPolytope.verts[n].x > this.upper.x) {
                    this.upper.x = boundingPolytope.verts[n].x;
                }
                if (boundingPolytope.verts[n].y > this.upper.y) {
                    this.upper.y = boundingPolytope.verts[n].y;
                }
                if (boundingPolytope.verts[n].z > this.upper.z) {
                    this.upper.z = boundingPolytope.verts[n].z;
                }
                ++n;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.checkBoundsIsEmpty();
    }

    public Object clone() {
        return new BoundingBox(this.lower, this.upper);
    }

    public boolean equals(Object object) {
        try {
            BoundingBox boundingBox = (BoundingBox)object;
            return this.lower.equals((Tuple3d)boundingBox.lower) && this.upper.equals((Tuple3d)boundingBox.upper);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + Double.doubleToLongBits(this.lower.x);
        l = 31L * l + Double.doubleToLongBits(this.lower.y);
        l = 31L * l + Double.doubleToLongBits(this.lower.z);
        l = 31L * l + Double.doubleToLongBits(this.upper.x);
        l = 31L * l + Double.doubleToLongBits(this.upper.y);
        l = 31L * l + Double.doubleToLongBits(this.upper.z);
        return (int)(l ^ l >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.isEmpty()) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(bounds);
            return;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.lower.x > boundingSphere.center.x - boundingSphere.radius) {
                this.lower.x = boundingSphere.center.x - boundingSphere.radius;
            }
            if (this.lower.y > boundingSphere.center.y - boundingSphere.radius) {
                this.lower.y = boundingSphere.center.y - boundingSphere.radius;
            }
            if (this.lower.z > boundingSphere.center.z - boundingSphere.radius) {
                this.lower.z = boundingSphere.center.z - boundingSphere.radius;
            }
            if (this.upper.x < boundingSphere.center.x + boundingSphere.radius) {
                this.upper.x = boundingSphere.center.x + boundingSphere.radius;
            }
            if (this.upper.y < boundingSphere.center.y + boundingSphere.radius) {
                this.upper.y = boundingSphere.center.y + boundingSphere.radius;
            }
            if (this.upper.z < boundingSphere.center.z + boundingSphere.radius) {
                this.upper.z = boundingSphere.center.z + boundingSphere.radius;
            }
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (this.lower.x > boundingBox.lower.x) {
                this.lower.x = boundingBox.lower.x;
            }
            if (this.lower.y > boundingBox.lower.y) {
                this.lower.y = boundingBox.lower.y;
            }
            if (this.lower.z > boundingBox.lower.z) {
                this.lower.z = boundingBox.lower.z;
            }
            if (this.upper.x < boundingBox.upper.x) {
                this.upper.x = boundingBox.upper.x;
            }
            if (this.upper.y < boundingBox.upper.y) {
                this.upper.y = boundingBox.upper.y;
            }
            if (this.upper.z < boundingBox.upper.z) {
                this.upper.z = boundingBox.upper.z;
            }
        } else if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            int n = 1;
            while (n < boundingPolytope.nVerts) {
                if (boundingPolytope.verts[n].x < this.lower.x) {
                    this.lower.x = boundingPolytope.verts[n].x;
                }
                if (boundingPolytope.verts[n].y < this.lower.y) {
                    this.lower.y = boundingPolytope.verts[n].y;
                }
                if (boundingPolytope.verts[n].z < this.lower.z) {
                    this.lower.z = boundingPolytope.verts[n].z;
                }
                if (boundingPolytope.verts[n].x > this.upper.x) {
                    this.upper.x = boundingPolytope.verts[n].x;
                }
                if (boundingPolytope.verts[n].y > this.upper.y) {
                    this.upper.y = boundingPolytope.verts[n].y;
                }
                if (boundingPolytope.verts[n].z > this.upper.z) {
                    this.upper.z = boundingPolytope.verts[n].z;
                }
                ++n;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox3"));
        }
        this.checkBoundsIsEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void combine(Bounds[] var1_1) {
        var2_2 = 0;
        if (var1_1 != null && var1_1.length > 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl5:
            // 2 sources

            ** while ((var1_1[var2_2] == null || var1_1[var2_2].isEmpty()) && var2_2 < var1_1.length)
        }
lbl6:
        // 1 sources

        if (var2_2 >= var1_1.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(var1_1[var2_2++]);
        }
        while (var2_2 < var1_1.length) {
            if (var1_1[var2_2] != null && !var1_1[var2_2].isEmpty()) {
                if (var1_1[var2_2] instanceof BoundingSphere) {
                    var3_3 /* !! */  = (BoundingSphere)var1_1[var2_2];
                    if (this.lower.x > var3_3 /* !! */ .center.x - var3_3 /* !! */ .radius) {
                        this.lower.x = var3_3 /* !! */ .center.x - var3_3 /* !! */ .radius;
                    }
                    if (this.lower.y > var3_3 /* !! */ .center.y - var3_3 /* !! */ .radius) {
                        this.lower.y = var3_3 /* !! */ .center.y - var3_3 /* !! */ .radius;
                    }
                    if (this.lower.z > var3_3 /* !! */ .center.z - var3_3 /* !! */ .radius) {
                        this.lower.z = var3_3 /* !! */ .center.z - var3_3 /* !! */ .radius;
                    }
                    if (this.upper.x < var3_3 /* !! */ .center.x + var3_3 /* !! */ .radius) {
                        this.upper.x = var3_3 /* !! */ .center.x + var3_3 /* !! */ .radius;
                    }
                    if (this.upper.y < var3_3 /* !! */ .center.y + var3_3 /* !! */ .radius) {
                        this.upper.y = var3_3 /* !! */ .center.y + var3_3 /* !! */ .radius;
                    }
                    if (this.upper.z < var3_3 /* !! */ .center.z + var3_3 /* !! */ .radius) {
                        this.upper.z = var3_3 /* !! */ .center.z + var3_3 /* !! */ .radius;
                    }
                } else if (var1_1[var2_2] instanceof BoundingBox) {
                    var3_3 /* !! */  = (BoundingBox)var1_1[var2_2];
                    if (this.lower.x > var3_3 /* !! */ .lower.x) {
                        this.lower.x = var3_3 /* !! */ .lower.x;
                    }
                    if (this.lower.y > var3_3 /* !! */ .lower.y) {
                        this.lower.y = var3_3 /* !! */ .lower.y;
                    }
                    if (this.lower.z > var3_3 /* !! */ .lower.z) {
                        this.lower.z = var3_3 /* !! */ .lower.z;
                    }
                    if (this.upper.x < var3_3 /* !! */ .upper.x) {
                        this.upper.x = var3_3 /* !! */ .upper.x;
                    }
                    if (this.upper.y < var3_3 /* !! */ .upper.y) {
                        this.upper.y = var3_3 /* !! */ .upper.y;
                    }
                    if (this.upper.z < var3_3 /* !! */ .upper.z) {
                        this.upper.z = var3_3 /* !! */ .upper.z;
                    }
                } else if (var1_1[var2_2] instanceof BoundingPolytope) {
                    var3_3 /* !! */  = (BoundingPolytope)var1_1[var2_2];
                    var2_2 = 1;
                    while (var2_2 < var3_3 /* !! */ .nVerts) {
                        if (var3_3 /* !! */ .verts[var2_2].x < this.lower.x) {
                            this.lower.x = var3_3 /* !! */ .verts[var2_2].x;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].y < this.lower.y) {
                            this.lower.y = var3_3 /* !! */ .verts[var2_2].y;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].z < this.lower.z) {
                            this.lower.z = var3_3 /* !! */ .verts[var2_2].z;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].x > this.upper.x) {
                            this.upper.x = var3_3 /* !! */ .verts[var2_2].x;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].y > this.upper.y) {
                            this.upper.y = var3_3 /* !! */ .verts[var2_2].y;
                        }
                        if (var3_3 /* !! */ .verts[var2_2].z > this.upper.z) {
                            this.upper.z = var3_3 /* !! */ .verts[var2_2].z;
                        }
                        ++var2_2;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox4"));
                }
            }
            ++var2_2;
        }
        this.checkBoundsIsEmpty();
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsEmpty) {
            this.upper.x = this.lower.x = point3d.x;
            this.upper.y = this.lower.y = point3d.y;
            this.upper.z = this.lower.z = point3d.z;
        } else {
            if (point3d.x > this.upper.x) {
                this.upper.x = point3d.x;
            }
            if (point3d.y > this.upper.y) {
                this.upper.y = point3d.y;
            }
            if (point3d.z > this.upper.z) {
                this.upper.z = point3d.z;
            }
            if (point3d.x < this.lower.x) {
                this.lower.x = point3d.x;
            }
            if (point3d.y < this.lower.y) {
                this.lower.y = point3d.y;
            }
            if (point3d.z < this.lower.z) {
                this.lower.z = point3d.z;
            }
        }
        this.checkBoundsIsEmpty();
    }

    public void combine(Point3d[] point3dArray) {
        if (this.boundsIsEmpty) {
            this.setUpper(point3dArray[0]);
            this.setLower(point3dArray[0]);
        }
        int n = 0;
        while (n < point3dArray.length) {
            if (point3dArray[n].x > this.upper.x) {
                this.upper.x = point3dArray[n].x;
            }
            if (point3dArray[n].y > this.upper.y) {
                this.upper.y = point3dArray[n].y;
            }
            if (point3dArray[n].z > this.upper.z) {
                this.upper.z = point3dArray[n].z;
            }
            if (point3dArray[n].x < this.lower.x) {
                this.lower.x = point3dArray[n].x;
            }
            if (point3dArray[n].y < this.lower.y) {
                this.lower.y = point3dArray[n].y;
            }
            if (point3dArray[n].z < this.lower.z) {
                this.lower.z = point3dArray[n].z;
            }
            ++n;
        }
        this.checkBoundsIsEmpty();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.isEmpty()) {
            this.boundsIsEmpty = true;
            return;
        }
        if (bounds instanceof BoundingSphere) {
            if (this.tmpSphere == null) {
                this.tmpSphere = new BoundingSphere((BoundingSphere)bounds);
            } else {
                this.tmpSphere.set((BoundingSphere)bounds);
            }
            this.tmpSphere.transform(transform3D);
            this.set(this.tmpSphere);
        } else if (bounds instanceof BoundingBox) {
            if (this.tmpBox == null) {
                this.tmpBox = new BoundingBox((BoundingBox)bounds);
            } else {
                this.tmpBox.set((BoundingBox)bounds);
            }
            this.tmpBox.transform(transform3D);
            this.set(this.tmpBox);
        } else if (bounds instanceof BoundingPolytope) {
            if (this.tmpPolytope == null) {
                this.tmpPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            } else {
                this.tmpPolytope.set((BoundingPolytope)bounds);
            }
            this.tmpPolytope.transform(transform3D);
            this.set(this.tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox5"));
        }
    }

    public void transform(Transform3D transform3D) {
        double d = this.upper.x;
        double d2 = this.upper.y;
        double d3 = this.upper.z;
        double d4 = this.lower.x;
        double d5 = this.lower.y;
        double d6 = this.lower.z;
        this.tmpP3d.set(d, d2, d3);
        transform3D.transform(this.tmpP3d);
        this.upper.x = this.tmpP3d.x;
        this.upper.y = this.tmpP3d.y;
        this.upper.z = this.tmpP3d.z;
        this.lower.x = this.tmpP3d.x;
        this.lower.y = this.tmpP3d.y;
        this.lower.z = this.tmpP3d.z;
        this.tmpP3d.set(d4, d2, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d5, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d5, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d2, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d2, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d5, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d5, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        double d;
        double d2;
        double d3;
        double d4;
        Vector3d vector3d2 = new Vector3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        double d5 = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        if (d5 == 0.0) {
            return this.intersect(point3d, point4d);
        }
        double d6 = 1.0 / Math.sqrt(d5);
        vector3d2.x = vector3d.x * d6;
        vector3d2.y = vector3d.y * d6;
        vector3d2.z = vector3d.z * d6;
        double d7 = -1.7976931348623157E308;
        double d8 = Double.MAX_VALUE;
        if (vector3d2.x == 0.0) {
            if (point3d.x < this.lower.x || point3d.x > this.upper.x) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d2.x;
            d3 = (this.lower.x - point3d.x) * d4;
            d2 = (this.upper.x - point3d.x) * d4;
            if (d3 > d2) {
                d7 = d2;
                d8 = d3;
            } else {
                d7 = d3;
                d8 = d2;
            }
            if (d8 < 0.0) {
                return false;
            }
        }
        if (vector3d2.y == 0.0) {
            if (point3d.y < this.lower.y || point3d.y > this.upper.y) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d2.y;
            d3 = (this.lower.y - point3d.y) * d4;
            d2 = (this.upper.y - point3d.y) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d7) {
                d7 = d3;
            }
            if (d2 < d8) {
                d8 = d2;
            }
            if (d8 < 0.0 || d7 > d8) {
                return false;
            }
        }
        if (vector3d2.z == 0.0) {
            if (point3d.z < this.lower.z || point3d.z > this.upper.z) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d2.z;
            d3 = (this.lower.z - point3d.z) * d4;
            d2 = (this.upper.z - point3d.z) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d7) {
                d7 = d3;
            }
            if (d2 < d8) {
                d8 = d2;
            }
            if (d8 < 0.0 || d7 > d8) {
                return false;
            }
        }
        if (d7 < 0.0 && d8 >= 0.0) {
            point4d.x = point3d.x + vector3d2.x * d8;
            point4d.y = point3d.y + vector3d2.y * d8;
            point4d.z = point3d.z + vector3d2.z * d8;
            point4d.w = d8;
        } else {
            point4d.x = point3d.x + vector3d2.x * d7;
            point4d.y = point3d.y + vector3d2.y * d7;
            point4d.z = point3d.z + vector3d2.z * d7;
            point4d.w = d7;
        }
        return true;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (point3d.x <= this.upper.x && point3d.x >= this.lower.x && point3d.y <= this.upper.y && point3d.y >= this.lower.y && point3d.z <= this.upper.z && point3d.z >= this.lower.z) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        double d;
        double d2;
        double d3;
        double d4;
        Vector3d vector3d = new Vector3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        double d5 = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        if (d5 == 0.0) {
            return this.intersect(point3d, point4d);
        }
        d5 = Math.sqrt(d5);
        double d6 = 1.0 / d5;
        vector3d.x *= d6;
        vector3d.y *= d6;
        vector3d.z *= d6;
        double d7 = -1.7976931348623157E308;
        double d8 = Double.MAX_VALUE;
        if (vector3d.x == 0.0) {
            if (point3d.x < this.lower.x || point3d.x > this.upper.x) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d.x;
            d3 = (this.lower.x - point3d.x) * d4;
            d2 = (this.upper.x - point3d.x) * d4;
            if (d3 > d2) {
                d7 = d2;
                d8 = d3;
            } else {
                d7 = d3;
                d8 = d2;
            }
            if (d8 < 0.0) {
                return false;
            }
        }
        if (vector3d.y == 0.0) {
            if (point3d.y < this.lower.y || point3d.y > this.upper.y) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d.y;
            d3 = (this.lower.y - point3d.y) * d4;
            d2 = (this.upper.y - point3d.y) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d7) {
                d7 = d3;
            }
            if (d2 < d8) {
                d8 = d2;
            }
            if (d8 < 0.0 || d7 > d8) {
                return false;
            }
        }
        if (vector3d.z == 0.0) {
            if (point3d.z < this.lower.z || point3d.z > this.upper.z) {
                return false;
            }
        } else {
            d4 = 1.0 / vector3d.z;
            d3 = (this.lower.z - point3d.z) * d4;
            d2 = (this.upper.z - point3d.z) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d7) {
                d7 = d3;
            }
            if (d2 < d8) {
                d8 = d2;
            }
            if (d8 < 0.0 || d7 > d8) {
                return false;
            }
        }
        if (d7 < 0.0 && d8 >= 0.0) {
            point4d.x = point3d.x + vector3d.x * d8;
            point4d.y = point3d.y + vector3d.y * d8;
            point4d.z = point3d.z + vector3d.z * d8;
            point4d.w = d8;
        } else {
            if (d7 > d5) {
                return false;
            }
            point4d.x = point3d.x + vector3d.x * d7;
            point4d.y = point3d.y + vector3d.y * d7;
            point4d.z = point3d.z + vector3d.z * d7;
            point4d.w = d7;
        }
        return true;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        Point3d point3d2 = new Point3d();
        if (this.boundsIsEmpty) {
            return false;
        }
        return this.intersect(point3d, vector3d, point3d2);
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = 0.0;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (point3d2 == null) {
            return false;
        }
        if (vector3d.x > 0.0) {
            d = Math.max(d, (this.lower.x - point3d.x) / vector3d.x);
        }
        if (vector3d.x < 0.0) {
            d = Math.max(d, (this.upper.x - point3d.x) / vector3d.x);
        }
        if (vector3d.y > 0.0) {
            d = Math.max(d, (this.lower.y - point3d.y) / vector3d.y);
        }
        if (vector3d.y < 0.0) {
            d = Math.max(d, (this.upper.y - point3d.y) / vector3d.y);
        }
        if (vector3d.z > 0.0) {
            d = Math.max(d, (this.lower.z - point3d.z) / vector3d.z);
        }
        if (vector3d.z < 0.0) {
            d = Math.max(d, (this.upper.z - point3d.z) / vector3d.z);
        }
        point3d2.x = point3d.x + d * vector3d.x;
        point3d2.y = point3d.y + d * vector3d.y;
        point3d2.z = point3d.z + d * vector3d.z;
        if (point3d2.x < this.lower.x - 1.0E-8) {
            return false;
        }
        if (point3d2.x > this.upper.x + 1.0E-8) {
            return false;
        }
        if (point3d2.y < this.lower.y - 1.0E-8) {
            return false;
        }
        if (point3d2.y > this.upper.y + 1.0E-8) {
            return false;
        }
        if (point3d2.z < this.lower.z - 1.0E-8) {
            return false;
        }
        return !(point3d2.z > this.upper.z + 1.0E-8);
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        return point3d.x <= this.upper.x && point3d.x >= this.lower.x && point3d.y <= this.upper.y && point3d.y >= this.lower.y && point3d.z <= this.upper.z && point3d.z >= this.lower.z;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.isEmpty()) {
            return false;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = boundingSphere.radius * boundingSphere.radius;
            double d2 = 0.0;
            if (boundingSphere.center.x < this.lower.x) {
                d2 = (boundingSphere.center.x - this.lower.x) * (boundingSphere.center.x - this.lower.x);
            } else if (boundingSphere.center.x > this.upper.x) {
                d2 = (boundingSphere.center.x - this.upper.x) * (boundingSphere.center.x - this.upper.x);
            }
            if (boundingSphere.center.y < this.lower.y) {
                d2 += (boundingSphere.center.y - this.lower.y) * (boundingSphere.center.y - this.lower.y);
            } else if (boundingSphere.center.y > this.upper.y) {
                d2 += (boundingSphere.center.y - this.upper.y) * (boundingSphere.center.y - this.upper.y);
            }
            if (boundingSphere.center.z < this.lower.z) {
                d2 += (boundingSphere.center.z - this.lower.z) * (boundingSphere.center.z - this.lower.z);
            } else if (boundingSphere.center.z > this.upper.z) {
                d2 += (boundingSphere.center.z - this.upper.z) * (boundingSphere.center.z - this.upper.z);
            }
            return d2 <= d;
        }
        if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            return this.upper.x > boundingBox.lower.x && boundingBox.upper.x > this.lower.x && this.upper.y > boundingBox.lower.y && boundingBox.upper.y > this.lower.y && this.upper.z > boundingBox.lower.z && boundingBox.upper.z > this.lower.z;
        }
        if (bounds instanceof BoundingPolytope) {
            return this.intersect_ptope_abox((BoundingPolytope)bounds, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        int n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].isEmpty()) {
                Bounds bounds;
                if (boundsArray[n] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n];
                    double d = bounds.radius * bounds.radius;
                    double d2 = 0.0;
                    if (bounds.center.x < this.lower.x) {
                        d2 = (bounds.center.x - this.lower.x) * (bounds.center.x - this.lower.x);
                    } else if (bounds.center.x > this.upper.x) {
                        d2 = (bounds.center.x - this.upper.x) * (bounds.center.x - this.upper.x);
                    }
                    if (bounds.center.y < this.lower.y) {
                        d2 += (bounds.center.y - this.lower.y) * (bounds.center.y - this.lower.y);
                    } else if (bounds.center.y > this.upper.y) {
                        d2 += (bounds.center.y - this.upper.y) * (bounds.center.y - this.upper.y);
                    }
                    if (bounds.center.z < this.lower.z) {
                        d2 += (bounds.center.z - this.lower.z) * (bounds.center.z - this.lower.z);
                    } else if (bounds.center.z > this.upper.z) {
                        d2 += (bounds.center.z - this.upper.z) * (bounds.center.z - this.upper.z);
                    }
                    if (d2 <= d) {
                        return true;
                    }
                } else if (boundsArray[n] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.upper.x > ((BoundingBox)bounds).lower.x && ((BoundingBox)bounds).upper.x > this.lower.x && this.upper.y > ((BoundingBox)bounds).lower.y && ((BoundingBox)bounds).upper.y > this.lower.y && this.upper.z > ((BoundingBox)bounds).lower.z && ((BoundingBox)bounds).upper.z > this.lower.z) {
                        return true;
                    }
                } else if (boundsArray[n] instanceof BoundingPolytope && this.intersect_ptope_abox((BoundingPolytope)boundsArray[n], this)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingBox boundingBox) {
        if (bounds == null) {
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        if (this.boundsIsEmpty || bounds.isEmpty()) {
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.intersect(boundingSphere)) {
                BoundingBox boundingBox2 = new BoundingBox(boundingSphere);
                this.intersect((Bounds)boundingBox2, boundingBox);
                return true;
            }
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox3 = (BoundingBox)bounds;
            if (this.upper.x > boundingBox3.lower.x && boundingBox3.upper.x > this.lower.x && this.upper.y > boundingBox3.lower.y && boundingBox3.upper.y > this.lower.y && this.upper.z > boundingBox3.lower.z && boundingBox3.upper.z > this.lower.z) {
                boundingBox.upper.x = this.upper.x > boundingBox3.upper.x ? boundingBox3.upper.x : this.upper.x;
                boundingBox.upper.y = this.upper.y > boundingBox3.upper.y ? boundingBox3.upper.y : this.upper.y;
                boundingBox.upper.z = this.upper.z > boundingBox3.upper.z ? boundingBox3.upper.z : this.upper.z;
                boundingBox.lower.x = this.lower.x < boundingBox3.lower.x ? boundingBox3.lower.x : this.lower.x;
                boundingBox.lower.y = this.lower.y < boundingBox3.lower.y ? boundingBox3.lower.y : this.lower.y;
                boundingBox.lower.z = this.lower.z < boundingBox3.lower.z ? boundingBox3.lower.z : this.lower.z;
                return true;
            }
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope)) {
                BoundingBox boundingBox4 = new BoundingBox(boundingPolytope);
                this.intersect((Bounds)boundingBox4, boundingBox);
                return true;
            }
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox7"));
    }

    public boolean intersect(Bounds[] boundsArray, BoundingBox boundingBox) {
        boolean bl = false;
        BoundingBox boundingBox2 = new BoundingBox();
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingBox.boundsIsEmpty = true;
            return false;
        }
        int n = 0;
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].isEmpty()) {
                BoundingBox boundingBox3;
                Bounds bounds;
                if (boundsArray[n] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n];
                    if (this.intersect(bounds)) {
                        boundingBox3 = new BoundingBox(bounds);
                        this.intersect((Bounds)boundingBox3, boundingBox2);
                        if (bl) {
                            boundingBox.combine(boundingBox2);
                        } else {
                            boundingBox.set(boundingBox2);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.upper.x > ((BoundingBox)bounds).lower.x && ((BoundingBox)bounds).upper.x > this.lower.x && this.upper.y > ((BoundingBox)bounds).lower.y && ((BoundingBox)bounds).upper.y > this.lower.y && this.upper.z > ((BoundingBox)bounds).lower.z && ((BoundingBox)bounds).upper.z > this.lower.z) {
                        boundingBox.upper.x = this.upper.x > ((BoundingBox)bounds).upper.x ? ((BoundingBox)bounds).upper.x : this.upper.x;
                        boundingBox.upper.y = this.upper.y > ((BoundingBox)bounds).upper.y ? ((BoundingBox)bounds).upper.y : this.upper.y;
                        boundingBox.upper.z = this.upper.z > ((BoundingBox)bounds).upper.z ? ((BoundingBox)bounds).upper.z : this.upper.z;
                        boundingBox.lower.x = this.lower.x < ((BoundingBox)bounds).lower.x ? ((BoundingBox)bounds).lower.x : this.lower.x;
                        boundingBox.lower.y = this.lower.y < ((BoundingBox)bounds).lower.y ? ((BoundingBox)bounds).lower.y : this.lower.y;
                        boundingBox.lower.z = this.lower.z < ((BoundingBox)bounds).lower.z ? ((BoundingBox)bounds).lower.z : this.lower.z;
                        bl = true;
                    }
                } else if (boundsArray[n] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    if (this.intersect(bounds)) {
                        boundingBox3 = new BoundingBox(bounds);
                        this.intersect((Bounds)boundingBox3, boundingBox2);
                        if (bl) {
                            boundingBox.combine(boundingBox2);
                        } else {
                            boundingBox.set(boundingBox2);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
                }
            }
            ++n;
        }
        if (!bl) {
            boundingBox.boundsIsEmpty = true;
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        boolean bl = false;
        boolean bl2 = false;
        double d = 1.0E13;
        int n = 0;
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        if (this.centroid == null) {
            this.centroid = new Point3d();
        }
        this.centroid.x = (this.upper.x + this.lower.x) * 0.5;
        this.centroid.y = (this.upper.y + this.lower.y) * 0.5;
        this.centroid.z = (this.upper.z + this.lower.z) * 0.5;
        int n2 = 0;
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && this.intersect(boundsArray[n2])) {
                boolean bl3;
                double d2;
                Bounds bounds;
                bl2 = true;
                if (boundsArray[n2] instanceof BoundingSphere) {
                    bounds = (BoundingSphere)boundsArray[n2];
                    d2 = Math.sqrt((this.centroid.x - bounds.center.x) * (this.centroid.x - bounds.center.x) + (this.centroid.y - bounds.center.y) * (this.centroid.y - bounds.center.y) + (this.centroid.z - bounds.center.z) * (this.centroid.z - bounds.center.z));
                    bl3 = false;
                    if (bounds.center.x <= this.upper.x && bounds.center.x >= this.lower.x && bounds.center.y <= this.upper.y && bounds.center.y >= this.lower.y && bounds.center.z <= this.upper.z && bounds.center.z >= this.lower.z && bounds.center.x - this.lower.x >= bounds.radius && this.upper.x - bounds.center.x >= bounds.radius && bounds.center.y - this.lower.y >= bounds.radius && this.upper.y - bounds.center.y >= bounds.radius && bounds.center.z - this.lower.z >= bounds.radius && this.upper.z - bounds.center.z >= bounds.radius) {
                        bl3 = true;
                    }
                    if (bl3) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else if (boundsArray[n2] instanceof BoundingBox) {
                    bounds = (BoundingBox)boundsArray[n2];
                    point3d.x = (((BoundingBox)bounds).upper.x + ((BoundingBox)bounds).lower.x) / 2.0;
                    point3d.y = (((BoundingBox)bounds).upper.y + ((BoundingBox)bounds).lower.y) / 2.0;
                    point3d.z = (((BoundingBox)bounds).upper.z + ((BoundingBox)bounds).lower.z) / 2.0;
                    d2 = Math.sqrt((this.centroid.x - point3d.x) * (this.centroid.x - point3d.x) + (this.centroid.y - point3d.y) * (this.centroid.y - point3d.y) + (this.centroid.z - point3d.z) * (this.centroid.z - point3d.z));
                    bl3 = false;
                    if (this.lower.x <= ((BoundingBox)bounds).lower.x && this.lower.y <= ((BoundingBox)bounds).lower.y && this.lower.z <= ((BoundingBox)bounds).lower.z && this.upper.x >= ((BoundingBox)bounds).upper.x && this.upper.y >= ((BoundingBox)bounds).upper.y && this.upper.z >= ((BoundingBox)bounds).upper.z) {
                        bl3 = true;
                    }
                    if (bl3) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else if (boundsArray[n2] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n2];
                    d2 = Math.sqrt((this.centroid.x - ((BoundingPolytope)bounds).centroid.x) * (this.centroid.x - ((BoundingPolytope)bounds).centroid.x) + (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) * (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) + (this.centroid.z - ((BoundingPolytope)bounds).centroid.z) * (this.centroid.z - ((BoundingPolytope)bounds).centroid.z));
                    bl3 = true;
                    int n3 = 0;
                    while (n3 < ((BoundingPolytope)bounds).nVerts) {
                        if (((BoundingPolytope)bounds).verts[n3].x < this.lower.x || ((BoundingPolytope)bounds).verts[n3].y < this.lower.y || ((BoundingPolytope)bounds).verts[n3].z < this.lower.z || ((BoundingPolytope)bounds).verts[n3].x > this.upper.x || ((BoundingPolytope)bounds).verts[n3].y > this.upper.y || ((BoundingPolytope)bounds).verts[n3].z > this.upper.z) {
                            bl3 = false;
                        }
                        ++n3;
                    }
                    if (bl3) {
                        if (!bl) {
                            n = n2;
                            d = d2;
                            bl = true;
                        } else if (d2 < d) {
                            n = n2;
                            d = d2;
                        }
                    } else if (!bl && d2 < d) {
                        n = n2;
                        d = d2;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox9"));
                }
            }
            ++n2;
        }
        if (bl2) {
            return boundsArray[n];
        }
        return null;
    }

    boolean intersect(CachedFrustum cachedFrustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.upper.x > cachedFrustum.lower.x && this.lower.x < cachedFrustum.upper.x && this.upper.y > cachedFrustum.lower.y && this.lower.y < cachedFrustum.upper.y && this.upper.z > cachedFrustum.lower.z && this.lower.z < cachedFrustum.upper.z) {
            Vector4d vector4d;
            int n = 5;
            while (n >= 0) {
                vector4d = cachedFrustum.clipPlanes[n--];
                if (!(this.upper.x * vector4d.x + this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.upper.x * vector4d.x + this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.upper.x * vector4d.x + this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.upper.x * vector4d.x + this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.lower.x * vector4d.x + this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.lower.x * vector4d.x + this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.lower.x * vector4d.x + this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) || !(this.lower.x * vector4d.x + this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8)) continue;
                return false;
            }
            n = cachedFrustum.nxEdges - 1;
            while (n >= 0) {
                vector4d = cachedFrustum.xEdges[cachedFrustum.xEdgeList[n]];
                if (this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) break;
                --n;
            }
            if (n < 0) {
                return false;
            }
            n = cachedFrustum.nyEdges - 1;
            while (n >= 0) {
                vector4d = cachedFrustum.yEdges[cachedFrustum.yEdgeList[n]];
                if (this.upper.x * vector4d.x + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.upper.x * vector4d.x + this.lower.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.x * vector4d.x + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.x * vector4d.x + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) break;
                --n;
            }
            if (n < 0) {
                return false;
            }
            n = cachedFrustum.nzEdges - 1;
            while (n >= 0) {
                vector4d = cachedFrustum.zEdges[cachedFrustum.zEdgeList[n]];
                if (this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 1.0E-8 || this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 1.0E-8) break;
                --n;
            }
            return n >= 0;
        }
        return false;
    }

    public String toString() {
        return new String("Bounding box: Lower=" + this.lower.x + " " + this.lower.y + " " + this.lower.z + " Upper=" + this.upper.x + " " + this.upper.y + " " + this.upper.z);
    }

    private void checkBoundsIsEmpty() {
        if (this.checkBoundsIsNaN()) {
            return;
        }
        if (this.lower.x > this.upper.x || this.lower.y > this.upper.y || this.lower.z > this.upper.z) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
        } else {
            this.boundsIsEmpty = false;
            this.zeroVolume = this.lower.x == this.upper.x || this.lower.y == this.upper.y || this.lower.z == this.upper.z;
        }
    }

    Point3d getCenter() {
        if (this.centroid == null) {
            this.centroid = new Point3d();
        }
        this.centroid.x = (this.upper.x + this.lower.x) * 0.5;
        this.centroid.y = (this.upper.y + this.lower.y) * 0.5;
        this.centroid.z = (this.upper.z + this.lower.z) * 0.5;
        return this.centroid;
    }

    void translate(BoundingBox boundingBox, Vector3d vector3d) {
        if (boundingBox == null || boundingBox.isEmpty()) {
            this.boundsIsEmpty = true;
            return;
        }
        this.lower.x = boundingBox.lower.x + vector3d.x;
        this.lower.y = boundingBox.lower.y + vector3d.y;
        this.lower.z = boundingBox.lower.z + vector3d.z;
        this.upper.x = boundingBox.upper.x + vector3d.x;
        this.upper.y = boundingBox.upper.y + vector3d.y;
        this.upper.z = boundingBox.upper.z + vector3d.z;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            boundingBox.lower.x = this.lower.x;
            boundingBox.lower.y = this.lower.y;
            boundingBox.lower.z = this.lower.z;
            boundingBox.upper.x = this.upper.x;
            boundingBox.upper.y = this.upper.y;
            boundingBox.upper.z = this.upper.z;
            boundingBox.boundsIsEmpty = this.boundsIsEmpty;
            boundingBox.zeroVolume = this.zeroVolume;
            return boundingBox;
        }
        return (Bounds)this.clone();
    }

    boolean checkBoundsIsNaN() {
        if (Double.isNaN(this.lower.x + this.lower.y + this.lower.z + this.upper.x + this.upper.y + this.upper.z)) {
            this.boundsIsEmpty = true;
            this.zeroVolume = true;
            return true;
        }
        return false;
    }
}

