/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TIFFDirectory
implements Serializable {
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable fieldIndex = new Hashtable();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n) {
        return n == 18761 || n == 19789;
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, int n) throws IOException {
        long l = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n2 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.isBigEndian = n2 == 19789;
        int n3 = this.readUnsignedShort(randomAccessFileOrArray);
        if (n3 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        long l2 = this.readUnsignedInt(randomAccessFileOrArray);
        int n4 = 0;
        while (n4 < n) {
            if (l2 == 0L) {
                throw new IllegalArgumentException("Directory number too large.");
            }
            randomAccessFileOrArray.seek(l2);
            int n5 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.skip(12 * n5);
            l2 = this.readUnsignedInt(randomAccessFileOrArray);
            ++n4;
        }
        randomAccessFileOrArray.seek(l2);
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l);
    }

    public TIFFDirectory(RandomAccessFileOrArray randomAccessFileOrArray, long l, int n) throws IOException {
        long l2 = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n2 = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.isBigEndian = n2 == 19789;
        randomAccessFileOrArray.seek(l);
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.readUnsignedShort(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l + (long)(12 * n4));
            l = this.readUnsignedInt(randomAccessFileOrArray);
            randomAccessFileOrArray.seek(l);
            ++n3;
        }
        this.initialize(randomAccessFileOrArray);
        randomAccessFileOrArray.seek(l2);
    }

    private void initialize(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        this.IFDOffset = randomAccessFileOrArray.getFilePointer();
        this.numEntries = this.readUnsignedShort(randomAccessFileOrArray);
        this.fields = new TIFFField[this.numEntries];
        int n = 0;
        while (n < this.numEntries) {
            block27: {
                long l;
                int n2;
                int n3;
                int n4;
                block26: {
                    n4 = this.readUnsignedShort(randomAccessFileOrArray);
                    n3 = this.readUnsignedShort(randomAccessFileOrArray);
                    n2 = (int)this.readUnsignedInt(randomAccessFileOrArray);
                    int n5 = 0;
                    l = randomAccessFileOrArray.getFilePointer() + 4;
                    try {
                        if (n2 * sizeOfType[n3] <= 4) break block26;
                        n5 = (int)this.readUnsignedInt(randomAccessFileOrArray);
                        randomAccessFileOrArray.seek(n5);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        randomAccessFileOrArray.seek(l);
                        break block27;
                    }
                }
                this.fieldIndex.put(new Integer(n4), new Integer(n));
                Object object = null;
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        Object[] objectArray;
                        Object object2;
                        byte[] byArray = new byte[n2];
                        randomAccessFileOrArray.readFully(byArray, 0, n2);
                        if (n3 == 2) {
                            int n6 = 0;
                            int n7 = 0;
                            object2 = new Vector();
                            while (n6 < n2) {
                                while (n6 < n2 && byArray[n6++] != 0) {
                                }
                                ((Vector)object2).add(new String(byArray, n7, n6 - n7));
                                n7 = n6;
                            }
                            n2 = ((Vector)object2).size();
                            objectArray = new String[n2];
                            int n8 = 0;
                            while (n8 < n2) {
                                objectArray[n8] = (short)((String)((Vector)object2).elementAt(n8));
                                ++n8;
                            }
                            object = objectArray;
                            break;
                        }
                        object = byArray;
                        break;
                    }
                    case 3: {
                        char[] cArray = new char[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            cArray[n9] = (char)this.readUnsignedShort(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = cArray;
                        break;
                    }
                    case 4: {
                        long[] lArray = new long[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            lArray[n9] = this.readUnsignedInt(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = lArray;
                        break;
                    }
                    case 5: {
                        Object object2 = new long[n2][2];
                        int n9 = 0;
                        while (n9 < n2) {
                            object2[n9][0] = this.readUnsignedInt(randomAccessFileOrArray);
                            object2[n9][1] = this.readUnsignedInt(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = object2;
                        break;
                    }
                    case 8: {
                        Object[] objectArray = new short[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            objectArray[n9] = this.readShort(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = objectArray;
                        break;
                    }
                    case 9: {
                        int[] nArray = new int[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            nArray[n9] = this.readInt(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = nArray;
                        break;
                    }
                    case 10: {
                        int[][] nArray = new int[n2][2];
                        int n9 = 0;
                        while (n9 < n2) {
                            nArray[n9][0] = this.readInt(randomAccessFileOrArray);
                            nArray[n9][1] = this.readInt(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = nArray;
                        break;
                    }
                    case 11: {
                        float[] fArray = new float[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            fArray[n9] = this.readFloat(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = fArray;
                        break;
                    }
                    case 12: {
                        double[] dArray = new double[n2];
                        int n9 = 0;
                        while (n9 < n2) {
                            dArray[n9] = this.readDouble(randomAccessFileOrArray);
                            ++n9;
                        }
                        object = dArray;
                        break;
                    }
                }
                this.fields[n] = new TIFFField(n4, n3, n2, object);
                randomAccessFileOrArray.seek(l);
            }
            ++n;
        }
        this.nextIFDOffset = this.readUnsignedInt(randomAccessFileOrArray);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int n) {
        Integer n2 = (Integer)this.fieldIndex.get(new Integer(n));
        if (n2 == null) {
            return null;
        }
        return this.fields[n2];
    }

    public boolean isTagPresent(int n) {
        return this.fieldIndex.containsKey(new Integer(n));
    }

    public int[] getTags() {
        int[] nArray = new int[this.fieldIndex.size()];
        Enumeration enumeration = this.fieldIndex.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        byte[] byArray = this.fields[n3].getAsBytes();
        return byArray[n2];
    }

    public byte getFieldAsByte(int n) {
        return this.getFieldAsByte(n, 0);
    }

    public long getFieldAsLong(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsLong(n2);
    }

    public long getFieldAsLong(int n) {
        return this.getFieldAsLong(n, 0);
    }

    public float getFieldAsFloat(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsFloat(n2);
    }

    public float getFieldAsFloat(int n) {
        return this.getFieldAsFloat(n, 0);
    }

    public double getFieldAsDouble(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsDouble(n2);
    }

    public double getFieldAsDouble(int n) {
        return this.getFieldAsDouble(n, 0);
    }

    private short readShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readShort();
        }
        return randomAccessFileOrArray.readShortLE();
    }

    private int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private int readInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readInt();
        }
        return randomAccessFileOrArray.readIntLE();
    }

    private long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    private long readLong(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readLong();
        }
        return randomAccessFileOrArray.readLongLE();
    }

    private float readFloat(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readFloat();
        }
        return randomAccessFileOrArray.readFloatLE();
    }

    private double readDouble(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        if (this.isBigEndian) {
            return randomAccessFileOrArray.readDouble();
        }
        return randomAccessFileOrArray.readDoubleLE();
    }

    private static int readUnsignedShort(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl) throws IOException {
        if (bl) {
            return randomAccessFileOrArray.readUnsignedShort();
        }
        return randomAccessFileOrArray.readUnsignedShortLE();
    }

    private static long readUnsignedInt(RandomAccessFileOrArray randomAccessFileOrArray, boolean bl) throws IOException {
        if (bl) {
            return randomAccessFileOrArray.readUnsignedInt();
        }
        return randomAccessFileOrArray.readUnsignedIntLE();
    }

    public static int getNumDirectories(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        long l = randomAccessFileOrArray.getFilePointer();
        randomAccessFileOrArray.seek(0L);
        int n = randomAccessFileOrArray.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        boolean bl = n == 19789;
        int n2 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl);
        if (n2 != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        randomAccessFileOrArray.seek(4L);
        long l2 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl);
        int n3 = 0;
        while (l2 != 0L) {
            ++n3;
            try {
                randomAccessFileOrArray.seek(l2);
                int n4 = TIFFDirectory.readUnsignedShort(randomAccessFileOrArray, bl);
                randomAccessFileOrArray.skip(12 * n4);
                l2 = TIFFDirectory.readUnsignedInt(randomAccessFileOrArray, bl);
            }
            catch (EOFException eOFException) {
                --n3;
                break;
            }
        }
        randomAccessFileOrArray.seek(l);
        return n3;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

