/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Vector;

public class VelocityModel
implements Cloneable,
Serializable {
    protected String modelName = "unknown";
    protected String fileType = "nd";
    protected double radiusOfEarth = 6371.0;
    protected double mohoDepth = 35.0;
    protected double cmbDepth = 2889.0;
    protected double iocbDepth = 5153.9;
    protected double meanDensity = 5517.0;
    protected double G = 6.67E-11;
    protected double minRadius = 0.0;
    protected double maxRadius = 6371.0;
    protected boolean spherical = true;
    protected static int vectorLength = 16;
    protected Vector layer = new Vector(vectorLength);

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName.length() > 0 ? modelName : "unknown";
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double[] getDisconDepths() {
        double[] disconDepths = new double[this.getNumLayers() + 2];
        int numFound = 0;
        disconDepths[numFound++] = this.getVelocityLayer(0).getTopDepth();
        for (int layerNum = 0; layerNum < this.getNumLayers() - 1; ++layerNum) {
            VelocityLayer aboveLayer = this.getVelocityLayer(layerNum);
            VelocityLayer belowLayer = this.getVelocityLayer(layerNum + 1);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            disconDepths[numFound++] = aboveLayer.getBotDepth();
        }
        disconDepths[numFound++] = this.getVelocityLayer(this.getNumLayers() - 1).getBotDepth();
        double[] temp = new double[numFound];
        System.arraycopy(disconDepths, 0, temp, 0, numFound);
        return temp;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public void setMohoDepth(double mohoDepth) {
        this.mohoDepth = mohoDepth;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public void setCmbDepth(double cmbDepth) {
        this.cmbDepth = cmbDepth;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public void setIocbDepth(double iocbDepth) {
        this.iocbDepth = iocbDepth;
    }

    public double getMeanDensity() {
        return this.meanDensity;
    }

    public void setMeanDensity(double meanDensity) {
        this.meanDensity = meanDensity;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double minRadius) {
        this.minRadius = minRadius;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
    }

    public double getG() {
        return this.G;
    }

    public void setG(double G) {
        this.G = G;
    }

    public boolean getSpherical() {
        return this.spherical;
    }

    public void setSpherical(boolean spherical) {
        this.spherical = spherical;
    }

    public VelocityLayer getVelocityLayerClone(int layerNum) {
        return (VelocityLayer)((VelocityLayer)this.layer.elementAt(layerNum)).clone();
    }

    public VelocityLayer getVelocityLayer(int layerNum) {
        return (VelocityLayer)this.layer.elementAt(layerNum);
    }

    public int getNumLayers() {
        return this.layer.size();
    }

    public int layerNumberAbove(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() >= depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public int layerNumberBelow(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        if (this.getVelocityLayer(tooLargeNum).getBotDepth() == depth) {
            return tooLargeNum;
        }
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() <= depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public double evaluateAbove(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberAbove(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateBelow(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberBelow(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateAtTop(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtTop(materialProperty);
    }

    public double evaluateAtBottom(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtBottom(materialProperty);
    }

    public double depthAtTop(int layerNumber) {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getTopDepth();
    }

    public double depthAtBottom(int layerNumber) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getBotDepth();
    }

    public void replaceLayers(VelocityLayer[] newLayers, boolean matchTop, boolean matchBot) throws NoSuchLayerException {
        int i;
        VelocityLayer newVLayer;
        int topLayerNum = this.layerNumberBelow(newLayers[0].getTopDepth());
        VelocityLayer topLayer = this.getVelocityLayer(topLayerNum);
        int botLayerNum = this.layerNumberAbove(newLayers[newLayers.length - 1].getBotDepth());
        VelocityLayer botLayer = this.getVelocityLayer(botLayerNum);
        if (matchTop) {
            try {
                newLayers[0].setTopPVelocity(topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'));
                newLayers[0].setTopSVelocity(topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'));
            }
            catch (NoSuchMatPropException e) {
                System.err.println("Caught NoSuchMatPropException: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (matchBot) {
            try {
                newLayers[newLayers.length - 1].setBotPVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'P'));
                newLayers[newLayers.length - 1].setBotSVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'S'));
            }
            catch (NoSuchMatPropException e) {
                System.err.println("Caught NoSuchMatPropException: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (topLayer.getBotDepth() > newLayers[0].getTopDepth()) {
            newVLayer = (VelocityLayer)topLayer.clone();
            try {
                topLayer.setBotPVelocity(topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'));
                topLayer.setBotSVelocity(topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'));
                topLayer.setBotDepth(newLayers[0].getTopDepth());
            }
            catch (NoSuchMatPropException e) {
                System.err.println("Caught NoSuchMatPropException: " + e.getMessage());
                e.printStackTrace();
            }
            newVLayer.setTopPVelocity(topLayer.getBotPVelocity());
            newVLayer.setTopSVelocity(topLayer.getBotSVelocity());
            newVLayer.setTopDepth(topLayer.getBotDepth());
            this.layer.insertElementAt(newVLayer, topLayerNum + 1);
            ++botLayerNum;
            ++topLayerNum;
        }
        if (botLayer.getBotDepth() > newLayers[newLayers.length - 1].getBotDepth()) {
            newVLayer = (VelocityLayer)botLayer.clone();
            try {
                botLayer.setBotPVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'P'));
                botLayer.setBotSVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'S'));
                botLayer.setBotDepth(newLayers[newLayers.length - 1].getBotDepth());
            }
            catch (NoSuchMatPropException e) {
                System.err.println("Caught NoSuchMatPropException: " + e.getMessage());
                e.printStackTrace();
            }
            newVLayer.setTopPVelocity(botLayer.getBotPVelocity());
            newVLayer.setTopSVelocity(botLayer.getBotSVelocity());
            newVLayer.setTopDepth(botLayer.getBotDepth());
            this.layer.insertElementAt(newVLayer, botLayerNum + 1);
            ++botLayerNum;
        }
        for (i = topLayerNum; i <= botLayerNum; ++i) {
            this.layer.removeElementAt(topLayerNum);
        }
        for (i = 0; i < newLayers.length; ++i) {
            this.layer.insertElementAt(newLayers[i], topLayerNum + i);
        }
        this.validate();
    }

    public void printGMT(String filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.printGMT(dos);
        dos.close();
    }

    public void printGMT(DataOutputStream dos) throws IOException {
        VelocityLayer currVelocityLayer;
        int layerNum;
        double depth = 0.0;
        double pVel = -1.0;
        double sVel = -1.0;
        dos.writeBytes("> P velocity for " + this.modelName + "  below\n");
        for (layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopPVelocity() != pVel) {
                dos.writeBytes((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopPVelocity() + "\n");
            }
            dos.writeBytes((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotPVelocity() + "\n");
            pVel = currVelocityLayer.getBotPVelocity();
        }
        dos.writeBytes("> S velocity for " + this.modelName + "  below\n");
        for (layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopSVelocity() != sVel) {
                dos.writeBytes((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopSVelocity() + "\n");
            }
            dos.writeBytes((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotSVelocity() + "\n");
            sVel = currVelocityLayer.getBotSVelocity();
        }
    }

    public boolean validate() {
        if (this.radiusOfEarth <= 0.0) {
            System.err.println("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
            return false;
        }
        if (this.mohoDepth < 0.0) {
            System.err.println("mohoDepth is not non-negative. mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth < this.mohoDepth) {
            System.err.println("cmbDepth < mohoDepth. cmbDepth = " + this.cmbDepth + " mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth <= 0.0) {
            System.err.println("cmbDepth is not positive. cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth < this.cmbDepth) {
            System.err.println("iocbDepth < cmbDepth. iocbDepth = " + this.iocbDepth + " cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth <= 0.0) {
            System.err.println("iocbDepth is not positive. iocbDepth = " + this.iocbDepth);
            return false;
        }
        if (this.minRadius < 0.0) {
            System.err.println("minRadius is not non-negative. minRadius = " + this.minRadius);
            return false;
        }
        if (this.maxRadius <= 0.0) {
            System.err.println("maxRadius is not positive. maxRadius = " + this.maxRadius);
            return false;
        }
        if (this.maxRadius <= this.minRadius) {
            System.err.println("maxRadius <= minRadius. maxRadius = " + this.maxRadius + " minRadius = " + this.minRadius);
            return false;
        }
        VelocityLayer currVelocityLayer = this.getVelocityLayer(0);
        VelocityLayer prevVelocityLayer = new VelocityLayer();
        prevVelocityLayer.setBotDepth(currVelocityLayer.getTopDepth());
        prevVelocityLayer.setBotPVelocity(currVelocityLayer.getTopPVelocity());
        prevVelocityLayer.setBotSVelocity(currVelocityLayer.getTopSVelocity());
        prevVelocityLayer.setBotDensity(currVelocityLayer.getTopDensity());
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            currVelocityLayer = this.getVelocityLayer(layerNum);
            if (prevVelocityLayer.getBotDepth() != currVelocityLayer.getTopDepth()) {
                System.err.println("There is a gap in the velocity model between layers " + (layerNum - 1) + " and " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getBotDepth() == currVelocityLayer.getTopDepth()) {
                System.err.println("There is a zero thickness layer in the velocity model at layer " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() <= 0.0 || currVelocityLayer.getBotPVelocity() <= 0.0) {
                System.err.println("There is a negative P velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() < 0.0 || currVelocityLayer.getBotSVelocity() < 0.0) {
                System.err.println("There is a negative S velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() != 0.0 && currVelocityLayer.getBotPVelocity() == 0.0 || currVelocityLayer.getTopPVelocity() == 0.0 && currVelocityLayer.getBotPVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero P velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() != 0.0 && currVelocityLayer.getBotSVelocity() == 0.0 || currVelocityLayer.getTopSVelocity() == 0.0 && currVelocityLayer.getBotSVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero S velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            prevVelocityLayer = currVelocityLayer;
        }
        return true;
    }

    public String toString() {
        String desc = "modelName=" + this.modelName + "\n" + "\n radiusOfEarth=" + this.radiusOfEarth + "\n mohoDepth=" + this.mohoDepth + "\n cmbDepth=" + this.cmbDepth + "\n iocbDepth=" + this.iocbDepth + "\n meanDensity=" + this.meanDensity + "\n G=" + this.G + "\n minRadius=" + this.minRadius + "\n maxRadius=" + this.maxRadius + "\n spherical=" + this.spherical;
        desc = desc + "\ngetNumLayers()=" + this.getNumLayers() + "\n";
        return desc;
    }

    public Object clone() {
        try {
            VelocityModel newObject = (VelocityModel)super.clone();
            newObject.layer = new Vector(this.getNumLayers());
            for (int i = 0; i < this.getNumLayers(); ++i) {
                newObject.layer.addElement(this.getVelocityLayerClone(i));
            }
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void print() {
        for (int i = 0; i < this.getNumLayers(); ++i) {
            System.out.println(this.getVelocityLayer(i));
        }
    }

    public void readVelocityFile(String filename) throws IOException, VelocityModelException {
        int j = filename.lastIndexOf(System.getProperty("file.separator"));
        String modelFilename = filename.substring(j + 1);
        this.modelName = modelFilename.endsWith("tvel") ? modelFilename.substring(0, modelFilename.length() - 5) : (modelFilename.endsWith(".nd") ? modelFilename.substring(0, modelFilename.length() - 3) : (modelFilename.startsWith("GB.") ? modelFilename.substring(3, modelFilename.length()) : modelFilename));
        if (this.fileType.equalsIgnoreCase("nd")) {
            this.readNDFile(filename);
        } else if (this.fileType.equalsIgnoreCase("tvel")) {
            this.readTVelFile(filename);
        } else {
            throw new VelocityModelException("What type of velocity file, .tvel or .nd?");
        }
        boolean changeMade = this.fixDisconDepths();
    }

    public void readCubicSplineFile(String filename, String lookForModelName) throws IOException {
        System.err.println("readCubicSplineFile not yet implemented.");
    }

    public void readTVelFile(String filename) throws IOException, VelocityModelException {
        double density;
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        while (tokenIn.nextToken() != 10) {
        }
        while (tokenIn.nextToken() != 10) {
        }
        int myLayerNumber = 0;
        VelocityLayer tempLayer = new VelocityLayer(myLayerNumber);
        tokenIn.nextToken();
        double depth = tokenIn.nval;
        tokenIn.nextToken();
        double pVel = tokenIn.nval;
        tokenIn.nextToken();
        double sVel = tokenIn.nval;
        tokenIn.nextToken();
        if (tokenIn.ttype != 10) {
            density = tokenIn.nval;
            tokenIn.nextToken();
        } else {
            density = 5571.0;
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        while (tokenIn.ttype != -1) {
            tempLayer.setTopDepth(depth);
            tempLayer.setTopPVelocity(pVel);
            tempLayer.setTopSVelocity(sVel);
            tempLayer.setTopDensity(density);
            depth = tokenIn.nval;
            tempLayer.setBotDepth(depth);
            tokenIn.nextToken();
            pVel = tokenIn.nval;
            tempLayer.setBotPVelocity(pVel);
            tokenIn.nextToken();
            sVel = tokenIn.nval;
            tempLayer.setBotSVelocity(sVel);
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                density = tokenIn.nval;
                tempLayer.setBotDensity(density);
                tokenIn.nextToken();
            }
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            this.layer.addElement(tempLayer);
            tempLayer = new VelocityLayer(++myLayerNumber);
        }
        this.radiusOfEarth = depth;
        this.maxRadius = depth;
    }

    public void readNDFile(String filename) throws IOException, VelocityModelException {
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        int myLayerNumber = 0;
        VelocityLayer tempLayer = new VelocityLayer(myLayerNumber);
        double density = 2.6;
        double qp = 1000.0;
        double qs = 2000.0;
        tokenIn.nextToken();
        double depth = tokenIn.nval;
        tokenIn.nextToken();
        double pVel = tokenIn.nval;
        tokenIn.nextToken();
        double sVel = tokenIn.nval;
        tokenIn.nextToken();
        if (tokenIn.ttype != 10) {
            density = tokenIn.nval;
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                qp = tokenIn.nval;
                tokenIn.nextToken();
                if (tokenIn.ttype != 10) {
                    qs = tokenIn.nval;
                    tokenIn.nextToken();
                }
            }
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        while (tokenIn.ttype != -1) {
            if (tokenIn.ttype == -3) {
                if (tokenIn.sval.equalsIgnoreCase("mantle")) {
                    this.mohoDepth = depth;
                }
                if (tokenIn.sval.equalsIgnoreCase("outer-core")) {
                    this.cmbDepth = depth;
                }
                if (tokenIn.sval.equalsIgnoreCase("inner-core")) {
                    this.iocbDepth = depth;
                }
                while (tokenIn.ttype != 10) {
                    tokenIn.nextToken();
                }
                tokenIn.nextToken();
            }
            tempLayer.setTopDepth(depth);
            tempLayer.setTopPVelocity(pVel);
            tempLayer.setTopSVelocity(sVel);
            tempLayer.setTopDensity(density);
            tempLayer.setTopQp(qp);
            tempLayer.setTopQs(qs);
            depth = tokenIn.nval;
            tempLayer.setBotDepth(depth);
            tokenIn.nextToken();
            pVel = tokenIn.nval;
            tempLayer.setBotPVelocity(pVel);
            tokenIn.nextToken();
            sVel = tokenIn.nval;
            tempLayer.setBotSVelocity(sVel);
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                density = tokenIn.nval;
                tempLayer.setBotDensity(density);
                tokenIn.nextToken();
                if (tokenIn.ttype != 10) {
                    qp = tokenIn.nval;
                    tempLayer.setBotQp(qp);
                    tokenIn.nextToken();
                    if (tokenIn.ttype != 10) {
                        qs = tokenIn.nval;
                        tempLayer.setBotQs(qs);
                        tokenIn.nextToken();
                    }
                }
            }
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            this.layer.addElement(tempLayer);
            tempLayer = new VelocityLayer(++myLayerNumber);
        }
        this.radiusOfEarth = depth;
        this.maxRadius = depth;
    }

    public boolean fixDisconDepths() {
        boolean changeMade = false;
        double mohoMin = 65.0;
        double cmbMin = this.radiusOfEarth;
        double iocbMin = this.radiusOfEarth - 100.0;
        double tempMohoDepth = 0.0;
        double tempCmbDepth = this.radiusOfEarth;
        double tempIocbDepth = this.radiusOfEarth;
        for (int layerNum = 0; layerNum < this.getNumLayers() - 1; ++layerNum) {
            VelocityLayer aboveLayer = this.getVelocityLayer(layerNum);
            VelocityLayer belowLayer = this.getVelocityLayer(layerNum + 1);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            if (Math.abs(this.mohoDepth - aboveLayer.getBotDepth()) < mohoMin) {
                tempMohoDepth = aboveLayer.getBotDepth();
                mohoMin = Math.abs(this.mohoDepth - aboveLayer.getBotDepth());
            }
            if (Math.abs(this.cmbDepth - aboveLayer.getBotDepth()) < cmbMin) {
                tempCmbDepth = aboveLayer.getBotDepth();
                cmbMin = Math.abs(this.cmbDepth - aboveLayer.getBotDepth());
            }
            if (aboveLayer.getBotSVelocity() != 0.0 || !(belowLayer.getTopSVelocity() > 0.0) || !(Math.abs(this.iocbDepth - aboveLayer.getBotDepth()) < iocbMin)) continue;
            tempIocbDepth = aboveLayer.getBotDepth();
            iocbMin = Math.abs(this.iocbDepth - aboveLayer.getBotDepth());
        }
        if (this.mohoDepth != tempMohoDepth || this.cmbDepth != tempCmbDepth || this.iocbDepth != tempIocbDepth) {
            changeMade = true;
        }
        this.mohoDepth = tempMohoDepth;
        this.cmbDepth = tempCmbDepth;
        this.iocbDepth = tempCmbDepth != tempIocbDepth ? tempIocbDepth : this.radiusOfEarth;
        return changeMade;
    }

    public VelocityModel earthFlattenTransform() throws VelocityModelException {
        VelocityModel flatModel = (VelocityModel)this.clone();
        flatModel.spherical = false;
        flatModel.layer = new Vector(vectorLength);
        for (int i = 0; i < this.getNumLayers(); ++i) {
            VelocityLayer oldLayer = this.getVelocityLayer(i);
            VelocityLayer newLayer = new VelocityLayer(i, this.radiusOfEarth * Math.log(oldLayer.getTopDepth() / this.radiusOfEarth), this.radiusOfEarth * Math.log(oldLayer.getBotDepth() / this.radiusOfEarth), this.radiusOfEarth * oldLayer.getTopPVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotPVelocity() / oldLayer.getBotDepth(), this.radiusOfEarth * oldLayer.getTopSVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotSVelocity() / oldLayer.getBotDepth());
            flatModel.layer.addElement(newLayer);
        }
        return flatModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        VelocityModel vMod = new VelocityModel();
        String modelFilename = args.length >= 1 ? args[0] : "iasp91.tvel";
        boolean DEBUG = true;
        try {
            vMod.readVelocityFile(modelFilename);
            System.out.println("Done reading.");
            if (!vMod.validate()) {
                System.out.println("FAILED VELOCITY MODEL VALIDATION!");
            }
            vMod.printGMT(vMod.modelName + ".gmt");
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage());
        }
        catch (VelocityModelException e) {
            System.out.println("Tried to read!\n Caught VelocityModelException " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            System.out.println("Done!\n");
        }
    }
}

