/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.XYPlot;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Vector;

public class TauPlot
extends XYPlot {
    public TauPlot(Container parent) {
        super(parent);
        this.title = "Tau";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "tau (sec)";
    }

    public TauPlot(Container parent, int width, int height) {
        super(parent, width, height);
        this.title = "Tau";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "depth (sec)";
    }

    public void plot(TauModel tModel, boolean isPWave) {
        int waveNum;
        if (!isPWave) {
            waveNum = 1;
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 2500.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = 2500.0;
        } else {
            waveNum = 0;
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 1300.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = 1300.0;
        }
        int jj = 0;
        this.xSegments = new Vector();
        this.ySegments = new Vector();
        for (int i = 0; i < tModel.tauBranches[0].length; ++i) {
            jj = 0;
            double[] tempXData = new double[tModel.rayParams.length];
            double[] tempYData = new double[tModel.rayParams.length];
            for (int j = 0; j < tModel.rayParams.length; ++j) {
                double x = tModel.rayParams[j];
                double y = 0.0;
                for (int k = 0; k <= i; ++k) {
                    y += 2.0 * tModel.tauBranches[waveNum][k].tau[j];
                }
                if (y == 0.0 && x != 0.0 || tModel.tauBranches[waveNum][i].tau[j] == 0.0) continue;
                tempXData[jj] = x;
                tempYData[jj] = y;
                if (this.DEBUG) {
                    System.out.println(x + " " + y);
                }
                ++jj;
            }
            if (this.DEBUG) {
                System.out.println("> ");
            }
            this.xData = new double[jj];
            System.arraycopy(tempXData, 0, this.xData, 0, jj);
            this.yData = new double[jj];
            System.arraycopy(tempYData, 0, this.yData, 0, jj);
            this.xSegments.addElement(this.xData);
            this.ySegments.addElement(this.yData);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }
}

