/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;

public class TauP_WKBJ
extends TauP_Time {
    protected double deltaT = 0.05;
    protected int numSamples = 1000;
    protected double startTime = 0.0;

    public TauP_WKBJ() {
    }

    public TauP_WKBJ(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_WKBJ(String modelName) throws TauModelException {
        super(modelName);
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public void setDeltaT(double v) {
        this.deltaT = v;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int v) {
        this.numSamples = v;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double v) {
        this.startTime = v;
    }

    public void calculate(double degrees) throws TauModelException {
        this.recalcPhases();
        this.clearArrivals();
        this.calcWKBJ(degrees);
    }

    public void calcWKBJ(double degrees) throws TauModelException {
        this.degrees = degrees;
        System.out.println("In calcWKBJ for " + degrees + " degrees.");
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            System.out.println("Phase " + ((SeismicPhase)this.phases.elementAt(phaseNum)).getName() + ".");
            SeismicPhase phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            phase.setDEBUG(this.DEBUG);
            phase.calcTime(degrees);
            double minRayParam = phase.getMinRayParam();
            if (!phase.hasArrivals()) continue;
            Arrival[] phaseArrivals = phase.getArrivals();
            for (int i = 0; i < phaseArrivals.length; ++i) {
                System.out.println("Arrival number " + i);
                Theta thetaAtX = new Theta(phase, phaseArrivals[i].getDist());
                System.out.println("Got Theta");
                float[] seismogramPoints = new float[this.numSamples];
                double rayParam = thetaAtX.getMaxRayParam();
                System.out.println("Got ray param");
                double theta = thetaAtX.getTheta(rayParam);
                System.out.println("Got theta for ray param");
                this.setStartTime(320.0);
                double nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                double nextTheta = thetaAtX.getTheta(nextRayParam);
                int n = 0;
                try {
                    while (nextRayParam >= minRayParam) {
                        n = (int)Math.round((theta - this.getStartTime()) / this.getDeltaT());
                        if (n >= 0 && n < seismogramPoints.length) {
                            System.out.println(n + "  " + seismogramPoints[n]);
                        }
                        rayParam = nextRayParam;
                        theta = nextTheta;
                        nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                        nextTheta = thetaAtX.getTheta(nextRayParam);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("ArrayIndexOutOfBoundsException: " + e);
                }
                SacTimeSeries sac = new SacTimeSeries();
                sac.y = seismogramPoints;
                sac.npts = seismogramPoints.length;
                sac.leven = 1;
                sac.iftype = 1;
                sac.delta = (float)this.getDeltaT();
                sac.t0 = (float)phaseArrivals[i].getTime();
                sac.kt0 = phaseArrivals[i].getName();
                sac.o = 0.0f;
                sac.b = 320.0f;
                sac.e = sac.b + (float)(sac.npts - 1) * sac.delta;
                try {
                    sac.write("tempsacfile");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            long prevTime = 0L;
            prevTime = System.currentTimeMillis();
            TauP_WKBJ tauPTime = new TauP_WKBJ();
            String[] noComprendoArgs = tauPTime.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(noComprendoArgs[i] + " ");
                }
                System.out.println();
                noComprendoArgs = null;
            }
            long currTime = System.currentTimeMillis();
            prevTime = System.currentTimeMillis();
            tauPTime.init();
            currTime = System.currentTimeMillis();
            if (tauPTime.DEBUG) {
                System.out.println("taup model read time=" + (currTime - prevTime));
            }
            tauPTime.start();
            tauPTime.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println("Caught: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

