/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.Version;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;

public class TauP_Time {
    public boolean DEBUG = false;
    public boolean verbose = false;
    protected String modelName = "iasp91";
    protected TauModel tMod;
    protected transient TauModel tModDepth;
    protected Vector phases = new Vector(10);
    protected Vector phaseNames = new Vector(10);
    protected double depth = 0.0;
    protected double degrees = Double.MAX_VALUE;
    protected double azimuth = Double.MAX_VALUE;
    protected double backAzimuth = Double.MAX_VALUE;
    protected double stationLat = Double.MAX_VALUE;
    protected double stationLon = Double.MAX_VALUE;
    protected double eventLat = Double.MAX_VALUE;
    protected double eventLon = Double.MAX_VALUE;
    protected Vector arrivals = new Vector(10);
    protected boolean GUI = false;
    protected boolean onlyPrintRayP = false;
    protected boolean onlyPrintTime = false;
    protected String outFile = "";
    protected DataOutputStream dos;
    protected Properties toolProps;
    protected Outputs outForms;

    public TauP_Time() {
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
        this.outForms = new Outputs(this.toolProps);
    }

    public TauP_Time(TauModel tMod) throws TauModelException {
        this();
        this.tMod = tMod;
        this.tModDepth = tMod;
        this.modelName = tMod.sMod.vMod.getModelName();
    }

    public TauP_Time(String modelName) throws TauModelException {
        this();
        try {
            this.loadTauModel(modelName);
        }
        catch (FileNotFoundException e) {
            throw new TauModelException("FileNotFoundException:" + e.getMessage(), e);
        }
        catch (InvalidClassException e) {
            throw new TauModelException("InvalidClassException:" + e.getMessage(), e);
        }
        catch (StreamCorruptedException e) {
            throw new TauModelException("StreamCorruptedException:" + e.getMessage(), e);
        }
        catch (OptionalDataException e) {
            throw new TauModelException("OptionalDataException:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TauModelException("IOException:" + e.getMessage(), e);
        }
    }

    public String[] getPhaseNames() {
        String[] phases = new String[this.phaseNames.size()];
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            phases[i] = ((PhaseName)this.phaseNames.elementAt(i)).getName();
        }
        return phases;
    }

    public String getPhaseNameString() {
        if (this.getNumPhases() == 0) {
            return "";
        }
        String phases = ((PhaseName)this.phaseNames.elementAt(0)).getName();
        for (int i = 1; i < this.getNumPhases(); ++i) {
            phases = phases + "," + ((PhaseName)this.phaseNames.elementAt(i)).getName();
        }
        return phases;
    }

    public void setPhaseNames(String[] phaseNames) {
        this.phaseNames.removeAllElements();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.appendPhaseName(phaseNames[i]);
        }
    }

    public void setPhaseNames(PhaseName[] phaseNames) {
        this.phaseNames.removeAllElements();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.phaseNames.addElement(phaseNames[i]);
        }
    }

    public static List getPhaseNames(String phaseName) {
        ArrayList<String> names = new ArrayList<String>();
        if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttall")) {
            if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("p");
                names.add("P");
                names.add("Pn");
                names.add("Pdiff");
                names.add("PKP");
                names.add("PKiKP");
                names.add("PKIKP");
            }
            if (phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("s");
                names.add("S");
                names.add("Sn");
                names.add("Sdiff");
                names.add("SKS");
                names.add("SKIKS");
            }
            if (phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("PcP");
                names.add("pP");
                names.add("pPdiff");
                names.add("pPKP");
                names.add("pPKIKP");
                names.add("pPKiKP");
                names.add("sP");
                names.add("sPdiff");
                names.add("sPKP");
                names.add("sPKIKP");
                names.add("sPKiKP");
            }
            if (phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("sS");
                names.add("sSdiff");
                names.add("sSKS");
                names.add("sSKIKS");
                names.add("ScS");
                names.add("pS");
                names.add("pSdiff");
                names.add("pSKS");
                names.add("pSKIKS");
            }
            if (phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("ScP");
                names.add("SKP");
                names.add("SKIKP");
                names.add("PKKP");
                names.add("PKIKKIKP");
                names.add("SKKP");
                names.add("SKIKKIKP");
                names.add("PP");
                names.add("PKPPKP");
                names.add("PKIKPPKIKP");
            }
            if (phaseName.equalsIgnoreCase("ttall")) {
                names.add("SKiKP");
                names.add("PP");
                names.add("ScS");
                names.add("PcS");
                names.add("PKS");
                names.add("PKIKS");
                names.add("PKKS");
                names.add("PKIKKIKS");
                names.add("SKKS");
                names.add("SKIKKIKS");
                names.add("SKSSKS");
                names.add("SKIKSSKIKS");
                names.add("SS");
                names.add("SP");
                names.add("PS");
            }
        } else {
            names.add(phaseName);
        }
        return names;
    }

    public synchronized void appendPhaseName(String phaseName) {
        List names = TauP_Time.getPhaseNames(phaseName);
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.appendPhaseName(new PhaseName((String)it.next()));
        }
    }

    public synchronized void appendPhaseName(PhaseName phaseName) {
        boolean unique = true;
        if (phaseName.name == null || phaseName.name.length() == 0) {
            return;
        }
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            if (!((PhaseName)this.phaseNames.elementAt(i)).equals(phaseName)) continue;
            unique = false;
            return;
        }
        if (unique) {
            this.phaseNames.addElement(phaseName);
        }
    }

    public int getNumPhases() {
        return this.phaseNames.size();
    }

    public void clearPhaseNames() {
        this.phases.removeAllElements();
        this.phaseNames.removeAllElements();
    }

    public double getSourceDepth() {
        return Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
    }

    public void setSourceDepth(double depth) {
        this.depth = depth;
        this.toolProps.put("taup.source.depth", Double.toString(depth));
    }

    public String getTauModelName() {
        return this.modelName;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void setTauModel(TauModel tMod) {
        this.tMod = tMod;
        this.tModDepth = tMod;
        this.modelName = tMod.sMod.vMod.getModelName();
        this.toolProps.put("taup.model.name", this.modelName);
    }

    public void loadTauModel(String modelName) throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        this.modelName = modelName;
        this.readTauModel();
        this.modelName = this.tMod.sMod.vMod.getModelName();
    }

    public double[] getDisconDepths() {
        return this.tMod.sMod.vMod.getDisconDepths();
    }

    public void clearArrivals() {
        this.arrivals.removeAllElements();
    }

    public int getNumArrivals() {
        return this.arrivals.size();
    }

    public Arrival getArrival(int i) {
        return (Arrival)((Arrival)this.arrivals.elementAt(i)).clone();
    }

    public Arrival[] getArrivals() {
        Arrival[] returnArrivals = new Arrival[this.arrivals.size()];
        for (int i = 0; i < this.arrivals.size(); ++i) {
            returnArrivals[i] = (Arrival)((Arrival)this.arrivals.elementAt(i)).clone();
        }
        return returnArrivals;
    }

    protected void readTauModel() throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        try {
            TauModel tModLoad = TauModelLoader.load(this.modelName, this.toolProps.getProperty("taup.model.path"));
            if (tModLoad != null) {
                this.tModDepth = this.tMod = tModLoad;
                this.modelName = this.tMod.sMod.vMod.getModelName();
            }
        }
        catch (ClassNotFoundException e) {
            Alert.error("Caught ClassNotFoundException", e.getMessage() + "\nThere must be something wrong with your installation of TauP.");
            throw new RuntimeException("Caught ClassNotFoundException" + e.getMessage() + "\nThere must be something wrong with your installation of TauP.", e);
        }
        catch (InvalidClassException e) {
            Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
            throw new RuntimeException("Model file " + this.modelName + " is not compatible with the current version." + "Recreate using taup_create.", e);
        }
    }

    protected void readPhaseFile(String filename) throws IOException {
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.wordChars(94, 94);
        tokenIn.wordChars(48, 57);
        tokenIn.wordChars(46, 46);
        tokenIn.wordChars(91, 91);
        tokenIn.wordChars(93, 93);
        while (tokenIn.nextToken() != -1) {
            if (tokenIn.sval != null) {
                this.parsePhaseList(tokenIn.sval);
                continue;
            }
            if (!this.DEBUG) continue;
            Alert.info("Token.sval was null! nval=" + tokenIn.nval);
        }
    }

    public void parsePhaseList(String phaseList) {
        int offset = 0;
        phaseList = phaseList.replace(' ', ',');
        int phaseSepIndex = phaseList.indexOf(",,", offset);
        while (phaseSepIndex != -1) {
            phaseList = phaseList.substring(0, phaseSepIndex) + phaseList.substring(phaseSepIndex + 1);
            phaseSepIndex = phaseList.indexOf(",,", offset);
        }
        if (phaseList.charAt(0) == ',') {
            if (phaseList.length() > 1) {
                phaseList = phaseList.substring(1);
            } else {
                return;
            }
        }
        if (phaseList.charAt(phaseList.length() - 1) == ',') {
            phaseList = phaseList.substring(0, phaseList.length() - 1);
        }
        while (offset < phaseList.length()) {
            String phaseEntry;
            phaseSepIndex = phaseList.indexOf(44, offset);
            if (phaseSepIndex != -1) {
                phaseEntry = phaseList.substring(offset, phaseSepIndex);
                offset = phaseSepIndex + 1;
            } else {
                phaseEntry = phaseList.substring(offset);
                offset = phaseList.length();
            }
            phaseSepIndex = phaseEntry.indexOf(45);
            if (phaseSepIndex == -1) {
                this.appendPhaseName(phaseEntry);
                continue;
            }
            if (phaseSepIndex == phaseEntry.length() - 2 && Character.isDigit(phaseEntry.charAt(phaseEntry.length() - 1))) {
                this.appendPhaseName(new PhaseName(phaseEntry.substring(0, phaseSepIndex), Integer.valueOf(phaseEntry.substring(phaseSepIndex + 1, phaseEntry.length()))));
                continue;
            }
            Alert.warning("Problem with phase=" + phaseEntry, "Skipping this phase.");
        }
    }

    public double[] parseDegreeList(String degList) {
        int offset = 0;
        int numDegrees = 0;
        double[] degreesFound = new double[degList.length()];
        while (offset < degList.length()) {
            String degEntry;
            int commaIndex = degList.indexOf(44, offset);
            if (commaIndex != -1) {
                degEntry = degList.substring(offset, commaIndex);
                degreesFound[numDegrees] = Double.valueOf(degEntry);
                offset = commaIndex + 1;
                ++numDegrees;
                continue;
            }
            degEntry = degList.substring(offset);
            degreesFound[numDegrees] = Double.valueOf(degEntry);
            offset = degList.length();
            ++numDegrees;
        }
        double[] temp = new double[numDegrees];
        System.arraycopy(degreesFound, 0, temp, 0, numDegrees);
        degreesFound = temp;
        return degreesFound;
    }

    protected String[] parseCmdLineArgs(String[] args) throws IOException {
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                Alert.info(Version.getVersion());
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.verbose = true;
                this.DEBUG = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-gui")) {
                this.GUI = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rayp")) {
                this.onlyPrintRayP = true;
                this.onlyPrintTime = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-time")) {
                this.onlyPrintTime = true;
                this.onlyPrintRayP = false;
                continue;
            }
            if (i < args.length - 1) {
                if (args[i].equalsIgnoreCase("-mod") || args[i].equalsIgnoreCase("-model")) {
                    this.toolProps.put("taup.model.name", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.toolProps.put("taup.source.depth", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-deg")) {
                    this.degrees = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-km")) {
                    this.degrees = Double.valueOf(args[i + 1]) / 6371.0 * 180.0 / Math.PI;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-az")) {
                    this.azimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-baz")) {
                    this.backAzimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-o")) {
                    this.outFile = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-ph")) {
                    if (cmdLineArgPhase) {
                        this.toolProps.put("taup.phase.list", this.toolProps.getProperty("taup.phase.list", "") + "," + args[i + 1]);
                    } else {
                        this.toolProps.put("taup.phase.list", args[i + 1]);
                    }
                    cmdLineArgPhase = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-pf")) {
                    cmdLineArgPhaseFile = true;
                    this.toolProps.put("taup.phase.file", args[i + 1]);
                    ++i;
                    continue;
                }
                if (i < args.length - 2) {
                    if (args[i].equalsIgnoreCase("-sta") || args[i].equalsIgnoreCase("-station")) {
                        this.stationLat = Double.valueOf(args[i + 1]);
                        this.stationLon = Double.valueOf(args[i + 2]);
                        i += 2;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-evt") || args[i].equalsIgnoreCase("-event")) {
                        this.eventLat = Double.valueOf(args[i + 1]);
                        this.eventLon = Double.valueOf(args[i + 2]);
                        i += 2;
                        continue;
                    }
                    noComprendoArgs[numNoComprendoArgs++] = args[i];
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (cmdLineArgPhaseFile || cmdLineArgPhase) {
            if (cmdLineArgPhaseFile && !cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.list");
            }
            if (!cmdLineArgPhaseFile && cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.file");
            }
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public synchronized void sortArrivals() {
        if (this.arrivals.size() < 2) {
            return;
        }
        boolean sorted = false;
        boolean k = false;
        while (!sorted) {
            sorted = true;
            Arrival currArrival = (Arrival)this.arrivals.elementAt(0);
            for (int j = 0; j < this.arrivals.size() - 1; ++j) {
                Arrival prevArrival = currArrival;
                currArrival = (Arrival)this.arrivals.elementAt(j + 1);
                if (!(prevArrival.time > currArrival.time)) continue;
                sorted = false;
                this.arrivals.setElementAt(currArrival, j);
                this.arrivals.setElementAt(prevArrival, j + 1);
                currArrival = prevArrival;
            }
        }
    }

    public void calculate(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.calcTime(degrees);
    }

    public void calcTime(double degrees) {
        this.degrees = degrees;
        this.arrivals.removeAllElements();
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            SeismicPhase phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            phase.setDEBUG(this.DEBUG);
            phase.calcTime(degrees);
            Arrival[] phaseArrivals = phase.getArrivals();
            for (int i = 0; i < phaseArrivals.length; ++i) {
                this.arrivals.addElement(phaseArrivals[i]);
            }
        }
        this.sortArrivals();
    }

    public void depthCorrect(double depth) throws TauModelException {
        if (this.tModDepth == null || this.tModDepth.getSourceDepth() != depth) {
            this.tModDepth = this.tMod.depthCorrect(depth);
            this.clearArrivals();
            this.recalcPhases();
        }
        this.setSourceDepth(depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recalcPhases() {
        Vector<SeismicPhase> newPhases = new Vector<SeismicPhase>(this.phases.size());
        for (int phaseNameNum = 0; phaseNameNum < this.phaseNames.size(); ++phaseNameNum) {
            SeismicPhase seismicPhase;
            String tempPhaseName = ((PhaseName)this.phaseNames.elementAt((int)phaseNameNum)).name;
            boolean alreadyAdded = false;
            for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
                seismicPhase = (SeismicPhase)this.phases.elementAt(phaseNum);
                if (!seismicPhase.name.equals(tempPhaseName)) continue;
                this.phases.removeElementAt(phaseNum);
                if (seismicPhase.sourceDepth != this.depth || !seismicPhase.tMod.equals(this.tModDepth)) continue;
                newPhases.addElement(seismicPhase);
                alreadyAdded = true;
                if (!this.verbose) break;
                Alert.info(seismicPhase.toString());
                break;
            }
            if (alreadyAdded) continue;
            try {
                seismicPhase = new SeismicPhase(tempPhaseName, this.tModDepth);
                seismicPhase.setDEBUG(this.DEBUG);
                seismicPhase.init();
                newPhases.addElement(seismicPhase);
                if (!this.verbose) continue;
                Alert.info(seismicPhase.toString());
                continue;
            }
            catch (TauModelException e) {
                Alert.warning("Error with phase=" + tempPhaseName, e.getMessage() + "\nSkipping this phase");
                continue;
            }
            finally {
                if (this.verbose) {
                    Alert.info("-----------------");
                }
            }
        }
        this.phases = newPhases;
    }

    public void printResult(DataOutputStream dos) throws IOException {
        BufferedWriter s = new BufferedWriter(new OutputStreamWriter(dos));
        this.printResult(s);
        ((Writer)s).flush();
    }

    public void printResult(Writer out) throws IOException {
        int maxNameLength = 5;
        int maxPuristNameLength = 5;
        for (int j = 0; j < this.arrivals.size(); ++j) {
            if (((Arrival)this.arrivals.elementAt((int)j)).name.length() > maxNameLength) {
                maxNameLength = ((Arrival)this.arrivals.elementAt((int)j)).name.length();
            }
            if (((Arrival)this.arrivals.elementAt((int)j)).puristName.length() <= maxPuristNameLength) continue;
            maxPuristNameLength = ((Arrival)this.arrivals.elementAt((int)j)).puristName.length();
        }
        Format phaseFormat = new Format("%-" + maxNameLength + "s");
        Format phasePuristFormat = new Format("%-" + maxPuristNameLength + "s");
        if (!this.onlyPrintRayP && !this.onlyPrintTime) {
            out.write("\nModel: " + this.modelName + "\n");
            out.write("Distance   Depth   " + phaseFormat.form("Phase") + "   Travel    Ray Param   Purist    Purist\n");
            out.write("  (deg)     (km)   " + phaseFormat.form("Name ") + "   Time (s)  p (s/deg)  Distance   Name\n");
            for (int i = 0; i < maxNameLength + maxPuristNameLength + 54; ++i) {
                out.write("-");
            }
            out.write("\n");
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = (Arrival)this.arrivals.elementAt(j);
                out.write(this.outForms.formatDistance(currArrival.getModuloDistDeg()) + this.outForms.formatDepth(this.depth) + "   ");
                out.write(phaseFormat.form(currArrival.name));
                out.write("  " + this.outForms.formatTime(currArrival.time) + "  " + this.outForms.formatRayParam(Math.PI / 180 * currArrival.rayParam) + "   ");
                out.write(this.outForms.formatDistance(currArrival.getDistDeg()));
                if (currArrival.name.equals(currArrival.puristName)) {
                    out.write("  = ");
                } else {
                    out.write("  * ");
                }
                out.write(phasePuristFormat.form(currArrival.puristName) + "\n");
            }
        } else if (this.onlyPrintTime) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = (Arrival)this.arrivals.elementAt(j);
                out.write(String.valueOf((float)currArrival.time) + " ");
            }
            out.write("\n");
        } else if (this.onlyPrintRayP) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = (Arrival)this.arrivals.elementAt(j);
                out.write(String.valueOf((float)(Math.PI / 180 * currArrival.rayParam)) + " ");
            }
            out.write("\n");
        }
        out.write("\n");
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning("Caught IOException while attempting to reading phase file " + this.toolProps.getProperty("taup.phase.file"), e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null || this.tMod.sMod.vMod.getModelName() != this.toolProps.getProperty("taup.model.name", "iasp91")) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                Alert.error("Caught TauModelException", ee.getMessage());
            }
            catch (FileNotFoundException ee) {
                Alert.error("Can't find saved model file for model " + this.modelName + ".", "");
                System.exit(1);
            }
            catch (InvalidClassException ee) {
                Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
                System.exit(1);
            }
        }
        this.dos = this.outFile != null && this.outFile.length() != 0 ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile))) : new DataOutputStream(System.out);
    }

    public void printHelp() {
        Alert.info("Enter:\nh for new depth\nr to recalculate\np to append phases, \nc to clear phases\nl to list phases\ns for new station lat lon\ne for new event lat lon\na for new azimuth\nb for new back azimuth\nm for new model or \nq to quit.\n");
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws IOException, TauModelException, TauPException {
        block72: {
            block71: {
                if (this.degrees == 1.7976931348623157E308 && (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308 || this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308)) break block71;
                if (this.degrees == 1.7976931348623157E308) {
                    this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                    this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                    this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                }
                this.depthCorrect(this.depth);
                this.calculate(this.degrees);
                this.printResult(this.dos);
                break block72;
            }
            prevTime = 0L;
            readMode = 100;
            tempDepth = this.depth;
            this.depthCorrect(this.depth);
            tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            tokenIn.wordChars(94, 94);
            tokenIn.ordinaryChar(47);
            tokenIn.wordChars(47, 47);
            tokenIn.commentChar(35);
            this.printHelp();
            do {
                switch (readMode) {
                    case 104: {
                        System.out.print("Enter Depth: ");
                        tokenIn.nextToken();
                        tempDepth = tokenIn.nval;
                        if (tempDepth < 0.0 || tempDepth > this.tMod.getRadiusOfEarth()) {
                            Alert.warning("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().", "depth = " + tempDepth + " getRadiusOfEarth= " + this.tMod.getRadiusOfEarth());
                            break;
                        }
                        prevTime = System.currentTimeMillis();
                        this.depthCorrect(tempDepth);
                        currTime = System.currentTimeMillis();
                        if (this.verbose) {
                            Alert.info("depthCorrect time=" + (currTime - prevTime));
                        }
                        readMode = 100;
                        break;
                    }
                    case 100: {
                        System.out.print("Enter Distance or Option [hrpclseabmq]: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.degrees = tokenIn.nval;
                            if (this.DEBUG) {
                                Alert.info("degrees=" + this.degrees);
                            }
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                            break;
                        }
                        if (tokenIn.ttype == -1) ** GOTO lbl55
                        if (tokenIn.ttype != -3 || !tokenIn.sval.equalsIgnoreCase("q") && !tokenIn.sval.equalsIgnoreCase("quit") && !tokenIn.sval.equalsIgnoreCase("exit") && !tokenIn.sval.equalsIgnoreCase("bye")) ** GOTO lbl57
lbl55:
                        // 2 sources

                        readMode = 113;
                        break;
lbl57:
                        // 1 sources

                        if (tokenIn.ttype == -3) {
                            if (tokenIn.sval.equalsIgnoreCase("l")) {
                                readMode = 108;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("c")) {
                                readMode = 99;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("s")) {
                                readMode = 115;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("e")) {
                                readMode = 101;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("a")) {
                                readMode = 97;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("b")) {
                                readMode = 98;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("r")) {
                                readMode = 114;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("p")) {
                                readMode = 112;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("m")) {
                                readMode = 109;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("h")) {
                                readMode = 104;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("?")) {
                                this.printHelp();
                                break;
                            }
                            Alert.warning("I don't understand this option", tokenIn.sval);
                            this.printHelp();
                            break;
                        }
                        this.printHelp();
                        break;
                    }
                    case 114: {
                        if (this.degrees != 1.7976931348623157E308) {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        readMode = 100;
                        break;
                    }
                    case 112: {
                        System.out.print("Enter phases (ie P,p,PcP,S): ");
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChar(46);
                        tokenIn.ordinaryChar(45);
                        tokenIn.wordChars(48, 57);
                        tokenIn.wordChars(46, 46);
                        tokenIn.wordChars(45, 45);
                        tokenIn.ordinaryChar(32);
                        tokenIn.wordChars(32, 32);
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.parsePhaseList(tokenIn.sval);
                            this.recalcPhases();
                        } else {
                            Alert.warning("Input phases not recognized.", "Please retry.");
                        }
                        tokenIn.parseNumbers();
                        tokenIn.ordinaryChar(32);
                        tokenIn.whitespaceChars(32, 32);
                        readMode = 100;
                        break;
                    }
                    case 108: {
                        numPhases = this.phaseNames.size();
                        output = numPhases + " phases.";
                        Alert.info(output);
                        output = "";
                        for (i = 0; i < numPhases; ++i) {
                            output = output + ((PhaseName)this.phaseNames.elementAt((int)i)).name;
                            if (i >= numPhases - 1) continue;
                            output = output + ",";
                        }
                        Alert.info(output);
                        readMode = 100;
                        break;
                    }
                    case 99: {
                        this.clearPhaseNames();
                        readMode = 112;
                        break;
                    }
                    case 97: {
                        System.out.print("Enter azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.azimuth = tokenIn.nval;
                            this.stationLat = 1.7976931348623157E308;
                            this.stationLon = 1.7976931348623157E308;
                            if (this.DEBUG) {
                                Alert.info("azimuth=" + this.azimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        if (this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308) {
                            readMode = 101;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        readMode = 100;
                        break;
                    }
                    case 98: {
                        System.out.print("Enter back azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.backAzimuth = tokenIn.nval;
                            this.eventLat = 1.7976931348623157E308;
                            this.eventLon = 1.7976931348623157E308;
                            if (this.DEBUG) {
                                Alert.info("backAzimuth=" + this.backAzimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead");
                            this.printHelp();
                            break;
                        }
                        if (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308) {
                            readMode = 115;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        readMode = 100;
                        break;
                    }
                    case 101: {
                        System.out.print("Enter event lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.eventLat = tokenIn.nval;
                            if (this.DEBUG) {
                                Alert.info("eventLat=" + this.eventLat);
                            }
                            tokenIn.nextToken();
                            if (tokenIn.ttype == -2) {
                                this.eventLon = tokenIn.nval;
                                if (this.DEBUG) {
                                    Alert.info("eventLon=" + this.eventLon);
                                }
                            } else {
                                this.printHelp();
                            }
                        } else {
                            this.printHelp();
                        }
                        if (this.stationLat != 1.7976931348623157E308 && this.stationLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        readMode = 100;
                        break;
                    }
                    case 115: {
                        System.out.print("Enter station lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) ** GOTO lbl232
                        this.stationLat = tokenIn.nval;
                        if (this.DEBUG) {
                            Alert.info("stationLat=" + this.stationLat);
                        }
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.stationLon = tokenIn.nval;
                            if (this.DEBUG) {
                                Alert.info("stationLon=" + this.stationLon);
                            }
                        } else {
                            this.printHelp();
                            break;
lbl232:
                            // 1 sources

                            this.printHelp();
                            break;
                        }
                        if (this.eventLat != 1.7976931348623157E308 && this.eventLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.dos);
                        }
                        readMode = 100;
                        break;
                    }
                    case 109: {
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.wordChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.wordChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.wordChars(45, 45);
                        oldModelName = this.modelName;
                        oldTMod = this.tMod;
                        oldTModDepth = this.tModDepth;
                        System.out.print("Enter model name: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.modelName = tokenIn.sval;
                        }
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.parseNumbers();
                        if (!this.modelName.equals(oldModelName)) {
                            try {
                                this.readTauModel();
                                this.depthCorrect(this.depth);
                            }
                            catch (FileNotFoundException e) {
                                Alert.warning("I can't find model file " + this.modelName, "Still using model " + oldModelName + ".");
                                this.modelName = oldModelName;
                                this.tMod = oldTMod;
                                this.tModDepth = oldTModDepth;
                            }
                            catch (InvalidClassException ee) {
                                Alert.warning("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create. Still using model " + oldModelName + ".");
                                this.modelName = oldModelName;
                                this.tMod = oldTMod;
                                this.tModDepth = oldTModDepth;
                            }
                        }
                        readMode = 100;
                        break;
                    }
                    case 113: {
                        return;
                    }
                }
            } while (tokenIn.ttype == -2 || tokenIn.ttype != -3 || tokenIn.ttype == -3 && !tokenIn.sval.equalsIgnoreCase("q"));
        }
    }

    public void destroy() throws IOException {
        if (this.dos != null) {
            this.dos.close();
        }
    }

    public void printStdUsageHead() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        Alert.info("Usage: " + className.toLowerCase() + " [arguments]");
        Alert.info("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        Alert.info("\nArguments are:");
    }

    public void printStdUsage() {
        this.printStdUsageHead();
        Alert.info("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\nDistance is given by:\n\n-deg degrees       -- distance in degrees,\n-km kilometers     -- distance in kilometers,\n                      assumes radius of earth is 6371km,\n\nor by giving the station and event latitude and lonitude,\n                      assumes a spherical earth,\n\n-sta[tion] lat lon -- sets the station latitude and longitude\n-evt       lat lon -- sets the event latitude and longitude\n\n");
    }

    public void printStdUsageTail() {
        Alert.info("\n-o outfile         -- output is redirected to \"outfile\"\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n");
    }

    public void printUsage() {
        this.printStdUsage();
        Alert.info("-rayp              -- only output the ray parameter\n-time              -- only output travel time");
        this.printStdUsageTail();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        BasicConfigurator.configure();
        try {
            long prevTime = 0L;
            prevTime = System.currentTimeMillis();
            TauP_Time tauPTime = new TauP_Time();
            String[] noComprendoArgs = tauPTime.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                for (int i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                String outStringA = "I don't understand the following arguments, continuing:";
                String outStringB = "";
                for (int i = 0; i < noComprendoArgs.length; ++i) {
                    outStringB = outStringB + noComprendoArgs[i] + " ";
                }
                Alert.warning(outStringA, outStringB);
                noComprendoArgs = null;
            }
            long currTime = System.currentTimeMillis();
            prevTime = System.currentTimeMillis();
            tauPTime.init();
            currTime = System.currentTimeMillis();
            if (tauPTime.DEBUG) {
                Alert.info("taup model read time=" + (currTime - prevTime));
            }
            tauPTime.start();
            tauPTime.destroy();
        }
        catch (TauModelException e) {
            Alert.error("Caught TauModelException", e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            Alert.error("Caught TauPException", e.getMessage());
            e.printStackTrace();
        }
    }
}

