/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class TauP_Table
extends TauP_Time {
    public static final int GENERIC = 0;
    public static final int LOCSAT = 1;
    protected int outputType = 0;
    protected String headerFile;
    protected double[] depths = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 19.0, 21.0, 25.0, 30.0, 33.0, 35.0, 40.0, 45.0, 49.0, 51.0, 55.0, 60.0, 70.0, 80.0, 90.0, 100.0, 120.0, 140.0, 160.0, 180.0, 200.0, 220.0, 240.0, 260.0, 280.0, 300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0};
    protected double[] distances = new double[]{0.0, 0.1f, 0.2f, 0.3f, 0.4f, 0.5, 0.6f, 0.7f, 0.8f, 0.9f, 1.0, 1.1f, 1.2f, 1.3f, 1.4f, 1.5, 1.6f, 1.7f, 1.8f, 1.9f, 2.0, 2.1f, 2.2f, 2.3f, 2.4f, 2.5, 2.6f, 2.7f, 2.8f, 2.9f, 3.0, 3.1f, 3.2f, 3.3f, 3.4f, 3.5, 3.6f, 3.7f, 3.8f, 3.9f, 4.0, 4.1f, 4.2f, 4.3f, 4.4f, 4.5, 4.6f, 4.7f, 4.8f, 4.9f, 5.0, 5.1f, 5.2f, 5.3f, 5.4f, 5.5, 5.6f, 5.7f, 5.8f, 5.9f, 6.0, 6.1f, 6.2f, 6.3f, 6.4f, 6.5, 6.6f, 6.7f, 6.8f, 6.9f, 7.0, 7.1f, 7.2f, 7.3f, 7.4f, 7.5, 7.6f, 7.7f, 7.8f, 7.9f, 8.0, 8.1f, 8.2f, 8.3f, 8.4f, 8.5, 8.6f, 8.7f, 8.8f, 8.9f, 9.0, 9.1f, 9.2f, 9.3f, 9.4f, 9.5, 9.6f, 9.7f, 9.8f, 9.9f, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 105.0, 110.0, 115.0, 120.0, 125.0, 130.0, 135.0, 140.0, 145.0, 150.0, 155.0, 160.0, 165.0, 170.0, 175.0, 180.0};

    public void init() throws IOException {
        super.init();
        if (this.headerFile != null) {
            try {
                int i;
                StreamTokenizer head = new StreamTokenizer(new BufferedReader(new FileReader(this.headerFile)));
                head.commentChar(35);
                head.nextToken();
                if (head.ttype == -3 && head.sval.equals("n")) {
                    head.nextToken();
                } else {
                    Alert.warning("First character of header file is not 'n'", "'" + head.ttype + "'  " + head.sval);
                }
                if (head.ttype != -2) {
                    if (head.ttype == -3) {
                        Alert.error("Expected a number of depth samples, but got ", head.sval);
                    } else {
                        Alert.error("Expected a number of depth samples, but got ", "'" + head.ttype + "'");
                    }
                    System.exit(1);
                }
                if (head.nval != Math.rint(head.nval)) {
                    Alert.error("Expected a number of depth samples, but got ", head.sval);
                }
                this.depths = new double[(int)head.nval];
                for (i = 0; i < this.depths.length; ++i) {
                    head.nextToken();
                    if (head.ttype != -2) {
                        if (head.ttype == -3) {
                            Alert.error("Expected a number of depth samples, but got ", head.sval);
                        } else {
                            Alert.error("Expected a number of depth samples, but got ", "'" + head.ttype + "'");
                        }
                        System.exit(1);
                    }
                    this.depths[i] = head.nval;
                }
                head.nextToken();
                if (head.ttype != -2) {
                    if (head.ttype == -3) {
                        Alert.error("Expected a number of distance samples, but got ", head.sval);
                    } else {
                        Alert.error("Expected a number of distance samples, but got ", "'" + head.ttype + "'");
                    }
                    System.exit(1);
                }
                if (head.nval != Math.rint(head.nval)) {
                    Alert.error("Expected a number of distance samples, but got ", head.sval);
                }
                this.distances = new double[(int)head.nval];
                for (i = 0; i < this.distances.length; ++i) {
                    head.nextToken();
                    if (head.ttype != -2) {
                        if (head.ttype == -3) {
                            Alert.error("Expected a distance sample, but got ", head.sval);
                        } else {
                            Alert.error("Expected a distance sample, but got ", "'" + head.ttype + "'");
                        }
                        System.exit(1);
                    }
                    this.distances[i] = head.nval;
                }
            }
            catch (FileNotFoundException e) {
                Alert.error("Couldn't find file.", e.getMessage());
                System.exit(1);
            }
            catch (IOException e) {
                Alert.error("Caught IOException.", e.getMessage());
                System.exit(1);
            }
        }
    }

    public void start() throws TauModelException, TauPException, IOException {
        switch (this.outputType) {
            case 0: {
                this.genericTable(this.dos);
                break;
            }
            case 1: {
                this.locsatTable(this.dos);
                break;
            }
            default: {
                throw new TauPException("TauP_Table: undefined state for output type: " + this.outputType);
            }
        }
    }

    protected void genericTable(DataOutputStream dos) throws TauModelException, IOException {
        Format decimal7 = new Format("%-7d");
        Format float6_1 = new Format("%6.1f");
        Format float8_1 = new Format("%8.1f");
        Format float8_2 = new Format("%8.2f");
        Format float8_3 = new Format("%8.3f");
        Format float8_4 = new Format("%8.4f");
        for (int depthNum = 0; depthNum < this.depths.length; ++depthNum) {
            this.depthCorrect(this.depths[depthNum]);
            for (int distNum = 0; distNum < this.distances.length; ++distNum) {
                this.calculate(this.distances[distNum]);
                if (this.getNumArrivals() <= 0) continue;
                Arrival[] arrivals = this.getArrivals();
                for (int aNum = 0; aNum < this.getNumArrivals(); ++aNum) {
                    Arrival currArrival = arrivals[aNum];
                    double moduloDist = currArrival.getModuloDistDeg();
                    dos.writeBytes(this.modelName + " " + this.outForms.formatDistance(moduloDist) + " " + this.outForms.formatDepth(this.depth) + " ");
                    dos.writeBytes(currArrival.name);
                    dos.writeBytes("  " + this.outForms.formatTime(currArrival.time) + "  ");
                    dos.writeBytes(this.outForms.formatRayParam(Math.PI / 180 * currArrival.rayParam) + "   ");
                    dos.writeBytes(this.outForms.formatDistance(currArrival.getDistDeg()));
                    dos.writeBytes("  " + currArrival.puristName + "\n");
                }
            }
        }
        dos.close();
    }

    protected void locsatTable(DataOutputStream dos) throws TauModelException, IOException {
        int depthNum;
        Format float15_4 = new Format("%15.4f");
        Format float7_2 = new Format("%7.2f");
        Format decimal7 = new Format("%-7d");
        double maxDiff = Double.valueOf(this.toolProps.getProperty("taup.table.locsat.maxdiff", "105.0"));
        dos.writeBytes("n # " + this.getPhaseNameString() + " travel-time tables for " + this.modelName + " structure. (From TauP_Table)\n");
        dos.writeBytes(decimal7.form(this.depths.length) + "# number of depth samples\n");
        for (depthNum = 0; depthNum < this.depths.length; ++depthNum) {
            dos.writeBytes(float7_2.form(this.depths[depthNum]));
            if (depthNum % 10 != 9) continue;
            dos.writeBytes("\n");
        }
        if ((this.depths.length - 1) % 10 != 9) {
            dos.writeBytes("\n");
        }
        dos.writeBytes(decimal7.form(this.distances.length) + "# number of distances\n");
        for (int distNum = 0; distNum < this.distances.length; ++distNum) {
            dos.writeBytes(float7_2.form(this.distances[distNum]));
            if (distNum % 10 != 9) continue;
            dos.writeBytes("\n");
        }
        if ((this.distances.length - 1) % 10 != 9) {
            dos.writeBytes("\n");
        }
        for (depthNum = 0; depthNum < this.depths.length; ++depthNum) {
            this.depthCorrect(this.depths[depthNum]);
            dos.writeBytes("#  Travel time for z =    " + this.depths[depthNum] + "\n");
            for (int distNum = 0; distNum < this.distances.length; ++distNum) {
                this.calculate(this.distances[distNum]);
                if (this.getNumArrivals() > 0) {
                    Arrival[] arrivals = this.getArrivals();
                    if (this.distances[distNum] > maxDiff && arrivals[0].name.endsWith("diff")) {
                        if (this.getNumArrivals() > 1) {
                            int aNum;
                            for (aNum = 1; arrivals[aNum].name.endsWith("diff") && aNum < this.getNumArrivals() - 1; ++aNum) {
                            }
                            if (!arrivals[aNum].name.endsWith("diff")) {
                                dos.writeBytes(float15_4.form(arrivals[aNum].time) + "    " + arrivals[aNum].name + "\n");
                                continue;
                            }
                            dos.writeBytes(float15_4.form(-1.0) + "    none\n");
                            continue;
                        }
                        dos.writeBytes(float15_4.form(-1.0) + "    none\n");
                        continue;
                    }
                    dos.writeBytes(float15_4.form(arrivals[0].time) + "    " + arrivals[0].name + "\n");
                    continue;
                }
                dos.writeBytes(float15_4.form(-1.0) + "    none\n");
            }
        }
        dos.close();
    }

    public void printUsage() {
        this.printStdUsageHead();
        System.out.println("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
        System.out.println("-header filename   -- reads depth and distance spacing data\n                      from a LOCSAT style file.");
        System.out.println("-generic           -- outputs a \"generic\" ascii table\n");
        System.out.println("-locsat            -- outputs a \"locsat\" style ascii table\n");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (leftOverArgs[i].equalsIgnoreCase("-header") && i < leftOverArgs.length - 1) {
                this.headerFile = leftOverArgs[i + 1];
                ++i;
                continue;
            }
            if (leftOverArgs[i].equals("-locsat")) {
                this.outputType = 1;
                continue;
            }
            if (leftOverArgs[i].equals("-generic")) {
                this.outputType = 0;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i].equals("-help") ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) {
        try {
            TauP_Table me = new TauP_Table();
            String[] noComprendoArgs = me.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(noComprendoArgs[i] + " ");
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            me.init();
            me.start();
        }
        catch (TauModelException e) {
            System.err.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.err.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Caught IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

