/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Pierce
extends TauP_Time {
    protected boolean onlyTurnPoints = false;
    protected boolean onlyRevPoints = false;
    protected boolean onlyUnderPoints = false;
    protected boolean onlyAddPoints = false;
    protected double[] addDepth = new double[0];

    protected TauP_Pierce() {
    }

    public TauP_Pierce(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_Pierce(String modelName) throws TauModelException {
        super(modelName);
    }

    public void setOnlyTurnPoints(boolean onlyTurnPoints) {
        this.onlyTurnPoints = onlyTurnPoints;
    }

    public void setOnlyRevPoints(boolean onlyRevPoints) {
        this.onlyRevPoints = onlyRevPoints;
    }

    public void setOnlyUnderPoints(boolean onlyUnderPoints) {
        this.onlyUnderPoints = onlyUnderPoints;
    }

    public void setOnlyAddPoints(boolean onlyAddPoints) {
        this.onlyAddPoints = onlyAddPoints;
    }

    public void setAddDepths(String depthString) {
        this.addDepth = this.parseAddDepthsList(depthString);
    }

    public void appendAddDepths(String depthString) {
        double[] newDepths = this.parseAddDepthsList(depthString);
        double[] temp = new double[this.addDepth.length + newDepths.length];
        System.arraycopy(this.addDepth, 0, temp, 0, this.addDepth.length);
        System.arraycopy(newDepths, 0, temp, this.addDepth.length, newDepths.length);
        this.addDepth = temp;
    }

    protected double[] parseAddDepthsList(String depthList) {
        int offset = 0;
        int numDepths = 0;
        depthList = depthList.replace(' ', ',');
        int commaIndex = depthList.indexOf(",,", offset);
        while (commaIndex != -1) {
            depthList = depthList.substring(0, commaIndex) + depthList.substring(commaIndex + 1);
            commaIndex = depthList.indexOf(",,", offset);
        }
        if (depthList.charAt(0) == ',') {
            if (depthList.length() > 1) {
                depthList = depthList.substring(1);
            } else {
                return new double[0];
            }
        }
        if (depthList.charAt(depthList.length() - 1) == ',') {
            depthList = depthList.substring(0, depthList.length() - 1);
        }
        double[] depthsFound = new double[depthList.length()];
        while (offset < depthList.length()) {
            String degEntry;
            commaIndex = depthList.indexOf(44, offset);
            if (commaIndex != -1) {
                degEntry = depthList.substring(offset, commaIndex);
                depthsFound[numDepths] = Double.valueOf(degEntry);
                offset = commaIndex + 1;
                ++numDepths;
                continue;
            }
            degEntry = depthList.substring(offset);
            depthsFound[numDepths] = Double.valueOf(degEntry);
            offset = depthList.length();
            ++numDepths;
        }
        double[] temp = new double[numDepths];
        System.arraycopy(depthsFound, 0, temp, 0, numDepths);
        depthsFound = temp;
        return depthsFound;
    }

    public void depthCorrect(double depth) throws TauModelException {
        TauModel tModOrig = (TauModel)this.tMod.clone();
        TauModel tModDepthOrig = this.tModDepth;
        boolean mustRecalc = false;
        if (this.tModDepth.sourceDepth == depth) {
            if (this.addDepth != null) {
                double[] branchDepths = this.tModDepth.getBranchDepths();
                for (int i = 0; i < this.addDepth.length; ++i) {
                    for (int j = 0; j < branchDepths.length && this.addDepth[i] != branchDepths[j]; ++j) {
                        mustRecalc = true;
                    }
                    if (!mustRecalc) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            mustRecalc = true;
        }
        if (!mustRecalc) {
            super.depthCorrect(depth);
            return;
        }
        this.tModDepth = null;
        try {
            if (this.addDepth != null) {
                for (int i = 0; i < this.addDepth.length; ++i) {
                    this.tMod = this.tMod.splitBranch(this.addDepth[i]);
                }
            }
        }
        catch (TauModelException e) {
            System.err.println("depthCorrect: caught TauModelException: " + e.getMessage() + "\nSkipping added depth" + " pierce points.");
            this.tMod = tModOrig;
            this.tMod = tModDepthOrig;
        }
        super.depthCorrect(depth);
        this.tMod = tModOrig;
    }

    public void calculate(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPierce(degrees);
    }

    protected void calcPierce(double degrees) {
        this.degrees = degrees;
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            SeismicPhase phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            try {
                phase.setDEBUG(this.DEBUG);
                phase.calcTime(degrees);
                if (!phase.hasArrivals()) continue;
                phase.calcPierce(this.tModDepth);
                Arrival[] phaseArrivals = phase.getArrivals();
                for (int i = 0; i < phaseArrivals.length; ++i) {
                    this.arrivals.addElement(phaseArrivals[i]);
                }
                continue;
            }
            catch (TauModelException e) {
                System.err.println("Caught TauModelException: " + e.getMessage());
                System.err.println("Skipping phase " + phase.getName());
            }
        }
    }

    public void printResult(Writer out) throws IOException {
        boolean longWayRound = false;
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival currArrival = (Arrival)this.arrivals.elementAt(i);
            out.write("> " + currArrival.name + " at " + this.outForms.formatTime(currArrival.time) + " seconds at " + this.outForms.formatDistance(currArrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(currArrival.sourceDepth) + " km deep source in the " + this.modelName + " model.\n");
            longWayRound = false;
            if (currArrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                longWayRound = true;
            }
            double prevDepth = currArrival.pierce[0].depth;
            for (int j = 0; j < currArrival.pierce.length; ++j) {
                double calcTime = currArrival.pierce[j].time;
                double calcDist = currArrival.pierce[j].dist * 180.0 / Math.PI;
                if (longWayRound && calcDist != 0.0) {
                    calcDist *= -1.0;
                }
                double nextDepth = j < currArrival.pierce.length - 1 ? currArrival.pierce[j + 1].depth : currArrival.pierce[j].depth;
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyAddPoints && this.isAddDepth(currArrival.pierce[j].depth) || this.onlyRevPoints && (prevDepth - currArrival.pierce[j].depth) * (currArrival.pierce[j].depth - nextDepth) < 0.0 || this.onlyTurnPoints && j != 0 && prevDepth - currArrival.pierce[j].depth <= 0.0 && currArrival.pierce[j].depth - nextDepth >= 0.0 || this.onlyUnderPoints && prevDepth - currArrival.pierce[j].depth >= 0.0 && currArrival.pierce[j].depth - nextDepth <= 0.0) {
                    double lon;
                    double lat;
                    out.write(this.outForms.formatDistance(calcDist));
                    out.write(this.outForms.formatDepth(currArrival.pierce[j].depth));
                    out.write(this.outForms.formatDepth(currArrival.pierce[j].time));
                    if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
                        lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
                        lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
                        out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
                        lat = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
                        lon = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
                        out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
                    } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
                        this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                        this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                        lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
                        lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
                        out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
                    }
                    out.write("\n");
                }
                prevDepth = currArrival.pierce[j].depth;
            }
        }
    }

    public synchronized boolean isAddDepth(double depth) {
        for (int i = 0; i < this.addDepth.length; ++i) {
            if (depth != this.addDepth[i]) continue;
            return true;
        }
        return false;
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-az azimuth        -- sets the azimuth (event to station)\n                      used to output lat and lon of pierce points\n                      if the event lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.");
        System.out.println("-baz backazimuth   -- sets the back azimuth (station to event)\n                      used to output lat and lon of pierce points\n                      if the station lat lon and distance are also\n                      given. Calculated if station and event\n                      lat and lon are given.\n");
        System.out.println("-rev               -- only prints underside and bottom turn points, e.g. ^ and v");
        System.out.println("-turn              -- only prints bottom turning points, e.g. v");
        System.out.println("-under             -- only prints underside reflection points, e.g. ^\n");
        System.out.println("-pierce depth      -- adds depth for calculating pierce points");
        System.out.println("-nodiscon          -- only prints pierce points for the depths added with -pierce\n");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (leftOverArgs[i].equalsIgnoreCase("-turn")) {
                this.onlyTurnPoints = true;
                continue;
            }
            if (leftOverArgs[i].equalsIgnoreCase("-rev")) {
                this.onlyRevPoints = true;
                continue;
            }
            if (leftOverArgs[i].equalsIgnoreCase("-under")) {
                this.onlyUnderPoints = true;
                continue;
            }
            if (leftOverArgs[i].equalsIgnoreCase("-pierce") && i < leftOverArgs.length - 1) {
                this.appendAddDepths(leftOverArgs[i + 1]);
                ++i;
                continue;
            }
            if (leftOverArgs[i].equalsIgnoreCase("-nodiscon")) {
                this.onlyAddPoints = true;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i].equals("-help") ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Pierce tauPPierce = new TauP_Pierce();
            String[] noComprendoArgs = tauPPierce.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(noComprendoArgs[i] + " ");
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            if (tauPPierce.DEBUG) {
                System.out.println("Done reading " + tauPPierce.modelName);
            }
            tauPPierce.init();
            tauPPierce.start();
            tauPPierce.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println("Caught TauPException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

