/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Path
extends TauP_Pierce {
    protected float mapWidth = 6.0f;
    protected boolean gmtScript = false;
    protected double maxPathInc = 1.0;
    protected static Format float8_4 = new Format("%8.4f");

    protected TauP_Path() {
        this.outFile = null;
    }

    public TauP_Path(TauModel tMod) throws TauModelException {
        super(tMod);
        this.outFile = null;
    }

    public TauP_Path(String modelName) throws TauModelException {
        super(modelName);
        this.outFile = null;
    }

    public TauP_Path(TauModel tMod, String outFileBase) throws TauModelException {
        super(tMod);
        this.setOutFileBase(outFileBase);
    }

    public TauP_Path(String modelName, String outFileBase) throws TauModelException {
        super(modelName);
        this.setOutFileBase(outFileBase);
    }

    public void setOutFileBase(String outFileBase) {
        this.outFile = outFileBase != null && outFileBase.length() != 0 ? outFileBase + ".gmt" : "taup_path.gmt";
    }

    public void setMapWidth() {
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public boolean getGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public double getMaxPathInc() {
        return this.maxPathInc;
    }

    public void setMaxPathInc(double maxPathInc) {
        this.maxPathInc = maxPathInc;
    }

    public void calculate(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPath(degrees);
    }

    public void calcPath(double degrees) {
        this.degrees = degrees;
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            SeismicPhase phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            phase.setDEBUG(this.DEBUG);
            phase.calcTime(degrees);
            if (!phase.hasArrivals()) continue;
            phase.calcPath(this.tModDepth);
            Arrival[] phaseArrivals = phase.getArrivals();
            for (int i = 0; i < phaseArrivals.length; ++i) {
                this.arrivals.addElement(phaseArrivals[i]);
            }
        }
    }

    public void printResult(Writer out) throws IOException {
        double radiusOfEarth = this.tModDepth.getRadiusOfEarth();
        Format float12_5 = new Format("%12.5f");
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival currArrival = (Arrival)this.arrivals.elementAt(i);
            out.write("> " + currArrival.name + " at " + this.outForms.formatDistance(currArrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(currArrival.sourceDepth) + " km deep source in the " + this.modelName + " model arriving at " + this.outForms.formatTime(currArrival.getTime()) + " s with rayParam " + this.outForms.formatRayParam(Math.PI / 180 * currArrival.getRayParam()) + " s/deg.\n");
            boolean longWayRound = false;
            if (currArrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                longWayRound = true;
            }
            double calcTime = 0.0;
            double calcDist = 0.0;
            double calcDepth = currArrival.sourceDepth;
            for (int j = 0; j < currArrival.path.length; ++j) {
                calcTime = currArrival.path[j].time;
                double prevDepth = calcDepth = currArrival.path[j].depth;
                calcDist = currArrival.path[j].dist * 180.0 / Math.PI;
                if (longWayRound && calcDist != 0.0) {
                    calcDist = -1.0 * calcDist;
                }
                out.write(this.outForms.formatDistance(calcDist) + "  " + this.outForms.formatDepth(radiusOfEarth - calcDepth));
                if (!this.gmtScript) {
                    this.printLatLon(out, calcDist);
                }
                out.write("\n");
                if (j < currArrival.path.length - 1 && currArrival.rayParam != 0.0 && 57.29577951308232 * (currArrival.path[j + 1].dist - currArrival.path[j].dist) > this.maxPathInc) {
                    int maxInterpNum = (int)Math.ceil((currArrival.path[j + 1].dist - currArrival.path[j].dist) * 180.0 / Math.PI / this.maxPathInc);
                    for (int interpNum = 1; interpNum < maxInterpNum; ++interpNum) {
                        calcTime += (currArrival.path[j + 1].time - currArrival.path[j].time) / (double)maxInterpNum;
                        calcDist = longWayRound ? (calcDist -= (currArrival.path[j + 1].dist - currArrival.path[j].dist) / (double)maxInterpNum * 180.0 / Math.PI) : (calcDist += (currArrival.path[j + 1].dist - currArrival.path[j].dist) / (double)maxInterpNum * 180.0 / Math.PI);
                        calcDepth = prevDepth + (double)interpNum * (currArrival.path[j + 1].depth - prevDepth) / (double)maxInterpNum;
                        out.write(this.outForms.formatDistance(calcDist) + "  " + this.outForms.formatDepth(radiusOfEarth - calcDepth));
                        if (!this.gmtScript) {
                            this.printLatLon(out, calcDist);
                        }
                        out.write("\n");
                    }
                }
                prevDepth = currArrival.path[j].depth;
            }
        }
    }

    protected void printLatLon(Writer out, double calcDist) throws IOException {
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            double lon = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + this.outForms.formatLatLon(lat) + "  " + this.outForms.formatLatLon(lon));
        }
    }

    public void init() throws IOException {
        super.init();
        if (this.gmtScript) {
            String psFile;
            if (this.outFile == null) {
                this.outFile = "taup_path.gmt";
                psFile = "taup_path.ps";
            } else {
                psFile = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            }
            this.dos.writeBytes("#!/bin/sh\n");
            this.dos.writeBytes("#\n# This script will plot ray paths using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, to the last psxy, as well as the last line.\n#\n");
            this.dos.writeBytes("/bin/rm -f " + psFile + "\n\n");
            this.dos.writeBytes("# draw surface and label distances.\npsbasemap -K -P -R0/360/0/6371 -JP" + this.mapWidth + " -B30p/500N > " + psFile + "\n\n");
            this.dos.writeBytes("# draw circles for branches, note these are scaled for a \n# map using -JP" + this.mapWidth + "\n" + "psxy -K -O -P -R -JP -Sc -A >> " + psFile + " <<ENDLAYERS\n");
            for (int j = 0; j < 2; ++j) {
                this.dos.writeBytes("0.0 0.0 " + (float)(this.tMod.getRadiusOfEarth() * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                for (int i = 0; i < this.tMod.tauBranches[j].length; ++i) {
                    this.dos.writeBytes("0.0 0.0 " + (float)((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[j][i].getBotDepth()) * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                }
            }
            this.dos.writeBytes("ENDLAYERS\n\n");
            this.dos.writeBytes("# draw paths\n");
            this.dos.writeBytes("psxy -P -R -O -JP -M -A >> " + psFile + " <<END\n");
        }
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-gmt             -- outputs path as a complete GMT script.");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (leftOverArgs[i].equalsIgnoreCase("-gmt")) {
                this.gmtScript = true;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i].equals("-help") ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public void start() throws IOException, TauModelException, TauPException {
        super.start();
    }

    public void destroy() throws IOException {
        if (this.gmtScript) {
            this.dos.writeBytes("END\n");
        }
        super.destroy();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Path tauPPath = new TauP_Path();
            tauPPath.setOutFileBase("taup_path");
            String[] noComprendoArgs = tauPPath.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                int i;
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(noComprendoArgs[i] + " ");
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            tauPPath.init();
            if (tauPPath.DEBUG) {
                System.out.println("Done reading " + tauPPath.modelName);
            }
            tauPPath.start();
            tauPPath.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println("Caught TauPException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

