/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;

public class TauModel
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public boolean spherical = true;
    protected double sourceDepth = 0.0;
    protected int sourceBranch = 0;
    protected double[] noDisconDepths = new double[0];
    protected double mohoDepth;
    protected int mohoBranch;
    protected double cmbDepth;
    protected int cmbBranch;
    protected double iocbDepth;
    protected int iocbBranch;
    protected double radiusOfEarth = 6371.0;
    public SlownessModel sMod;
    protected double[] rayParams;
    public TauBranch[][] tauBranches = new TauBranch[2][];

    public String getModelName() {
        return this.sMod.vMod.getModelName();
    }

    public SlownessModel getSlownessModel() {
        return this.sMod;
    }

    public VelocityModel getVelocityModel() {
        return this.sMod.vMod;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public int getSourceBranch() {
        return this.sourceBranch;
    }

    public double[] getNoDisconDepths() {
        return this.noDisconDepths;
    }

    public boolean isNoDisconBranch(int branchNum) {
        for (int i = 0; i < this.noDisconDepths.length; ++i) {
            if (this.noDisconDepths[i] != this.getTauBranch(branchNum, true).getTopDepth()) continue;
            return true;
        }
        return false;
    }

    public boolean isNoDisconDepth(double noDisconDepth) {
        for (int i = 0; i < this.noDisconDepths.length; ++i) {
            if (this.noDisconDepths[i] != noDisconDepth) continue;
            return true;
        }
        return false;
    }

    public synchronized void setNoDisconDepths(double[] noDisconDepths) {
        this.noDisconDepths = noDisconDepths;
    }

    public synchronized void appendNoDisconDepth(double noDisconDepth) {
        double[] temp = new double[this.noDisconDepths.length + 1];
        System.arraycopy(this.noDisconDepths, 0, temp, 0, this.noDisconDepths.length);
        this.noDisconDepths = temp;
        this.noDisconDepths[this.noDisconDepths.length - 1] = noDisconDepth;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public int getMohoBranch() {
        return this.mohoBranch;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public int getCmbBranch() {
        return this.cmbBranch;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public int getIocbBranch() {
        return this.iocbBranch;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double getOneRayParam(int i) {
        return this.rayParams[i];
    }

    public int getNumBranches() {
        return this.tauBranches[0].length;
    }

    public TauBranch getTauBranch(int branchNum, boolean isPWave) {
        if (isPWave) {
            return this.tauBranches[0][branchNum];
        }
        return this.tauBranches[1][branchNum];
    }

    public double[] getBranchDepths() {
        double[] branchDepths = new double[this.getNumBranches()];
        branchDepths[0] = this.getTauBranch(0, true).getTopDepth();
        for (int i = 1; i < branchDepths.length; ++i) {
            branchDepths[i] = this.getTauBranch(i - 1, true).getBotDepth();
        }
        return branchDepths;
    }

    public double findDepth(double rayParam, boolean isPWave) throws TauModelException {
        try {
            return this.sMod.findDepth(rayParam, isPWave);
        }
        catch (SlownessModelException e) {
            throw new TauModelException("findDepth: caught SlownessModelException:" + e.getMessage());
        }
    }

    public void calcTauIncFrom(SlownessModel sMod) throws SlownessModelException, NoSuchLayerException, TauModelException, NoSuchMatPropException {
        TimeDist timedist = new TimeDist();
        if (this.DEBUG) {
            System.out.println("Size of slowness model: sMod.getNumLayers('P') = " + sMod.getNumLayers(true) + ", sMod.getNumLayers('S') = " + sMod.getNumLayers(false));
        }
        if (sMod.getNumLayers(true) == 0 || sMod.getNumLayers(false) == 0) {
            throw new SlownessModelException("Can't calculate tauInc when getNumLayers() = 0. I need more slowness samples.");
        }
        if (!sMod.validate()) {
            throw new SlownessModelException("Validation failed: Something is wrong with the slowness model.");
        }
        this.sMod = (SlownessModel)sMod.clone();
        this.radiusOfEarth = sMod.getRadiusOfEarth();
        this.sourceDepth = 0.0;
        this.sourceBranch = 0;
        int numBranches = sMod.getNumCriticalDepths() - 1;
        this.tauBranches[0] = new TauBranch[numBranches];
        this.tauBranches[1] = new TauBranch[numBranches];
        int rayNum = 0;
        double minPSoFar = sMod.getSlownessLayerClone(0, false).getTopP();
        double[] tempRayParams = new double[2 * sMod.getNumLayers(false) + sMod.getNumCriticalDepths()];
        tempRayParams[rayNum] = minPSoFar;
        ++rayNum;
        for (int layerNum = 0; layerNum < sMod.getNumLayers(false); ++layerNum) {
            SlownessLayer currSLayer = sMod.getSlownessLayer(layerNum, false);
            if (currSLayer.getTopP() < minPSoFar) {
                tempRayParams[rayNum] = currSLayer.getTopP();
                ++rayNum;
                minPSoFar = currSLayer.getTopP();
            }
            if (!(currSLayer.getBotP() < minPSoFar)) continue;
            tempRayParams[rayNum] = currSLayer.getBotP();
            ++rayNum;
            minPSoFar = currSLayer.getBotP();
        }
        this.rayParams = new double[rayNum];
        System.arraycopy(tempRayParams, 0, this.rayParams, 0, rayNum);
        tempRayParams = null;
        if (this.DEBUG) {
            System.out.println("Number of slowness samples for tau =" + rayNum);
        }
        boolean isPWave = true;
        for (int waveNum = 0; waveNum < 2; ++waveNum) {
            minPSoFar = sMod.getSlownessLayerClone(0, isPWave).getTopP();
            for (int critNum = 0; critNum < sMod.getNumCriticalDepths() - 1; ++critNum) {
                CriticalDepth topCritDepth = sMod.getCriticalDepth(critNum);
                int topCritLayerNum = topCritDepth.getLayerNum(isPWave);
                CriticalDepth botCritDepth = sMod.getCriticalDepth(critNum + 1);
                int botCritLayerNum = botCritDepth.getLayerNum(isPWave) - 1;
                if (this.DEBUG) {
                    System.out.println("Calculating " + (isPWave ? "P" : "S") + " tau branch for branch " + critNum + " topCritLayerNum=" + topCritLayerNum + " botCritLayerNum=" + botCritLayerNum + "\nminPSoFar=" + minPSoFar);
                }
                this.tauBranches[waveNum][critNum] = new TauBranch(topCritDepth.depth, botCritDepth.depth, isPWave);
                this.tauBranches[waveNum][critNum].DEBUG = this.DEBUG;
                this.tauBranches[waveNum][critNum].createBranch(sMod, minPSoFar, this.rayParams);
                SlownessLayer topSLayer = sMod.getSlownessLayer(topCritLayerNum, isPWave);
                SlownessLayer botSLayer = sMod.getSlownessLayer(botCritLayerNum, isPWave);
                minPSoFar = Math.min(minPSoFar, Math.min(topSLayer.getTopP(), botSLayer.getBotP()));
                botSLayer = sMod.getSlownessLayer(sMod.layerNumberAbove(botCritDepth.depth, isPWave), isPWave);
                minPSoFar = Math.min(minPSoFar, botSLayer.getBotP());
            }
            isPWave = false;
        }
        double bestMoho = Double.MAX_VALUE;
        double bestCmb = Double.MAX_VALUE;
        double bestIocb = Double.MAX_VALUE;
        for (int branchNum = 0; branchNum < this.tauBranches[0].length; ++branchNum) {
            TauBranch tBranch = this.tauBranches[0][branchNum];
            if (Math.abs(tBranch.getTopDepth() - sMod.vMod.getMohoDepth()) <= bestMoho) {
                this.mohoBranch = branchNum;
                bestMoho = Math.abs(tBranch.getTopDepth() - sMod.vMod.getMohoDepth());
            }
            if (Math.abs(tBranch.getTopDepth() - sMod.vMod.getCmbDepth()) < bestCmb) {
                this.cmbBranch = branchNum;
                bestCmb = Math.abs(tBranch.getTopDepth() - sMod.vMod.getCmbDepth());
            }
            if (!(Math.abs(tBranch.getTopDepth() - sMod.vMod.getIocbDepth()) < bestIocb)) continue;
            this.iocbBranch = branchNum;
            bestIocb = Math.abs(tBranch.getTopDepth() - sMod.vMod.getIocbDepth());
        }
        this.mohoDepth = this.tauBranches[0][this.mohoBranch].getTopDepth();
        this.cmbDepth = this.tauBranches[0][this.cmbBranch].getTopDepth();
        this.iocbDepth = this.tauBranches[0][this.iocbBranch].getTopDepth();
        if (!this.validate()) {
            throw new TauModelException("calcTauIncFrom: Validation failed!");
        }
    }

    public int findBranch(double depth) throws TauModelException {
        for (int i = 0; i < this.tauBranches[0].length; ++i) {
            if (!(this.tauBranches[0][i].getTopDepth() <= depth) || !(this.tauBranches[0][i].getBotDepth() > depth)) continue;
            return i;
        }
        if (this.tauBranches[0][this.tauBranches[0].length - 1].getBotDepth() == depth) {
            return this.tauBranches[0].length - 1;
        }
        throw new TauModelException("No TauBranch contains depth=" + depth);
    }

    public TauModel depthCorrect(double depth) throws TauModelException {
        if (this.sourceDepth != 0.0) {
            throw new TauModelException("depthCorrect: Can't depth correct a tau model that is not for a surface source.");
        }
        if (depth > this.getCmbDepth()) {
            throw new TauModelException("depthCorrect: Can't depth correct for a depth in the core.");
        }
        TauModel tMod = this.splitBranch(depth);
        tMod.sourceDepth = depth;
        tMod.sourceBranch = tMod.findBranch(depth);
        this.validate();
        return tMod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TauModel splitBranch(double depth) throws TauModelException {
        try {
            TauModel tMod = (TauModel)this.clone();
            for (int branchNum = 0; branchNum < tMod.tauBranches[0].length; ++branchNum) {
                if (tMod.tauBranches[0][branchNum].getTopDepth() == depth) return tMod;
                if (tMod.tauBranches[0][branchNum].getBotDepth() != depth) continue;
                return tMod;
            }
            int indexP = -1;
            double PWaveRayParam = -1.0;
            int indexS = -1;
            double SWaveRayParam = -1.0;
            int waveNum = 1;
            boolean isPWave = false;
            while (true) {
                block18: {
                    int index;
                    double newRayParam;
                    block19: {
                        int topCritLayerNumS;
                        int i;
                        block17: {
                            if (waveNum < 0) break block17;
                            SplitLayerInfo splitInfo = tMod.sMod.splitLayer(depth, isPWave);
                            if (splitInfo.movedSample || !splitInfo.neededSplit) break block18;
                            int layerNum = tMod.sMod.layerNumberAbove(depth, isPWave);
                            SlownessLayer sLayer = tMod.sMod.getSlownessLayer(layerNum, isPWave);
                            newRayParam = splitInfo.getRayParam();
                            index = -1;
                            break block19;
                        }
                        int branchToSplit = tMod.findBranch(depth);
                        TauBranch[][] newtauBranches = new TauBranch[2][tMod.getNumBranches() + 1];
                        for (i = 0; i < branchToSplit; ++i) {
                            newtauBranches[0][i] = (TauBranch)tMod.tauBranches[0][i].clone();
                            newtauBranches[1][i] = (TauBranch)tMod.tauBranches[1][i].clone();
                            int topCritLayerNumP = tMod.sMod.layerNumberBelow(newtauBranches[0][i].getTopDepth(), true);
                            int botCritLayerNumP = tMod.sMod.layerNumberAbove(newtauBranches[0][i].getBotDepth(), true);
                            topCritLayerNumS = tMod.sMod.layerNumberBelow(newtauBranches[1][i].getTopDepth(), false);
                            int botCritLayerNumS = tMod.sMod.layerNumberAbove(newtauBranches[1][i].getBotDepth(), false);
                            if (indexS != -1) {
                                newtauBranches[0][i].insert(SWaveRayParam, tMod.sMod, indexS);
                                newtauBranches[1][i].insert(SWaveRayParam, tMod.sMod, indexS);
                            }
                            if (indexP == -1) continue;
                            newtauBranches[0][i].insert(PWaveRayParam, tMod.sMod, indexP);
                            newtauBranches[1][i].insert(PWaveRayParam, tMod.sMod, indexP);
                        }
                        tMod.appendNoDisconDepth(depth);
                        topCritLayerNumS = tMod.sMod.layerNumberBelow(tMod.tauBranches[1][branchToSplit].getTopDepth(), false);
                        int splitLayerNumS = tMod.sMod.layerNumberAbove(depth, false);
                        newtauBranches[1][branchToSplit] = new TauBranch(tMod.tauBranches[1][branchToSplit].getTopDepth(), depth, false);
                        newtauBranches[1][branchToSplit].createBranch(tMod.sMod, tMod.tauBranches[1][branchToSplit].getMaxRayParam(), tMod.rayParams);
                        newtauBranches[1][branchToSplit + 1] = tMod.tauBranches[1][branchToSplit].difference(newtauBranches[1][branchToSplit], indexP, indexS, tMod.sMod, newtauBranches[1][branchToSplit].getMinRayParam(), tMod.rayParams);
                        int topCritLayerNumP = tMod.sMod.layerNumberBelow(tMod.tauBranches[0][branchToSplit].getTopDepth(), true);
                        int splitLayerNumP = tMod.sMod.layerNumberAbove(depth, true);
                        newtauBranches[0][branchToSplit] = new TauBranch(tMod.tauBranches[0][branchToSplit].getTopDepth(), depth, true);
                        newtauBranches[0][branchToSplit].createBranch(tMod.sMod, tMod.tauBranches[0][branchToSplit].getMaxRayParam(), tMod.rayParams);
                        newtauBranches[0][branchToSplit + 1] = tMod.tauBranches[0][branchToSplit].difference(newtauBranches[0][branchToSplit], indexP, indexS, tMod.sMod, newtauBranches[0][branchToSplit].getMinRayParam(), tMod.rayParams);
                        for (i = branchToSplit + 1; i < tMod.tauBranches[0].length; ++i) {
                            newtauBranches[1][i + 1] = tMod.tauBranches[1][i];
                            newtauBranches[0][i + 1] = tMod.tauBranches[0][i];
                            if (indexS != -1) {
                                newtauBranches[0][i + 1].insert(SWaveRayParam, tMod.sMod, indexS);
                                newtauBranches[1][i + 1].insert(SWaveRayParam, tMod.sMod, indexS);
                            }
                            if (indexP == -1) continue;
                            newtauBranches[0][i + 1].insert(PWaveRayParam, tMod.sMod, indexP);
                            newtauBranches[1][i + 1].insert(PWaveRayParam, tMod.sMod, indexP);
                        }
                        tMod.tauBranches = newtauBranches;
                        if (tMod.sourceDepth > depth) {
                            ++tMod.sourceBranch;
                        }
                        if (tMod.mohoDepth > depth) {
                            ++tMod.mohoBranch;
                        }
                        if (tMod.cmbDepth > depth) {
                            ++tMod.cmbBranch;
                        }
                        if (tMod.iocbDepth > depth) {
                            ++tMod.iocbBranch;
                        }
                        if (tMod.validate()) return tMod;
                        throw new TauModelException("splitBranch(" + depth + "): Validation failed!");
                    }
                    for (int i = 0; i < tMod.rayParams.length - 1; ++i) {
                        if (!(tMod.rayParams[i] < newRayParam) || !(tMod.rayParams[i + 1] > newRayParam)) continue;
                        index = i;
                        double[] oldRayParams = tMod.rayParams;
                        tMod.rayParams = new double[oldRayParams.length + 1];
                        System.arraycopy(oldRayParams, 0, tMod.rayParams, 0, index);
                        tMod.rayParams[index] = newRayParam;
                        System.arraycopy(oldRayParams, index, tMod.rayParams, index + 1, oldRayParams.length - index);
                        if (isPWave) {
                            indexP = index;
                            PWaveRayParam = newRayParam;
                            break;
                        }
                        indexS = index;
                        SWaveRayParam = newRayParam;
                        break;
                    }
                }
                --waveNum;
                isPWave = true;
            }
        }
        catch (NoSuchLayerException e) {
            throw new TauModelException("TauModel.depthCorrect - NoSuchLayerException", e);
        }
        catch (SlownessModelException e) {
            e.printStackTrace();
            throw new TauModelException("TauModel.depthCorrect - SlownessModelException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeModel(String filename) throws IOException {
        FileOutputStream fOut = new FileOutputStream(filename);
        ObjectOutputStream out = new ObjectOutputStream(fOut);
        try {
            out.writeObject(this);
        }
        finally {
            out.close();
            fOut.close();
        }
    }

    public void writeModelToStream(OutputStream outStream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        out.writeObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TauModel readModel(String filename) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauModel tMod;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        try {
            tMod = TauModel.readModelFromStream(in);
        }
        finally {
            in.close();
        }
        return tMod;
    }

    public static TauModel readModelFromStream(InputStream inStream) throws InvalidClassException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        ObjectInputStream in = new ObjectInputStream(inStream);
        TauModel tMod = (TauModel)in.readObject();
        return tMod;
    }

    public boolean validate() {
        int i;
        for (i = 0; i < this.rayParams.length - 1; ++i) {
            if (!(this.rayParams[i + 1] >= this.rayParams[i])) continue;
            System.err.println("RayParams are not monotonically decreasing. rayParams[" + i + "]=" + this.rayParams[i] + " rayParams[" + (i + 1) + "]=" + this.rayParams[i + 1]);
            return false;
        }
        if (this.tauBranches[0].length != this.tauBranches[1].length) {
            System.err.println("TauBranches for P and S are not equal. " + this.tauBranches[0].length + " " + this.tauBranches[1].length);
            return false;
        }
        if (this.tauBranches[0][0].getTopDepth() != 0.0 || this.tauBranches[1][0].getTopDepth() != 0.0) {
            System.err.println("branch 0 topDepth != 0");
            return false;
        }
        if (this.tauBranches[1][0].getMaxRayParam() != this.rayParams[0]) {
            System.err.println("branch 0 maxRayParam != rayParams[0]");
            return false;
        }
        for (i = 1; i < this.getNumBranches(); ++i) {
            if (this.tauBranches[0][i].getTopDepth() != this.tauBranches[1][i].getTopDepth()) {
                System.err.println("branch " + i + " P topDepth != S topDepth");
                return false;
            }
            if (this.tauBranches[0][i].getBotDepth() != this.tauBranches[1][i].getBotDepth()) {
                System.err.println("branch " + i + " P botDepth != S botDepth");
                return false;
            }
            if (this.tauBranches[0][i].getTopDepth() != this.tauBranches[0][i - 1].getBotDepth()) {
                System.err.println("branch " + i + " topDepth != botDepth of " + (i - 1));
                return false;
            }
            if (this.tauBranches[0][i].getMaxRayParam() != this.tauBranches[0][i - 1].getMinRayParam()) {
                System.err.println("branch " + i + " P maxRayParam != minRayParam of " + (i - 1) + "\nmaxRayParam=" + this.tauBranches[0][i].getMaxRayParam() + "\nminRayParam=" + this.tauBranches[0][i - 1].getMinRayParam());
                return false;
            }
            if (this.tauBranches[1][i].getMaxRayParam() == this.tauBranches[1][i - 1].getMinRayParam()) continue;
            System.err.println("branch " + i + " S maxRayParam != minRayParam of " + (i - 1) + "\nmaxRayParam=" + this.tauBranches[1][i].getMaxRayParam() + "\nminRayParam=" + this.tauBranches[1][i - 1].getMinRayParam() + "\ndepth = " + this.tauBranches[1][i].getTopDepth());
            return false;
        }
        if (this.tauBranches[0][this.getNumBranches() - 1].getMinRayParam() != 0.0) {
            System.err.println("branch tauBranches[0].length-1 minRayParam != 0");
            return false;
        }
        if (this.tauBranches[1][this.getNumBranches() - 1].getMinRayParam() != 0.0) {
            System.err.println("branch tauBranches[1].length-1 minRayParam != 0");
            return false;
        }
        return true;
    }

    public void print() {
        if (this.DEBUG) {
            System.out.println("Starting print() in TauModel");
        }
        System.out.println("Delta tau for each slowness sample and layer.");
        for (int j = 0; j < this.rayParams.length; ++j) {
            double deg = 0.0;
            double time = 0.0;
            for (int i = 0; i < this.getNumBranches(); ++i) {
                deg += this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI;
                time += this.tauBranches[0][i].time[j];
                System.out.println(" i " + i + " j " + j + " rayParam " + this.rayParams[j] + " tau " + this.tauBranches[0][i].tau[j] + " time " + this.tauBranches[0][i].time[j] + " dist " + this.tauBranches[0][i].getDist(j) + " degrees " + this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI);
            }
            System.out.println();
            System.out.println("deg= " + deg + "  time=" + time);
        }
    }

    public Object clone() {
        try {
            TauModel newObject = (TauModel)super.clone();
            newObject.rayParams = (double[])this.rayParams.clone();
            newObject.sMod = (SlownessModel)this.sMod.clone();
            newObject.tauBranches = new TauBranch[2][this.getNumBranches()];
            for (int i = 0; i < this.getNumBranches(); ++i) {
                newObject.tauBranches[0][i] = (TauBranch)this.tauBranches[0][i].clone();
                newObject.tauBranches[1][i] = (TauBranch)this.tauBranches[1][i].clone();
            }
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Caught CloneNotSupportedException: " + e.getMessage());
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        if (this.DEBUG) {
            System.out.println("Starting toString() in TauModel");
        }
        String desc = "Delta tau for each slowness sample and layer.\n";
        for (int j = 0; j < this.rayParams.length; ++j) {
            for (int i = 0; i < this.tauBranches[0].length; ++i) {
                desc = desc + " i " + i + " j " + j + " rayParam " + this.rayParams[j] + " tau " + this.tauBranches[0][i].tau[j] + " time " + this.tauBranches[0][i].time[j] + " dist " + this.tauBranches[0][i].getDist(j) + " degrees " + this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI + "\n";
            }
            desc = desc + "\n";
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        VelocityModel vMod = new VelocityModel();
        SphericalSModel sMod = new SphericalSModel();
        TauModel tMod = new TauModel();
        String modelFilename = args.length == 1 ? args[0] : "iasp91.tvel";
        boolean DEBUG = false;
        try {
            vMod.setFileType("tvel");
            vMod.readVelocityFile(modelFilename);
            System.out.println("Done reading.");
            sMod.createSample(vMod);
            tMod.calcTauIncFrom(sMod);
            StreamTokenizer tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            System.out.println("Enter branch rayNum");
            tokenIn.nextToken();
            while (tokenIn.ttype == -2) {
                int branch = (int)tokenIn.nval;
                tokenIn.nextToken();
                int rayNum = (int)tokenIn.nval;
                System.out.println("ray parameter=" + tMod.rayParams[rayNum] + " distance=" + tMod.tauBranches[0][branch].getDist(rayNum) + " time=" + tMod.tauBranches[0][branch].time[rayNum] + " tau=" + tMod.tauBranches[0][branch].tau[rayNum]);
                System.out.println("Enter branch rayNum");
                tokenIn.nextToken();
            }
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage());
        }
        catch (VelocityModelException e) {
            System.out.println("Tried to read!\n Caught VelocityModelException " + e.getMessage());
        }
        catch (SlownessModelException e) {
            System.out.println("Caught SlownessModelException " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            System.out.println("Done!\n");
        }
    }
}

