/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.XYPlot;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Vector;

public class SlownessPlot
extends XYPlot {
    public SlownessPlot(Container parent) {
        super(parent);
        this.title = "Slowness";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "depth (km)";
        this.yTickWidth = 500;
    }

    public SlownessPlot(Container parent, int width, int height) {
        super(parent, width, height);
        this.title = "Slowness";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "depth (km)";
        this.yTickWidth = 500;
    }

    public void plot(SlownessModel sModel, boolean isPWave) {
        this.xSegments = new Vector();
        this.ySegments = new Vector();
        this.xData = new double[2 * sModel.getNumLayers(isPWave)];
        this.yData = new double[2 * sModel.getNumLayers(isPWave)];
        if (!isPWave) {
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 2500.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = sModel.getRadiusOfEarth();
        } else {
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 1300.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = sModel.getRadiusOfEarth();
        }
        int j = 0;
        for (int i = 0; i < sModel.getNumLayers(isPWave); ++i) {
            SlownessLayer ss = sModel.getSlownessLayerClone(i, isPWave);
            this.yData[j] = sModel.getRadiusOfEarth() - ss.getTopDepth();
            this.xData[j] = ss.getTopP();
            if (this.DEBUG) {
                System.out.println("x " + this.xData[j] + " y " + this.yData[j]);
            }
            this.yData[++j] = sModel.getRadiusOfEarth() - ss.getBotDepth();
            this.xData[j] = ss.getBotP();
            if (this.DEBUG) {
                System.out.println("x " + this.xData[j] + " y " + this.yData[j]);
            }
            ++j;
        }
        this.xSegments.addElement(this.xData);
        this.ySegments.addElement(this.yData);
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }
}

