/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.io.Serializable;
import java.util.Vector;

public abstract class SlownessModel
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public transient boolean verbose = false;
    protected double radiusOfEarth = 6371.0;
    protected VelocityModel vMod;
    protected Vector criticalDepthVector = new Vector();
    protected Vector highSlownessLayerDepthsP = new Vector();
    protected Vector highSlownessLayerDepthsS = new Vector();
    protected Vector fluidLayerDepths = new Vector();
    protected static int vectorLength = 256;
    protected Vector PLayers = new Vector(vectorLength);
    protected Vector SLayers = new Vector(vectorLength);
    protected double minDeltaP = 0.1;
    protected double maxDeltaP = 11.0;
    protected double maxDepthInterval = 115.0;
    protected double maxRangeInterval = 200.0 / this.radiusOfEarth;
    protected double maxInterpError = 0.5;
    protected boolean allowInnerCoreS = true;
    protected double slownessTolerance = 1.0E-16;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public void setMinDeltaP(double minDeltaP) {
        this.minDeltaP = minDeltaP;
    }

    public void setMaxDeltaP(double maxDeltaP) {
        this.maxDeltaP = maxDeltaP;
    }

    public void setMaxDepthInterval(double maxDepthInterval) {
        this.maxDepthInterval = maxDepthInterval;
    }

    public void setMaxRangeInterval(double maxRangeInterval) {
        this.maxRangeInterval = maxRangeInterval * Math.PI / 180.0;
    }

    public void setMaxInterpError(double maxInterpError) {
        this.maxInterpError = maxInterpError;
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.allowInnerCoreS = allowInnerCoreS;
    }

    public void setSlownessTolerance(double slownessTolerance) {
        this.slownessTolerance = slownessTolerance;
    }

    public final double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public final double getMinDeltaP() {
        return this.minDeltaP;
    }

    public final double getMaxDeltaP() {
        return this.maxDeltaP;
    }

    public final double getMaxDepthInterval() {
        return this.maxDepthInterval;
    }

    public final double getMaxRangeInterval() {
        return 180.0 * this.maxRangeInterval / Math.PI;
    }

    public final double getMaxInterpError() {
        return this.maxInterpError;
    }

    public final boolean isAllowInnerCoreS() {
        return this.allowInnerCoreS;
    }

    public final double getSlownessTolerance() {
        return this.slownessTolerance;
    }

    public final int getNumCriticalDepths() {
        return this.criticalDepthVector.size();
    }

    public final CriticalDepth getCriticalDepth(int i) {
        return (CriticalDepth)this.criticalDepthVector.elementAt(i);
    }

    public final int getNumLayers(boolean isPWave) {
        if (isPWave) {
            return this.PLayers.size();
        }
        return this.SLayers.size();
    }

    public double getMinTurnRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        double minPSoFar = Double.MAX_VALUE;
        Vector layers = isPWave ? this.PLayers : this.SLayers;
        if (this.depthInHighSlowness(depth, Double.MAX_VALUE, isPWave)) {
            for (int i = 0; i < layers.size(); ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                if (sLayer.getBotDepth() == depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
                    return minPSoFar;
                }
                if (sLayer.getBotDepth() > depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth()));
                    return minPSoFar;
                }
                minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
            }
        } else {
            SlownessLayer sLayer = this.getSlownessLayer(this.layerNumberAbove(depth, isPWave), isPWave);
            minPSoFar = depth == sLayer.getBotDepth() ? sLayer.getBotP() : sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth());
        }
        return minPSoFar;
    }

    public double getMinRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        double minPSoFar = this.getMinTurnRayParam(depth, isPWave);
        int i = this.layerNumberAbove(depth, isPWave);
        int j = this.layerNumberBelow(depth, isPWave);
        SlownessLayer sLayerAbove = this.getSlownessLayer(i, isPWave);
        SlownessLayer sLayerBelow = this.getSlownessLayer(j, isPWave);
        if (sLayerAbove.getBotDepth() == depth) {
            minPSoFar = Math.min(Math.min(minPSoFar, sLayerAbove.getBotP()), sLayerBelow.getTopP());
        }
        return minPSoFar;
    }

    public DepthRange[] getHighSlowness(boolean isPWave) {
        Vector highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        DepthRange[] hsz = new DepthRange[highSlownessLayerDepths.size()];
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            hsz[i] = (DepthRange)((DepthRange)highSlownessLayerDepths.elementAt(i)).clone();
        }
        return hsz;
    }

    public SlownessLayer getSlownessLayerClone(int layerNum, boolean isPWave) {
        if (isPWave) {
            return (SlownessLayer)((SlownessLayer)this.PLayers.elementAt(layerNum)).clone();
        }
        return (SlownessLayer)((SlownessLayer)this.SLayers.elementAt(layerNum)).clone();
    }

    protected SlownessLayer getSlownessLayer(int layerNum, boolean isPWave) {
        if (isPWave) {
            return (SlownessLayer)this.PLayers.elementAt(layerNum);
        }
        return (SlownessLayer)this.SLayers.elementAt(layerNum);
    }

    public abstract double toSlowness(double var1, double var3) throws SlownessModelException;

    public abstract double toVelocity(double var1, double var3) throws SlownessModelException;

    public abstract TimeDist layerTimeDist(double var1, int var3, boolean var4) throws SlownessModelException;

    public abstract SlownessLayer toSlownessLayer(VelocityLayer var1, boolean var2) throws SlownessModelException;

    public abstract double interpolate(double var1, double var3, double var5, double var7) throws SlownessModelException;

    public TimeDist approxDistance(int slownessTurnLayer, double p, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        if (slownessTurnLayer >= this.getNumLayers(isPWave)) {
            throw new SlownessModelException("Can't calculate a distance when slownessTurnLayer >= getNumLayers(" + isPWave + ")\n" + " slownessTurnLayer=" + slownessTurnLayer + " getNumLayers()=" + this.getNumLayers(isPWave));
        }
        if (p < 0.0) {
            throw new SlownessModelException("approxDistance: Ray parameter is negative!!!" + p + " slownessTurnLayer=" + slownessTurnLayer);
        }
        TimeDist td = new TimeDist(p);
        for (int layerNum = 0; layerNum <= slownessTurnLayer; ++layerNum) {
            td.add(this.layerTimeDist(p, layerNum, isPWave));
        }
        td.dist *= 2.0;
        td.time *= 2.0;
        return td;
    }

    public boolean depthInHighSlowness(double depth, double rayParam, boolean isPWave) {
        DepthRange highSZoneDepth = new DepthRange();
        return this.depthInHighSlowness(depth, rayParam, highSZoneDepth, isPWave);
    }

    public boolean depthInHighSlowness(double depth, double rayParam, DepthRange highSZoneDepth, boolean isPWave) {
        Vector highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            DepthRange tempRange = (DepthRange)highSlownessLayerDepths.elementAt(i);
            if (!(tempRange.topDepth <= depth) || !(depth <= tempRange.botDepth)) continue;
            highSZoneDepth.topDepth = tempRange.topDepth;
            highSZoneDepth.botDepth = tempRange.botDepth;
            highSZoneDepth.rayParam = tempRange.rayParam;
            if (!(rayParam > tempRange.rayParam) && (rayParam != tempRange.rayParam || depth != tempRange.topDepth)) continue;
            return true;
        }
        return false;
    }

    public boolean depthInFluid(double depth) {
        DepthRange fluidZoneDepth = new DepthRange();
        return this.depthInFluid(depth, fluidZoneDepth);
    }

    public boolean depthInFluid(double depth, DepthRange fluidZoneDepth) {
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange tempRange = (DepthRange)this.fluidLayerDepths.elementAt(i);
            if (!(tempRange.topDepth <= depth) || !(depth < tempRange.botDepth)) continue;
            fluidZoneDepth.topDepth = tempRange.topDepth;
            fluidZoneDepth.botDepth = tempRange.botDepth;
            return true;
        }
        return false;
    }

    public SplitLayerInfo splitLayer(double depth, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        Vector otherLayers;
        Vector layers;
        if (isPWave) {
            layers = this.PLayers;
            otherLayers = this.SLayers;
        } else {
            layers = this.SLayers;
            otherLayers = this.PLayers;
        }
        boolean otherWaveType = !isPWave;
        boolean changeMade = false;
        int layerNum = this.layerNumberAbove(depth, isPWave);
        SlownessLayer sLayer = this.getSlownessLayer(layerNum, isPWave);
        if (sLayer.getTopDepth() == depth || sLayer.getBotDepth() == depth) {
            return new SplitLayerInfo(false, false, 0.0);
        }
        if (Math.abs(sLayer.getTopDepth() - depth) < 1.0E-6) {
            sLayer.setTopDepth(depth);
            sLayer = this.getSlownessLayer(layerNum - 1, isPWave);
            sLayer.setBotDepth(depth);
            return new SplitLayerInfo(false, true, sLayer.getBotP());
        }
        if (Math.abs(depth - sLayer.getBotDepth()) < 1.0E-6) {
            sLayer.setBotDepth(depth);
            sLayer = this.getSlownessLayer(layerNum + 1, isPWave);
            sLayer.setTopDepth(depth);
            return new SplitLayerInfo(false, true, sLayer.getTopP());
        }
        double p = sLayer.evaluateAt_bullen(depth, this.radiusOfEarth);
        int index = -1;
        int otherIndex = -1;
        SlownessLayer topLayer = (SlownessLayer)sLayer.clone();
        topLayer.setBotP(p);
        topLayer.setBotDepth(depth);
        SlownessLayer botLayer = (SlownessLayer)sLayer.clone();
        botLayer.setTopP(p);
        botLayer.setTopDepth(topLayer.getBotDepth());
        layers.removeElementAt(layerNum);
        layers.insertElementAt(botLayer, layerNum);
        layers.insertElementAt(topLayer, layerNum);
        for (int i = 0; i < this.getNumCriticalDepths(); ++i) {
            CriticalDepth cd = this.getCriticalDepth(i);
            if (cd.getLayerNum(isPWave) <= layerNum) continue;
            cd.setLayerNum(cd.getLayerNum(isPWave) + 1, isPWave);
        }
        otherIndex = otherLayers.indexOf(sLayer);
        if (otherIndex != -1) {
            otherLayers.removeElementAt(otherIndex);
            otherLayers.insertElementAt(botLayer, otherIndex);
            otherLayers.insertElementAt(topLayer, otherIndex);
        }
        for (int otherLayerNum = 0; otherLayerNum < otherLayers.size(); ++otherLayerNum) {
            sLayer = (SlownessLayer)otherLayers.elementAt(otherLayerNum);
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            topLayer = (SlownessLayer)sLayer.clone();
            topLayer.setBotP(p);
            topLayer.setBotDepth(sLayer.bullenDepthFor(p, this.radiusOfEarth));
            botLayer = (SlownessLayer)sLayer.clone();
            botLayer.setTopP(p);
            botLayer.setTopDepth(topLayer.getBotDepth());
            otherLayers.removeElementAt(otherLayerNum);
            otherLayers.insertElementAt(botLayer, otherLayerNum);
            otherLayers.insertElementAt(topLayer, otherLayerNum);
            for (int critNum = 0; critNum < this.getNumCriticalDepths(); ++critNum) {
                CriticalDepth cd = this.getCriticalDepth(critNum);
                if (cd.getLayerNum(otherWaveType) <= otherLayerNum) continue;
                cd.setLayerNum(cd.getLayerNum(otherWaveType) + 1, otherWaveType);
            }
        }
        return new SplitLayerInfo(true, false, p);
    }

    protected void findCriticalPoints() throws SlownessModelException {
        int layerNum;
        double botDepth = this.getRadiusOfEarth();
        double minPSoFar = Double.MAX_VALUE;
        double minSSoFar = Double.MAX_VALUE;
        DepthRange highSlownessZoneP = new DepthRange();
        DepthRange highSlownessZoneS = new DepthRange();
        boolean inHighSlownessZoneP = false;
        boolean inHighSlownessZoneS = false;
        DepthRange fluidZone = new DepthRange();
        boolean inFluidZone = false;
        boolean belowOuterCore = false;
        this.highSlownessLayerDepthsP.removeAllElements();
        this.highSlownessLayerDepthsS.removeAllElements();
        this.criticalDepthVector.removeAllElements();
        this.fluidLayerDepths.removeAllElements();
        VelocityLayer currVLayer = this.vMod.getVelocityLayer(0);
        currVLayer = new VelocityLayer(0, currVLayer.getTopDepth(), currVLayer.getTopDepth(), currVLayer.getTopPVelocity(), currVLayer.getTopPVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopDensity(), currVLayer.getTopDensity(), currVLayer.getTopQp(), currVLayer.getTopQp(), currVLayer.getTopQs(), currVLayer.getTopQs());
        SlownessLayer currSLayer = this.toSlownessLayer(currVLayer, false);
        SlownessLayer currPLayer = this.toSlownessLayer(currVLayer, true);
        this.criticalDepthVector.addElement(new CriticalDepth(0.0, 0, 0, 0));
        if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
            inFluidZone = true;
            fluidZone = new DepthRange();
            fluidZone.topDepth = currVLayer.getTopDepth();
            currSLayer = currPLayer;
        }
        if (minSSoFar > currSLayer.getTopP()) {
            minSSoFar = currSLayer.getTopP();
        }
        if (minPSoFar > currPLayer.getTopP()) {
            minPSoFar = currPLayer.getTopP();
        }
        for (layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
            VelocityLayer prevVLayer = currVLayer;
            SlownessLayer prevSLayer = currSLayer;
            SlownessLayer prevPLayer = currPLayer;
            currVLayer = this.vMod.getVelocityLayerClone(layerNum);
            currSLayer = this.toSlownessLayer(currVLayer, false);
            currPLayer = this.toSlownessLayer(currVLayer, true);
            if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
                inFluidZone = true;
                fluidZone = new DepthRange();
                fluidZone.topDepth = currVLayer.getTopDepth();
            }
            if (inFluidZone && currVLayer.getTopSVelocity() != 0.0) {
                if (prevVLayer.getBotDepth() > this.vMod.getIocbDepth()) {
                    belowOuterCore = true;
                }
                inFluidZone = false;
                fluidZone.botDepth = prevVLayer.getBotDepth();
                this.fluidLayerDepths.addElement(fluidZone);
            }
            if (inFluidZone || belowOuterCore && !this.allowInnerCoreS) {
                currSLayer = currPLayer;
            }
            if (prevSLayer.getBotP() != currSLayer.getTopP() || prevPLayer.getBotP() != currPLayer.getTopP()) {
                this.criticalDepthVector.addElement(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                if (this.DEBUG) {
                    System.out.println("first order discontinuity, depth=" + currSLayer.getTopDepth());
                    System.out.println(prevSLayer + "\n" + currSLayer);
                    System.out.println(prevPLayer + "\n" + currPLayer);
                }
                if (inHighSlownessZoneS && currSLayer.getTopP() < minSSoFar) {
                    if (this.DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneS.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsS.addElement(highSlownessZoneS);
                    inHighSlownessZoneS = false;
                }
                if (inHighSlownessZoneP && currPLayer.getTopP() < minPSoFar) {
                    if (this.DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneP.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsP.addElement(highSlownessZoneP);
                    inHighSlownessZoneP = false;
                }
                if (minPSoFar > currPLayer.getTopP()) {
                    minPSoFar = currPLayer.getTopP();
                }
                if (minSSoFar > currSLayer.getTopP()) {
                    minSSoFar = currSLayer.getTopP();
                }
                if (!inHighSlownessZoneS && (prevSLayer.getBotP() < currSLayer.getTopP() || currSLayer.getTopP() < currSLayer.getBotP())) {
                    if (this.DEBUG) {
                        System.out.println("Found S high slowness at first order discontinuity, layer = " + layerNum);
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = minSSoFar;
                }
                if (!inHighSlownessZoneP && (prevPLayer.getBotP() < currPLayer.getTopP() || currPLayer.getTopP() < currPLayer.getBotP())) {
                    if (this.DEBUG) {
                        System.out.println("Found P high slowness at first order discontinuity, layer = " + layerNum);
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneP.rayParam = minPSoFar;
                }
            } else if ((prevSLayer.getTopP() - prevSLayer.getBotP()) * (prevSLayer.getBotP() - currSLayer.getBotP()) < 0.0 || (prevPLayer.getTopP() - prevPLayer.getBotP()) * (prevPLayer.getBotP() - currPLayer.getBotP()) < 0.0) {
                this.criticalDepthVector.addElement(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                if (this.DEBUG) {
                    System.out.println("local slowness extrema, depth=" + currSLayer.getTopDepth());
                }
                if (!inHighSlownessZoneP && currPLayer.getTopP() < currPLayer.getBotP()) {
                    if (this.DEBUG) {
                        System.out.println("start of a P high slowness zone, local slowness extrema, minPSoFar=" + minPSoFar);
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneP.rayParam = minPSoFar;
                }
                if (!inHighSlownessZoneS && currSLayer.getTopP() < currSLayer.getBotP()) {
                    if (this.DEBUG) {
                        System.out.println("start of a S high slowness zone, local slowness extrema, minSSoFar=" + minSSoFar);
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = minSSoFar;
                }
            }
            if (inHighSlownessZoneP && currPLayer.getBotP() < minPSoFar) {
                if (this.DEBUG) {
                    System.out.println("layer contains the bottom of a P high slowness zone. minPSoFar=" + minPSoFar + " " + currPLayer);
                }
                highSlownessZoneP.botDepth = this.findDepth(minPSoFar, layerNum, layerNum, true);
                this.highSlownessLayerDepthsP.addElement(highSlownessZoneP);
                inHighSlownessZoneP = false;
            }
            if (inHighSlownessZoneS && currSLayer.getBotP() < minSSoFar) {
                if (this.DEBUG) {
                    System.out.println("layer contains the bottom of a S high slowness zone. minSSoFar=" + minSSoFar + " " + currSLayer);
                }
                highSlownessZoneS.botDepth = this.findDepth(minSSoFar, layerNum, layerNum, false);
                this.highSlownessLayerDepthsS.addElement(highSlownessZoneS);
                inHighSlownessZoneS = false;
            }
            if (minPSoFar > currPLayer.getBotP()) {
                minPSoFar = currPLayer.getBotP();
            }
            if (minPSoFar > currPLayer.getTopP()) {
                minPSoFar = currPLayer.getTopP();
            }
            if (minSSoFar > currSLayer.getBotP()) {
                minSSoFar = currSLayer.getBotP();
            }
            if (minSSoFar > currSLayer.getTopP()) {
                minSSoFar = currSLayer.getTopP();
            }
            if (this.DEBUG && inHighSlownessZoneS) {
                System.out.println("In S high slowness zone, layerNum = " + layerNum + " minSSoFar=" + minSSoFar);
            }
            if (!this.DEBUG || !inHighSlownessZoneP) continue;
            System.out.println("In P high slowness zone, layerNum = " + layerNum + " minPSoFar=" + minPSoFar);
        }
        this.criticalDepthVector.addElement(new CriticalDepth(this.getRadiusOfEarth(), this.vMod.getNumLayers(), -1, -1));
        if (inHighSlownessZoneS) {
            highSlownessZoneS.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsS.addElement(highSlownessZoneS);
        }
        if (inHighSlownessZoneP) {
            highSlownessZoneP.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsP.addElement(highSlownessZoneP);
        }
        if (inFluidZone) {
            fluidZone.botDepth = currVLayer.getBotDepth();
            this.fluidLayerDepths.addElement(fluidZone);
        }
        if (this.DEBUG && this.criticalDepthVector.size() != 0) {
            String desc = "**** Critical Velocity Layers ************************\n";
            int botCriticalLayerNum = ((CriticalDepth)this.criticalDepthVector.elementAt((int)0)).velLayerNum - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepthVector.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = ((CriticalDepth)this.criticalDepthVector.elementAt((int)criticalNum)).velLayerNum - 1;
                desc = desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
            System.out.println(desc);
        }
        if (this.DEBUG && this.highSlownessLayerDepthsP.size() != 0) {
            for (layerNum = 0; layerNum < this.highSlownessLayerDepthsP.size(); ++layerNum) {
                System.out.println((DepthRange)this.highSlownessLayerDepthsP.elementAt(layerNum));
            }
        }
        if (this.DEBUG && this.highSlownessLayerDepthsS.size() != 0) {
            for (layerNum = 0; layerNum < this.highSlownessLayerDepthsS.size(); ++layerNum) {
                System.out.println((DepthRange)this.highSlownessLayerDepthsS.elementAt(layerNum));
            }
        }
        if (!this.validate()) {
            throw new SlownessModelException("Validation Failed!");
        }
    }

    public double findDepth(double rayParam, boolean isPWave) throws SlownessModelException {
        return this.findDepth(rayParam, 0, this.vMod.getNumLayers() - 1, isPWave);
    }

    public double findDepth(double rayParam, double topDepth, double botDepth, boolean isPWave) throws SlownessModelException {
        try {
            int topLayerNum = this.vMod.layerNumberBelow(topDepth);
            if (this.vMod.getVelocityLayer(topLayerNum).getBotDepth() == topDepth) {
                ++topLayerNum;
            }
            int botLayerNum = this.vMod.layerNumberAbove(botDepth);
            return this.findDepth(rayParam, topLayerNum, botLayerNum, isPWave);
        }
        catch (NoSuchLayerException e) {
            throw new SlownessModelException(e.getMessage());
        }
    }

    public double findDepth(double p, int topCriticalLayer, int botCriticalLayer, boolean isPWave) throws SlownessModelException {
        VelocityLayer velLayer = new VelocityLayer();
        double topP = Double.MAX_VALUE;
        double botP = Double.MAX_VALUE;
        char waveType = isPWave ? (char)'P' : 'S';
        try {
            if (topCriticalLayer > botCriticalLayer) {
                throw new SlownessModelException("findDepth: no layers to search!: topCriticalLayer = " + topCriticalLayer + "botCriticalLayer = " + botCriticalLayer);
            }
            for (int layerNum = topCriticalLayer; layerNum <= botCriticalLayer; ++layerNum) {
                velLayer = this.vMod.getVelocityLayer(layerNum);
                double topVelocity = velLayer.evaluateAtTop(waveType);
                double botVelocity = velLayer.evaluateAtBottom(waveType);
                topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
                botP = this.toSlowness(botVelocity, velLayer.getBotDepth());
                if (Math.abs(topP - p) < this.slownessTolerance) {
                    return velLayer.getTopDepth();
                }
                if (Math.abs(p - botP) < this.slownessTolerance) {
                    return velLayer.getBotDepth();
                }
                if ((topP - p) * (p - botP) >= 0.0) {
                    double slope = (botVelocity - topVelocity) / (velLayer.getBotDepth() - velLayer.getTopDepth());
                    double depth = this.interpolate(p, topVelocity, velLayer.getTopDepth(), slope);
                    return depth;
                }
                if (layerNum == topCriticalLayer && Math.abs(p - topP) < this.slownessTolerance) {
                    return velLayer.getTopDepth();
                }
                if (layerNum >= this.vMod.getNumLayers() - 1) continue;
                velLayer = this.vMod.getVelocityLayerClone(layerNum + 1);
                topVelocity = velLayer.evaluateAtTop(waveType);
                if (!isPWave && this.depthInFluid(velLayer.getTopDepth())) {
                    topVelocity = velLayer.evaluateAtTop('P');
                }
                topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
                if (!(botP >= p) || !(p >= topP)) continue;
                return velLayer.getTopDepth();
            }
            if (Math.abs(p - botP) < this.slownessTolerance) {
                System.out.println(" p is just outside the bottommost layer. This probably shouldn't be allowed to happen!\n");
                return velLayer.getBotDepth();
            }
        }
        catch (NoSuchMatPropException e) {
            e.printStackTrace();
        }
        throw new SlownessModelException("slowness p=" + p + " is not contained within the specified layers." + "\np=" + p + " topCriticalLayer=" + topCriticalLayer + " botCriticalLayer=" + botCriticalLayer + " isPWave=" + isPWave + " topP=" + topP + " botP=" + botP);
    }

    public void createSample(VelocityModel velModel) throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        double maxVelSoFar = 0.0;
        DepthRange highSZoneDepth = new DepthRange();
        if (!velModel.validate()) {
            throw new SlownessModelException("Error in velocity model!");
        }
        if (velModel.getNumLayers() == 0) {
            throw new SlownessModelException("velModel.getNumLayers()==0");
        }
        if (this.DEBUG) {
            System.out.println("start createSample");
        }
        this.vMod = velModel;
        this.setRadiusOfEarth(velModel.getRadiusOfEarth());
        if (this.DEBUG) {
            System.out.println("findCriticalPoints");
        }
        this.findCriticalPoints();
        if (this.DEBUG) {
            System.out.println("coarseSample");
        }
        this.coarseSample();
        boolean isOK = false;
        if (this.DEBUG) {
            isOK = this.validate();
            System.out.println("rayParamCheck");
        }
        this.rayParamIncCheck();
        if (this.DEBUG) {
            isOK &= this.validate();
            System.out.println("depthIncCheck");
        }
        this.depthIncCheck();
        if (this.DEBUG) {
            isOK &= this.validate();
            System.out.println("distanceCheck");
        }
        this.distanceCheck();
        if (this.DEBUG) {
            isOK &= this.validate();
            System.out.println("fixCriticalPoints");
        }
        this.fixCriticalPoints();
        if (this.DEBUG) {
            System.out.println("done createSample");
        }
    }

    protected void coarseSample() throws SlownessModelException, NoSuchLayerException {
        VelocityLayer currVLayer = new VelocityLayer();
        this.PLayers.removeAllElements();
        this.SLayers.removeAllElements();
        VelocityLayer origVLayer = this.vMod.getVelocityLayer(0);
        origVLayer = new VelocityLayer(0, origVLayer.getTopDepth(), origVLayer.getTopDepth(), origVLayer.getTopPVelocity(), origVLayer.getTopPVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopDensity(), origVLayer.getTopDensity(), origVLayer.getTopQp(), origVLayer.getTopQp(), origVLayer.getTopQs(), origVLayer.getTopQs());
        try {
            int j;
            SlownessLayer highSLayer;
            int SLayerNum;
            DepthRange highZone;
            int highZoneNum;
            for (int layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
                SlownessLayer currSLayer;
                SlownessLayer currPLayer;
                VelocityLayer prevVLayer = origVLayer;
                origVLayer = this.vMod.getVelocityLayer(layerNum);
                if (prevVLayer.getBotPVelocity() != origVLayer.getTopPVelocity() || prevVLayer.getBotSVelocity() != origVLayer.getTopSVelocity() && (this.allowInnerCoreS || origVLayer.getTopDepth() < this.vMod.getIocbDepth())) {
                    currVLayer.setTopDepth(prevVLayer.getBotDepth());
                    currVLayer.setBotDepth(prevVLayer.getBotDepth());
                    currVLayer.setTopPVelocity(prevVLayer.evaluateAtBottom('P'));
                    currVLayer.setBotPVelocity(origVLayer.evaluateAtTop('P'));
                    if (prevVLayer.getBotSVelocity() == 0.0) {
                        currVLayer.setTopSVelocity(prevVLayer.evaluateAtBottom('P'));
                    } else {
                        currVLayer.setTopSVelocity(prevVLayer.evaluateAtBottom('S'));
                    }
                    if (origVLayer.getTopSVelocity() == 0.0) {
                        currVLayer.setBotSVelocity(origVLayer.evaluateAtTop('P'));
                    } else {
                        currVLayer.setBotSVelocity(origVLayer.evaluateAtTop('S'));
                    }
                    currPLayer = this.toSlownessLayer(currVLayer, true);
                    this.PLayers.addElement(currPLayer);
                    currSLayer = prevVLayer.getBotSVelocity() == 0.0 && origVLayer.getTopSVelocity() == 0.0 || !this.allowInnerCoreS && currVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(currVLayer, false);
                    this.SLayers.addElement(currSLayer);
                }
                currPLayer = this.toSlownessLayer(origVLayer, true);
                this.PLayers.addElement(currPLayer);
                currSLayer = this.depthInFluid(origVLayer.getTopDepth()) || !this.allowInnerCoreS && origVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(origVLayer, false);
                this.SLayers.addElement(currSLayer);
            }
            for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsS.size(); ++highZoneNum) {
                highZone = (DepthRange)this.highSlownessLayerDepthsS.elementAt(highZoneNum);
                SLayerNum = this.layerNumberAbove(highZone.botDepth, false);
                highSLayer = this.getSlownessLayer(SLayerNum, false);
                while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                    highSLayer = this.getSlownessLayer(++SLayerNum, false);
                }
                if (highZone.rayParam == highSLayer.getBotP()) continue;
                this.addSlowness(highZone.rayParam, false);
            }
            for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsP.size(); ++highZoneNum) {
                highZone = (DepthRange)this.highSlownessLayerDepthsP.elementAt(highZoneNum);
                SLayerNum = this.layerNumberAbove(highZone.botDepth, true);
                highSLayer = this.getSlownessLayer(SLayerNum, true);
                while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                    highSLayer = this.getSlownessLayer(++SLayerNum, true);
                }
                if (highZone.rayParam == highSLayer.getBotP()) continue;
                this.addSlowness(highZone.rayParam, true);
            }
            double botP = -1.0;
            double topP = -1.0;
            for (j = 0; j < this.PLayers.size(); ++j) {
                topP = ((SlownessLayer)this.PLayers.elementAt(j)).getTopP();
                if (topP != botP) {
                    this.addSlowness(topP, false);
                }
                botP = ((SlownessLayer)this.PLayers.elementAt(j)).getBotP();
                this.addSlowness(botP, false);
            }
            botP = -1.0;
            for (j = 0; j < this.SLayers.size(); ++j) {
                topP = ((SlownessLayer)this.SLayers.elementAt(j)).getTopP();
                if (topP != botP) {
                    this.addSlowness(topP, true);
                }
                botP = ((SlownessLayer)this.SLayers.elementAt(j)).getBotP();
                this.addSlowness(botP, true);
            }
        }
        catch (NoSuchMatPropException e) {
            e.printStackTrace();
        }
    }

    protected void rayParamIncCheck() throws SlownessModelException, NoSuchLayerException {
        int rayNum;
        double deltaP;
        double numNewP;
        SlownessLayer sLayer;
        int j;
        for (j = 0; j < this.SLayers.size(); ++j) {
            sLayer = (SlownessLayer)this.SLayers.elementAt(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
        for (j = 0; j < this.PLayers.size(); ++j) {
            sLayer = (SlownessLayer)this.PLayers.elementAt(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
    }

    protected void depthIncCheck() throws SlownessModelException, NoSuchLayerException {
        try {
            double p;
            int depthNum;
            double deltaDepth;
            int numNewDepths;
            SlownessLayer sLayer;
            int j;
            for (j = 0; j < this.SLayers.size(); ++j) {
                sLayer = (SlownessLayer)this.SLayers.elementAt(j);
                if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
                numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
                deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
                for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                    double velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'S');
                    if (velocity == 0.0 || !this.allowInnerCoreS && sLayer.getTopDepth() + (double)depthNum * deltaDepth >= this.vMod.getIocbDepth()) {
                        velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'P');
                    }
                    p = this.toSlowness(velocity, sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                    this.addSlowness(p, true);
                    this.addSlowness(p, false);
                }
            }
            for (j = 0; j < this.PLayers.size(); ++j) {
                sLayer = (SlownessLayer)this.PLayers.elementAt(j);
                if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
                numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
                deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
                for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                    p = this.toSlowness(this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'P'), sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                    this.addSlowness(p, true);
                    this.addSlowness(p, false);
                }
            }
        }
        catch (NoSuchMatPropException e) {
            e.printStackTrace();
        }
    }

    protected void distanceCheck() throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        for (int waveN = 0; waveN < 2; ++waveN) {
            boolean currWaveType = waveN != 0;
            boolean otherWaveType = !currWaveType;
            TimeDist prevPrevTD = null;
            TimeDist prevTD = null;
            TimeDist currTD = null;
            boolean isCurrOK = false;
            boolean isPrevOK = false;
            int j = 0;
            SlownessLayer sLayer = this.getSlownessLayer(0, currWaveType);
            while (j < this.getNumLayers(currWaveType)) {
                SlownessLayer prevSLayer = sLayer;
                sLayer = this.getSlownessLayer(j, currWaveType);
                if (!this.depthInHighSlowness(sLayer.getBotDepth(), sLayer.getBotP(), currWaveType) && !this.depthInHighSlowness(sLayer.getTopDepth(), sLayer.getTopP(), currWaveType)) {
                    if (isCurrOK) {
                        prevPrevTD = isPrevOK ? prevTD : null;
                        prevTD = currTD;
                        isPrevOK = true;
                    } else {
                        prevTD = this.approxDistance(j - 1, sLayer.getTopP(), currWaveType);
                        isPrevOK = true;
                    }
                    currTD = this.approxDistance(j, sLayer.getBotP(), currWaveType);
                    isCurrOK = true;
                    if (Math.abs(prevTD.dist - currTD.dist) > this.maxRangeInterval && Math.abs(sLayer.getTopP() - sLayer.getBotP()) > 2.0 * this.minDeltaP) {
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevTD;
                        prevTD = prevPrevTD;
                        continue;
                    }
                    if (prevPrevTD != null && Math.abs(prevTD.time - ((currTD.time - prevPrevTD.time) * (prevTD.dist - prevPrevTD.dist) / (currTD.dist - prevPrevTD.dist) + prevPrevTD.time)) > this.maxInterpError) {
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, true);
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, false);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevPrevTD;
                        isPrevOK = false;
                        sLayer = this.getSlownessLayer(--j - 1 >= 0 ? j - 1 : 0, currWaveType);
                        continue;
                    }
                    if (!this.DEBUG || ++j % 100 != 0) continue;
                    System.out.print(" " + j);
                    continue;
                }
                prevPrevTD = null;
                prevTD = null;
                currTD = null;
                isCurrOK = false;
                isPrevOK = false;
                if (!this.DEBUG || ++j % 100 != 0) continue;
                System.out.print(" " + j);
            }
            if (!this.DEBUG) continue;
            System.out.println("\nNumber of " + (currWaveType ? (char)'P' : 'S') + " slowness layers: " + j);
        }
    }

    protected void addSlowness(double p, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        Vector otherLayers;
        Vector layers;
        boolean madeAChange = false;
        if (isPWave) {
            layers = this.PLayers;
            otherLayers = this.SLayers;
        } else {
            layers = this.SLayers;
            otherLayers = this.PLayers;
        }
        for (int i = 0; i < layers.size(); ++i) {
            double botVelocity;
            double topVelocity;
            SlownessLayer sLayer = (SlownessLayer)layers.elementAt(i);
            try {
                if (sLayer.getTopDepth() != sLayer.getBotDepth()) {
                    topVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? (char)'P' : 'S');
                    botVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? (char)'P' : 'S');
                } else {
                    topVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? (char)'P' : 'S');
                    botVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? (char)'P' : 'S');
                }
            }
            catch (NoSuchMatPropException e) {
                throw new SlownessModelException("Caught NoSuchMatPropException: " + e.getMessage());
            }
            if (!isPWave) {
                if (!this.allowInnerCoreS && sLayer.getBotDepth() > this.vMod.getIocbDepth()) break;
                if (topVelocity == 0.0) continue;
            }
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            madeAChange = true;
            SlownessLayer topLayer = (SlownessLayer)sLayer.clone();
            topLayer.setBotP(p);
            if (sLayer.getBotDepth() != sLayer.getTopDepth()) {
                double slope = (botVelocity - topVelocity) / (sLayer.getBotDepth() - sLayer.getTopDepth());
                topLayer.setBotDepth(this.interpolate(p, topVelocity, sLayer.getTopDepth(), slope));
            }
            SlownessLayer botLayer = (SlownessLayer)sLayer.clone();
            botLayer.setTopP(p);
            botLayer.setTopDepth(topLayer.getBotDepth());
            layers.removeElementAt(i);
            layers.insertElementAt(botLayer, i);
            layers.insertElementAt(topLayer, i);
            int otherIndex = otherLayers.indexOf(sLayer);
            if (otherIndex == -1) continue;
            otherLayers.removeElementAt(otherIndex);
            otherLayers.insertElementAt(botLayer, otherIndex);
            otherLayers.insertElementAt(topLayer, otherIndex);
        }
    }

    protected void fixCriticalPoints() throws NoSuchLayerException {
        for (int i = 0; i < this.criticalDepthVector.size(); ++i) {
            CriticalDepth cd = (CriticalDepth)this.criticalDepthVector.elementAt(i);
            cd.PLayerNum = this.layerNumberBelow(cd.depth, true);
            SlownessLayer sLayer = this.getSlownessLayer(cd.PLayerNum, true);
            if (cd.PLayerNum == this.PLayers.size() - 1 && sLayer.getBotDepth() == cd.depth) {
                ++cd.PLayerNum;
            }
            cd.SLayerNum = this.layerNumberBelow(cd.depth, false);
            sLayer = this.getSlownessLayer(cd.SLayerNum, false);
            if (cd.SLayerNum != this.SLayers.size() - 1 || sLayer.getBotDepth() != cd.depth) continue;
            ++cd.SLayerNum;
        }
    }

    public int layerNumberAbove(double depth, boolean isPWave) throws NoSuchLayerException {
        Vector layers = isPWave ? this.PLayers : this.SLayers;
        SlownessLayer tempLayer = (SlownessLayer)layers.elementAt(0);
        if (tempLayer.getTopDepth() == depth) {
            return 0;
        }
        if (depth < tempLayer.getTopDepth() || ((SlownessLayer)layers.elementAt(layers.size() - 1)).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        int tooSmallNum = 0;
        int tooLargeNum = layers.size() - 1;
        int currentNum = 0;
        boolean found = false;
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getSlownessLayer(currentNum, isPWave);
            if (tempLayer.getTopDepth() >= depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public int layerNumberBelow(double depth, boolean isPWave) throws NoSuchLayerException {
        Vector layers = isPWave ? this.PLayers : this.SLayers;
        SlownessLayer tempLayer = (SlownessLayer)layers.elementAt(0);
        if (tempLayer.getTopDepth() == depth) {
            return 0;
        }
        tempLayer = (SlownessLayer)layers.elementAt(layers.size() - 1);
        if (tempLayer.getBotDepth() == depth) {
            return layers.size() - 1;
        }
        if (depth < ((SlownessLayer)layers.elementAt(0)).getTopDepth() || ((SlownessLayer)layers.elementAt(layers.size() - 1)).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        int tooSmallNum = 0;
        int tooLargeNum = layers.size() - 1;
        int currentNum = 0;
        boolean found = false;
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getSlownessLayer(currentNum, isPWave);
            if (tempLayer.getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() <= depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public boolean validate() throws SlownessModelException {
        double prevDepth;
        boolean isOK = true;
        if (this.radiusOfEarth <= 0.0) {
            throw new SlownessModelException("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
        }
        if (this.maxDepthInterval <= 0.0) {
            throw new SlownessModelException("maxDepthInterval is not positive. maxDepthInterval = " + this.maxDepthInterval);
        }
        Vector highSlownessLayerDepths = this.highSlownessLayerDepthsP;
        boolean isPWave = true;
        for (int j = 0; j < 2; ++j) {
            highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
            prevDepth = -1.7976931348623157E308;
            for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
                DepthRange highSZoneDepth = (DepthRange)highSlownessLayerDepths.elementAt(i);
                if (highSZoneDepth.topDepth >= highSZoneDepth.botDepth) {
                    throw new SlownessModelException("High slowness zone has zero or negative thickness. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                if (highSZoneDepth.topDepth <= prevDepth) {
                    throw new SlownessModelException("High slowness zone overlaps previous zone. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                prevDepth = highSZoneDepth.botDepth;
            }
            isPWave = false;
        }
        prevDepth = -1.7976931348623157E308;
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange fluidZone = (DepthRange)this.fluidLayerDepths.elementAt(i);
            if (fluidZone.topDepth >= fluidZone.botDepth) {
                throw new SlownessModelException("Fluid zone has zero or negative thickness. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            if (fluidZone.topDepth <= prevDepth) {
                throw new SlownessModelException("Fluid zone overlaps previous zone. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            prevDepth = fluidZone.botDepth;
        }
        isPWave = true;
        for (int j = 0; j < 2; ++j) {
            prevDepth = 0.0;
            double prevBotP = this.getNumLayers(isPWave) > 0 ? this.getSlownessLayer(0, isPWave).getTopP() : -1.0;
            for (int i = 0; i < this.getNumLayers(isPWave); ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                isOK &= sLayer.validate();
                if (sLayer.getTopDepth() > prevDepth) {
                    throw new SlownessModelException("Gap of " + (sLayer.getTopDepth() - prevDepth) + " between slowness layers. Num " + i + " isPWave=" + isPWave + " top depth " + sLayer.getTopDepth() + " bottom depth " + sLayer.getBotDepth());
                }
                if (sLayer.getTopDepth() < prevDepth) {
                    throw new SlownessModelException("Slowness layer overlaps previous layer by " + (prevDepth - sLayer.getTopDepth()) + ". Num " + i + " isPWave=" + isPWave + " top depth " + sLayer.getTopDepth() + " bottom depth " + sLayer.getBotDepth());
                }
                if (sLayer.getTopP() != prevBotP) {
                    throw new SlownessModelException("Slowness layer gap/overlaps previous layer in slowness . Num " + i + " isPWave=" + isPWave + " prevBotP= " + prevBotP + " sLayer= " + sLayer);
                }
                if (Double.isNaN(sLayer.getTopDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + (isPWave ? (char)'P' : 'S'));
                }
                if (Double.isNaN(sLayer.getBotDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + (isPWave ? (char)'P' : 'S'));
                }
                prevBotP = sLayer.getBotP();
                prevDepth = sLayer.getBotDepth();
            }
            isPWave = false;
        }
        return isOK;
    }

    public Object clone() {
        try {
            int i;
            SlownessModel newObject = (SlownessModel)super.clone();
            newObject.criticalDepthVector = new Vector(this.criticalDepthVector.size());
            for (i = 0; i < this.criticalDepthVector.size(); ++i) {
                newObject.criticalDepthVector.addElement(((CriticalDepth)this.criticalDepthVector.elementAt(i)).clone());
            }
            newObject.highSlownessLayerDepthsP = new Vector(this.highSlownessLayerDepthsP.size());
            for (i = 0; i < this.highSlownessLayerDepthsP.size(); ++i) {
                newObject.highSlownessLayerDepthsP.addElement(((DepthRange)this.highSlownessLayerDepthsP.elementAt(i)).clone());
            }
            newObject.highSlownessLayerDepthsS = new Vector(this.highSlownessLayerDepthsS.size());
            for (i = 0; i < this.highSlownessLayerDepthsS.size(); ++i) {
                newObject.highSlownessLayerDepthsS.addElement(((DepthRange)this.highSlownessLayerDepthsS.elementAt(i)).clone());
            }
            newObject.fluidLayerDepths = new Vector(this.fluidLayerDepths.size());
            for (i = 0; i < this.fluidLayerDepths.size(); ++i) {
                newObject.fluidLayerDepths.addElement(((DepthRange)this.fluidLayerDepths.elementAt(i)).clone());
            }
            newObject.PLayers = new Vector(this.getNumLayers(true));
            for (i = 0; i < this.getNumLayers(true); ++i) {
                newObject.PLayers.addElement(this.getSlownessLayerClone(i, true));
            }
            newObject.SLayers = new Vector(this.getNumLayers(false));
            for (i = 0; i < this.getNumLayers(false); ++i) {
                newObject.SLayers.addElement(this.getSlownessLayerClone(i, false));
            }
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Caught CloneNotSupportedException: " + e.getMessage());
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        int i;
        String desc = "";
        desc = "radiusOfEarth=" + this.radiusOfEarth + "\n maxDeltaP=" + this.maxDeltaP + "\n minDeltaP=" + this.minDeltaP + "\n maxDepthInterval=" + this.maxDepthInterval + "\n maxRangeInterval=" + this.maxRangeInterval + "\n allowInnerCoreS=" + this.allowInnerCoreS + "\n slownessTolerance=" + this.slownessTolerance + "\n getNumLayers('P')=" + this.getNumLayers(true) + "\n getNumLayers('S')=" + this.getNumLayers(false) + "\n fluidLayerDepths.size()=" + this.fluidLayerDepths.size() + "\n highSlownessLayerDepthsP.size()=" + this.highSlownessLayerDepthsP.size() + "\n highSlownessLayerDepthsS.size()=" + this.highSlownessLayerDepthsS.size() + "\n criticalDepthVector.size()=" + this.criticalDepthVector.size() + "\n";
        if (this.criticalDepthVector.size() != 0) {
            desc = desc + "**** Critical Depth Layers ************************\n";
            int botCriticalLayerNum = ((CriticalDepth)this.criticalDepthVector.elementAt((int)0)).velLayerNum - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepthVector.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = ((CriticalDepth)this.criticalDepthVector.elementAt((int)criticalNum)).velLayerNum - 1;
                desc = desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
        }
        desc = desc + "\n";
        if (this.fluidLayerDepths.size() != 0) {
            desc = desc + "\n**** Fluid Layer Depths ************************\n";
            for (i = 0; i < this.fluidLayerDepths.size(); ++i) {
                desc = desc + ((DepthRange)this.fluidLayerDepths.elementAt((int)i)).topDepth + "," + ((DepthRange)this.fluidLayerDepths.elementAt((int)i)).botDepth + " ";
            }
        }
        desc = desc + "\n";
        if (this.highSlownessLayerDepthsP.size() != 0) {
            desc = desc + "\n**** P High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsP.size(); ++i) {
                desc = desc + ((DepthRange)this.highSlownessLayerDepthsP.elementAt((int)i)).topDepth + "," + ((DepthRange)this.highSlownessLayerDepthsP.elementAt((int)i)).botDepth + " ";
            }
        }
        desc = desc + "\n";
        if (this.highSlownessLayerDepthsS.size() != 0) {
            desc = desc + "\n**** S High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsS.size(); ++i) {
                desc = desc + ((DepthRange)this.highSlownessLayerDepthsS.elementAt((int)i)).topDepth + "," + ((DepthRange)this.highSlownessLayerDepthsS.elementAt((int)i)).botDepth + " ";
            }
        }
        desc = desc + "\n";
        return desc;
    }
}

