/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class SeismicPhase
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public transient boolean verbose = false;
    protected TauModel tMod;
    protected static final int TURN = 0;
    protected static final int REFLECTTOP = 1;
    protected static final int REFLECTBOT = 2;
    protected static final int TRANSUP = 3;
    protected static final int TRANSDOWN = 4;
    protected double maxRefraction = 20.0;
    protected double maxDiffraction = 60.0;
    protected double sourceDepth;
    protected double[] dist = new double[0];
    protected double[] time = new double[0];
    protected double[] rayParams = new double[0];
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected Vector arrivals = new Vector();
    protected Vector branchSeq = new Vector();
    protected String name;
    protected String puristName;
    protected Vector legs = new Vector();
    protected transient int currBranch;
    protected transient int endAction;
    protected Vector legAction = new Vector();
    protected Vector downGoing = new Vector();
    protected Vector waveType = new Vector();
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public SeismicPhase(String name, TauModel tMod) {
        this.name = name;
        this.sourceDepth = tMod.sourceDepth;
        this.tMod = tMod;
    }

    public boolean hasArrivals() {
        return this.arrivals.size() > 0;
    }

    public Arrival[] getArrivals() {
        Arrival[] returnArrivals = new Arrival[this.arrivals.size()];
        for (int i = 0; i < this.arrivals.size(); ++i) {
            returnArrivals[i] = (Arrival)this.arrivals.elementAt(i);
        }
        return returnArrivals;
    }

    public void setTauModel(TauModel tMod) throws TauModelException {
        this.tMod = tMod;
        this.init();
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    public double getMaxDiffraction() {
        return this.maxDiffraction;
    }

    public void setMaxDiffraction(double maxDiffraction) {
        this.maxDiffraction = maxDiffraction;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.name;
    }

    public String[] getLegs() {
        String[] legsArray = new String[this.legs.size()];
        for (int i = 0; i < this.legs.size(); ++i) {
            legsArray[i] = (String)this.legs.elementAt(i);
        }
        return legsArray;
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double[] getTau() {
        double[] tau = new double[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            tau[i] = this.time[i] - this.rayParams[i] * this.dist[i];
        }
        return tau;
    }

    public void init() throws TauModelException {
        this.legPuller();
        this.createPuristName(this.tMod);
        this.parseName(this.tMod);
        this.sumBranches(this.tMod);
    }

    public void calcTime(double deg) {
        double tempDeg = deg;
        if (tempDeg < 0.0) {
            tempDeg *= -1.0;
        }
        while (tempDeg > 360.0) {
            tempDeg -= 360.0;
        }
        if (tempDeg > 180.0) {
            tempDeg = 360.0 - tempDeg;
        }
        double radDist = tempDeg * Math.PI / 180.0;
        this.arrivals.removeAllElements();
        int n = 0;
        while ((double)n * 2.0 * Math.PI + radDist <= this.maxDistance) {
            Arrival newArrival;
            double arrivalRayParam;
            double arrivalTime;
            int rayNum;
            double searchDist = (double)n * 2.0 * Math.PI + radDist;
            for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                if (this.DEBUG) {
                    System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                }
                arrivalTime = (searchDist - this.dist[rayNum]) / (this.dist[rayNum + 1] - this.dist[rayNum]) * (this.time[rayNum + 1] - this.time[rayNum]) + this.time[rayNum];
                arrivalRayParam = (searchDist - this.dist[rayNum + 1]) * (this.rayParams[rayNum] - this.rayParams[rayNum + 1]) / (this.dist[rayNum] - this.dist[rayNum + 1]) + this.rayParams[rayNum + 1];
                newArrival = new Arrival(this, arrivalTime, searchDist, arrivalRayParam, rayNum, this.name, this.puristName, this.sourceDepth);
                this.arrivals.addElement(newArrival);
            }
            searchDist = (double)(n + 1) * 2.0 * Math.PI - radDist;
            if (tempDeg != 180.0) {
                for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                    if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                    if (this.DEBUG) {
                        System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                    }
                    arrivalTime = (searchDist - this.dist[rayNum]) / (this.dist[rayNum + 1] - this.dist[rayNum]) * (this.time[rayNum + 1] - this.time[rayNum]) + this.time[rayNum];
                    arrivalRayParam = (searchDist - this.dist[rayNum]) * (this.rayParams[rayNum + 1] - this.rayParams[rayNum]) / (this.dist[rayNum + 1] - this.dist[rayNum]) + this.rayParams[rayNum];
                    newArrival = new Arrival(this, arrivalTime, searchDist, arrivalRayParam, rayNum, this.name, this.puristName, this.sourceDepth);
                    this.arrivals.addElement(newArrival);
                }
            }
            ++n;
        }
    }

    protected void phaseConversion(TauModel tMod, int fromBranch, int endAction, boolean isPtoS) throws TauModelException {
        if (endAction == 0) {
            throw new TauModelException("Illegal endAction: endAction=" + endAction + "\nphase conversion are not allowed at turn points.");
        }
        if (endAction == 1) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMaxRayParam());
        } else if (endAction == 2) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinTurnRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 3) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch - 1, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 4) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch + 1, !isPtoS).getMaxRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addToBranch(TauModel tMod, int startBranch, int endBranch, boolean isPWave, int endAction) throws TauModelException {
        void var6_6;
        void var7_7;
        boolean isDownGoing;
        int endOffset;
        this.endAction = endAction;
        if (this.DEBUG) {
            System.out.print("start=" + startBranch + " end=" + endBranch + " endOffset=");
            if (endAction == 0) {
                System.out.println("TURN");
            } else if (endAction == 1) {
                System.out.println("REFLECTTOP");
            } else if (endAction == 2) {
                System.out.println("REFLECTBOT");
            } else if (endAction == 3) {
                System.out.println("TRANSUP");
            } else if (endAction == 4) {
                System.out.println("TRANSDOWN");
            } else {
                System.out.println(endAction);
            }
        }
        if (endAction == 0) {
            endOffset = 0;
            isDownGoing = true;
            this.minRayParam = Math.max(this.minRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 1) {
            endOffset = 0;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 2) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 3) {
            endOffset = -1;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 4) {
            endOffset = 1;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
        if (var7_7 != false) {
            int i;
            for (i = startBranch; i <= endBranch; ++i) {
                this.branchSeq.addElement(new Integer(i));
                this.downGoing.addElement(new Boolean((boolean)var7_7));
                this.waveType.addElement(new Boolean(isPWave));
                this.legAction.addElement(new Integer(endAction));
            }
            if (this.DEBUG) {
                for (i = startBranch; i <= endBranch; ++i) {
                    System.out.println("i=" + i + " isDownGoing=" + (boolean)var7_7 + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + endAction);
                }
            }
        } else {
            int i;
            for (i = startBranch; i >= endBranch; --i) {
                this.branchSeq.addElement(new Integer(i));
                this.downGoing.addElement(new Boolean((boolean)var7_7));
                this.waveType.addElement(new Boolean(isPWave));
                this.legAction.addElement(new Integer(endAction));
            }
            if (this.DEBUG) {
                for (i = startBranch; i >= endBranch; --i) {
                    System.out.println("i=" + i + " isDownGoing=" + (boolean)var7_7 + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + endAction);
                }
            }
        }
        this.currBranch = endBranch + var6_6;
    }

    public int closestBranchToDepth(TauModel tMod, String depthString) {
        if (depthString.equals("m")) {
            return tMod.getMohoBranch();
        }
        if (depthString.equals("c")) {
            return tMod.getCmbBranch();
        }
        if (depthString.equals("i")) {
            return tMod.getIocbBranch();
        }
        int disconBranch = -1;
        double disconMax = Double.MAX_VALUE;
        double disconDepth = Double.valueOf(depthString);
        for (int i = 0; i < tMod.getNumBranches(); ++i) {
            TauBranch tBranch = tMod.getTauBranch(i, true);
            if (!(Math.abs(disconDepth - tBranch.getTopDepth()) < disconMax) || tMod.isNoDisconDepth(tBranch.getTopDepth())) continue;
            disconBranch = i;
            disconMax = Math.abs(disconDepth - tBranch.getTopDepth());
        }
        return disconBranch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseName(TauModel tMod) throws TauModelException {
        boolean isDownGoing;
        boolean isPWave;
        String currLeg;
        String nextLeg = currLeg = (String)this.legs.elementAt(0);
        this.branchSeq.removeAllElements();
        boolean isPWavePrev = isPWave = true;
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            return;
        }
        if (this.name.indexOf(74) != -1 && !tMod.sMod.isAllowInnerCoreS()) {
            throw new TauModelException("'J' phases were not created for this model: " + this.name);
        }
        if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("K") || currLeg.equals("I")) {
            isPWavePrev = isPWave = true;
        } else if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J")) {
            isPWavePrev = isPWave = false;
        }
        if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
            this.currBranch = tMod.getSourceBranch();
            isDownGoing = true;
            this.endAction = 2;
        } else {
            if (!currLeg.equals("p") && !currLeg.equals("s")) throw new TauModelException("First phase not recognized: " + currLeg + " must be one of P, Pg, Pn, Pdiff, p or the S equivalents");
            isDownGoing = false;
            this.endAction = 1;
            if (tMod.getSourceBranch() != 0) {
                this.currBranch = tMod.getSourceBranch() - 1;
            } else {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                return;
            }
        }
        this.maxRayParam = tMod.getSourceBranch() != 0 ? Math.max(tMod.getTauBranch(tMod.getSourceBranch() - 1, isPWave).getMinTurnRayParam(), tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam()) : tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam();
        this.minRayParam = 0.0;
        int disconBranch = 0;
        double nextLegDepth = 0.0;
        boolean isNextLegDepth = false;
        this.endAction = 4;
        currLeg = "START";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            String prevLeg = currLeg;
            currLeg = nextLeg;
            nextLeg = (String)this.legs.elementAt(legNum + 1);
            if (this.DEBUG) {
                System.out.println(legNum + "  " + prevLeg + "  " + currLeg + "  " + nextLeg);
            }
            double legDepth = nextLegDepth;
            boolean isLegDepth = isNextLegDepth;
            try {
                nextLegDepth = new Double(nextLeg);
                isNextLegDepth = true;
            }
            catch (NumberFormatException e) {
                nextLegDepth = -1.0;
                isNextLegDepth = false;
            }
            isPWavePrev = isPWave;
            if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("I")) {
                isPWave = true;
            } else if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J")) {
                isPWave = false;
            } else if (currLeg.equals("K")) {
                // empty if block
            }
            if (this.branchSeq.size() > 0 && isPWavePrev != isPWave) {
                this.phaseConversion(tMod, (Integer)this.branchSeq.elementAt(this.branchSeq.size() - 1), this.endAction, isPWavePrev);
            }
            if (currLeg.equals("p") || currLeg.equals("s")) {
                if (nextLeg.startsWith("v")) {
                    throw new TauModelException("p and s must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch < disconBranch) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("m") && this.currBranch >= tMod.getMohoBranch()) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 3);
                    continue;
                }
                if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("END")) {
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                if (!isNextLegDepth) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                continue;
            }
            if (currLeg.equals("P") || currLeg.equals("S")) {
                if (nextLeg.equals("P") || nextLeg.equals("S") || nextLeg.equals("Pn") || nextLeg.equals("Sn") || nextLeg.equals("END")) {
                    if (this.endAction == 4 || this.endAction == 1) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                if (nextLeg.startsWith("v")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch > disconBranch - 1) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, 2);
                    continue;
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (prevLeg.equals("K")) {
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                        continue;
                    }
                    if (prevLeg.startsWith("^") || prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("p") || prevLeg.equals("s") || prevLeg.equals("START")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                        continue;
                    }
                    if (!(prevLeg.startsWith("v") && disconBranch < this.closestBranchToDepth(tMod, prevLeg.substring(1)) || prevLeg.equals("m") && disconBranch < tMod.getMohoBranch()) && (!prevLeg.equals("c") || disconBranch >= tMod.getCmbBranch())) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("c")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 2);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 4);
                    continue;
                }
                if (!nextLeg.equals("m") && (!isNextLegDepth || !(nextLegDepth < tMod.getCmbDepth()))) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                if (this.DEBUG) {
                    System.out.println("DisconBranch=" + disconBranch + " for " + nextLeg);
                    System.out.println(tMod.getTauBranch(disconBranch, isPWave).getTopDepth());
                }
                if (this.endAction == 0 || this.endAction == 2 || this.endAction == 3) {
                    if (disconBranch > this.currBranch) {
                        throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    }
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                    continue;
                }
                String nextNextLeg = (String)this.legs.elementAt(legNum + 2);
                if (nextNextLeg.equals("p") || nextNextLeg.equals("s")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                    continue;
                }
                if (!nextNextLeg.equals("P") && !nextNextLeg.equals("S")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " followed by " + nextNextLeg);
                if (disconBranch > this.currBranch) {
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, 4);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + currLeg + " " + nextLeg + " " + nextNextLeg + ", so this phase, " + this.getName() + " is illegal for this sourceDepth.");
                return;
            }
            if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
                if (currLeg.equals("Pdiff") || currLeg.equals("Sdiff")) {
                    if (this.maxRayParam >= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam()) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                        this.maxRayParam = this.minRayParam;
                        if (!nextLeg.equals("END")) continue;
                        this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                        continue;
                    }
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                    return;
                }
                if (!currLeg.equals("Pg") && !currLeg.equals("Sg") && !currLeg.equals("Pn") && !currLeg.equals("Sn")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                if (this.currBranch >= tMod.getMohoBranch()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("(currBranch >= tMod.getMohoBranch() " + this.currBranch + " " + tMod.getMohoBranch() + " so there cannot be a " + currLeg + " phase for this sourceDepth and/or path.");
                    return;
                }
                if (currLeg.equals("Pg") || currLeg.equals("Sg")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch() - 1, isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                if (!currLeg.equals("Pn") && !currLeg.equals("Sn")) continue;
                if (this.maxRayParam >= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam()) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 3);
                    this.minRayParam = this.maxRayParam;
                    if (!nextLeg.equals("END") && !nextLeg.startsWith("P") && !nextLeg.startsWith("S")) continue;
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                return;
            }
            if (currLeg.equals("K")) {
                if (nextLeg.equals("P") || nextLeg.equals("S")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, 3);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 4);
                    continue;
                }
                if (!nextLeg.equals("i")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 2);
                continue;
            }
            if (currLeg.equals("I") || currLeg.equals("J")) {
                this.addToBranch(tMod, this.currBranch, tMod.getNumBranches() - 1, isPWave, 0);
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, 1);
                    continue;
                }
                if (!nextLeg.equals("K")) continue;
                this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, 3);
                continue;
            }
            if (currLeg.equals("m") || currLeg.equals("c") || currLeg.equals("i") || currLeg.startsWith("^") || currLeg.startsWith("v") || isLegDepth) continue;
            throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
        }
    }

    protected void legPuller() throws TauModelException {
        int offset = 0;
        this.legs.removeAllElements();
        if (this.name.endsWith("kmps")) {
            try {
                double vel = Double.valueOf(this.name.substring(0, this.name.length() - 4));
                this.legs.addElement(this.name);
            }
            catch (NumberFormatException e) {
                throw new TauModelException("Invalid phase name:\n" + this.name);
            }
        } else {
            while (offset < this.name.length()) {
                if (this.name.charAt(offset) == 'K' || this.name.charAt(offset) == 'I' || this.name.charAt(offset) == 'J' || this.name.charAt(offset) == 'p' || this.name.charAt(offset) == 's' || this.name.charAt(offset) == 'm' || this.name.charAt(offset) == 'c' || this.name.charAt(offset) == 'i') {
                    this.legs.addElement(this.name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (this.name.charAt(offset) == 'P' || this.name.charAt(offset) == 'S') {
                    if (offset + 1 == this.name.length() || this.name.charAt(offset + 1) == 'P' || this.name.charAt(offset + 1) == 'S' || this.name.charAt(offset + 1) == 'K' || this.name.charAt(offset + 1) == 'p' || this.name.charAt(offset + 1) == 's' || this.name.charAt(offset + 1) == 'm' || this.name.charAt(offset + 1) == 'c' || this.name.charAt(offset + 1) == '^' || this.name.charAt(offset + 1) == 'v' || Character.isDigit(this.name.charAt(offset + 1))) {
                        this.legs.addElement(this.name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (this.name.charAt(offset + 1) == 'g' || this.name.charAt(offset + 1) == 'b' || this.name.charAt(offset + 1) == 'n') {
                        this.legs.addElement(this.name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (this.name.length() >= offset + 5 && (this.name.substring(offset, offset + 5).equals("Sdiff") || this.name.substring(offset, offset + 5).equals("Pdiff"))) {
                        this.legs.addElement(this.name.substring(offset, offset + 5));
                        offset += 5;
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + this.name.substring(offset) + " in " + this.name);
                }
                if (this.name.charAt(offset) == '^' || this.name.charAt(offset) == 'v') {
                    if (this.name.charAt(offset + 1) == 'm' || this.name.charAt(offset + 1) == 'c' || this.name.charAt(offset + 1) == 'i') {
                        this.legs.addElement(this.name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (Character.isDigit(this.name.charAt(offset + 1))) {
                        int numDigits = 1;
                        while (offset + numDigits + 1 < this.name.length() && Character.isDigit(this.name.charAt(offset + numDigits + 1))) {
                            ++numDigits;
                        }
                        this.legs.addElement(this.name.substring(offset, offset + numDigits + 1));
                        offset = offset + numDigits + 1;
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + this.name.substring(offset) + " in " + this.name);
                }
                if (Character.isDigit(this.name.charAt(offset)) || this.name.charAt(offset) == '.') {
                    String numString = this.name.substring(offset, offset + 1);
                    ++offset;
                    while (Character.isDigit(this.name.charAt(offset)) || this.name.charAt(offset) == '.') {
                        numString = numString + this.name.substring(offset, offset + 1);
                        ++offset;
                    }
                    try {
                        Double d = new Double(numString);
                        this.legs.addElement(numString);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new TauModelException("Invalid phase name: " + numString + "\n" + e.getMessage() + " in " + this.name);
                    }
                }
                throw new TauModelException("Invalid phase name:\n" + this.name.substring(offset) + " in " + this.name);
            }
        }
        this.legs.addElement(new String("END"));
        if (!this.phaseValidate()) {
            throw new TauModelException("Phase failed validation: " + this.name);
        }
    }

    protected void createPuristName(TauModel tMod) {
        String currLeg = (String)this.legs.elementAt(0);
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            this.puristName = this.name;
            return;
        }
        this.puristName = "";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            int intLegDepth;
            double legDepth;
            int disconBranch;
            currLeg = (String)this.legs.elementAt(legNum);
            if (currLeg.startsWith("v") || currLeg.startsWith("^")) {
                disconBranch = this.closestBranchToDepth(tMod, currLeg.substring(1));
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                this.puristName = this.puristName + currLeg.substring(0, 1);
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            try {
                legDepth = new Double(currLeg);
                disconBranch = this.closestBranchToDepth(tMod, currLeg);
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            catch (NumberFormatException e) {
                this.puristName = this.puristName + currLeg;
            }
        }
    }

    protected void sumBranches(TauModel tMod) throws TauModelException {
        int j;
        int i;
        if (this.maxRayParam < 0.0 || this.minRayParam > this.maxRayParam) {
            this.rayParams = new double[0];
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            this.dist = new double[0];
            this.time = new double[0];
            this.maxDistance = -1.0;
            return;
        }
        if (this.name.endsWith("kmps")) {
            this.dist = new double[2];
            this.time = new double[2];
            this.rayParams = new double[2];
            this.dist[0] = 0.0;
            this.time[0] = 0.0;
            this.rayParams[0] = tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.dist[1] = Math.PI * 2;
            this.time[1] = Math.PI * 2 * tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.rayParams[1] = this.rayParams[0];
            this.minDistance = 0.0;
            this.maxDistance = Math.PI * 2;
            return;
        }
        for (int i2 = 0; i2 < tMod.rayParams.length; ++i2) {
            if (tMod.rayParams[i2] >= this.minRayParam) {
                this.minRayParamIndex = i2;
            }
            if (!(tMod.rayParams[i2] >= this.maxRayParam)) continue;
            this.maxRayParamIndex = i2;
        }
        if (this.maxRayParamIndex == 0 && this.minRayParamIndex == tMod.rayParams.length - 1) {
            this.rayParams = new double[tMod.rayParams.length];
            System.arraycopy(tMod.rayParams, 0, this.rayParams, 0, tMod.rayParams.length);
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.endsWith("kmps")) {
                this.rayParams = new double[2];
                this.rayParams[0] = 0.0;
                this.rayParams[1] = this.maxRayParam;
            } else {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            }
        } else {
            if (this.DEBUG) {
                System.out.println("maxRayParamIndex=" + this.maxRayParamIndex + " minRayParamIndex=" + this.minRayParamIndex + " tMod.rayParams.length=" + tMod.rayParams.length + " tMod.rayParams[0]=" + tMod.rayParams[0] + " maxRayParam=" + this.maxRayParam);
            }
            this.rayParams = new double[this.minRayParamIndex - this.maxRayParamIndex + 1];
            System.arraycopy(tMod.rayParams, this.maxRayParamIndex, this.rayParams, 0, this.minRayParamIndex - this.maxRayParamIndex + 1);
        }
        this.dist = new double[this.rayParams.length];
        this.time = new double[this.rayParams.length];
        int[][] timesBranches = new int[2][tMod.getNumBranches()];
        for (i = 0; i < timesBranches[0].length; ++i) {
            timesBranches[0][i] = 0;
            timesBranches[1][i] = 0;
        }
        for (i = 0; i < this.branchSeq.size(); ++i) {
            if (((Boolean)this.waveType.elementAt(i)).booleanValue()) {
                int[] nArray = timesBranches[0];
                int n = (Integer)this.branchSeq.elementAt(i);
                nArray[n] = nArray[n] + 1;
                continue;
            }
            int[] nArray = timesBranches[1];
            int n = (Integer)this.branchSeq.elementAt(i);
            nArray[n] = nArray[n] + 1;
        }
        for (j = 0; j < tMod.getNumBranches(); ++j) {
            int i3;
            if (timesBranches[0][j] != 0) {
                for (i3 = this.maxRayParamIndex; i3 < this.minRayParamIndex + 1; ++i3) {
                    int n = i3 - this.maxRayParamIndex;
                    this.dist[n] = this.dist[n] + (double)timesBranches[0][j] * tMod.getTauBranch(j, true).getDist(i3);
                    int n2 = i3 - this.maxRayParamIndex;
                    this.time[n2] = this.time[n2] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).time[i3];
                }
            }
            if (timesBranches[1][j] == 0) continue;
            for (i3 = this.maxRayParamIndex; i3 < this.minRayParamIndex + 1; ++i3) {
                int n = i3 - this.maxRayParamIndex;
                this.dist[n] = this.dist[n] + (double)timesBranches[1][j] * tMod.getTauBranch(j, false).getDist(i3);
                int n3 = i3 - this.maxRayParamIndex;
                this.time[n3] = this.time[n3] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).time[i3];
            }
        }
        if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
            if (tMod.sMod.depthInHighSlowness(tMod.cmbDepth - 1.0E-10, this.minRayParam, this.name.charAt(0) == 'P')) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                this.maxDistance = -1.0;
                this.dist = new double[0];
                this.time = new double[0];
                this.rayParams = new double[0];
                return;
            }
            this.dist[1] = this.dist[0] + this.maxDiffraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + this.maxDiffraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
            this.dist[1] = this.dist[0] + this.maxRefraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + this.maxRefraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            this.dist[1] = this.dist[0];
            this.time[1] = this.time[0];
        }
        this.minDistance = Double.MAX_VALUE;
        this.maxDistance = 0.0;
        for (j = 0; j < this.dist.length; ++j) {
            if (this.dist[j] < this.minDistance) {
                this.minDistance = this.dist[j];
            }
            if (!(this.dist[j] > this.maxDistance)) continue;
            this.maxDistance = this.dist[j];
        }
        boolean foundOverlap = false;
        boolean isPWave = true;
        for (int dummy = 0; dummy < 2; ++dummy) {
            DepthRange[] hsz = tMod.sMod.getHighSlowness(isPWave);
            int hSZIndex = 0;
            int indexOffset = 0;
            for (int i4 = 0; i4 < hsz.length; ++i4) {
                int j2;
                if (!(this.maxRayParam > hsz[i4].rayParam) || !(hsz[i4].rayParam > this.minRayParam)) continue;
                int branchNum = tMod.findBranch(hsz[i4].topDepth);
                foundOverlap = false;
                for (int legNum = 0; legNum < this.branchSeq.size(); ++legNum) {
                    if ((Integer)this.branchSeq.elementAt(legNum) != branchNum || (Boolean)this.waveType.elementAt(legNum) != isPWave || !((Boolean)this.downGoing.elementAt(legNum)).booleanValue() || (Integer)this.branchSeq.elementAt(legNum - 1) != branchNum - 1 || (Boolean)this.waveType.elementAt(legNum - 1) != isPWave || !((Boolean)this.downGoing.elementAt(legNum - 1)).booleanValue()) continue;
                    foundOverlap = true;
                    break;
                }
                if (!foundOverlap) continue;
                double[] newdist = new double[this.dist.length + 1];
                double[] newtime = new double[this.time.length + 1];
                double[] newrayParams = new double[this.rayParams.length + 1];
                for (j2 = 0; j2 < this.rayParams.length; ++j2) {
                    if (this.rayParams[j2] != hsz[i4].rayParam) continue;
                    hSZIndex = j2;
                    break;
                }
                System.arraycopy(this.dist, 0, newdist, 0, hSZIndex);
                System.arraycopy(this.time, 0, newtime, 0, hSZIndex);
                System.arraycopy(this.rayParams, 0, newrayParams, 0, hSZIndex);
                newrayParams[hSZIndex] = hsz[i4].rayParam;
                newdist[hSZIndex] = 0.0;
                newtime[hSZIndex] = 0.0;
                for (j2 = 0; j2 < tMod.getNumBranches(); ++j2) {
                    if (timesBranches[0][j2] != 0 && tMod.getTauBranch(j2, true).getTopDepth() < hsz[i4].topDepth) {
                        int n = hSZIndex;
                        newdist[n] = newdist[n] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                        int n4 = hSZIndex;
                        newtime[n4] = newtime[n4] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                    }
                    if (timesBranches[1][j2] == 0 || !(tMod.getTauBranch(j2, false).getTopDepth() < hsz[i4].topDepth)) continue;
                    int n = hSZIndex;
                    newdist[n] = newdist[n] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                    int n5 = hSZIndex;
                    newtime[n5] = newtime[n5] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                }
                System.arraycopy(this.dist, hSZIndex, newdist, hSZIndex + 1, this.dist.length - hSZIndex);
                System.arraycopy(this.time, hSZIndex, newtime, hSZIndex + 1, this.time.length - hSZIndex);
                System.arraycopy(this.rayParams, hSZIndex, newrayParams, hSZIndex + 1, this.rayParams.length - hSZIndex);
                ++indexOffset;
                this.dist = newdist;
                this.time = newtime;
                this.rayParams = newrayParams;
            }
            isPWave = false;
        }
    }

    public void calcPierce(TauModel tMod) throws TauModelException {
        int rayNum = 0;
        for (int arrivalNum = 0; arrivalNum < this.arrivals.size(); ++arrivalNum) {
            double branchTime;
            Arrival currArrival = (Arrival)this.arrivals.elementAt(arrivalNum);
            double branchDist = 0.0;
            double prevBranchTime = branchTime = 0.0;
            int i = 0;
            while (i < tMod.rayParams.length - 1 && tMod.rayParams[i] >= currArrival.rayParam) {
                rayNum = i++;
            }
            currArrival.pierce = new TimeDist[this.branchSeq.size() + 2];
            double rayParamA = this.rayParams[currArrival.rayParamIndex];
            double rayParamB = this.rayParams[currArrival.rayParamIndex + 1];
            double distA = this.dist[currArrival.rayParamIndex];
            double distB = this.dist[currArrival.rayParamIndex + 1];
            double distRatio = (currArrival.dist - distA) / (distB - distA);
            double distRayParam = distRatio * (rayParamB - rayParamA) + rayParamA;
            currArrival.pierce[0] = new TimeDist(distRayParam, 0.0, 0.0, tMod.sourceDepth);
            int numAdded = 1;
            for (i = 0; i < this.branchSeq.size(); ++i) {
                double timeB;
                double timeA;
                double turnDepth;
                int branchNum = (Integer)this.branchSeq.elementAt(i);
                boolean isPWave = (Boolean)this.waveType.elementAt(i);
                if (this.DEBUG) {
                    System.out.println(i + " branchNum =" + branchNum + " downGoing=" + (Boolean)this.downGoing.elementAt(i) + "  isPWave=" + isPWave);
                }
                try {
                    turnDepth = distRayParam > tMod.getTauBranch(branchNum, isPWave).getMaxRayParam() ? tMod.getTauBranch(branchNum, isPWave).getTopDepth() : (distRayParam <= tMod.getTauBranch(branchNum, isPWave).getMinRayParam() ? tMod.getTauBranch(branchNum, isPWave).getBotDepth() : (isPWave || tMod.sMod.depthInFluid((tMod.getTauBranch(branchNum, isPWave).getTopDepth() + tMod.getTauBranch(branchNum, isPWave).getBotDepth()) / 2.0) ? tMod.sMod.findDepth(distRayParam, tMod.getTauBranch(branchNum, isPWave).getTopDepth(), tMod.getTauBranch(branchNum, isPWave).getBotDepth(), true) : tMod.sMod.findDepth(distRayParam, tMod.getTauBranch(branchNum, isPWave).getTopDepth(), tMod.getTauBranch(branchNum, isPWave).getBotDepth(), isPWave)));
                }
                catch (SlownessModelException e) {
                    System.err.println("SeismicPhase.calcPierce: Caught SlownessModelException: " + e.getMessage());
                    e.printStackTrace();
                    turnDepth = 0.0;
                }
                if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
                    distA = tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                    timeA = tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                    distB = tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                    timeB = tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                } else {
                    distA = tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                    timeA = tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                    distB = tMod.getTauBranch(branchNum, isPWave).getDist(rayNum + 1);
                    timeB = tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum + 1];
                }
                branchDist += distRatio * (distB - distA) + distA;
                prevBranchTime = branchTime;
                branchTime += distRatio * (timeB - timeA) + timeA;
                double branchDepth = (Boolean)this.downGoing.elementAt(i) != false ? Math.min(tMod.getTauBranch(branchNum, isPWave).getBotDepth(), turnDepth) : Math.min(tMod.getTauBranch(branchNum, isPWave).getTopDepth(), turnDepth);
                if (!(Math.abs(prevBranchTime - branchTime) > 1.0E-10)) continue;
                currArrival.pierce[numAdded++] = new TimeDist(distRayParam, branchTime, branchDist, branchDepth);
                if (!this.DEBUG) continue;
                System.out.println(" branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
                System.out.println("incrementTime = " + distRatio * (timeB - timeA) + " timeB=" + timeB + " timeA=" + timeA);
            }
            if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
                int j;
                TimeDist[] diffTD;
                int i2 = 0;
                if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Sdiff") != -1) {
                    diffTD = new TimeDist[numAdded + 1];
                    while (currArrival.pierce[i2].depth != tMod.cmbDepth) {
                        diffTD[i2] = currArrival.pierce[i2];
                        ++i2;
                    }
                    diffTD[i2] = currArrival.pierce[i2];
                    double diffractDist = currArrival.dist - this.dist[0];
                    double diffractTime = diffractDist * diffTD[i2].p;
                    diffTD[i2 + 1] = new TimeDist(diffTD[i2].p, diffTD[i2].time + diffractTime, diffTD[i2].dist + diffractDist, tMod.cmbDepth);
                    System.arraycopy(currArrival.pierce, ++i2, diffTD, i2 + 1, numAdded - i2);
                    for (j = i2 + 1; j < diffTD.length; ++j) {
                        diffTD[j].dist += diffractDist;
                        diffTD[j].time += diffractTime;
                    }
                    ++numAdded;
                } else {
                    int numFound = 0;
                    int indexInString = -1;
                    while ((indexInString = this.name.indexOf("Pn", indexInString + 1)) != -1) {
                        ++numFound;
                    }
                    while ((indexInString = this.name.indexOf("Sn", indexInString + 1)) != -1) {
                        ++numFound;
                    }
                    double refractDist = currArrival.dist - this.dist[0];
                    diffTD = new TimeDist[numAdded + numFound];
                    for (j = 0; j < numFound; ++j) {
                        while (currArrival.pierce[i2].depth != tMod.mohoDepth) {
                            diffTD[i2 + j] = currArrival.pierce[i2];
                            diffTD[i2 + j].dist += (double)j * refractDist / (double)numFound;
                            ++i2;
                        }
                        diffTD[i2 + j] = currArrival.pierce[i2];
                        diffTD[i2 + j].dist += (double)j * refractDist / (double)numFound;
                        diffTD[i2 + j + 1] = new TimeDist(diffTD[i2].p, diffTD[i2 + j].time + refractDist / (double)numFound * diffTD[i2].p, diffTD[i2 + j].dist + refractDist / (double)numFound, tMod.mohoDepth);
                        ++i2;
                    }
                    System.arraycopy(currArrival.pierce, i2, diffTD, i2 + j, numAdded - i2);
                    for (int k = i2 + j; k < diffTD.length; ++k) {
                        diffTD[k].dist += refractDist;
                    }
                    numAdded += j;
                }
                currArrival.pierce = diffTD;
                continue;
            }
            TimeDist[] temp = new TimeDist[numAdded];
            System.arraycopy(currArrival.pierce, 0, temp, 0, numAdded);
            currArrival.pierce = temp;
        }
    }

    public void calcPath(TauModel tMod) {
        Vector<TimeDist[]> pathList = new Vector<TimeDist[]>(10);
        int rayNum = 0;
        for (int arrivalNum = 0; arrivalNum < this.arrivals.size(); ++arrivalNum) {
            int i;
            pathList.removeAllElements();
            Arrival currArrival = (Arrival)this.arrivals.elementAt(arrivalNum);
            for (i = 0; i < tMod.rayParams.length; ++i) {
                if (!(tMod.rayParams[i] >= currArrival.rayParam)) continue;
                rayNum = i;
            }
            TimeDist[] tempTimeDist = new TimeDist[]{new TimeDist(currArrival.rayParam, 0.0, 0.0, tMod.sourceDepth)};
            pathList.addElement(tempTimeDist);
            try {
                for (i = 0; i < this.branchSeq.size(); ++i) {
                    int branchNum = (Integer)this.branchSeq.elementAt(i);
                    boolean isPWave = (Boolean)this.waveType.elementAt(i);
                    if (this.DEBUG) {
                        System.out.println("i=" + i + " branchNum=" + branchNum + " isPWave=" + isPWave + " downgoing=" + (Boolean)this.downGoing.elementAt(i));
                    }
                    if ((tempTimeDist = tMod.getTauBranch(branchNum, isPWave).path(currArrival.rayParam, (Boolean)this.downGoing.elementAt(i), tMod.sMod)) != null) {
                        pathList.addElement(tempTimeDist);
                    }
                    if (branchNum == tMod.cmbBranch - 1 && (Integer)this.branchSeq.elementAt(i + 1) == tMod.cmbBranch - 1 && (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Sdiff") != -1)) {
                        TimeDist[] diffTD = new TimeDist[]{new TimeDist(currArrival.rayParam, (currArrival.dist - this.dist[0]) * currArrival.rayParam, currArrival.dist - this.dist[0], tMod.cmbDepth)};
                        pathList.addElement(diffTD);
                        continue;
                    }
                    if (branchNum != tMod.mohoBranch - 1 || (Integer)this.branchSeq.elementAt(i + 1) != tMod.mohoBranch - 1 || this.name.indexOf("Pn") == -1 && this.name.indexOf("Sn") == -1) continue;
                    int numFound = 0;
                    int indexInString = -1;
                    while ((indexInString = this.name.indexOf("Pn", indexInString + 1)) != -1) {
                        ++numFound;
                    }
                    while ((indexInString = this.name.indexOf("Sn", indexInString + 1)) != -1) {
                        ++numFound;
                    }
                    TimeDist[] headTD = new TimeDist[]{new TimeDist(currArrival.rayParam, (currArrival.dist - this.dist[0]) / (double)numFound * currArrival.rayParam, (currArrival.dist - this.dist[0]) / (double)numFound, tMod.mohoDepth)};
                    pathList.addElement(headTD);
                }
                int arraySize = 0;
                for (i = 0; i < pathList.size(); ++i) {
                    arraySize += ((TimeDist[])pathList.elementAt(i)).length;
                }
                currArrival.path = new TimeDist[arraySize];
                TimeDist cummulative = new TimeDist(currArrival.rayParam, 0.0, 0.0, currArrival.sourceDepth);
                int numAdded = 0;
                for (int i2 = 0; i2 < pathList.size(); ++i2) {
                    TimeDist[] branchPath = (TimeDist[])pathList.elementAt(i2);
                    for (int j = 0; j < branchPath.length; ++j) {
                        cummulative.add(branchPath[j]);
                        cummulative.depth = branchPath[j].depth;
                        currArrival.path[numAdded] = (TimeDist)cummulative.clone();
                        ++numAdded;
                    }
                }
                continue;
            }
            catch (SlownessModelException e) {
                System.out.println("Caught SlownessModelException in SeismicPhase.calcPath(): " + e.getMessage());
                e.printStackTrace();
                System.out.println("Skipping phase " + currArrival.name);
            }
        }
    }

    public boolean phaseValidate() {
        String currToken = (String)this.legs.elementAt(0);
        boolean prevIsReflect = false;
        if (this.legs.size() == 2 && (currToken.equals("Pdiff") || currToken.equals("Sdiff") || currToken.endsWith("kmps")) && ((String)this.legs.elementAt(1)).equals("END")) {
            return true;
        }
        if (!(currToken.equals("Pg") || currToken.equals("Pb") || currToken.equals("Pn") || currToken.equals("Pdiff") || currToken.equals("Sg") || currToken.equals("Sb") || currToken.equals("Sn") || currToken.equals("Sdiff") || currToken.equals("P") || currToken.equals("S") || currToken.equals("p") || currToken.equals("s"))) {
            return false;
        }
        for (int i = 1; i < this.legs.size(); ++i) {
            String prevToken = currToken;
            currToken = (String)this.legs.elementAt(i);
            if (currToken.startsWith("^") || currToken.startsWith("v") || currToken.equals("m") || currToken.equals("c") || currToken.equals("i")) {
                if (prevIsReflect) {
                    return false;
                }
                prevIsReflect = true;
            } else {
                prevIsReflect = false;
            }
            if (prevToken.equals("END")) {
                return false;
            }
            if ((currToken.startsWith("P") || currToken.startsWith("S") || currToken.startsWith("p") || currToken.startsWith("s") || currToken.equals("m") || currToken.equals("c")) && (prevToken.equals("I") || prevToken.equals("J") || prevToken.equals("i"))) {
                return false;
            }
            if ((prevToken.startsWith("P") || prevToken.startsWith("S") || prevToken.startsWith("p") || prevToken.startsWith("s") || prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return false;
            }
            if (prevToken.equals("m") && currToken.equals("K")) {
                return false;
            }
            if (!currToken.equals("m") || !prevToken.equals("K")) continue;
            return false;
        }
        return currToken.equals("END");
    }

    public String toString() {
        int i;
        String desc = this.name + ": ";
        for (i = 0; i < this.legs.size(); ++i) {
            desc = desc + this.legs.elementAt(i) + " ";
        }
        desc = desc + "\n";
        for (i = 0; i < this.branchSeq.size(); ++i) {
            desc = desc + (Integer)this.branchSeq.elementAt(i) + " ";
        }
        desc = desc + "\n";
        desc = desc + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        desc = desc + "\n";
        desc = desc + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return desc;
    }

    public void dump() {
        for (int j = 0; j < this.dist.length; ++j) {
            System.out.println(j + "  " + this.dist[j] + "  " + this.rayParams[j]);
        }
    }

    public Object clone() {
        try {
            int i;
            SeismicPhase newObject = (SeismicPhase)super.clone();
            newObject.branchSeq = new Vector(this.branchSeq.size());
            for (i = 0; i < this.branchSeq.size(); ++i) {
                newObject.branchSeq.addElement(new Integer((Integer)this.branchSeq.elementAt(i)));
            }
            for (i = 0; i < this.legs.size(); ++i) {
                newObject.legs.addElement(new Integer((Integer)this.legs.elementAt(i)));
            }
            newObject.dist = (double[])this.dist.clone();
            newObject.time = (double[])this.time.clone();
            newObject.rayParams = (double[])this.rayParams.clone();
            for (i = 0; i < this.arrivals.size(); ++i) {
                newObject.arrivals.addElement((Arrival)((Arrival)this.arrivals.elementAt(i)).clone());
            }
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Caught CloneNotSupportedException: " + e.getMessage());
            throw new InternalError(e.toString());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Usage: SeismicPhase modelfile depth phasename [phasename ...]");
            }
            TauModel tMod = TauModel.readModel(args[0]);
            TauModel tModDepth = tMod.depthCorrect(Double.valueOf(args[1]));
            for (int i = 2; i < args.length; ++i) {
                boolean offset = false;
                System.out.println("-----");
                SeismicPhase sp = new SeismicPhase(args[i], tModDepth);
                sp.init();
                System.out.println(sp);
                sp.dump();
            }
            System.out.println("-----");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (OptionalDataException e) {
            System.out.println(e.getMessage());
        }
        catch (StreamCorruptedException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (TauModelException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

