/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class ReflTransCoefficient
implements Serializable,
Cloneable {
    private static final Complex CX = new Complex();
    protected double topVp;
    protected double topVs;
    protected double topDensity;
    protected double botVp;
    protected double botVs;
    protected double botDensity;
    protected double rp;
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected Complex det;
    protected Complex E;
    protected Complex F;
    protected Complex G;
    protected Complex H;
    protected Complex fsA;
    protected Complex topVertSlownessP;
    protected Complex topVertSlownessS;
    protected Complex botVertSlownessP;
    protected Complex botVertSlownessS;
    protected double sqBotVs;
    protected double sqTopVs;
    protected double sqBotVp;
    protected double sqTopVp;
    protected double sqRP;
    protected double lastRayParam = -1.0;
    protected boolean lastInIsPWave = true;

    public ReflTransCoefficient(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) {
        this.topVp = topVp;
        this.topVs = topVs;
        this.topDensity = topDensity;
        this.botVp = botVp;
        this.botVs = botVs;
        this.botDensity = botDensity;
    }

    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        this.rp = rayParam;
        if (rayParam != this.lastRayParam && inIsPWave == this.lastInIsPWave) {
            this.lastRayParam = -1.0;
            this.sqBotVs = this.botVs * this.botVs;
            this.sqTopVs = this.topVs * this.topVs;
            this.sqBotVp = this.botVp * this.botVp;
            this.sqTopVp = this.topVp * this.topVp;
            this.sqRP = this.rp * this.rp;
            this.topVertSlownessP = Complex.sqrt(new Complex(1.0 / this.sqTopVp - this.sqRP));
            this.topVertSlownessS = Complex.sqrt(new Complex(1.0 / this.sqTopVs - this.sqRP));
            this.botVertSlownessP = Complex.sqrt(new Complex(1.0 / this.sqBotVp - this.sqRP));
            this.botVertSlownessS = Complex.sqrt(new Complex(1.0 / this.sqBotVs - this.sqRP));
            this.a = this.botDensity * (1.0 - 2.0 * this.sqBotVs * this.sqRP) - this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP);
            this.b = this.botDensity * (1.0 - 2.0 * this.sqBotVs * this.sqRP) + 2.0 * this.topDensity * this.sqTopVs * this.sqRP;
            this.c = this.topDensity * (1.0 - 2.0 * this.sqTopVs * this.sqRP) + 2.0 * this.botDensity * this.sqBotVs * this.sqRP;
            this.d = 2.0 * (this.botDensity * this.sqBotVs - this.topDensity * this.sqTopVs);
            this.E = Complex.plus(this.topVertSlownessP.times(this.b), this.botVertSlownessP.times(this.c));
            this.F = Complex.plus(this.topVertSlownessS.times(this.b), this.botVertSlownessS.times(this.c));
            this.G = Complex.minus(new Complex(this.a), Complex.times(this.d, Complex.times(this.topVertSlownessP, this.botVertSlownessS)));
            this.H = Complex.minus(new Complex(this.a), Complex.times(this.d, Complex.times(this.botVertSlownessP, this.topVertSlownessS)));
            this.det = Complex.plus(Complex.times(this.E, this.F), Complex.times(this.G, this.H).times(this.sqRP));
            this.fsA = Complex.plus(new Complex((1.0 / this.sqBotVs - 2.0 * this.sqRP) * (1.0 / this.sqBotVs - 2.0 * this.sqRP)), Complex.times(this.botVertSlownessP, this.botVertSlownessS).times(4.0 * this.sqRP));
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
        }
    }

    public Complex getComplexFreePtoPRefl(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex numerator = Complex.plus(new Complex(-1.0 * (1.0 / this.sqTopVs - 2.0 * this.sqRP) * (1.0 / this.sqTopVs - 2.0 * this.sqRP)), Complex.times(this.topVertSlownessP, this.topVertSlownessS).times(4.0 * this.sqRP));
        return Complex.over(numerator, this.fsA);
    }

    public double getFreePtoPRefl(double rayParam) {
        return Complex.abs(this.getComplexFreePtoPRefl(rayParam));
    }

    public Complex getComplexFreePtoSVRefl(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 4.0 * (this.topVp / this.topVs) * this.rp * (1.0 / this.sqTopVs - 2.0 * this.sqRP);
        return Complex.over(Complex.times(realNumerator, this.topVertSlownessP), this.fsA);
    }

    public double getFreePtoSVRefl(double rayParam) {
        return Complex.abs(this.getComplexFreePtoSVRefl(rayParam));
    }

    public Complex getComplexFreeSVtoPRefl(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = 4.0 * (this.topVs / this.topVp) * this.rp * (1.0 / this.sqTopVs - 2.0 * this.sqRP);
        return Complex.over(Complex.times(realNumerator, this.topVertSlownessS), this.fsA);
    }

    public double getFreeSVtoPRefl(double rayParam) {
        return Complex.abs(this.getComplexFreeSVtoPRefl(rayParam));
    }

    public Complex getComplexFreeSVtoSVRefl(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = -1.0 * ((1.0 / this.sqTopVs - 2.0 * this.sqRP) * (1.0 / this.sqTopVs - 2.0 * this.sqRP));
        Complex numerator = Complex.plus(realNumerator, Complex.times(4.0 * this.sqRP, Complex.times(this.topVertSlownessP, this.topVertSlownessS)));
        return Complex.over(numerator, this.fsA);
    }

    public double getFreeSVtoSVRefl(double rayParam) {
        return Complex.abs(this.getComplexFreeSVtoSVRefl(rayParam));
    }

    public Complex getComplexFreeSHtoSHRefl(double rayParam) {
        return new Complex(1.0);
    }

    public double getFreeSHtoSHRefl(double rayParam) {
        return 1.0;
    }

    public Complex getComplexPtoPRefl(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex FTerm = Complex.times(Complex.minus(Complex.times(this.b, this.topVertSlownessP), Complex.times(this.c, this.botVertSlownessP)), this.F);
        Complex HTerm = Complex.times(Complex.plus(this.a, Complex.times(this.d, Complex.times(this.topVertSlownessP, this.botVertSlownessS))), Complex.times(this.H, this.sqRP));
        return Complex.over(Complex.minus(FTerm, HTerm), this.det);
    }

    public double getPtoPRefl(double rayParam) {
        return Complex.abs(this.getComplexPtoPRefl(rayParam));
    }

    public Complex getComplexPtoSVRefl(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = -2.0 * this.rp * (this.topVp / this.topVs);
        Complex middleTerm = Complex.plus(this.a * this.b, Complex.times(this.c * this.d, Complex.times(this.botVertSlownessP, this.botVertSlownessS)));
        Complex numerator = Complex.times(Complex.times(realNumerator, this.topVertSlownessP), middleTerm);
        return Complex.over(numerator, this.det);
    }

    public double getPtoSVRefl(double rayParam) {
        return Complex.abs(this.getComplexPtoSVRefl(rayParam));
    }

    public Complex getComplexPtoPTrans(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 2.0 * this.topDensity * (this.topVp / this.botVp);
        return Complex.over(Complex.times(realNumerator, Complex.times(this.topVertSlownessP, this.F)), this.det);
    }

    public double getPtoPTrans(double rayParam) {
        return Complex.abs(this.getComplexPtoPTrans(rayParam));
    }

    public Complex getComplexPtoSVTrans(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 2.0 * this.topDensity * this.rp * (this.topVp / this.botVs);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessP, this.H));
        return Complex.over(numerator, this.det);
    }

    public double getPtoSVTrans(double rayParam) {
        return Complex.abs(this.getComplexPtoSVTrans(rayParam));
    }

    public Complex getComplexSVtoPRefl(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = -2.0 * this.rp * (this.topVs / this.topVp);
        Complex middleTerm = Complex.plus(this.a * this.b, Complex.times(this.c * this.d, Complex.times(this.botVertSlownessP, this.botVertSlownessS)));
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, middleTerm));
        return Complex.over(numerator, this.det);
    }

    public double getSVtoPRefl(double rayParam) {
        return Complex.abs(this.getComplexSVtoPRefl(rayParam));
    }

    public Complex getComplexSVtoSVRefl(double rayParam) {
        this.calcTempVars(rayParam, false);
        Complex abNumerator = Complex.times(Complex.plus(this.a, Complex.times(this.d, Complex.times(this.botVertSlownessP, this.topVertSlownessS))), Complex.times(this.G, this.sqRP));
        Complex bcNumerator = Complex.times(Complex.plus(Complex.times(this.b, this.topVertSlownessS), Complex.times(this.c, this.botVertSlownessS)), this.E);
        return Complex.over(Complex.minus(abNumerator, bcNumerator), this.det);
    }

    public double getSVtoSVRefl(double rayParam) {
        return Complex.abs(this.getComplexSVtoSVRefl(rayParam));
    }

    public Complex getComplexSVtoPTrans(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = -2.0 * this.topDensity * this.rp * (this.topVs / this.botVp);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, this.G));
        return Complex.over(numerator, this.det);
    }

    public double getSVtoPTrans(double rayParam) {
        return Complex.abs(this.getComplexSVtoPTrans(rayParam));
    }

    public Complex getComplexSVtoSVTrans(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = 2.0 * this.topDensity * this.rp * (this.topVs / this.botVs);
        Complex numerator = Complex.times(realNumerator, Complex.times(this.topVertSlownessS, this.E));
        return Complex.over(numerator, this.det);
    }

    public double getSVtoSVTrans(double rayParam) {
        return Complex.abs(this.getComplexSVtoSVTrans(rayParam));
    }

    public Complex getComplexSHtoSHRefl(double rayParam) {
        this.calcTempVars(rayParam, false);
        double topMu = this.topVs * this.topVs * this.topDensity;
        double botMu = this.botVs * this.botVs * this.botDensity;
        Complex topTerm = Complex.times(topMu, this.topVertSlownessS);
        Complex botTerm = Complex.times(botMu, this.botVertSlownessS);
        return Complex.over(Complex.minus(topTerm, botTerm), Complex.plus(topTerm, botTerm));
    }

    public double getSHtoSHRefl(double rayParam) {
        return Complex.abs(this.getComplexSHtoSHRefl(rayParam));
    }

    public Complex getComplexSHtoSHTrans(double rayParam) {
        this.calcTempVars(rayParam, false);
        double topMu = this.topVs * this.topVs * this.topDensity;
        double botMu = this.botVs * this.botVs * this.botDensity;
        Complex topTerm = Complex.times(topMu, this.topVertSlownessS);
        Complex botTerm = Complex.times(botMu, this.botVertSlownessS);
        return Complex.over(Complex.times(topTerm, 2.0), Complex.plus(topTerm, botTerm));
    }

    public double getSHtoSHTrans(double rayParam) {
        return Complex.abs(this.getComplexSHtoSHTrans(rayParam));
    }

    public static void main(String[] args) {
        double topVp = 4.98;
        double topVs = 2.9;
        double topDensity = 2.667;
        double botVp = 8.0;
        double botVs = 4.6;
        double botDensity = 3.38;
        double DtoR = Math.PI / 180;
        double RtoD = 57.29577951308232;
        double[] RPP = new double[91];
        double[] RPS = new double[91];
        double[] RSP = new double[91];
        double[] RSS = new double[91];
        double[] TPP = new double[91];
        double[] TPS = new double[91];
        double[] TSP = new double[91];
        double[] TSS = new double[91];
        ReflTransCoefficient coeff = new ReflTransCoefficient(topVp, topVs, topDensity, botVp, botVs, botDensity);
        for (int i = 0; i <= 90; ++i) {
            double rayParam = Math.sin(DtoR * (double)i) / topVp;
            RPP[i] = coeff.getPtoPRefl(rayParam);
            RPS[i] = coeff.getPtoSVRefl(rayParam);
            TPP[i] = coeff.getPtoPTrans(rayParam);
            TPS[i] = coeff.getPtoSVTrans(rayParam);
            rayParam = Math.sin(DtoR * (double)i) / topVs;
            RSP[i] = coeff.getSVtoPRefl(rayParam);
            RSS[i] = coeff.getSVtoSVRefl(rayParam);
            TSP[i] = coeff.getSVtoPTrans(rayParam);
            TSS[i] = coeff.getSVtoSVTrans(rayParam);
        }
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter("refltrans.gmt"));
            out.write("#!/bin/sh\n\n");
            out.write("/bin/rm -f refltrans.ps\n\n");
            out.write("psbasemap -K -P -JX6 -R0/90/0/2  -B10/1 > refltrans.ps\n");
            out.write("psxy -K -O -JX -R -M -W1/255/0/0 >> refltrans.ps <<END\n");
            for (i = 0; i <= 90; ++i) {
                out.write(i + " " + RSP[i] + "\n");
            }
            out.write("END\n");
            out.write("psxy -K -O -JX -R -M -W1/0/255/0 >> refltrans.ps <<END\n");
            for (i = 0; i <= 90; ++i) {
                out.write(i + " " + RSS[i] + "\n");
            }
            out.write("END\n");
            out.write("psxy -K -O -JX -R -M -W1/0/0/255 >> refltrans.ps <<END\n");
            for (i = 0; i <= 90; ++i) {
                out.write(i + " " + TSP[i] + "\n");
            }
            out.write("END\n");
            out.write("psxy -O -JX -R -M -W1/255/0/255 >> refltrans.ps <<END\n");
            for (i = 0; i <= 90; ++i) {
                out.write(i + " " + TSS[i] + "\n");
            }
            out.write("END\n");
            ((Writer)out).close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

