/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Format;
import java.util.Properties;

public class Outputs {
    protected Format depthFormat;
    protected Format distanceFormat;
    protected Format timeFormat;
    protected Format rayParamFormat;
    protected Format latLonFormat;

    public Outputs(Properties props) {
        String formString = "%8." + props.getProperty("taup.depth.precision", "1") + "f";
        this.depthFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.distance.precision", "2") + "f";
        this.distanceFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.time.precision", "2") + "f";
        this.timeFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.rayparam.precision", "3") + "f";
        this.rayParamFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.latlon.precision", "2") + "f";
        this.latLonFormat = new Format(formString);
    }

    public String formatDepth(double depth) {
        return this.depthFormat.form(depth);
    }

    public String formatDistance(double distance) {
        return this.distanceFormat.form(distance);
    }

    public String formatTime(double time) {
        return this.timeFormat.form(time);
    }

    public String formatRayParam(double rayParam) {
        return this.rayParamFormat.form(rayParam);
    }

    public String formatLatLon(double latlon) {
        return this.latLonFormat.form(latlon);
    }
}

