/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPlot;
import java.awt.Color;
import java.awt.Graphics;

public class CurvePlot
extends ArrivalPlot {
    public CurvePlot() {
        this.setOpaque(true);
    }

    public void paintBackground(Graphics g) {
    }

    public void paintArrivals(Graphics g) {
        for (int i = 0; i < this.arrivals.size(); ++i) {
            this.paintCurve(g, i);
        }
    }

    public void paintForeground(Graphics g) {
        Color orig = g.getColor();
        g.setColor(Color.red);
        this.paintCurve(g, this.selectedIndex);
        g.setColor(orig);
    }

    protected void paintCurve(Graphics g, int i) {
        int xOffset = this.getSize().width / 2;
        int yOffset = this.getSize().height / 2;
        int pixelRad = Math.min(xOffset, yOffset);
        double roe = 6371.0;
        Arrival a = (Arrival)this.arrivals.elementAt(i);
        int[] x = new int[a.getNumPathPoints()];
        int[] y = new int[a.getNumPathPoints()];
        for (int j = 0; j < x.length; ++j) {
            x[j] = xOffset + (int)Math.rint(Math.sin(a.getPathPoint((int)j).dist) * (roe - a.getPathPoint((int)j).depth) / roe * (double)pixelRad);
            y[j] = yOffset - (int)Math.rint(Math.cos(a.getPathPoint((int)j).dist) * (roe - a.getPathPoint((int)j).depth) / roe * (double)pixelRad);
        }
        g.drawPolyline(x, y, x.length);
    }
}

