/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import javax.swing.table.AbstractTableModel;

public class ArrivalTableModel
extends AbstractTableModel {
    protected Arrival[] arrivals = new Arrival[0];
    private static Format float6_1 = new Format("%6.1f");
    private static Format float8_1 = new Format("%8.1f");
    private static Format float8_2 = new Format("%8.2f");
    private static Format float8_3 = new Format("%8.3f");
    private static Format float8_4 = new Format("%8.4f");

    public int getRowCount() {
        return this.arrivals.length;
    }

    public int getColumnCount() {
        return 8;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return float8_1.form(this.arrivals[row].getModuloDistDeg());
            }
            case 1: {
                return float8_1.form(this.arrivals[row].getModuloDist() * this.arrivals[row].getPhase().getTauModel().getRadiusOfEarth());
            }
            case 2: {
                return float8_1.form(this.arrivals[row].getSourceDepth());
            }
            case 3: {
                return this.arrivals[row].getName();
            }
            case 4: {
                return float8_2.form(this.arrivals[row].getTime());
            }
            case 5: {
                return float8_3.form(Math.PI / 180 * this.arrivals[row].getRayParam());
            }
            case 6: {
                return float8_1.form(this.arrivals[row].getDistDeg());
            }
            case 7: {
                return this.arrivals[row].getName().equals(this.arrivals[row].getPuristName()) ? "=" : "*";
            }
            case 8: {
                return this.arrivals[row].getPuristName();
            }
        }
        return "";
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Dist";
            }
            case 1: {
                return "Dist (km)";
            }
            case 2: {
                return "Depth";
            }
            case 3: {
                return "Name";
            }
            case 4: {
                return "Time";
            }
            case 5: {
                return "Ray Param";
            }
            case 6: {
                return "Purist Dist";
            }
            case 7: {
                return "";
            }
            case 8: {
                return "Purist Name";
            }
        }
        return "";
    }

    public void setArrivals(Arrival[] arrivals) {
        this.arrivals = arrivals;
        this.fireTableDataChanged();
    }
}

