/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.View;

public class Viewer {
    protected Canvas3D canvas;
    protected View view;
    protected ViewerAvatar avatar = null;
    protected static PhysicalBody physicalBody = null;
    protected static PhysicalEnvironment physicalEnvironment = null;
    protected Frame j3dFrame = null;
    protected Panel j3dPanel = null;
    ViewingPlatform viewingPlatform = null;

    public Viewer() {
        this(null, null);
    }

    public Viewer(Canvas3D canvas3D) {
        this(canvas3D, null);
    }

    public Viewer(URL uRL) {
        this(null, uRL);
    }

    public Viewer(Canvas3D canvas3D, URL uRL) {
        if (physicalBody == null) {
            physicalBody = new PhysicalBody();
            if (uRL != null) {
                // empty if block
            }
        }
        if (physicalEnvironment == null) {
            physicalEnvironment = new PhysicalEnvironment();
        }
        if (canvas3D == null) {
            GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
            this.canvas = new Canvas3D(graphicsConfiguration);
            this.j3dFrame = new Frame();
            this.j3dFrame.setLayout(new BorderLayout());
            ((Component)this.j3dFrame).setSize(256, 256);
            this.j3dPanel = new Panel();
            this.j3dPanel.setLayout(new BorderLayout());
            this.j3dPanel.add("Center", (Component)this.canvas);
            this.j3dFrame.add("Center", this.j3dPanel);
            this.j3dFrame.show();
            this.j3dFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        } else {
            this.canvas = canvas3D;
        }
        this.view = new View();
        this.view.addCanvas3D(this.canvas);
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    public View getView() {
        return this.view;
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        if (this.viewingPlatform != null) {
            this.viewingPlatform.removeViewer(this);
        }
        this.viewingPlatform = viewingPlatform;
        if (viewingPlatform != null) {
            this.view.attachViewPlatform(viewingPlatform.getViewPlatform());
            viewingPlatform.addViewer(this);
            if (this.avatar != null) {
                this.viewingPlatform.setAvatar(this, this.avatar);
            }
        } else {
            this.view.attachViewPlatform(null);
        }
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewingPlatform;
    }

    public void setAvatar(ViewerAvatar viewerAvatar) {
        if (this.avatar == viewerAvatar) {
            return;
        }
        this.avatar = viewerAvatar;
        if (this.viewingPlatform != null) {
            this.viewingPlatform.setAvatar(this, this.avatar);
        }
    }

    public ViewerAvatar getAvatar() {
        return this.avatar;
    }

    public PhysicalBody getPhysicalBody() {
        return physicalBody;
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return physicalEnvironment;
    }

    public Canvas3D getCanvases() {
        return this.canvas;
    }

    public Frame getFrame() {
        return this.j3dFrame;
    }

    public Panel getPanel() {
        return this.j3dPanel;
    }

    public AudioDevice createAudioDevice() {
        if (physicalEnvironment != null) {
            JavaSoundMixer javaSoundMixer = new JavaSoundMixer(physicalEnvironment);
            javaSoundMixer.initialize();
            return javaSoundMixer;
        }
        return null;
    }
}

